/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.core.grid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class ElectricityNetwork
implements IElectricityNetwork {
    public Map<TileEntity, ForgeDirection> electricalTiles = new HashMap<TileEntity, ForgeDirection>();
    private final Set<IConductor> conductors = new HashSet<IConductor>();
    public float acceptorResistance = 500.0f;

    @Override
    public Set<TileEntity> getAcceptors() {
        return this.electricalTiles.keySet();
    }

    @Override
    public ForgeDirection getPossibleDirections(TileEntity tile) {
        return this.electricalTiles.containsKey(tile) ? this.electricalTiles.get(tile) : null;
    }

    @Override
    public float getTotalResistance() {
        float resistance = 0.0f;
        for (IConductor conductor : this.conductors) {
            resistance += conductor.getResistance();
        }
        return resistance;
    }

    @Override
    public float getLowestCurrentCapacity() {
        float lowestAmperage = 0.0f;
        for (IConductor conductor : this.conductors) {
            if (lowestAmperage != 0.0f && !(conductor.getCurrentCapacity() < lowestAmperage)) continue;
            lowestAmperage = conductor.getCurrentCapacity();
        }
        return lowestAmperage;
    }

    @Override
    public Set<IConductor> getTransmitters() {
        return this.conductors;
    }
}

