/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import micdoodle8.mods.galacticraft.api.transmission.ElectricalEvent;
import micdoodle8.mods.galacticraft.api.transmission.ElectricityPack;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.ElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.path.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class UniversalNetwork
extends ElectricityNetwork {
    @Override
    public float produce(ElectricityPack electricity, boolean doReceive, TileEntity ... ignoreTiles) {
        float totalEnergyRequest;
        ElectricalEvent.ElectricityProductionEvent evt = new ElectricalEvent.ElectricityProductionEvent(this, electricity, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        float totalEnergy = electricity.getWatts();
        float voltage = electricity.voltage;
        float sent = 0.0f;
        if (!evt.isCanceled() && !this.electricalTiles.isEmpty() && (totalEnergyRequest = this.getRequest(ignoreTiles).getWatts()) > 0.0f) {
            CopyOnWriteArrayList acceptors = Lists.newCopyOnWriteArrayList();
            acceptors.addAll(this.electricalTiles.keySet());
            for (TileEntity tileEntity : ignoreTiles) {
                if (!acceptors.contains(tileEntity)) continue;
                acceptors.remove(tileEntity);
            }
            ArrayList<TileEntity> removeList = new ArrayList<TileEntity>();
            for (Object obj : acceptors) {
                TileEntity tileEntity;
                if (!(obj instanceof TileEntity) || (tileEntity = (TileEntity)obj) != null && !tileEntity.func_70320_p()) continue;
                removeList.add(tileEntity);
            }
            acceptors.removeAll(removeList);
            Collections.shuffle(acceptors);
            int divider = acceptors.size();
            double remaining = totalEnergy % (float)divider;
            double sending = ((double)totalEnergy - remaining) / (double)divider;
            for (Object obj : acceptors) {
                PowerHandler.PowerReceiver receiver;
                IElectrical electricalTile;
                if (!(obj instanceof TileEntity)) continue;
                TileEntity tileEntity = (TileEntity)obj;
                double currentSending = sending + remaining;
                ForgeDirection side = (ForgeDirection)this.electricalTiles.get(tileEntity);
                if (side == null) continue;
                remaining = 0.0;
                if (tileEntity instanceof IElectrical) {
                    electricalTile = (IElectrical)tileEntity;
                    ElectricityPack electricityToSend = ElectricityPack.getFromWatts((float)currentSending, voltage);
                    sent += electricalTile.receiveElectricity(side.getOpposite(), electricityToSend, doReceive);
                    continue;
                }
                if (NetworkConfigHandler.isThermalExpansionLoaded() && tileEntity instanceof IEnergyHandler) {
                    IEnergyHandler handler = (IEnergyHandler)tileEntity;
                    int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(currentSending * (double)NetworkConfigHandler.TO_TE_RATIO), !doReceive);
                    sent += (float)used * NetworkConfigHandler.TE_RATIO;
                    continue;
                }
                if (NetworkConfigHandler.isIndustrialCraft2Loaded() && tileEntity instanceof IEnergySink) {
                    electricalTile = (IEnergySink)tileEntity;
                    double toSend = Math.min(currentSending, (double)((float)electricalTile.getMaxSafeInput() * NetworkConfigHandler.IC2_RATIO));
                    toSend = Math.min(toSend, electricalTile.demandedEnergyUnits() * (double)NetworkConfigHandler.IC2_RATIO);
                    sent = (float)((double)sent + (toSend - electricalTile.injectEnergyUnits(side.getOpposite(), toSend * (double)NetworkConfigHandler.TO_IC2_RATIO) * (double)NetworkConfigHandler.IC2_RATIO));
                    continue;
                }
                if (!NetworkConfigHandler.isBuildcraftLoaded() || !(tileEntity instanceof IPowerReceptor) || (receiver = (electricalTile = (IPowerReceptor)tileEntity).getPowerReceiver(side.getOpposite())) == null) continue;
                float req = receiver.powerRequest();
                double bcToSend = currentSending * (double)NetworkConfigHandler.TO_BC_RATIO;
                float bcSent = receiver.receiveEnergy(PowerHandler.Type.PIPE, (float)Math.min((double)req, bcToSend), side.getOpposite());
                sent += bcSent * NetworkConfigHandler.BC3_RATIO;
            }
        }
        return totalEnergy - sent;
    }

    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        ArrayList<ElectricityPack> requests = new ArrayList<ElectricityPack>();
        block0: for (TileEntity tileEntity : new HashSet(this.electricalTiles.keySet())) {
            Vector3 tileVec;
            if (Arrays.asList(ignoreTiles).contains(tileEntity) || tileEntity == null || tileEntity.func_70320_p() || tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) continue;
            if (tileEntity instanceof IElectrical) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    tileVec = new Vector3(tileEntity);
                    TileEntity tile = tileVec.modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                    if (!((IElectrical)tileEntity).canConnect(direction, NetworkType.POWER) || !this.getTransmitters().contains(tile)) continue;
                    requests.add(ElectricityPack.getFromWatts(((IElectrical)tileEntity).getRequest(direction), ((IElectrical)tileEntity).getVoltage()));
                }
                continue;
            }
            if (NetworkConfigHandler.isThermalExpansionLoaded() && tileEntity instanceof IEnergyHandler) {
                IEnergyHandler receiver = (IEnergyHandler)tileEntity;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    ElectricityPack pack;
                    Vector3 tileVec2 = new Vector3(tileEntity);
                    TileEntity conductor = tileVec2.modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                    if (!receiver.canInterface(direction) || !this.getTransmitters().contains(conductor) || !((pack = ElectricityPack.getFromWatts((float)receiver.receiveEnergy(direction, Integer.MAX_VALUE, true) * NetworkConfigHandler.TE_RATIO, 1.0f)).getWatts() > 0.0f)) continue;
                    requests.add(pack);
                    continue block0;
                }
                continue;
            }
            if (NetworkConfigHandler.isIndustrialCraft2Loaded() && tileEntity instanceof IEnergySink) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    ElectricityPack pack;
                    tileVec = new Vector3(tileEntity);
                    TileEntity conductor = tileVec.modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                    if (!((IEnergySink)tileEntity).acceptsEnergyFrom(tileVec.modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k), direction) || !this.getTransmitters().contains(conductor) || !((pack = ElectricityPack.getFromWatts((float)(((IEnergySink)tileEntity).demandedEnergyUnits() * (double)NetworkConfigHandler.IC2_RATIO), 1.0f)).getWatts() > 0.0f)) continue;
                    requests.add(pack);
                }
                continue;
            }
            if (!NetworkConfigHandler.isBuildcraftLoaded() || !(tileEntity instanceof IPowerReceptor)) continue;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                ElectricityPack pack;
                if (((IPowerReceptor)tileEntity).getPowerReceiver(direction) == null || !((pack = ElectricityPack.getFromWatts(((IPowerReceptor)tileEntity).getPowerReceiver(direction).powerRequest() * NetworkConfigHandler.BC3_RATIO, 1.0f)).getWatts() > 0.0f)) continue;
                requests.add(pack);
                continue block0;
            }
        }
        ElectricityPack mergedPack = ElectricityPack.merge(requests);
        ElectricalEvent.ElectricityRequestEvent evt = new ElectricalEvent.ElectricityRequestEvent(this, mergedPack, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return mergedPack;
    }

    @Override
    public void refresh() {
        this.electricalTiles.clear();
        try {
            Iterator<IConductor> it = this.getTransmitters().iterator();
            while (it.hasNext()) {
                IConductor conductor = it.next();
                if (conductor == null) {
                    it.remove();
                    continue;
                }
                conductor.onNetworkChanged();
                if (((TileEntity)conductor).func_70320_p() || ((TileEntity)conductor).func_70314_l() == null) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)conductor).func_70314_l().func_72796_p(((TileEntity)conductor).field_70329_l, ((TileEntity)conductor).field_70330_m, ((TileEntity)conductor).field_70327_n) != conductor) {
                    it.remove();
                    continue;
                }
                conductor.setNetwork(this);
                for (int i = 0; i < conductor.getAdjacentConnections().length; ++i) {
                    TileEntity acceptor = conductor.getAdjacentConnections()[i];
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    if (acceptor instanceof IConductor || !(acceptor instanceof IElectrical || NetworkConfigHandler.isThermalExpansionLoaded() && acceptor instanceof IEnergyHandler || NetworkConfigHandler.isIndustrialCraft2Loaded() && acceptor instanceof IEnergyAcceptor) && (!NetworkConfigHandler.isBuildcraftLoaded() || !(acceptor instanceof IPowerReceptor))) continue;
                    boolean canConnect = false;
                    if (acceptor instanceof IElectrical && ((IElectrical)acceptor).canConnect(direction.getOpposite(), NetworkType.POWER)) {
                        canConnect = true;
                    } else if (NetworkConfigHandler.isThermalExpansionLoaded() && acceptor instanceof IEnergyHandler && ((IEnergyHandler)acceptor).canInterface(direction)) {
                        canConnect = true;
                    } else if (NetworkConfigHandler.isIndustrialCraft2Loaded() && acceptor instanceof IEnergyAcceptor && ((IEnergyAcceptor)acceptor).acceptsEnergyFrom((TileEntity)conductor, direction)) {
                        canConnect = true;
                    } else if (NetworkConfigHandler.isBuildcraftLoaded() && acceptor instanceof IPowerReceptor && ((IPowerReceptor)acceptor).getPowerReceiver(direction) != null) {
                        canConnect = true;
                    }
                    if (!canConnect) continue;
                    this.electricalTiles.put(acceptor, direction);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Universal Electricity: Failed to refresh conductor.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public IElectricityNetwork merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            UniversalNetwork newNetwork = new UniversalNetwork();
            newNetwork.getTransmitters().addAll(this.getTransmitters());
            newNetwork.getTransmitters().addAll(network.getTransmitters());
            newNetwork.refresh();
            return newNetwork;
        }
        return null;
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.getTransmitters().remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, NetworkType.POWER, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    UniversalNetwork newNetwork = new UniversalNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getTransmitters().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "UniversalNetwork[" + this.hashCode() + "|Wires:" + this.getTransmitters().size() + "|Acceptors:" + this.electricalTiles.size() + "]";
    }
}

