/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.compatibility;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.core.item.ItemElectric;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public abstract class ItemUniversalElectric
extends ItemElectric
implements ISpecialElectricItem,
IEnergyContainerItem {
    public static final float CHARGE_RATE = 0.005f;

    public ItemUniversalElectric(int id) {
        super(id);
    }

    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) * NetworkConfigHandler.TO_IC2_RATIO);
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) * 0.005f * NetworkConfigHandler.TO_IC2_RATIO);
    }

    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ElectricItemManager.MANAGER;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.recharge(itemStack, 1.0f, false) > 0.0f;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean doReceive) {
        return (int)(this.recharge(theItem, (float)energy * NetworkConfigHandler.BC3_RATIO, doReceive) * NetworkConfigHandler.TO_BC_RATIO);
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean doTransfer) {
        return (int)(this.discharge(theItem, (float)energy * NetworkConfigHandler.BC3_RATIO, doTransfer) * NetworkConfigHandler.TO_BC_RATIO);
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getElectricityStored(theItem) * NetworkConfigHandler.TO_BC_RATIO);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxElectricityStored(theItem) * NetworkConfigHandler.TO_BC_RATIO);
    }

    public static class IC2ElectricItemManager
    implements IElectricItemManager {
        public static final IElectricItemManager MANAGER = new IC2ElectricItemManager();

        private IItemElectric getElectricItem(ItemStack itemStack) {
            if (itemStack.func_77973_b() instanceof IItemElectric) {
                return (IItemElectric)itemStack.func_77973_b();
            }
            return null;
        }

        public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
            float inputElectricity = (float)amount * NetworkConfigHandler.IC2_RATIO;
            return (int)(this.getElectricItem(itemStack).recharge(itemStack, inputElectricity, !simulate) * NetworkConfigHandler.TO_IC2_RATIO);
        }

        public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
            float outputElectricity = (float)amount * NetworkConfigHandler.IC2_RATIO;
            return (int)(this.getElectricItem(itemStack).discharge(itemStack, outputElectricity, !simulate) * NetworkConfigHandler.TO_IC2_RATIO);
        }

        public boolean canUse(ItemStack itemStack, int amount) {
            return false;
        }

        public int getCharge(ItemStack itemStack) {
            return 0;
        }

        public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
            return false;
        }

        public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        }

        public String getToolTip(ItemStack itemStack) {
            return null;
        }
    }
}

