/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class NetworkHelper {
    public static EnumSet<ForgeDirection> getDirections(TileEntity tileEntity, NetworkType type) {
        EnumSet<ForgeDirection> possibleSides = EnumSet.noneOf(ForgeDirection.class);
        if (tileEntity instanceof IConnector) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                if (!((IConnector)tileEntity).canConnect(direction, type)) continue;
                possibleSides.add(direction);
            }
        }
        return possibleSides;
    }

    public static Set<IElectricityNetwork> getNetworksFromMultipleSides(TileEntity tileEntity, EnumSet<ForgeDirection> approachingDirection) {
        HashSet<IElectricityNetwork> connectedNetworks = new HashSet<IElectricityNetwork>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!approachingDirection.contains(side)) continue;
            Vector3 position = new Vector3(tileEntity);
            position.modifyPositionFromSide(side);
            TileEntity outputConductor = position.getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            IElectricityNetwork electricityNetwork = NetworkHelper.getElectricalNetworkFromTileEntity(outputConductor, side);
            if (electricityNetwork == null) continue;
            connectedNetworks.add(electricityNetwork);
        }
        return connectedNetworks;
    }

    public static IElectricityNetwork getElectricalNetworkFromTileEntity(TileEntity tileEntity, ForgeDirection approachDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider && (tileEntity instanceof IConnector ? ((IConnector)tileEntity).canConnect(approachDirection.getOpposite(), NetworkType.POWER) && ((INetworkProvider)tileEntity).getNetwork() instanceof IElectricityNetwork : ((INetworkProvider)tileEntity).getNetwork() instanceof IElectricityNetwork)) {
            return (IElectricityNetwork)((INetworkProvider)tileEntity).getNetwork();
        }
        return null;
    }

    public static IOxygenNetwork getOxygenNetworkFromTileEntity(TileEntity tileEntity, ForgeDirection approachDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider && (tileEntity instanceof IConnector ? ((IConnector)tileEntity).canConnect(approachDirection.getOpposite(), NetworkType.OXYGEN) && ((INetworkProvider)tileEntity).getNetwork() instanceof IOxygenNetwork : ((INetworkProvider)tileEntity).getNetwork() instanceof IOxygenNetwork)) {
            return (IOxygenNetwork)((INetworkProvider)tileEntity).getNetwork();
        }
        return null;
    }
}

