/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.recipe;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SpaceStationRecipe {
    private final HashMap<Object, Integer> input = new HashMap();

    public SpaceStationRecipe(HashMap<Object, Integer> objMap) {
        for (Object obj : objMap.keySet()) {
            Integer amount = objMap.get(obj);
            if (obj instanceof ItemStack) {
                this.input.put(((ItemStack)obj).func_77946_l(), amount);
                continue;
            }
            if (obj instanceof Item) {
                this.input.put(new ItemStack((Item)obj), amount);
                continue;
            }
            if (obj instanceof Block) {
                this.input.put(new ItemStack((Block)obj), amount);
                continue;
            }
            if (obj instanceof String) {
                FMLLog.info((String)("While registering space station recipe, found " + OreDictionary.getOres((String)((String)obj)).size() + " type(s) of " + obj), (Object[])new Object[0]);
                this.input.put(OreDictionary.getOres((String)((String)obj)), amount);
                continue;
            }
            if (obj instanceof ArrayList) {
                this.input.put(obj, amount);
                continue;
            }
            throw new RuntimeException("INVALID SPACE STATION RECIPE");
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public boolean matches(EntityPlayer player, boolean remove) {
        HashMap<Object, Integer> required = new HashMap<Object, Integer>();
        required.putAll(this.input);
        for (Object next : this.input.keySet()) {
            int amountRequired = (Integer)required.get(next);
            int amountInInv = 0;
            for (int x = 0; x < player.field_71071_by.func_70302_i_(); ++x) {
                ItemStack slot = player.field_71071_by.func_70301_a(x);
                if (slot == null) continue;
                if (next instanceof ItemStack) {
                    if (!SpaceStationRecipe.checkItemEquals((ItemStack)next, slot)) continue;
                    amountInInv += slot.field_77994_a;
                    continue;
                }
                if (!(next instanceof ArrayList)) continue;
                for (ItemStack item : (ArrayList)next) {
                    if (!SpaceStationRecipe.checkItemEquals(item, slot)) continue;
                    amountInInv += slot.field_77994_a;
                }
            }
            if (amountInInv < amountRequired) continue;
            required.remove(next);
        }
        if (required.isEmpty() && remove) {
            this.removeItems(player);
        }
        return required.isEmpty();
    }

    public void removeItems(EntityPlayer player) {
        HashMap<Object, Integer> required = new HashMap<Object, Integer>(this.input);
        for (Object next : required.keySet()) {
            int amountRequired = required.get(next);
            int amountRemoved = 0;
            for (int x = 0; x < player.field_71071_by.func_70302_i_(); ++x) {
                ItemStack slot = player.field_71071_by.func_70301_a(x);
                if (slot == null) continue;
                int amountRemaining = amountRequired - amountRemoved;
                if (next instanceof ItemStack) {
                    if (!SpaceStationRecipe.checkItemEquals((ItemStack)next, slot)) continue;
                    int amountToRemove = Math.min(slot.field_77994_a, amountRemaining);
                    ItemStack newStack = slot.func_77946_l();
                    newStack.field_77994_a -= amountToRemove;
                    if (newStack.field_77994_a <= 0) {
                        newStack = null;
                    }
                    player.field_71071_by.func_70299_a(x, newStack);
                    amountRemoved += amountToRemove;
                    continue;
                }
                if (!(next instanceof ArrayList)) continue;
                for (ItemStack item : (ArrayList)next) {
                    if (!SpaceStationRecipe.checkItemEquals(item, slot)) continue;
                    int amountToRemove = Math.min(slot.field_77994_a, amountRemaining);
                    ItemStack newStack = slot.func_77946_l();
                    newStack.field_77994_a -= amountToRemove;
                    if (newStack.field_77994_a <= 0) {
                        newStack = null;
                    }
                    player.field_71071_by.func_70299_a(x, newStack);
                    amountRemoved += amountToRemove;
                }
            }
        }
    }

    public static boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.field_77993_c == input.field_77993_c && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    public HashMap<Object, Integer> getInput() {
        return this.input;
    }
}

