/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreDamageSource;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntitySpaceshipBase
extends Entity
implements IPacketReceiver {
    public int launchPhase = EnumLaunchPhase.UNIGNITED.getPhase();
    protected long ticks = 0L;
    protected double dragAir;
    public int timeUntilLaunch;
    public float timeSinceLaunch;
    public float rollAmplitude;
    public float shipDamage;

    public EntitySpaceshipBase(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70155_l = 5.0;
    }

    public abstract int getMaxFuel();

    public abstract int getScaledFuelLevel(int var1);

    public abstract int getPreLaunchWait();

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70106_y() {
        if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
            Object[] toSend2 = new Object[]{0};
            ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, toSend2));
        }
        super.func_70106_y();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_85032_ar() || this.field_70163_u > 300.0) {
                return false;
            }
            this.rollAmplitude = 10.0f;
            this.func_70018_K();
            this.shipDamage += par2 * 10.0f;
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.shipDamage = 100.0f;
            }
            if (this.shipDamage > 90.0f && !this.field_70170_p.field_72995_K) {
                if (this.field_70153_n != null) {
                    Object[] toSend2 = new Object[]{0};
                    ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, toSend2));
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70106_y();
                this.dropShipAsItem();
                return true;
            }
            return true;
        }
        return true;
    }

    public void dropShipAsItem() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (ItemStack item : this.getItemsDropped(new ArrayList<ItemStack>())) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public abstract List<ItemStack> getItemsDropped(List<ItemStack> var1);

    public void func_70057_ab() {
        this.rollAmplitude = 5.0f;
        this.shipDamage += this.shipDamage * 10.0f;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70071_h_() {
        block24: {
            block23: {
                if (this.ticks >= Long.MAX_VALUE) {
                    this.ticks = 1L;
                }
                ++this.ticks;
                super.func_70071_h_();
                if (this.field_70153_n != null) {
                    this.field_70153_n.field_70143_R = 0.0f;
                }
                double d = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                if (this.field_70163_u > d) {
                    this.onReachAtmoshpere();
                }
                if (this.rollAmplitude > 0.0f) {
                    this.rollAmplitude -= 1.0f;
                }
                if (this.shipDamage > 0.0f) {
                    this.shipDamage -= 1.0f;
                }
                if (this.field_70163_u < 0.0) break block23;
                double d2 = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                if (!(this.field_70163_u > d2 + 10.0)) break block24;
            }
            this.func_70076_C();
        }
        if (this.launchPhase == EnumLaunchPhase.UNIGNITED.getPhase()) {
            this.timeUntilLaunch = this.getPreLaunchWait();
        }
        this.timeSinceLaunch = this.launchPhase == EnumLaunchPhase.LAUNCHED.getPhase() ? (this.timeSinceLaunch += 1.0f) : 0.0f;
        if (this.timeUntilLaunch > 0 && this.launchPhase == EnumLaunchPhase.IGNITED.getPhase()) {
            --this.timeUntilLaunch;
        }
        AxisAlignedBB box = null;
        box = this.field_70121_D.func_72314_b(0.2, 0.2, 0.2);
        List var15 = this.field_70170_p.func_72839_b((Entity)this, box);
        if (var15 != null && !var15.isEmpty()) {
            for (int var52 = 0; var52 < var15.size(); ++var52) {
                Entity var17 = (Entity)var15.get(var52);
                if (var17 == this.field_70153_n) continue;
                var17.func_70108_f((Entity)this);
            }
        }
        if (this.timeUntilLaunch == 0 && this.launchPhase == EnumLaunchPhase.IGNITED.getPhase()) {
            this.launchPhase = EnumLaunchPhase.LAUNCHED.getPhase();
            this.onLaunch();
        }
        if (this.field_70125_A > 90.0f) {
            this.field_70125_A = 90.0f;
        }
        if (this.field_70125_A < -90.0f) {
            this.field_70125_A = -90.0f;
        }
        this.field_70159_w = -(50.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0));
        this.field_70179_y = -(50.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0));
        if (this.timeSinceLaunch > 50.0f && this.field_70122_E) {
            this.failRocket();
        }
        if (this.launchPhase != EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.shouldMoveClientSide()) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K && this.ticks % 3L == 0L) {
            PacketDispatcher.sendPacketToAllInDimension((Packet)GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, this.getNetworkedData(new ArrayList<Object>())), (int)this.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    protected boolean shouldMoveClientSide() {
        return true;
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.readNetworkedData(dataStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readNetworkedData(ByteArrayDataInput dataStream) {
        this.launchPhase = dataStream.readInt();
        this.timeSinceLaunch = dataStream.readFloat();
        this.timeUntilLaunch = dataStream.readInt();
    }

    public ArrayList<Object> getNetworkedData(ArrayList<Object> list) {
        list.add(this.launchPhase);
        list.add(Float.valueOf(this.timeSinceLaunch));
        list.add(this.timeUntilLaunch);
        return list;
    }

    public void turnYaw(float f) {
        this.field_70177_z += f;
    }

    public void turnPitch(float f) {
        this.field_70125_A += f;
    }

    protected void failRocket() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70097_a((DamageSource)GCCoreDamageSource.spaceshipCrash, 81.0f);
        }
        if (!GCCoreConfigManager.disableSpaceshipGrief) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70101_b(par7, par8);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("launchPhase", this.launchPhase);
        nbt.func_74768_a("timeUntilLaunch", this.timeUntilLaunch);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.timeUntilLaunch = nbt.func_74762_e("timeUntilLaunch");
        boolean hasOldTags = false;
        if (nbt.func_74758_c().contains("launched")) {
            hasOldTags = true;
            boolean launched = nbt.func_74767_n("launched");
            if (launched) {
                this.launchPhase = EnumLaunchPhase.LAUNCHED.getPhase();
            }
        }
        if (nbt.func_74758_c().contains("ignite")) {
            hasOldTags = true;
            int ignite = nbt.func_74762_e("ignite");
            if (ignite == 1) {
                this.launchPhase = EnumLaunchPhase.IGNITED.getPhase();
            }
        }
        if (hasOldTags) {
            if (this.launchPhase != EnumLaunchPhase.LAUNCHED.getPhase() && this.launchPhase != EnumLaunchPhase.IGNITED.getPhase()) {
                this.launchPhase = EnumLaunchPhase.UNIGNITED.getPhase();
            }
        } else {
            this.launchPhase = nbt.func_74762_e("launchPhase");
        }
    }

    public boolean getLaunched() {
        return this.launchPhase == EnumLaunchPhase.LAUNCHED.getPhase();
    }

    public boolean canBeRidden() {
        return false;
    }

    public void ignite() {
        this.launchPhase = EnumLaunchPhase.IGNITED.getPhase();
    }

    public double func_70042_X() {
        return -1.0;
    }

    public void onLaunch() {
    }

    public void onReachAtmoshpere() {
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public boolean canRiderInteract() {
        return true;
    }

    public ResourceLocation getSpaceshipGui() {
        return GalacticraftRegistry.getResouceLocationForDimension(this.field_70170_p.field_73011_w.getClass());
    }

    public static enum EnumLaunchPhase {
        UNIGNITED(1),
        IGNITED(2),
        LAUNCHED(3);

        private int phase;

        private EnumLaunchPhase(int phase) {
            this.phase = phase;
        }

        public int getPhase() {
            return this.phase;
        }
    }
}

