/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.MathHelper;
import cofh.util.StringHelper;
import cofh.util.inventory.ComparableItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.item.TEItems;

public class PulverizerManager {
    private static Map<ComparableItemStackPulverizer, RecipePulverizer> recipeMap = new HashMap<ComparableItemStackPulverizer, RecipePulverizer>();
    private static ComparableItemStackPulverizer query = new ComparableItemStackPulverizer(new ItemStack(Block.field_71981_t));
    private static boolean allowOverwrite = false;

    public static RecipePulverizer getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return recipeMap.get((Object)query.set(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return PulverizerManager.getRecipe(input) != null;
    }

    public static RecipePulverizer[] getRecipeList() {
        return recipeMap.values().toArray(new RecipePulverizer[0]);
    }

    public static void addDefaultRecipes() {
        String category = "tweak.crafting";
        boolean recipeSandstone = ThermalExpansion.config.get(category, "Pulverizer.Sandstone", true);
        boolean recipeNetherrack = ThermalExpansion.config.get(category, "Pulverizer.Netherrack", true);
        boolean recipeCloth = ThermalExpansion.config.get(category, "Pulverizer.Cloth", true);
        boolean recipeReed = ThermalExpansion.config.get(category, "Pulverizer.Reed", true);
        boolean recipeBone = ThermalExpansion.config.get(category, "Pulverizer.Bone", true);
        boolean recipeBlazeRod = ThermalExpansion.config.get(category, "Pulverizer.BlazeRod", true);
        boolean recipeBlizzRod = ThermalExpansion.config.get(category, "Pulverizer.BlizzRod", true);
        int chanceCinnabar = (int)MathHelper.clip((double)ThermalExpansion.config.get(category, "Pulverizer.Cinnabar.Chance", 25), (double)1.0, (double)100.0);
        PulverizerManager.addRecipe(3200, new ItemStack(Block.field_71981_t), new ItemStack(Block.field_71978_w));
        PulverizerManager.addRecipe(3200, new ItemStack(Block.field_71978_w), new ItemStack(Block.field_71939_E), new ItemStack(Block.field_71940_F), 10);
        PulverizerManager.addRecipe(3200, new ItemStack(Block.field_71940_F), new ItemStack(Item.field_77804_ap));
        PulverizerManager.addRecipe(3200, new ItemStack(Block.field_71946_M), new ItemStack(Block.field_71939_E));
        PulverizerManager.addRecipe(800, new ItemStack(Block.field_72007_bm), new ItemStack(Block.field_72007_bm, 1, 2));
        if (recipeSandstone) {
            PulverizerManager.addTERecipe(3200, new ItemStack(Block.field_71957_Q), new ItemStack(Block.field_71939_E, 2), TEItems.dustNiter, 15);
        }
        PulverizerManager.addRecipe(2400, new ItemStack(Item.field_77705_m, 1, 0), TEItems.dustCoal, TEItems.dustSulfur, 10);
        PulverizerManager.addRecipe(4000, new ItemStack(Block.field_72089_ap), ItemHelper.cloneStack((ItemStack)TEItems.dustObsidian, (int)4));
        if (recipeNetherrack) {
            PulverizerManager.addTERecipe(3200, new ItemStack(Block.field_72012_bb), new ItemStack(Block.field_71940_F), TEItems.dustSulfur, 10);
        }
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_71950_I), new ItemStack(Item.field_77705_m, 2, 0));
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_72073_aw), new ItemStack(Item.field_77702_n, 2, 0));
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_72068_bR), new ItemStack(Item.field_77817_bH, 2, 0));
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_72014_bd), new ItemStack(Item.field_77751_aT, 4));
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_71947_N), new ItemStack(Item.field_77756_aW, 8, 4));
        PulverizerManager.addTERecipe(3200, new ItemStack(Block.field_72047_aN), new ItemStack(Item.field_77767_aC, 6), TEItems.crystalCinnabar, chanceCinnabar);
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_94342_cr), new ItemStack(Item.field_94583_ca, 2), TEItems.dustSulfur, 10);
        for (int i = 0; i < 3; ++i) {
            PulverizerManager.addRecipe(2400, new ItemStack(Block.field_94339_ct, 1, i), new ItemStack(Item.field_94583_ca, 4));
        }
        PulverizerManager.addRecipe(2400, new ItemStack(Block.field_94338_cu), new ItemStack(Item.field_94583_ca, 6));
        PulverizerManager.addRecipe(1600, new ItemStack(Block.field_71951_J), TEItems.woodchips);
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Block.field_72107_ae), new ItemStack(Item.field_77756_aW, 4, 1));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Block.field_72097_ad), new ItemStack(Item.field_77756_aW, 4, 11));
        if (recipeCloth) {
            ItemStack silkStack = new ItemStack(Item.field_77683_K, 4);
            for (int i = 0; i < 16; ++i) {
                PulverizerManager.addTERecipe(1600, new ItemStack(Block.field_72101_ab, 1, i), silkStack);
            }
        }
        if (recipeReed) {
            PulverizerManager.addTERecipe(800, new ItemStack(Item.field_77758_aJ), new ItemStack(Item.field_77747_aY, 2));
        }
        if (recipeBone) {
            PulverizerManager.addTERecipe(1600, new ItemStack(Item.field_77755_aX), new ItemStack(Item.field_77756_aW, 6, 15));
        }
        if (recipeBlazeRod) {
            PulverizerManager.addTERecipe(1600, new ItemStack(Item.field_77731_bo), new ItemStack(Item.field_77722_bw, 4), TEItems.dustSulfur, 50);
        }
        if (recipeBlizzRod) {
            PulverizerManager.addTERecipe(1600, TEItems.rodBlizz, ItemHelper.cloneStack((ItemStack)TEItems.dustBlizz, (int)4), new ItemStack(Item.field_77768_aD), 50);
        }
    }

    public static void loadRecipes() {
        PulverizerManager.addDefaultRecipes();
        int energy = 4000;
        PulverizerManager.addOreNameToDustRecipe(energy, "oreIron", TEItems.dustIron, TEItems.dustNickel, 10);
        PulverizerManager.addOreNameToDustRecipe(energy, "oreGold", TEItems.dustGold, null, 0);
        PulverizerManager.addOreNameToDustRecipe(energy, "oreCopper", TEItems.dustCopper, TEItems.dustGold, 10);
        PulverizerManager.addOreNameToDustRecipe(energy, "oreTin", TEItems.dustTin, TEItems.dustIron, 10);
        PulverizerManager.addOreNameToDustRecipe(energy, "oreSilver", TEItems.dustSilver, TEItems.dustLead, 10);
        PulverizerManager.addOreNameToDustRecipe(energy, "oreLead", TEItems.dustLead, TEItems.dustSilver, 10);
        PulverizerManager.addOreNameToDustRecipe(energy, "oreNickel", TEItems.dustNickel, TEItems.dustPlatinum, 10);
        PulverizerManager.addOreNameToDustRecipe(energy, "orePlatinum", TEItems.dustPlatinum, null, 0);
        energy = 2400;
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotIron", TEItems.dustIron);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotGold", TEItems.dustGold);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotCopper", TEItems.dustCopper);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotTin", TEItems.dustTin);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotSilver", TEItems.dustSilver);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotLead", TEItems.dustLead);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotNickel", TEItems.dustNickel);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotPlatinum", TEItems.dustPlatinum);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotElectrum", TEItems.dustElectrum);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotInvar", TEItems.dustInvar);
        PulverizerManager.addIngotNameToDustRecipe(energy, "ingotBronze", TEItems.dustBronze);
        if (ItemHelper.oreNameExists((String)"dustCharcoal")) {
            PulverizerManager.addRecipe(1600, new ItemStack(Item.field_77705_m, 1, 1), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustCharcoal").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"dustEnderPearl")) {
            PulverizerManager.addRecipe(1600, new ItemStack(Item.field_77730_bn), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustEnderPearl").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"oreSaltpeter")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreSaltpeter").get(0), ItemHelper.cloneStack((ItemStack)TEItems.dustNiter, (int)4));
        }
        if (ItemHelper.oreNameExists((String)"oreSulfur")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreSulfur").get(0), ItemHelper.cloneStack((ItemStack)TEItems.dustSulfur, (int)6));
        }
        if (ItemHelper.oreNameExists((String)"oreCertusQuartz") && ItemHelper.oreNameExists((String)"dustCertusQuartz") && ItemHelper.oreNameExists((String)"crystalCertusQuartz")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreCertusQuartz").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0)), (int)2), (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0), 10);
            PulverizerManager.addRecipe(1600, (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0), (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0));
        }
        if (ItemHelper.oreNameExists((String)"dustNetherQuartz")) {
            PulverizerManager.addRecipe(1600, new ItemStack(Item.field_94583_ca, 1), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustNetherQuartz").get(0)), (int)1));
        }
        String[] oreNameList = OreDictionary.getOreNames();
        String oreName = "";
        for (int i = 0; i < oreNameList.length; ++i) {
            if (oreNameList[i].startsWith("ore")) {
                oreName = oreNameList[i].substring(3, oreNameList[i].length());
                PulverizerManager.addDefaultOreDictionaryRecipe(oreName);
                continue;
            }
            if (!oreNameList[i].startsWith("dust")) continue;
            oreName = oreNameList[i].substring(4, oreNameList[i].length());
            PulverizerManager.addDefaultOreDictionaryRecipe(oreName);
        }
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null || energy <= 0) {
            return false;
        }
        RecipePulverizer recipe = new RecipePulverizer(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(new ComparableItemStackPulverizer(input), recipe);
        return true;
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        if (input == null || primaryOutput == null || energy <= 0 || !(allowOverwrite & overwrite) && PulverizerManager.recipeExists(input)) {
            return false;
        }
        RecipePulverizer recipe = new RecipePulverizer(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(new ComparableItemStackPulverizer(input), recipe);
        return true;
    }

    public static void addDefaultOreDictionaryRecipe(String oreType) {
        PulverizerManager.addDefaultOreDictionaryRecipe(oreType, "");
    }

    public static void addDefaultOreDictionaryRecipe(String oreType, String relatedType) {
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        ArrayList registeredOre = OreDictionary.getOres((String)oreName);
        ArrayList registeredDust = OreDictionary.getOres((String)dustName);
        ArrayList registeredIngot = OreDictionary.getOres((String)ingotName);
        ArrayList registeredRelated = new ArrayList();
        String clusterName = "cluster" + StringHelper.titleCase((String)oreType);
        ArrayList registeredCluster = OreDictionary.getOres((String)clusterName);
        if (relatedType != "") {
            String relatedName = "dust" + StringHelper.titleCase((String)relatedType);
            registeredRelated = OreDictionary.getOres((String)relatedName);
        }
        if (registeredDust.isEmpty()) {
            return;
        }
        if (registeredIngot.isEmpty()) {
            ingotName = null;
        }
        if (registeredOre.isEmpty()) {
            oreName = null;
        }
        if (registeredCluster.isEmpty()) {
            clusterName = null;
        }
        if (!registeredRelated.isEmpty()) {
            PulverizerManager.addOreNameToDustRecipe(4000, oreName, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), ItemHelper.cloneStack((ItemStack)((ItemStack)registeredRelated.get(0)), (int)1), 5);
            PulverizerManager.addOreNameToDustRecipe(4800, clusterName, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), ItemHelper.cloneStack((ItemStack)((ItemStack)registeredRelated.get(0)), (int)1), 5);
        } else {
            PulverizerManager.addOreNameToDustRecipe(4000, oreName, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), null, 0);
            PulverizerManager.addOreNameToDustRecipe(4800, clusterName, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), null, 0);
        }
        PulverizerManager.addIngotNameToDustRecipe(2400, ingotName, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)1));
    }

    public static void addOreNameToDustRecipe(int energy, String oreName, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryOutput == null || oreName == null) {
            return;
        }
        ArrayList registeredOres = OreDictionary.getOres((String)oreName);
        if (!registeredOres.isEmpty()) {
            PulverizerManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)primaryOutput, (int)2), secondaryOutput, secondaryChance);
        }
    }

    public static void addOreToDustRecipe(int energy, ItemStack ore, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryOutput == null) {
            return;
        }
        ItemStack dust = ItemHelper.cloneStack((ItemStack)primaryOutput, (int)2);
        PulverizerManager.addRecipe(energy, ore, dust, secondaryOutput, secondaryChance);
    }

    public static void addIngotNameToDustRecipe(int energy, String ingotName, ItemStack dust) {
        if (dust == null || ingotName == null) {
            return;
        }
        ArrayList registeredOres = OreDictionary.getOres((String)ingotName);
        if (!registeredOres.isEmpty()) {
            PulverizerManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(0)), (int)1), dust, null, 0);
        }
    }

    public static void addIngotNameToDustRecipe(int energy, String oreType) {
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return PulverizerManager.addTERecipe(energy, input, primaryOutput, null, 0);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, false);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, boolean overwrite) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, null, 0, overwrite);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, secondaryOutput, false);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, boolean overwrite) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, secondaryOutput, 100, overwrite);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Pulverizer.AllowRecipeOverwrite", false);
    }

    public static class ComparableItemStackPulverizer
    extends ComparableItemStack {
        static final String BLOCK = "block";
        static final String ORE = "ore";
        static final String DUST = "dust";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String LOG = "log";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(BLOCK) || oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(INGOT) || oreName.startsWith(NUGGET) || oreName.startsWith(LOG);
        }

        public static int getOreID(ItemStack stack) {
            int id = OreDictionary.getOreID((ItemStack)stack);
            if (id == -1 || !ComparableItemStackPulverizer.safeOreType(OreDictionary.getOreName((int)id))) {
                return -1;
            }
            return id;
        }

        public static int getOreID(String oreName) {
            if (!ComparableItemStackPulverizer.safeOreType(oreName)) {
                return -1;
            }
            return OreDictionary.getOreID((String)oreName);
        }

        public ComparableItemStackPulverizer(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackPulverizer.getOreID(stack);
        }

        public ComparableItemStackPulverizer(int itemID, int damage, int stackSize) {
            super(itemID, damage, stackSize);
            this.oreID = ComparableItemStackPulverizer.getOreID(this.toItemStack());
        }

        public ComparableItemStackPulverizer set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackPulverizer.getOreID(stack);
            return this;
        }
    }

    public static class RecipePulverizer {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipePulverizer(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

