/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util;

import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.util.crafting.CrucibleManager;
import thermalexpansion.util.crafting.FurnaceManager;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.SawmillManager;
import thermalexpansion.util.crafting.SmelterManager;
import thermalexpansion.util.crafting.TransposerManager;

public class IMCHandler {
    public static IMCHandler instance = new IMCHandler();

    public void handleIMC(FMLInterModComms.IMCEvent theIMC) {
        for (FMLInterModComms.IMCMessage theMessage : theIMC.getMessages()) {
            try {
                int energy;
                String fluidName;
                if (!theMessage.isNBTMessage()) continue;
                NBTTagCompound theNBT = theMessage.getNBTValue();
                if (theMessage.key.equalsIgnoreCase("CrucibleRecipe")) {
                    CrucibleManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), FluidStack.loadFluidStackFromNBT((NBTTagCompound)theNBT.func_74775_l("output")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("FurnaceRecipe")) {
                    FurnaceManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("output")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("PulverizerRecipe")) {
                    if (theNBT.func_74764_b("secondaryChance")) {
                        PulverizerManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryOutput")), theNBT.func_74762_e("secondaryChance"), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                        continue;
                    }
                    if (theNBT.func_74764_b("secondaryOutput")) {
                        PulverizerManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryOutput")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                        continue;
                    }
                    PulverizerManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("SmelterRecipe")) {
                    if (theNBT.func_74764_b("secondaryChance")) {
                        SmelterManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryInput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryInput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryOutput")), theNBT.func_74762_e("secondaryChance"), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                        continue;
                    }
                    if (theNBT.func_74764_b("secondaryOutput")) {
                        SmelterManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryInput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryInput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryOutput")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                        continue;
                    }
                    SmelterManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryInput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryInput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("SmelterBlastOreType")) {
                    if (!theNBT.func_74764_b("oreType")) continue;
                    SmelterManager.addBlastOreName(theNBT.func_74779_i("oreType"));
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("SawmillRecipe")) {
                    if (theNBT.func_74764_b("secondaryChance")) {
                        SawmillManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryOutput")), theNBT.func_74762_e("secondaryChance"), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                        continue;
                    }
                    if (theNBT.func_74764_b("secondaryOutput")) {
                        SawmillManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("secondaryOutput")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                        continue;
                    }
                    SawmillManager.addRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("primaryOutput")), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("TransposerFillRecipe")) {
                    TransposerManager.addFillRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("output")), FluidStack.loadFluidStackFromNBT((NBTTagCompound)theNBT.func_74775_l("fluid")), theNBT.func_74767_n("reversible"), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("TransposerExtractRecipe")) {
                    TransposerManager.addExtractionRecipe(theNBT.func_74762_e("energy"), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("input")), ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("output")), FluidStack.loadFluidStackFromNBT((NBTTagCompound)theNBT.func_74775_l("fluid")), theNBT.func_74762_e("chance"), theNBT.func_74767_n("reversible"), theNBT.func_74764_b("overwrite") ? theNBT.func_74767_n("overwrite") : false);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("MagmaticFuel")) {
                    fluidName = theNBT.func_74779_i("fluidName").toLowerCase(Locale.ENGLISH);
                    if (!TEFluids.registerMagmaticFuel(fluidName, energy = theNBT.func_74762_e("energy"))) continue;
                    TEFluids.configFuels.get("fuels.magmatic", fluidName, energy);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("CompressionFuel")) {
                    fluidName = theNBT.func_74779_i("fluidName").toLowerCase(Locale.ENGLISH);
                    if (!TEFluids.registerCompressionFuel(fluidName, energy = theNBT.func_74762_e("energy"))) continue;
                    TEFluids.configFuels.get("fuels.compression", fluidName, energy);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("ReactantFuel")) {
                    fluidName = theNBT.func_74779_i("fluidName").toLowerCase(Locale.ENGLISH);
                    if (!TEFluids.registerCompressionFuel(fluidName, energy = theNBT.func_74762_e("energy"))) continue;
                    TEFluids.configFuels.get("fuels.reactant", fluidName, energy);
                    continue;
                }
                if (theMessage.key.equalsIgnoreCase("Coolant")) {
                    fluidName = theNBT.func_74779_i("fluidName").toLowerCase(Locale.ENGLISH);
                    if (!TEFluids.registerCoolant(fluidName, energy = theNBT.func_74762_e("energy"))) continue;
                    TEFluids.configFuels.get("coolants", fluidName, energy);
                    continue;
                }
                ThermalExpansion.log.warning("ThermalExpansion received an invalid IMC from " + theMessage.getSender() + "! Key was " + theMessage.key);
            }
            catch (Exception e) {
                ThermalExpansion.log.warning("ThermalExpansion received an broken IMC from " + theMessage.getSender() + "!");
                e.printStackTrace();
            }
        }
    }
}

