/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.item;

import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.part.conduit.item.ConduitItem;

public class ItemRoute
implements Comparable<ItemRoute> {
    LinkedList<Byte> pathDirections = new LinkedList();
    int pathPos = 0;
    ConduitItem endPoint;
    ConduitItem startPoint;
    int pathLength = 0;
    boolean routeFinished = false;

    public ItemRoute(ConduitItem myParent) {
        this.startPoint = myParent;
        this.endPoint = myParent;
        myParent.wasVisited = true;
    }

    public ItemRoute(ItemRoute prevRoute, ConduitItem newPlace, byte direction, boolean isFinished) {
        this.pathDirections = (LinkedList)prevRoute.pathDirections.clone();
        this.pathLength = prevRoute.pathLength + newPlace.getLength();
        this.endPoint = newPlace;
        this.startPoint = prevRoute.startPoint;
        this.pathDirections.add(direction);
        this.routeFinished = isFinished;
    }

    public ItemRoute(ItemRoute prevRoute, boolean endPath) {
        this.pathDirections = (LinkedList)prevRoute.pathDirections.clone();
        this.pathLength = prevRoute.pathLength;
        this.endPoint = prevRoute.endPoint;
        this.startPoint = prevRoute.startPoint;
        this.routeFinished = true;
    }

    public ItemRoute(ItemRoute prevRoute) {
        this.pathDirections = (LinkedList)prevRoute.pathDirections.clone();
        this.pathLength = prevRoute.pathLength;
        this.endPoint = prevRoute.endPoint;
        this.startPoint = prevRoute.startPoint;
        this.routeFinished = prevRoute.routeFinished;
    }

    public void moveForwards(LinkedList<ItemRoute> newRoutes, LinkedList<ItemRoute> outputRoutes) {
        boolean foundRoute = false;
        ConduitItem foundPath = null;
        byte foundDir = -1;
        for (byte i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; i = (byte)((byte)(i + 1))) {
            if (this.endPoint.sideType[i] == 1) {
                ConduitItem validTile = (ConduitItem)this.endPoint.getConduit(i);
                if (validTile.wasVisited) continue;
                validTile.wasVisited = true;
                if (!foundRoute) {
                    foundPath = validTile;
                    foundDir = i;
                    foundRoute = true;
                    continue;
                }
                newRoutes.add(new ItemRoute(this, validTile, i, false));
                continue;
            }
            if (!this.endPoint.isOutput || this.endPoint.wasOutput) continue;
            outputRoutes.add(new ItemRoute(this, true));
            this.endPoint.wasOutput = true;
        }
        if (!foundRoute) {
            this.routeFinished = true;
        } else {
            this.pathDirections.add(foundDir);
            this.pathLength += foundPath.getLength();
            this.endPoint = foundPath;
        }
    }

    public void moveForwards(LinkedList<ItemRoute> newRoutes, LinkedList<ItemRoute> outputRoutes, LinkedList<ItemRoute> stuffableRoutes) {
        boolean foundRoute = false;
        ConduitItem foundPath = null;
        byte foundDir = -1;
        for (byte i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; i = (byte)((byte)(i + 1))) {
            if (this.endPoint.sideType[i] == 1) {
                ConduitItem validTile = (ConduitItem)this.endPoint.getConduit(i);
                if (validTile == null || validTile.wasVisited) continue;
                validTile.wasVisited = true;
                if (validTile.canStuffItem()) {
                    stuffableRoutes.add(new ItemRoute(this, validTile, i, true));
                }
                if (!foundRoute) {
                    foundPath = validTile;
                    foundDir = i;
                    foundRoute = true;
                    continue;
                }
                newRoutes.add(new ItemRoute(this, validTile, i, false));
                continue;
            }
            if (!this.endPoint.isOutput || this.endPoint.wasOutput) continue;
            outputRoutes.add(new ItemRoute(this, true));
            this.endPoint.wasOutput = true;
        }
        if (!foundRoute) {
            this.routeFinished = true;
        } else {
            this.pathDirections.add(foundDir);
            this.pathLength += foundPath.getLength();
            this.endPoint = foundPath;
        }
    }

    @Override
    public int compareTo(ItemRoute otherRoute) {
        if (this.pathLength < otherRoute.pathLength) {
            return -1;
        }
        if (this.pathLength > otherRoute.pathLength) {
            return 1;
        }
        return 0;
    }

    public ItemRoute copy() {
        return new ItemRoute(this);
    }

    public int getNextDirection() {
        return this.pathDirections.get(this.pathPos++).byteValue();
    }

    public boolean hasNextDirection() {
        return this.pathDirections.size() > this.pathPos;
    }

    public int getCurrentDirection() {
        return this.pathDirections.get(this.pathPos).byteValue();
    }

    public int checkNextDirection() {
        return this.pathDirections.get(this.pathPos + 1).byteValue();
    }

    public int getLastSide() {
        return this.pathDirections.size() > 0 ? (int)this.pathDirections.get(this.pathDirections.size() - 1).byteValue() : 0;
    }
}

