/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit;

import java.util.LinkedHashSet;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.GridTickHandler;

public class Grid {
    public LinkedHashSet<ConduitBase> nodeSet = new LinkedHashSet();
    public LinkedHashSet<ConduitBase> conduitSet = new LinkedHashSet();

    public Grid(ConduitBase myNode) {
        this.addConduit(myNode);
        GridTickHandler.tickingGridsToAdd.add(this);
    }

    protected Grid() {
    }

    public void addConduit(ConduitBase theCond) {
        if (theCond.isNode && !this.nodeSet.contains(theCond)) {
            this.nodeSet.add(theCond);
            this.rebalanceGrid();
            this.nodeAdded(theCond);
        } else if (!theCond.isNode && !this.conduitSet.contains(theCond)) {
            this.conduitSet.add(theCond);
        }
        if (GridTickHandler.tickingGrids.contains(this) || GridTickHandler.tickingGridsToAdd.contains(this)) {
            return;
        }
        GridTickHandler.tickingGridsToAdd.add(this);
    }

    public void removeConduit(ConduitBase theCond) {
        this.nodeSet.remove(theCond);
        this.conduitSet.remove(theCond);
        if (theCond.isNode) {
            this.rebalanceGrid();
        }
        if (this.nodeSet.isEmpty() && this.conduitSet.isEmpty()) {
            GridTickHandler.tickingGridsToRemove.add(this);
        }
    }

    public void nodeAdded(ConduitBase theCond) {
    }

    public void rebalanceGrid() {
    }

    public void makeNode(ConduitBase conduitBase) {
        this.conduitSet.remove(conduitBase);
        this.addConduit(conduitBase);
    }

    public void makeConduit(ConduitBase conduitBase) {
        this.conduitSet.remove(conduitBase);
        this.addConduit(conduitBase);
    }

    public LinkedHashSet<ConduitBase> destroyGrid() {
        GridTickHandler.tickingGridsToRemove.add(this);
        for (ConduitBase curCond : this.nodeSet) {
            this.destroyNode(curCond);
        }
        for (ConduitBase curCond : this.conduitSet) {
            this.destroyConduit(curCond);
        }
        this.conduitSet.clear();
        return this.nodeSet;
    }

    public void regenerateGrid() {
        GridTickHandler.tickingGridsToRemove.add(this);
        for (ConduitBase curCond : this.nodeSet) {
            this.destroyNode(curCond);
        }
        for (ConduitBase curCond : this.conduitSet) {
            this.destroyConduit(curCond);
        }
        for (ConduitBase curCond : this.nodeSet) {
            curCond.calculateGrid();
        }
        for (ConduitBase curCond : this.conduitSet) {
            curCond.calculateGrid();
        }
        this.conduitSet.clear();
        this.nodeSet.clear();
    }

    public void destroyNode(ConduitBase theNode) {
        theNode.setGrid(null);
    }

    public void destroyConduit(ConduitBase theCond) {
        theCond.setGrid(null);
    }

    public void gridFormed() {
        for (ConduitBase curCond : this.nodeSet) {
            curCond.hasBeenTransversed = false;
        }
        for (ConduitBase curCond : this.conduitSet) {
            curCond.hasBeenTransversed = false;
        }
    }

    public void doGridUpdate() {
        if (this.nodeSet.isEmpty() && this.conduitSet.isEmpty()) {
            GridTickHandler.tickingGridsToRemove.add(this);
            return;
        }
        for (ConduitBase curCond : this.nodeSet) {
            curCond.doOutput();
        }
        for (ConduitBase curCond : this.nodeSet) {
            curCond.doInput();
        }
    }

    public void mergeGrid(Grid theGrid) {
        for (ConduitBase aConduit : theGrid.nodeSet) {
            aConduit.setGrid(this);
        }
        for (ConduitBase aConduit : theGrid.conduitSet) {
            aConduit.setGrid(this);
        }
        this.nodeSet.addAll(theGrid.nodeSet);
        this.conduitSet.addAll(theGrid.conduitSet);
        this.rebalanceGrid();
        GridTickHandler.tickingGridsToRemove.add(theGrid);
    }

    public boolean canGridMerge(Grid theNewGrid) {
        return true;
    }

    public int getConduitCount() {
        return this.nodeSet.size() + this.conduitSet.size();
    }

    public boolean isFirstConduit(ConduitBase theCond) {
        return !this.nodeSet.isEmpty() ? ((ConduitBase)this.nodeSet.iterator().next()).equals(theCond) : (!this.conduitSet.isEmpty() ? ((ConduitBase)this.conduitSet.iterator().next()).equals(theCond) : false);
    }

    public void setUntransversed() {
        for (ConduitBase aConduit : this.nodeSet) {
            aConduit.hasBeenTransversed = false;
        }
        for (ConduitBase aConduit : this.conduitSet) {
            aConduit.hasBeenTransversed = false;
        }
    }
}

