/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cofh.block.ITileInfo;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.item.TEItems;
import thermalexpansion.part.PartOcclusionTest;
import thermalexpansion.part.PartRSBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.GridFormer;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.IConduit;
import thermalexpansion.part.conduit.PropsConduit;
import thermalexpansion.part.conduit.energy.ConduitEnergy;
import thermalexpansion.part.conduit.fluid.ConduitFluid;
import thermalexpansion.part.conduit.item.ConduitItem;
import thermalexpansion.render.RenderConduit;
import thermalexpansion.util.Utils;

public abstract class ConduitBase
extends PartRSBase
implements ITileInfoPacketHandler,
INeighborTileChange,
IConduit,
TSlottedPart,
JNormalOcclusion,
ITileInfo,
JIconHitEffects {
    public byte[] sideType = new byte[]{0, 0, 0, 0, 0, 0};
    public byte[] sideMode = new byte[]{1, 1, 1, 1, 1, 1};
    public boolean isNode = false;
    public Grid gridBase;
    public boolean isInput = false;
    public boolean isOutput = false;
    public boolean hasServo = false;
    public ConduitBase[] conduitCache = new ConduitBase[6];
    public CacheTypes[] cacheType = new CacheTypes[6];
    public boolean hasBeenTransversed = false;
    public boolean isConduitDead = false;
    public byte conduitType = 0;
    public byte internal_mode = 0;
    public byte sideTracker = 0;
    GridFormer myFormer = new GridFormer();
    public static List<Cuboid6> myOcclusions = new LinkedList<Cuboid6>();
    double minX;
    double minY;
    double minZ;
    double maxX;
    double maxY;
    double maxZ;

    public ConduitBase(byte type) {
        this.conduitType = type;
    }

    public String getType() {
        return null;
    }

    public void doOutput() {
    }

    public void doInput() {
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
    }

    @Override
    public void writeDesc(MCDataOutput payload) {
        super.writeDesc(payload);
        payload.writeByteArray(this.sideType);
        payload.writeByteArray(this.sideMode);
        payload.writeByte((int)this.internal_mode);
        payload.writeByte((int)this.conduitType);
        payload.writeBoolean(this.hasServo);
    }

    @Override
    public void readDesc(MCDataInput payload) {
        super.readDesc(payload);
        this.sideType = payload.readByteArray(this.sideType.length);
        this.sideMode = payload.readByteArray(this.sideMode.length);
        this.internal_mode = payload.readByte();
        this.conduitType = payload.readByte();
        this.hasServo = payload.readBoolean();
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.internal_mode = nbt.func_74771_c("Mode");
        this.conduitType = nbt.func_74771_c("SubType");
        this.sideTracker = nbt.func_74771_c("Tracker");
        this.sideType = nbt.func_74770_j("SideType");
        this.sideMode = nbt.func_74770_j("SideMode");
        this.hasServo = nbt.func_74767_n("hasServo");
        this.updateInternalTypes();
        if (this.isNode) {
            GridTickHandler.tickConduitToAdd.add(this);
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74774_a("Mode", this.internal_mode);
        nbt.func_74774_a("SubType", this.conduitType);
        nbt.func_74774_a("Tracker", this.sideTracker);
        nbt.func_74773_a("SideType", this.sideType);
        nbt.func_74773_a("SideMode", this.sideMode);
        nbt.func_74757_a("hasServo", this.hasServo);
    }

    public void onChunkUnload() {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        if (this.gridBase != null) {
            this.tileUnloading();
            this.gridBase.removeConduit(this);
            this.setGrid(null);
        }
    }

    public void onNeighborTileChanged(int side, boolean weak) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        TileEntity curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)side);
        byte oldType = this.sideType[side];
        boolean wasNode = this.isNode;
        this.sideType[side] = 0;
        if (curTile != null && this.passOcclusionTest(side)) {
            if (this.isConduit(curTile)) {
                if (this.theyPassOcclusionTest((IConduit)curTile, side)) {
                    this.cacheConduit(curTile, side);
                    this.sideType[side] = 1;
                }
            } else if (this.isImportant(curTile, side)) {
                this.cacheImportant(curTile, side);
                this.sideType[side] = 2;
                this.isNode = true;
            }
        }
        if (this.gridBase != null) {
            if (this.isNode && !wasNode) {
                this.gridBase.makeNode(this);
            } else if (!this.isNode && wasNode) {
                this.gridBase.makeConduit(this);
            }
        }
        if (this.sideType[side] != oldType) {
            this.sideChanged(null, side, oldType);
        }
        this.updateInternalTypes();
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        byte[] oldType = new byte[6];
        boolean wasNode = this.isNode;
        boolean sideChanged = false;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            TileEntity curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)i);
            oldType[i] = this.sideType[i];
            this.sideType[i] = 0;
            if (curTile != null && this.passOcclusionTest(i)) {
                if (this.isConduit(curTile)) {
                    if (this.theyPassOcclusionTest((IConduit)curTile, i)) {
                        this.cacheConduit(curTile, i);
                        this.sideType[i] = 1;
                    }
                } else if (this.isImportant(curTile, i)) {
                    this.cacheImportant(curTile, i);
                    this.sideType[i] = 2;
                    this.isNode = true;
                }
            }
            if (this.sideType[i] == oldType[i]) continue;
            sideChanged = true;
        }
        if (this.gridBase != null) {
            if (this.isNode && !wasNode) {
                this.gridBase.makeNode(this);
            } else if (!this.isNode && wasNode) {
                this.gridBase.makeConduit(this);
            }
        }
        if (sideChanged) {
            this.sideChanged(oldType, -1, -1);
        }
        this.updateInternalTypes();
    }

    public void sideChanged(byte[] oldType, int side, int oldMode) {
        this.sendDescUpdate();
    }

    public boolean weakTileChanges() {
        return false;
    }

    public void onAdded() {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        this.isConduitDead = false;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            TileEntity curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)i);
            this.sideType[i] = 0;
            if (curTile == null || !this.passOcclusionTest(i)) continue;
            if (this.isConduit(curTile)) {
                if (!this.theyPassOcclusionTest((IConduit)curTile, i)) continue;
                this.cacheConduit(curTile, i);
                this.sideType[i] = 1;
                continue;
            }
            if (!this.isImportant(curTile, i)) continue;
            this.cacheImportant(curTile, i);
            this.sideType[i] = 2;
            this.isNode = true;
        }
        this.setRedstoneConfig(false, true);
        this.updateInternalTypes();
        this.calculateGrid();
        this.sendDescUpdate();
    }

    public void onPartChanged(TMultiPart part) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        boolean wasNode = this.isNode;
        boolean gridBreaker = false;
        ConduitBase[] connectedConduit = new ConduitBase[6];
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            TileEntity curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)i);
            byte oldType = this.sideType[i];
            this.sideType[i] = 0;
            if (curTile != null) {
                if (this.isConduit(curTile)) {
                    connectedConduit[i] = ((IConduit)curTile).getConduit();
                    if (this.bothPassOcclusionTest(i, connectedConduit[i])) {
                        this.cacheConduit(curTile, i);
                        this.sideType[i] = 1;
                    }
                } else if (this.isImportant(curTile, i) && this.passOcclusionTest(i)) {
                    this.cacheImportant(curTile, i);
                    this.sideType[i] = 2;
                    this.isNode = true;
                }
            }
            if (this.sideType[i] == oldType || this.sideType[i] != 1 && oldType != 1) continue;
            gridBreaker = true;
            if (connectedConduit[i] == null) continue;
            if (oldType == 1) {
                connectedConduit[i].sideType[i ^ 1] = 0;
                connectedConduit[i].conduitCache[i ^ 1] = null;
            } else {
                connectedConduit[i].sideType[i ^ 1] = 1;
                connectedConduit[i].cacheConduit((TileEntity)this.tile(), i ^ 1);
            }
            connectedConduit[i].sendDescUpdate();
        }
        if (gridBreaker) {
            LinkedHashSet<Object> resultingNodes = new LinkedHashSet();
            if (this.gridBase != null) {
                resultingNodes = this.gridBase.destroyGrid();
            }
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (connectedConduit[i] == null || connectedConduit[i].gridBase == null) continue;
                resultingNodes.addAll(connectedConduit[i].gridBase.destroyGrid());
            }
            this.calculateGrid();
            for (ConduitBase conduitBase : resultingNodes) {
                conduitBase.calculateGrid();
            }
        } else {
            this.world().func_72898_h(this.x(), this.y(), this.z(), Block.field_71981_t.field_71990_ca);
        }
        this.updateInternalTypes();
        this.sendDescUpdate();
    }

    public void onRemoved() {
        this.isConduitDead = true;
        int side = 0;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this.sideType[i] != 1) continue;
            ++side;
        }
        if (this.gridBase != null) {
            if (side > 1) {
                this.gridBase.removeConduit(this);
                this.gridBase.regenerateGrid();
            } else {
                this.gridBase.removeConduit(this);
            }
        }
        this.setGrid(null);
    }

    public void onWorldSeparate() {
        this.onRemoved();
    }

    public void onMoved() {
        this.onAdded();
    }

    public abstract boolean isImportant(TileEntity var1, int var2);

    public abstract boolean isConduit(TileEntity var1);

    public void setGrid(Grid newGrid) {
        this.gridBase = newGrid;
    }

    public void calculateGrid() {
        if (this.gridBase == null && !this.isConduitDead) {
            this.myFormer.setup(this);
            this.myFormer.moveForwards(this.gridBase, this);
            this.gridBase.setUntransversed();
        }
    }

    public void cacheConduit(TileEntity theTile, int side) {
        this.conduitCache[side] = theTile instanceof IConduit ? ((IConduit)theTile).getConduit() : null;
    }

    public abstract void cacheImportant(TileEntity var1, int var2);

    public void tileUnloading() {
    }

    public ConduitBase getConduit(int side) {
        TileEntity adjTile;
        if (this.conduitCache[side] == null && (adjTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)side)) instanceof IConduit) {
            this.cacheConduit(adjTile, side);
        }
        return this.conduitCache[side];
    }

    public void updateInternalTypes() {
        this.isNode = false;
        this.isOutput = false;
        this.isInput = false;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this.sideType[i] != 2) continue;
            if (this.sideMode[i] == 1) {
                this.isOutput = true;
            } else if (this.sideMode[i] == 2) {
                this.isInput = true;
            }
            this.isNode = true;
        }
    }

    public void increaseTracker() {
        byte i;
        for (i = this.sideTracker = (byte)(this.sideTracker + 1); i < 6; i = (byte)(i + 1)) {
            if (this.sideType[i] <= 1) continue;
            this.sideTracker = i;
            return;
        }
        for (i = 0; i < this.sideTracker; i = (byte)(i + 1)) {
            if (this.sideType[i] <= 1) continue;
            this.sideTracker = i;
            return;
        }
        this.sideTracker = 0;
    }

    public abstract Grid createNewGrid();

    @Override
    public ConduitBase getConduit() {
        return this;
    }

    @Override
    public boolean isItemConduit() {
        return false;
    }

    @Override
    public boolean isFluidConduit() {
        return false;
    }

    @Override
    public int isEnergyConduit() {
        return -1;
    }

    @Override
    public ConduitEnergy getConduitEnergy() {
        return null;
    }

    @Override
    public ConduitFluid getConduitFluid() {
        return null;
    }

    @Override
    public ConduitItem getConduitItem() {
        return null;
    }

    @Override
    public boolean isEnderConduit() {
        return false;
    }

    public boolean doesTick() {
        return false;
    }

    public boolean passOcclusionTest(int side) {
        return this.tile().occlusionTest(this.tile().partList(), (TMultiPart)PropsConduit.CONDUIT_OCCLUSION[side]);
    }

    public boolean theyPassOcclusionTest(IConduit them, int side) {
        return them.getConduit().tile().occlusionTest(them.getConduit().tile().partList(), (TMultiPart)PropsConduit.CONDUIT_OCCLUSION[BlockHelper.getOppositeSide((int)side)]);
    }

    public boolean bothPassOcclusionTest(int side, ConduitBase them) {
        return this.theyPassOcclusionTest(them, side) && this.passOcclusionTest(side);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return myOcclusions;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return npart instanceof PartOcclusionTest ? true : NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Cuboid6 getBounds() {
        this.minZ = 0.3;
        this.minY = 0.3;
        this.minX = 0.3;
        this.maxZ = 0.7;
        this.maxY = 0.7;
        this.maxX = 0.7;
        if (this.sideType[0] != 0) {
            this.minY = 0.0;
        }
        if (this.sideType[1] != 0) {
            this.maxY = 1.0;
        }
        if (this.sideType[2] != 0) {
            this.minZ = 0.0;
        }
        if (this.sideType[3] != 0) {
            this.maxZ = 1.0;
        }
        if (this.sideType[4] != 0) {
            this.minX = 0.0;
        }
        if (this.sideType[5] != 0) {
            this.maxX = 1.0;
        }
        return new Cuboid6(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> myResults = new LinkedList<Cuboid6>();
        this.minZ = 0.3;
        this.minY = 0.3;
        this.minX = 0.3;
        this.maxZ = 0.7;
        this.maxY = 0.7;
        this.maxX = 0.7;
        if (this.sideType[0] != 0) {
            this.minY = 0.0;
        }
        if (this.sideType[1] != 0) {
            this.maxY = 1.0;
        }
        if (this.sideType[2] != 0) {
            this.minZ = 0.0;
        }
        if (this.sideType[3] != 0) {
            this.maxZ = 1.0;
        }
        if (this.sideType[4] != 0) {
            this.minX = 0.0;
        }
        if (this.sideType[5] != 0) {
            this.maxX = 1.0;
        }
        myResults.add(new Cuboid6(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ));
        return myResults;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        LinkedList<IndexedCuboid6> myResults = new LinkedList<IndexedCuboid6>();
        this.minZ = 0.3;
        this.minY = 0.3;
        this.minX = 0.3;
        this.maxZ = 0.7;
        this.maxY = 0.7;
        this.maxX = 0.7;
        Vector3 pos = new Vector3((double)this.x(), (double)this.y(), (double)this.z());
        for (int i = 0; i < 6; ++i) {
            if (this.sideType[i] < 2) continue;
            myResults.add(new IndexedCuboid6((Object)i, PropsConduit.CONDUIT_SUBSELECTION[i].copy()));
        }
        if (this.sideType[0] == 1) {
            this.minY = 0.0;
        }
        if (this.sideType[1] == 1) {
            this.maxY = 1.0;
        }
        if (this.sideType[2] == 1) {
            this.minZ = 0.0;
        }
        if (this.sideType[3] == 1) {
            this.maxZ = 1.0;
        }
        if (this.sideType[4] == 1) {
            this.minX = 0.0;
        }
        if (this.sideType[5] == 1) {
            this.maxX = 1.0;
        }
        myResults.add(new IndexedCuboid6((Object)6, new Cuboid6(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ)));
        return myResults;
    }

    public int getSlotMask() {
        return 64;
    }

    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        RenderConduit.instance.renderPart(this, pass);
    }

    public abstract int getRenderType();

    public abstract int getConnectionType(int var1);

    public int[] getConnectionTypeArray() {
        return new int[]{this.getConnectionType(0), this.getConnectionType(1), this.getConnectionType(2), this.getConnectionType(3), this.getConnectionType(4), this.getConnectionType(5)};
    }

    public abstract ItemStack pickItem(MovingObjectPosition var1);

    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> myList = new LinkedList<ItemStack>();
        if (this.hasServo) {
            myList.add(TEItems.pneumaticServo.func_77946_l());
        }
        return myList;
    }

    public void setUnvisited() {
    }

    public void setRouteInvalid() {
    }

    public int getStuffedSize() {
        return 0;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        Item equipped;
        Item item2 = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player)) {
                if (ServerHelper.isServerWorld((World)this.world())) {
                    this.dismantlePart(player);
                }
                return true;
            }
            return false;
        }
        if (!(player instanceof EntityPlayerMP) || hit == null) {
            return false;
        }
        if (Utils.isHoldingUsableWrench(player)) {
            if (ServerHelper.isServerWorld((World)this.world())) {
                if (hit.subHit < 6) {
                    this.wrenchSide(player, hit.subHit);
                } else {
                    this.wrenchMiddle(player, BlockHelper.getCurrentMousedOverSide((EntityPlayer)player));
                }
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.x(), this.y(), this.z());
            return true;
        }
        if (Utils.isHoldingNothing(player)) {
            if (!this.hasServo && this.isEnergyConduit() == -1) {
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)StringHelper.localize((String)"message.thermalexpansion.conduit.servo0")));
            }
            if (hit.subHit < 6) {
                return this.punchSide(player, hit.subHit);
            }
            return this.punchMiddle(player, BlockHelper.getCurrentMousedOverSide((EntityPlayer)player));
        }
        if (Utils.isHoldingServo(player)) {
            if (!this.hasServo && this.isEnergyConduit() == -1) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                    if (player.func_71045_bC().field_77994_a <= 0) {
                        player.func_70062_b(0, null);
                    }
                }
                this.hasServo = true;
                this.servoInstalled(hit.subHit);
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)StringHelper.localize((String)"message.thermalexpansion.conduit.servo1")));
            } else if (this.isEnergyConduit() == -1) {
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)StringHelper.localize((String)"message.thermalexpansion.conduit.servo2")));
            }
            return true;
        }
        return false;
    }

    public void servoInstalled(int side) {
    }

    public void dismantlePart(EntityPlayer player) {
        for (ItemStack curStack : this.getDrops()) {
            CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)curStack, (World)this.world(), (double)this.x(), (double)this.y(), (double)this.z());
        }
        this.tile().remPart((TMultiPart)this);
    }

    public void wrenchSide(EntityPlayer player, int subHit) {
        if (this.sideType[subHit] == 2) {
            int n = subHit;
            byte by = (byte)(this.sideMode[n] + 1);
            this.sideMode[n] = by;
            this.sideMode[subHit] = (byte)(by % 2);
            this.updateInternalTypes();
            this.onNeighborChangedRS();
            this.sendDescUpdate();
        }
    }

    public boolean wrenchMiddle(EntityPlayer player, int hitSide) {
        return false;
    }

    public boolean punchSide(EntityPlayer player, int subHit) {
        return this.punchMiddle(player, subHit);
    }

    public boolean punchMiddle(EntityPlayer player, int hitSide) {
        return false;
    }

    public void getTileInfo(List<String> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        if (this.gridBase == null) {
            info.add("Grid: Null");
            return;
        }
        if (debug) {
            this.gridBase.destroyGrid();
            this.calculateGrid();
            return;
        }
        info.add("Grid: " + this.gridBase + " - Conduits: " + this.gridBase.getConduitCount());
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBrokenIcon(int side) {
        return RenderConduit.instance.getFrameTexture(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer);
    }

    static {
        myOcclusions.add(new Cuboid6((double)0.3f, (double)0.3f, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f));
    }

    public static enum CacheTypes {
        NOT_SET,
        IMPORTANT,
        IMPORTANT2;

    }

    public static final class ConduitTypes {
        public static final byte NONE = 0;
        public static final byte CONDUIT = 1;
        public static final byte IMPORTANT = 2;
        public static final byte CONNECTION = 3;

        public static final class Modes {
            public static final byte BLOCKED = 0;
            public static final byte NONE = 0;
            public static final byte ACTIVE = 1;
            public static final byte INPUT = 2;
        }
    }
}

