/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.fluid;

import cofh.core.CoFHProps;
import cofh.util.ConfigHandler;
import cofh.util.ItemHelper;
import cofh.util.fluid.BucketHandler;
import cofh.util.fluid.DispenserEmptyBucketHandler;
import cofh.util.fluid.DispenserFilledBucketHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.dynamo.TileDynamoCompression;
import thermalexpansion.block.dynamo.TileDynamoMagmatic;
import thermalexpansion.block.dynamo.TileDynamoReactant;
import thermalexpansion.core.TEProps;
import thermalexpansion.fluid.BlockFluidCoal;
import thermalexpansion.fluid.BlockFluidCryotheum;
import thermalexpansion.fluid.BlockFluidEnder;
import thermalexpansion.fluid.BlockFluidGlowstone;
import thermalexpansion.fluid.BlockFluidPyrotheum;
import thermalexpansion.fluid.BlockFluidRedstone;
import thermalexpansion.item.TEItems;
import thermalexpansion.item.tool.ItemBucket;
import thermalexpansion.item.tool.ItemFlorb;
import thermalexpansion.util.crafting.TransposerManager;

public class TEFluids {
    public static final int REDSTONE_LEVELS = 8;
    public static final int GLOWSTONE_LEVELS = 6;
    public static final int ENDER_LEVELS = 4;
    public static final int PYROTHEUM_LEVELS = 5;
    public static final int CRYOTHEUM_LEVELS = 5;
    public static final int MANA_LEVELS = 4;
    public static final int COAL_LEVELS = 6;
    public static Fluid fluidRedstone;
    public static Fluid fluidGlowstone;
    public static Fluid fluidEnder;
    public static Fluid fluidPyrotheum;
    public static Fluid fluidCryotheum;
    public static Fluid fluidMana;
    public static Fluid fluidCoal;
    public static Fluid fluidSteam;
    public static Block blockRedstone;
    public static Block blockGlowstone;
    public static Block blockEnder;
    public static Block blockPyrotheum;
    public static Block blockCryotheum;
    public static Block blockMana;
    public static Block blockCoal;
    public static ItemBucket itemBucket;
    public static ItemFlorb itemFlorb;
    public static ItemStack bucketRedstone;
    public static ItemStack bucketGlowstone;
    public static ItemStack bucketEnder;
    public static ItemStack bucketPyrotheum;
    public static ItemStack bucketCryotheum;
    public static ItemStack bucketMana;
    public static ItemStack bucketCoal;
    public static ItemStack florb;
    public static ItemStack florbMagmatic;
    public static ArrayList<ItemStack> florbList;
    public static boolean effectRedstone;
    public static boolean effectGlowstone;
    public static boolean effectEnder;
    public static boolean effectPyrotheum;
    public static boolean effectCryotheum;
    public static boolean effectMana;
    public static boolean effectCoal;
    public static boolean enableFlorbs;
    public static final int MAGMATIC_FLORB_TEMPERATURE = 1000;
    public static final Material materialFluidRedstone;
    public static final Material materialFluidGlowstone;
    public static final Material materialFluidEnder;
    public static final Material materialFluidCryotheum;
    public static final Material materialFluidCoal;
    public static final Map<String, Integer> fluidFlowrate;
    public static ConfigHandler configFlorbs;
    public static ConfigHandler configFuels;

    public static void preInit() {
        configFlorbs.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/ThermalExpansion-Florbs.cfg")));
        configFuels.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/ThermalExpansion-Fuels.cfg")));
        ThermalExpansion.config.addBlockEntry("FluidRedstone", 2);
        ThermalExpansion.config.addBlockEntry("FluidGlowstone", 2);
        ThermalExpansion.config.addBlockEntry("FluidEnder", 2);
        ThermalExpansion.config.addBlockEntry("FluidPyrotheum", 2);
        ThermalExpansion.config.addBlockEntry("FluidCryotheum", 2);
        ThermalExpansion.config.addBlockEntry("FluidMana", 2);
        ThermalExpansion.config.addBlockEntry("FluidCoal", 2);
        ThermalExpansion.config.addItemEntry("Tool.Bucket");
        ThermalExpansion.config.addItemEntry("Tool.Florb");
        String category = "tweak";
        String comment = null;
        comment = "Enable this for Fluid Redstone to emit a signal proportional to its fluid level.";
        effectRedstone = ThermalExpansion.config.get(category, "Fluid.Redstone.Effect", true, comment);
        comment = "Enable this for Fluid Glowstone to do...something.";
        effectGlowstone = ThermalExpansion.config.get(category, "Fluid.Glowstone.Effect", true, comment);
        comment = "Enable this for Fluid Ender to randomly teleport entities on contact.";
        effectEnder = ThermalExpansion.config.get(category, "Fluid.Ender.Effect", true, comment);
        comment = "Enable this for Fluid Pyrotheum to be worse than lava.";
        effectPyrotheum = ThermalExpansion.config.get(category, "Fluid.Pyrotheum.Effect", true, comment);
        comment = "Enable this for Fluid Cryotheum to be worse than lava, except cold.";
        effectCryotheum = ThermalExpansion.config.get(category, "Fluid.Cryotheum.Effect", true, comment);
        comment = "Enable this for Fluid Coal to be flammable.";
        effectCoal = ThermalExpansion.config.get(category, "Fluid.Coal.Flammable", true, comment);
        comment = "Enable this for Fluid Glowstone Source blocks to condense back into solid Glowstone above a given y-value.";
        BlockFluidGlowstone.enableSourceCondense = ThermalExpansion.config.get(category, "Fluid.Glowstone.Condense", BlockFluidGlowstone.enableSourceCondense, comment);
        comment = "Enable this for Fluid Glowstone Source blocks to gradually float upwards.";
        BlockFluidGlowstone.enableSourceFloat = ThermalExpansion.config.get(category, "Fluid.Glowstone.Float", BlockFluidGlowstone.enableSourceFloat, comment);
        comment = "Enable this for Fluid Pyrotheum Source blocks to gradually fall downwards.";
        BlockFluidPyrotheum.enableSourceFall = ThermalExpansion.config.get(category, "Fluid.Pyrotheum.Fall", BlockFluidPyrotheum.enableSourceFall, comment);
        comment = "Enable this for Fluid Cryotheum Source blocks to gradually fall downwards.";
        BlockFluidCryotheum.enableSourceFall = ThermalExpansion.config.get(category, "Fluid.Cryotheum.Fall", BlockFluidCryotheum.enableSourceFall, comment);
        int glowstoneHeight = BlockFluidGlowstone.maxGlowstoneHeight;
        comment = "This adjusts the y-value where Fluid Glowstone will *always* condense, if that is enabled. It will also condense above 80% of this value, if it cannot flow.";
        glowstoneHeight = ThermalExpansion.config.get(category, "Fluid.Glowstone.MaxHeight", BlockFluidGlowstone.maxGlowstoneHeight, comment);
        if (glowstoneHeight >= BlockFluidGlowstone.maxGlowstoneHeight) {
            BlockFluidGlowstone.maxGlowstoneHeight = glowstoneHeight;
        } else {
            ThermalExpansion.log.log(Level.INFO, "'Fluid.Glowstone.MaxHeight' config value is out of acceptable range. Using default.");
        }
        category = "item.feature";
        comment = "This allows you to disable Florbs entirely. It also means that you actively dislike fun things.";
        enableFlorbs = configFlorbs.get(category, "Florb.Enable", true, comment);
    }

    public static void initialize() {
        fluidRedstone = new Fluid("redstone").setLuminosity(7).setDensity(1200).setViscosity(1500).setTemperature(350).setRarity(EnumRarity.uncommon);
        fluidGlowstone = new Fluid("glowstone").setLuminosity(15).setDensity(-500).setViscosity(100).setTemperature(350).setGaseous(true).setRarity(EnumRarity.uncommon);
        fluidEnder = new Fluid("ender").setLuminosity(3).setDensity(4000).setViscosity(3000).setTemperature(300).setRarity(EnumRarity.uncommon);
        fluidPyrotheum = new Fluid("pyrotheum").setLuminosity(15).setDensity(2000).setViscosity(1200).setTemperature(3000).setRarity(EnumRarity.rare);
        fluidCryotheum = new Fluid("cryotheum").setLuminosity(0).setDensity(4000).setViscosity(3000).setTemperature(50).setRarity(EnumRarity.rare);
        fluidCoal = new Fluid("coal").setLuminosity(0).setDensity(900).setViscosity(2000).setTemperature(300);
        fluidSteam = new Fluid("steam").setLuminosity(0).setDensity(-1000).setViscosity(200).setTemperature(1100).setGaseous(true);
        FluidRegistry.registerFluid((Fluid)fluidRedstone);
        FluidRegistry.registerFluid((Fluid)fluidGlowstone);
        FluidRegistry.registerFluid((Fluid)fluidEnder);
        FluidRegistry.registerFluid((Fluid)fluidPyrotheum);
        FluidRegistry.registerFluid((Fluid)fluidCryotheum);
        FluidRegistry.registerFluid((Fluid)fluidCoal);
        FluidRegistry.registerFluid((Fluid)fluidSteam);
        blockRedstone = new BlockFluidRedstone(ThermalExpansion.config.getBlockId("FluidRedstone"));
        blockGlowstone = new BlockFluidGlowstone(ThermalExpansion.config.getBlockId("FluidGlowstone"));
        blockEnder = new BlockFluidEnder(ThermalExpansion.config.getBlockId("FluidEnder"));
        blockPyrotheum = new BlockFluidPyrotheum(ThermalExpansion.config.getBlockId("FluidPyrotheum"));
        blockCryotheum = new BlockFluidCryotheum(ThermalExpansion.config.getBlockId("FluidCryotheum"));
        blockCoal = new BlockFluidCoal(ThermalExpansion.config.getBlockId("FluidCoal"));
        GameRegistry.registerBlock((Block)blockRedstone, (String)"FluidRedstone");
        GameRegistry.registerBlock((Block)blockGlowstone, (String)"FluidGlowstone");
        GameRegistry.registerBlock((Block)blockEnder, (String)"FluidEnder");
        GameRegistry.registerBlock((Block)blockPyrotheum, (String)"FluidPyrotheum");
        GameRegistry.registerBlock((Block)blockCryotheum, (String)"FluidCryotheum");
        GameRegistry.registerBlock((Block)blockCoal, (String)"FluidCoal");
        itemBucket = (ItemBucket)new ItemBucket(ThermalExpansion.config.getItemId("Tool.Bucket")).func_77655_b("thermalexpansion.bucket");
        itemFlorb = (ItemFlorb)new ItemFlorb(ThermalExpansion.config.getItemId("Tool.Florb")).func_77655_b("thermalexpansion.florb");
        TEFluids.loadItems();
    }

    private static void loadItems() {
        bucketRedstone = itemBucket.addItem(0, "bucketRedstone", 1);
        bucketGlowstone = itemBucket.addItem(1, "bucketGlowstone", 1);
        bucketEnder = itemBucket.addItem(2, "bucketEnder", 1);
        bucketPyrotheum = itemBucket.addItem(3, "bucketPyrotheum", 2);
        bucketCryotheum = itemBucket.addItem(4, "bucketCryotheum", 2);
        bucketCoal = itemBucket.addItem(6, "bucketCoal");
        florb = itemFlorb.addItem(0, "florb");
        florbMagmatic = itemFlorb.addItem(1, "florbMagmatic");
        BucketHandler.registerBucket((int)TEFluids.blockRedstone.field_71990_ca, (int)0, (ItemStack)bucketRedstone);
        BucketHandler.registerBucket((int)TEFluids.blockGlowstone.field_71990_ca, (int)0, (ItemStack)bucketGlowstone);
        BucketHandler.registerBucket((int)TEFluids.blockEnder.field_71990_ca, (int)0, (ItemStack)bucketEnder);
        BucketHandler.registerBucket((int)TEFluids.blockPyrotheum.field_71990_ca, (int)0, (ItemStack)bucketPyrotheum);
        BucketHandler.registerBucket((int)TEFluids.blockCryotheum.field_71990_ca, (int)0, (ItemStack)bucketCryotheum);
        BucketHandler.registerBucket((int)TEFluids.blockCoal.field_71990_ca, (int)0, (ItemStack)bucketCoal);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidRedstone, (ItemStack)bucketRedstone, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidGlowstone, (ItemStack)bucketGlowstone, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidEnder, (ItemStack)bucketEnder, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidPyrotheum, (ItemStack)bucketPyrotheum, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidCryotheum, (ItemStack)bucketCryotheum, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidCoal, (ItemStack)bucketCoal, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
    }

    public static void postInit() {
        TEFluids.parseFlorbs();
        TEFluids.parseFuels();
        fluidFlowrate.put("steam", 360);
        configFlorbs.cleanUp(true, false);
        configFuels.cleanUp(true, false);
    }

    public static void registerDispenserHandlers() {
        BlockDispenser.field_82527_a.func_82595_a((Object)itemBucket, (Object)new DispenserFilledBucketHandler());
        BlockDispenser.field_82527_a.func_82595_a((Object)Item.field_77788_aw, (Object)new DispenserEmptyBucketHandler());
    }

    public static boolean registerMagmaticFuel(String name, int energy) {
        if (!FluidRegistry.isFluidRegistered((String)name)) {
            return false;
        }
        return TileDynamoMagmatic.registerFuel(FluidRegistry.getFluid((String)name), energy);
    }

    public static boolean registerCompressionFuel(String name, int energy) {
        if (!FluidRegistry.isFluidRegistered((String)name)) {
            return false;
        }
        return TileDynamoCompression.registerFuel(FluidRegistry.getFluid((String)name), energy);
    }

    public static boolean registerReactantFuel(String name, int energy) {
        if (!FluidRegistry.isFluidRegistered((String)name)) {
            return false;
        }
        return TileDynamoReactant.registerFuel(FluidRegistry.getFluid((String)name), energy);
    }

    public static boolean registerCoolant(String name, int cooling) {
        if (!FluidRegistry.isFluidRegistered((String)name)) {
            return false;
        }
        return TileDynamoCompression.registerCoolant(FluidRegistry.getFluid((String)name), cooling);
    }

    public static void parseFlorbs() {
        ItemStack florbStack = ItemHelper.cloneStack((ItemStack)florb, (int)4);
        ItemStack florbMagmaticStack = ItemHelper.cloneStack((ItemStack)florbMagmatic, (int)4);
        if (!enableFlorbs) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(florbStack, new Object[]{TEItems.sawdust, TEItems.slag, "slimeball"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(florbMagmaticStack, new Object[]{TEItems.sawdust, TEItems.slag, "slimeball", Item.field_77722_bw}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(florbMagmaticStack, new Object[]{TEItems.sawdust, TEItems.slag, Item.field_77725_bx}));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!fluid.canBePlacedInWorld() || !configFlorbs.get("whitelist", fluid.getName(), true)) continue;
            if (fluid.getTemperature() < 1000) {
                florbList.add(ItemFlorb.setTag(new ItemStack((Item)itemFlorb, 1, 0), fluid));
                TransposerManager.addFillRecipe(1600, florb, florbList.get(florbList.size() - 1), new FluidStack(fluid, 1000), false);
                continue;
            }
            florbList.add(ItemFlorb.setTag(new ItemStack((Item)itemFlorb, 1, 1), fluid));
            TransposerManager.addFillRecipe(1600, florbMagmatic, florbList.get(florbList.size() - 1), new FluidStack(fluid, 1000), false);
        }
    }

    public static void parseFuels() {
        String category = "fuels.magmatic";
        TEFluids.registerMagmaticFuel("lava", configFuels.get(category, "lava", TEProps.lavaRF * 9 / 10));
        TEFluids.registerMagmaticFuel("pyrotheum", configFuels.get(category, "pyrotheum", 2000000));
        Set catKeys = configFuels.getCategoryKeys(category);
        for (String s : catKeys) {
            TEFluids.registerMagmaticFuel(s.toLowerCase(Locale.ENGLISH), configFuels.get(category, s, TEProps.lavaRF * 9 / 10));
        }
        category = "fuels.compression";
        TEFluids.registerCompressionFuel("coal", configFuels.get(category, "coal", 1000000));
        TEFluids.registerCompressionFuel("biofuel", configFuels.get(category, "biofuel", 500000));
        TEFluids.registerCompressionFuel("bioethanol", configFuels.get(category, "bioethanol", 500000));
        TEFluids.registerCompressionFuel("fuel", configFuels.get(category, "fuel", 1500000));
        TEFluids.registerCompressionFuel("oil", configFuels.get(category, "oil", 150000));
        catKeys = configFuels.getCategoryKeys(category);
        for (String s : catKeys) {
            TEFluids.registerCompressionFuel(s.toLowerCase(Locale.ENGLISH), configFuels.get(category, s, 500000));
        }
        category = "fuels.reactant";
        TEFluids.registerReactantFuel("redstone", configFuels.get(category, "redstone", 600000));
        TEFluids.registerReactantFuel("glowstone", configFuels.get(category, "glowstone", 750000));
        TEFluids.registerReactantFuel("mobessence", configFuels.get(category, "mobessence", 500000));
        TEFluids.registerReactantFuel("sewage", configFuels.get(category, "sewage", 12000));
        TEFluids.registerReactantFuel("sludge", configFuels.get(category, "sludge", 12000));
        TEFluids.registerReactantFuel("seedoil", configFuels.get(category, "seedoil", 250000));
        TEFluids.registerReactantFuel("biomass", configFuels.get(category, "biomass", 450000));
        TEFluids.registerReactantFuel("creosote", configFuels.get(category, "creosote", 200000));
        catKeys = configFuels.getCategoryKeys(category);
        for (String s : catKeys) {
            TEFluids.registerReactantFuel(s.toLowerCase(Locale.ENGLISH), configFuels.get(category, s, 200000));
        }
        category = "coolants";
        TEFluids.registerCoolant("water", configFuels.get(category, "water", 400000));
        TEFluids.registerCoolant("cryotheum", configFuels.get(category, "cryotheum", 4000000));
        TEFluids.registerCoolant("ice", configFuels.get(category, "ice", 2000000));
        catKeys = configFuels.getCategoryKeys(category);
        for (String s : catKeys) {
            TEFluids.registerCoolant(s.toLowerCase(Locale.ENGLISH), configFuels.get(category, s, 400000));
        }
    }

    static {
        florbList = new ArrayList();
        effectRedstone = true;
        effectGlowstone = true;
        effectEnder = true;
        effectPyrotheum = true;
        effectCryotheum = true;
        effectMana = true;
        effectCoal = true;
        enableFlorbs = true;
        materialFluidRedstone = new MaterialLiquid(MapColor.field_76275_f);
        materialFluidGlowstone = new MaterialLiquid(MapColor.field_76277_d);
        materialFluidEnder = new MaterialLiquid(MapColor.field_76289_i);
        materialFluidCryotheum = new MaterialLiquid(MapColor.field_76276_g);
        materialFluidCoal = new MaterialLiquid(MapColor.field_76284_l);
        fluidFlowrate = new HashMap<String, Integer>();
        configFlorbs = new ConfigHandler("3.0.0.5");
        configFuels = new ConfigHandler("3.0.0.5");
    }
}

