/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.entity.projectile;

import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.entity.monster.EntityBlizz;
import thermalexpansion.util.Utils;

public class EntityBlizzSpike
extends Entity {
    public static DamageSource blizzSpike = new DamageSourceBlizzSpike();
    public static PotionEffect spikeSlow = new PotionEffectBlizzSpike(100, 2);
    public static double accelMultiplier = 0.2;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile;
    private boolean inGround;
    public EntityLivingBase shootingEntity;
    private int ticksAlive;
    private int ticksInAir;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public static void initialize() {
        EntityRegistry.registerModEntity(EntityBlizzSpike.class, (String)"blizzSpike", (int)Utils.getEntityId(), (Object)ThermalExpansion.instance, (int)64, (int)1, (boolean)true);
    }

    public EntityBlizzSpike(World world) {
        super(world);
        this.func_70105_a(0.3125f, 0.3125f);
    }

    public EntityBlizzSpike(World world, EntityLivingBase entitySource, double dX, double dY, double dZ) {
        this(world);
        this.shootingEntity = entitySource;
        this.func_70012_b(entitySource.field_70165_t, entitySource.field_70163_u, entitySource.field_70161_v, entitySource.field_70177_z, entitySource.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double dist = MathHelper.func_76133_a((double)((dX += this.field_70146_Z.nextGaussian() * 0.4) * dX + (dY += this.field_70146_Z.nextGaussian() * 0.4) * dY + (dZ += this.field_70146_Z.nextGaussian() * 0.4) * dZ));
        this.accelerationX = dX / dist * accelMultiplier;
        this.accelerationY = dY / dist * accelMultiplier;
        this.accelerationZ = dZ / dist * accelMultiplier;
    }

    public EntityBlizzSpike(World world, double x, double y, double z, double dX, double dY, double dZ) {
        this(world);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        double dist = MathHelper.func_76133_a((double)(dX * dX + dY * dY + dZ * dZ));
        this.accelerationX = dX / dist * accelMultiplier;
        this.accelerationY = dY / dist * accelMultiplier;
        this.accelerationZ = dZ / dist * accelMultiplier;
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void func_70071_h_() {
        if (ServerHelper.isServerWorld((World)this.field_70170_p) && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_72899_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            if (this.inGround) {
                int i = this.field_70170_p.func_72798_a(this.xTile, this.yTile, this.zTile);
                if (i == this.inTile) {
                    ++this.ticksAlive;
                    if (this.ticksAlive == 600) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3 vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec31 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec31 = this.field_70170_p.func_82732_R().func_72345_a(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.shootingEntity) && this.ticksInAir < 25 || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null) {
                this.onImpact(movingobjectposition);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f2 = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int k = 0; k < 4; ++k) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                f2 = 0.8f;
            }
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(MovingObjectPosition pos) {
        if (ServerHelper.isServerWorld((World)this.field_70170_p)) {
            if (pos.field_72308_g != null) {
                if (pos.field_72308_g instanceof EntityBlizz) {
                    pos.field_72308_g.func_70097_a(DamageSourceBlizzSpike.causeSpikeDamage(this, (Entity)this.shootingEntity), 0.0f);
                } else if (pos.field_72308_g.func_70097_a(DamageSourceBlizzSpike.causeSpikeDamage(this, (Entity)this.shootingEntity), pos.field_72308_g.func_70045_F() ? 8.0f : 5.0f) && pos.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase living = (EntityLivingBase)pos.field_72308_g;
                    living.func_70690_d(new PotionEffect(spikeSlow));
                }
            } else {
                Block block;
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e);
                int i = pos.field_72311_b + dir.offsetX;
                int j = pos.field_72312_c + dir.offsetY;
                int k = pos.field_72309_d + dir.offsetZ;
                if (this.field_70170_p.func_72799_c(i, j, k) && (block = Block.field_71973_m[this.field_70170_p.func_72798_a(i, j - 1, k)]) != null && block.isBlockSolidOnSide(this.field_70170_p, i, j - 1, k, ForgeDirection.UP)) {
                    this.field_70170_p.func_94575_c(i, j, k, Block.field_72037_aS.field_71990_ca);
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("xTile", (short)this.xTile);
        nbt.func_74777_a("yTile", (short)this.yTile);
        nbt.func_74777_a("zTile", (short)this.zTile);
        nbt.func_74774_a("inTile", (byte)this.inTile);
        nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.xTile = nbt.func_74765_d("xTile");
        this.yTile = nbt.func_74765_d("yTile");
        this.zTile = nbt.func_74765_d("zTile");
        this.inTile = nbt.func_74771_c("inTile") & 0xFF;
        boolean bl = this.inGround = nbt.func_74771_c("inGround") == 1;
        if (nbt.func_74764_b("direction")) {
            NBTTagList nbttaglist = nbt.func_74761_m("direction");
            this.field_70159_w = ((NBTTagDouble)nbttaglist.func_74743_b((int)0)).field_74755_a;
            this.field_70181_x = ((NBTTagDouble)nbttaglist.func_74743_b((int)1)).field_74755_a;
            this.field_70179_y = ((NBTTagDouble)nbttaglist.func_74743_b((int)2)).field_74755_a;
        } else {
            this.func_70106_y();
        }
    }

    protected static class PotionEffectBlizzSpike
    extends PotionEffect {
        public PotionEffectBlizzSpike(int id, int duration, int amplifier, boolean isAmbient) {
            super(id, duration, amplifier, isAmbient);
            this.getCurativeItems().clear();
        }

        public PotionEffectBlizzSpike(int duration, int amplifier) {
            this(Potion.field_76421_d.field_76415_H, duration, amplifier, false);
        }
    }

    protected static class DamageSourceBlizzSpike
    extends EntityDamageSource {
        public DamageSourceBlizzSpike() {
            this(null);
        }

        public DamageSourceBlizzSpike(Entity source) {
            super("blizz", source);
        }

        public static DamageSource causeSpikeDamage(EntityBlizzSpike entitySpike, Entity entitySource) {
            return new EntityDamageSourceIndirect("blizz", (Entity)entitySpike, (Entity)(entitySource == null ? entitySpike : entitySource)).func_76349_b();
        }
    }
}

