/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.api.tileentity.ISecureTile;
import cofh.api.tileentity.ISidedBlockTexture;
import cofh.render.IconRegistry;
import cofh.util.StringHelper;
import cofh.util.UpgradeRecipe;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.device.TileActivator;
import thermalexpansion.block.device.TileBreaker;
import thermalexpansion.block.device.TileNullifier;
import thermalexpansion.block.device.TileWorkbench;
import thermalexpansion.block.strongbox.BlockStrongbox;
import thermalexpansion.item.TEEquipment;
import thermalexpansion.item.TEItems;

public class BlockDevice
extends BlockTEBase {
    public static String[] NAMES = new String[]{"workbench", "PLACE_HOLDER", "activator", "breaker", "nullifier", "lexicon"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack field_72060_ay;
    public static ItemStack activator;
    public static ItemStack breaker;
    public static ItemStack nullifier;

    public BlockDevice(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.device");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        switch (Types.values()[metadata]) {
            case WORKBENCH: {
                return new TileWorkbench();
            }
            case ACTIVATOR: {
                return new TileActivator();
            }
            case BREAKER: {
                return new TileBreaker();
            }
            case NULLIFIER: {
                return new TileNullifier();
            }
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        TileEntity theTile;
        if (stack.field_77990_d != null && (theTile = world.func_72796_p(x, y, z)) instanceof TileWorkbench) {
            TileWorkbench tile = (TileWorkbench)theTile;
            if (stack.field_77990_d.func_74764_b("Owner")) {
                tile.setOwnerName(stack.field_77990_d.func_74779_i("Owner"));
                tile.setAccess(ISecureTile.AccessMode.values()[stack.field_77990_d.func_74771_c("Access")]);
                tile.selectedSchematic = stack.field_77990_d.func_74771_c("Mode");
                tile.readInventoryFromNBT(stack.field_77990_d);
            }
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        NBTTagCompound tag = null;
        if (metadata == Types.WORKBENCH.ordinal() && !secureOwner.equals("[None]")) {
            tag = new NBTTagCompound();
            tag.func_74778_a("Owner", secureOwner);
            tag.func_74774_a("Access", secureAccess);
            secureOwner = "[None]";
            secureAccess = 0;
        }
        ItemStack retStack = new ItemStack(this.field_71990_ca, 1, this.func_71899_b(metadata));
        retStack.func_77982_d(tag);
        ret.add(retStack);
        return ret;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        return tile instanceof ISecureTile ? -1.0f : super.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        return tile instanceof ISecureTile ? 1200.0f : super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        ISidedBlockTexture theTile = (ISidedBlockTexture)world.func_72796_p(x, y, z);
        return theTile == null ? null : theTile.getBlockTexture(side, renderPass);
    }

    @Override
    public Icon func_71858_a(int side, int metadata) {
        if (metadata == Types.WORKBENCH.ordinal()) {
            if (side == 0) {
                return IconRegistry.getIcon((String)"WorkbenchBottom");
            }
            if (side == 1) {
                return IconRegistry.getIcon((String)"WorkbenchTop");
            }
            return IconRegistry.getIcon((String)"WorkbenchSide");
        }
        return side != 3 ? IconRegistry.getIcon((String)"DeviceSide") : IconRegistry.getIcon((String)("DeviceFace_" + metadata));
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public boolean func_71926_d() {
        return true;
    }

    public boolean func_71886_c() {
        return true;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"WorkbenchBottom", (String)"thermalexpansion:device/Device_Bottom_Workbench", (IconRegister)ir);
        IconRegistry.addIcon((String)"WorkbenchTop", (String)"thermalexpansion:device/Device_Top_Workbench", (IconRegister)ir);
        IconRegistry.addIcon((String)"WorkbenchSide", (String)"thermalexpansion:device/Device_Side_Workbench", (IconRegister)ir);
        IconRegistry.addIcon((String)"DeviceSide", (String)"thermalexpansion:device/Device_Side", (IconRegister)ir);
        for (int i = 2; i < Types.values().length; ++i) {
            IconRegistry.addIcon((String)("DeviceFace_" + i), (String)("thermalexpansion:device/Device_Face_" + StringHelper.titleCase((String)NAMES[i])), (IconRegister)ir);
            IconRegistry.addIcon((String)("DeviceActive_" + i), (String)("thermalexpansion:device/Device_Active_" + StringHelper.titleCase((String)NAMES[i])), (IconRegister)ir);
        }
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        NBTTagCompound tag = super.getItemStackTag(world, x, y, z);
        if (world.func_72805_g(x, y, z) == Types.WORKBENCH.ordinal()) {
            TileWorkbench tile = (TileWorkbench)world.func_72796_p(x, y, z);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74778_a("Owner", tile.owner);
            tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
            tag.func_74774_a("Mode", (byte)tile.selectedSchematic);
            tile.writeInventoryToNBT(tag);
        }
        return tag;
    }

    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        NBTTagCompound tag = this.getItemStackTag(world, x, y, z);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileWorkbench) {
            ((TileWorkbench)tile).inventory = new ItemStack[((TileWorkbench)tile).inventory.length];
        }
        return super.dismantleBlock(player, tag, world, x, y, z, returnBlock, false);
    }

    public boolean initialize() {
        TileActivator.initialize();
        TileBreaker.initialize();
        TileWorkbench.initialize();
        TileNullifier.initialize();
        field_72060_ay = new ItemStack((Block)this, 1, Types.WORKBENCH.ordinal());
        activator = new ItemStack((Block)this, 1, Types.ACTIVATOR.ordinal());
        breaker = new ItemStack((Block)this, 1, Types.BREAKER.ordinal());
        nullifier = new ItemStack((Block)this, 1, Types.NULLIFIER.ordinal());
        GameRegistry.registerCustomItemStack((String)"workbench", (ItemStack)field_72060_ay);
        GameRegistry.registerCustomItemStack((String)"activator", (ItemStack)activator);
        GameRegistry.registerCustomItemStack((String)"breaker", (ItemStack)breaker);
        GameRegistry.registerCustomItemStack((String)"nullifier", (ItemStack)nullifier);
        return true;
    }

    public boolean postInit() {
        String category = "tweak.recipe";
        boolean breakerUseDiamondPickaxe = ThermalExpansion.config.get(category, "Breaker.UseDiamondPickaxe", false);
        ItemStack pickaxe = null;
        pickaxe = breakerUseDiamondPickaxe ? new ItemStack(Item.field_77674_B) : TEEquipment.toolInvarPickaxe;
        if (enable[Types.WORKBENCH.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(7, field_72060_ay, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Block.field_72060_ay, Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), BlockStrongbox.strongboxBasic, Character.valueOf('X'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(field_72060_ay, new Object[]{"YXY", "ICI", "YPY", Character.valueOf('C'), Block.field_72060_ay, Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), Block.field_72077_au, Character.valueOf('X'), Item.field_77759_aK, Character.valueOf('Y'), "ingotTin"}));
        }
        if (enable[Types.ACTIVATOR.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(activator, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Block.field_71963_Z, Character.valueOf('I'), "ingotTin", Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Block.field_72077_au}));
        }
        if (enable[Types.BREAKER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(breaker, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Block.field_71963_Z, Character.valueOf('I'), "ingotTin", Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), pickaxe}));
        }
        if (enable[Types.NULLIFIER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(nullifier, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Item.field_77775_ay, Character.valueOf('I'), "ingotTin", Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), "ingotInvar"}));
        }
        return true;
    }

    static {
        String category = "block.feature";
        BlockDevice.enable[Types.WORKBENCH.ordinal()] = ThermalExpansion.config.get(category, "Device.Workbench", true);
        BlockDevice.enable[Types.ACTIVATOR.ordinal()] = ThermalExpansion.config.get(category, "Device.Activator", true);
        BlockDevice.enable[Types.BREAKER.ordinal()] = ThermalExpansion.config.get(category, "Device.Breaker", true);
        BlockDevice.enable[Types.NULLIFIER.ordinal()] = ThermalExpansion.config.get(category, "Device.Nullifier", true);
    }

    public static enum Types {
        WORKBENCH,
        PLACE_HOLDER,
        ACTIVATOR,
        BREAKER,
        NULLIFIER,
        LEXICON;

    }
}

