/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.cache;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.cache.BlockCache;

public class TileCache
extends TileInventory
implements IReconfigurableFacing,
ISidedInventory,
IDeepStorageUnit {
    public static final int[] SIZE = new int[]{Integer.MAX_VALUE, 4096, 16384, 24576, 262144};
    public static final int[] SLOTS = new int[]{0, 1};
    public byte type;
    public byte facing = (byte)3;
    public ItemStack myStack;
    public int maxCacheStackSize = 3968;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCache.class, (String)"cofh.thermalexpansion.Cache");
    }

    public TileCache() {
        this.inventory = new ItemStack[2];
    }

    public TileCache(int metadata) {
        this.type = (byte)metadata;
        this.inventory = new ItemStack[2];
    }

    public String getName() {
        return "tile.thermalexpansion.cache." + BlockCache.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByte(this.type);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.type = payload.getByte();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        this.type = nbt.func_74771_c("Type");
        this.facing = nbt.func_74771_c("Facing");
        ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item"));
        super.func_70307_a(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Type", this.type);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74782_a("Item", (NBTBase)this.myStack.func_77955_b(new NBTTagCompound()));
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (this.inventory[0] != null) {
            if (this.myStack == null) {
                this.myStack = this.inventory[0].func_77946_l();
                this.inventory[0] = null;
                this.maxCacheStackSize = SIZE[this.type] - this.myStack.func_77976_d() * 2;
            } else if (this.myStack.field_77994_a < this.maxCacheStackSize) {
                this.setSlotHelper();
            }
        }
        if ((this.inventory[1] == null || this.inventory[1].field_77994_a < this.inventory[1].func_77976_d()) && this.myStack != null && this.myStack.field_77994_a > 0) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.myStack, (int)Math.min(this.myStack.func_77976_d(), this.myStack.field_77994_a));
            this.myStack.field_77994_a -= this.inventory[1].field_77994_a;
            if (this.inventory[0] != null && this.myStack.field_77994_a < this.maxCacheStackSize) {
                this.setSlotHelper();
            }
        }
    }

    public void setSlotHelper() {
        this.myStack.field_77994_a += this.inventory[0].field_77994_a;
        if (this.myStack.field_77994_a > this.maxCacheStackSize) {
            this.inventory[0].field_77994_a = this.myStack.field_77994_a - this.maxCacheStackSize;
            this.myStack.field_77994_a = this.maxCacheStackSize;
        } else {
            this.inventory[0] = null;
        }
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0 && this.myStack == null || stack != null && ItemHelper.areItemStackEqualNoNull((ItemStack)stack, (ItemStack)this.myStack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public ItemStack getStoredItemType() {
        return this.myStack;
    }

    public void setStoredItemCount(int amount) {
        if (this.myStack != null && amount >= 0) {
            this.myStack.field_77994_a = Math.min(amount, this.getMaxStoredCount());
        }
    }

    public void setStoredItemType(ItemStack type, int amount) {
        if (type != null && amount >= 0) {
            this.myStack = ItemHelper.cloneStack((ItemStack)type, (int)Math.min(amount, this.getMaxStoredCount()));
            this.maxCacheStackSize = SIZE[this.type] - this.myStack.func_77976_d() * 2;
        }
    }

    public int getMaxStoredCount() {
        return SIZE[this.type];
    }
}

