/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion;

import cofh.CoFHWorld;
import cofh.api.world.WeightedRandomBlock;
import cofh.gui.GuiHandler;
import cofh.network.Payload;
import cofh.util.ConfigHandler;
import cofh.util.StringHelper;
import cofh.util.version.VersionHandler;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.device.TileWorkbench;
import thermalexpansion.block.energycell.BlockEnergyCell;
import thermalexpansion.block.simple.BlockOre;
import thermalexpansion.block.strongbox.TileStrongbox;
import thermalexpansion.core.Proxy;
import thermalexpansion.core.TEProps;
import thermalexpansion.entity.TEPlayerTracker;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.gui.CreativeTabBlocks;
import thermalexpansion.gui.CreativeTabFlorbs;
import thermalexpansion.gui.CreativeTabItems;
import thermalexpansion.gui.CreativeTabTools;
import thermalexpansion.item.TEItems;
import thermalexpansion.network.TEPacketHandler;
import thermalexpansion.part.TEPartFactory;
import thermalexpansion.plugins.TEPlugins;
import thermalexpansion.util.GenericEventHandler;
import thermalexpansion.util.IMCHandler;
import thermalexpansion.util.crafting.CrucibleManager;
import thermalexpansion.util.crafting.FurnaceManager;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.SawmillManager;
import thermalexpansion.util.crafting.SmelterManager;
import thermalexpansion.util.crafting.TECraftingHandler;
import thermalexpansion.util.crafting.TransposerManager;

@Mod(name="Thermal Expansion", version="3.0.0.5", useMetadata=false, modid="ThermalExpansion", dependencies="required-after:Forge@[9.1.11.953,);required-after:CoFHCore@[2.0.0.5,);required-after:ForgeMultipart;before:IC2;before:Metallurgy")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class ThermalExpansion {
    @SidedProxy(clientSide="thermalexpansion.core.ProxyClient", serverSide="thermalexpansion.core.Proxy")
    public static Proxy proxy;
    @Mod.Instance(value="ThermalExpansion")
    public static ThermalExpansion instance;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final GuiHandler guiHandler;
    public static final VersionHandler version;
    public static final CreativeTabs tabBlocks;
    public static final CreativeTabs tabItems;
    public static final CreativeTabs tabTools;
    public static final CreativeTabs tabFlorbs;
    public static final Material CLOTH_FIREPROOF;
    public static final Material WOOD_FIREPROOF;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GenericEventHandler.initialize();
        TECraftingHandler.initialize();
        TEPlayerTracker.initialize();
        version.checkForNewVersion();
        boolean optionColorBlind = false;
        boolean optionDrawBorders = true;
        boolean optionEnableAchievements = true;
        int tweakLavaRF = TEProps.lavaRF;
        config.setConfiguration(new Configuration(new File(event.getModConfigurationDirectory(), "cofh/ThermalExpansion.cfg")));
        this.cleanConfig(true);
        TEItems.preInit();
        TEBlocks.preInit();
        TEFluids.preInit();
        TEPlugins.preInit();
        String category = "general";
        String version = config.get(category, "Version", "3.0.0.5");
        String comment = "";
        TEProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", TEProps.enableUpdateNotice);
        TEProps.enableDismantleLogging = config.get(category, "EnableDismantleLogging", TEProps.enableDismantleLogging);
        TEProps.enableDebugOutput = config.get(category, "EnableDebugOutput", TEProps.enableDebugOutput);
        optionColorBlind = config.get(category, "ColorBlindTextures", false);
        optionDrawBorders = config.get(category, "DrawGUISlotBorders", true);
        category = "gui.hud";
        TEProps.enableFluidModule = config.get(category, "EnableFluidModule", TEProps.enableFluidModule);
        TEProps.enableStuffedItemModule = config.get(category, "EnableStuffedItemModule", TEProps.enableStuffedItemModule);
        category = "tweak";
        tweakLavaRF = config.get(category, "LavaRFValue", tweakLavaRF);
        category = "holiday";
        comment = "Set this to true to disable Christmas cheer. Scrooge. :(";
        boolean bl = TEProps.holidayChristmas = !config.get(category, "HoHoNo", false, comment);
        if (optionColorBlind) {
            TEProps.textureGuiCommon = TEProps.PATH_COMMON_CB;
            TEProps.textureSelection = "Config_CB_";
            BlockEnergyCell.textureSelection = "EnergyCellConfig_CB_";
        }
        TEProps.enableGuiBorders = optionDrawBorders;
        if (tweakLavaRF >= 10000 && tweakLavaRF < 400000) {
            TEProps.lavaRF = tweakLavaRF;
        } else {
            log.log(Level.INFO, "'LavaRFValue' config value is out of acceptable range. Using default.");
        }
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        block3: {
            config.initialize();
            TEItems.initialize();
            TEBlocks.initialize();
            TEFluids.initialize();
            TEPlugins.initialize();
            TEPartFactory.initialize();
            if (TEProps.enableAchievements) {
                // empty if block
            }
            this.loadWorldGeneration();
            NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
            TEPacketHandler.initialize();
            MinecraftForge.EVENT_BUS.register((Object)proxy);
            try {
                Field eBus = FMLModContainer.class.getDeclaredField("eventBus");
                eBus.setAccessible(true);
                EventBus FMLbus = (EventBus)eBus.get(FMLCommonHandler.instance().findContainerFor((Object)this));
                FMLbus.register((Object)this);
            }
            catch (Throwable t) {
                if (!TEProps.enableDebugOutput) break block3;
                t.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        TEItems.postInit();
        TEBlocks.postInit();
        TEFluids.postInit();
        TEPlugins.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
    }

    @Subscribe
    public void loadComplete(FMLLoadCompleteEvent event) {
        TECraftingHandler.loadRecipes();
        FurnaceManager.loadRecipes();
        PulverizerManager.loadRecipes();
        SawmillManager.loadRecipes();
        SmelterManager.loadRecipes();
        CrucibleManager.loadRecipes();
        TransposerManager.loadRecipes();
        this.cleanConfig(false);
        config.cleanUp(false, true);
        log.log(Level.INFO, "Load Complete.");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        TEFluids.registerDispenserHandlers();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent theIMC) {
        IMCHandler.instance.handleIMC(theIMC);
    }

    public void handleConfigSync(Payload payload) {
        TileWorkbench.enableSecurity = payload.getBool();
        TileStrongbox.enableSecurity = payload.getBool();
        log.info(StringHelper.localize((String)"message.cofh.receiveConfig"));
    }

    public Payload getConfigSync(int packetID) {
        Payload myPayload = Payload.getPayload((int)packetID);
        myPayload.addByte(TEPacketHandler.PacketTypes.CONFIG_SYNC.ordinal());
        myPayload.addBool(TileWorkbench.enableSecurity);
        myPayload.addBool(TileStrongbox.enableSecurity);
        return myPayload;
    }

    public void resetClientConfigs() {
        TileWorkbench.configure();
        TileStrongbox.configure();
        log.info(StringHelper.localize((String)"message.cofh.restoreConfig"));
    }

    void loadWorldGeneration() {
        int i;
        String category = "world.thermalexpansion";
        List[] oreList = new List[TEProps.Ores.values().length];
        for (i = 0; i < oreList.length; ++i) {
            oreList[i] = new ArrayList();
        }
        oreList[TEProps.Ores.COPPER.ordinal()].add(new WeightedRandomBlock(BlockOre.oreCopper));
        oreList[TEProps.Ores.TIN.ordinal()].add(new WeightedRandomBlock(BlockOre.oreTin));
        oreList[TEProps.Ores.SILVER.ordinal()].add(new WeightedRandomBlock(BlockOre.oreSilver, 90));
        oreList[TEProps.Ores.LEAD.ordinal()].add(new WeightedRandomBlock(BlockOre.oreLead, 80));
        oreList[TEProps.Ores.NICKEL.ordinal()].add(new WeightedRandomBlock(BlockOre.oreNickel));
        if (BlockOre.enable[TEProps.Ores.LEAD.ordinal()]) {
            oreList[TEProps.Ores.SILVER.ordinal()].add(new WeightedRandomBlock(BlockOre.oreLead, 10));
        }
        if (BlockOre.enable[TEProps.Ores.SILVER.ordinal()]) {
            oreList[TEProps.Ores.LEAD.ordinal()].add(new WeightedRandomBlock(BlockOre.oreSilver, 20));
        }
        for (i = 0; i < oreList.length; ++i) {
            CoFHWorld.addFeature((String)category, (List)oreList[i], (String)BlockOre.NAMES[i], (int)TEProps.oreClusterSize[i], (int)TEProps.oreNumCluster[i], (int)TEProps.oreMinY[i], (int)TEProps.oreMaxY[i], (int)0, (boolean)true, (boolean)BlockOre.enable[i]);
        }
    }

    void cleanConfig(boolean preInit) {
        if (preInit) {
            String category = "tweak";
            String newCategory = "tweak.crafting";
            config.renameProperty(category, "Pulverizer.Sandstone", newCategory, "Pulverizer.Sandstone", true);
            config.renameProperty(category, "Pulverizer.Netherrack", newCategory, "Pulverizer.Netherrack", true);
            config.renameProperty(category, "Pulverizer.Cloth", newCategory, "Pulverizer.Cloth", true);
            config.renameProperty(category, "Pulverizer.Reed", newCategory, "Pulverizer.Reed", true);
            config.renameProperty(category, "Pulverizer.Bone", newCategory, "Pulverizer.Bone", true);
            config.renameProperty(category, "Pulverizer.BlazeRod", newCategory, "Pulverizer.BlazeRod", true);
            config.renameProperty(category, "Pulverizer.Cinnabar.Chance", newCategory, "Pulverizer.Cinnabar.Chance", true);
            config.renameProperty(category, "Smelter.Bronze.Quantity", newCategory, "Smelter.Bronze.Quantity", true);
            config.renameProperty(category, "RockGen.Cobblestone.Lava", newCategory, "RockGen.Cobblestone.Lava", true);
            config.renameProperty(category, "RockGen.Stone.Lava", newCategory, "RockGen.Stone.Lava", true);
            config.renameProperty(category, "RockGen.Obsidian.Lava", newCategory, "RockGen.Obsidian.Lava", true);
            config.renameProperty(category, "RockGen.Cobblestone.Water", newCategory, "RockGen.Cobblestone.Water", true);
            config.renameProperty(category, "RockGen.Stone.Water", newCategory, "RockGen.Stone.Water", true);
            config.renameProperty(category, "RockGen.Obsidian.Water", newCategory, "RockGen.Obsidian.Water", true);
            config.renameProperty(category, "RockGen.Cobblestone.Time", newCategory, "RockGen.Cobblestone.Time", true);
            config.renameProperty(category, "RockGen.Stone.Time", newCategory, "RockGen.Stone.Time", true);
            config.renameProperty(category, "RockGen.Obsidian.Time", newCategory, "RockGen.Obsidian.Time", true);
            config.removeProperty(category, "Pulverizer.IngotsToDust");
            config.removeProperty(newCategory, "Pulverizer.IngotsToDust");
            config.removeProperty(newCategory, "Smelter.Bronze.Quantity");
            category = "tweak.recipe";
            config.renameProperty(category, "MachineFrame.UseSteel", category, "MachineFrame.RequireSteel", true);
            category = "general";
            config.removeProperty(category, "EnableStuffedItemHudModule");
        }
    }

    static {
        log = Logger.getLogger("ThermalExpansion");
        config = new ConfigHandler("3.0.0.5", 2000, 20000);
        guiHandler = new GuiHandler();
        version = new VersionHandler("Thermal Expansion", "3.0.0.5", "http://teamcofh.com/thermalexpansion/version/version.txt", log);
        tabBlocks = new CreativeTabBlocks();
        tabItems = new CreativeTabItems();
        tabTools = new CreativeTabTools();
        tabFlorbs = new CreativeTabFlorbs();
        log.setParent(FMLLog.getLogger());
        CLOTH_FIREPROOF = new Material(MapColor.field_76278_e);
        WOOD_FIREPROOF = new Material(MapColor.field_76283_o);
    }
}

