/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.utils;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import mrtjp.projectred.core.utils.OpenGLLib;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.input.Mouse;

public class DirectionalRayTracer {
    private final double negX;
    private final double negY;
    private final double negZ;
    private final double posX;
    private final double posY;
    private final double posZ;

    public DirectionalRayTracer(double d, double d2, double d3, double d4, double d5, double d6) {
        this.negX = d;
        this.negY = d2;
        this.negZ = d3;
        this.posX = d4;
        this.posY = d5;
        this.posZ = d6;
    }

    public DirectionalRayTracer(double d) {
        this.negY = this.negZ = -d;
        this.negX = this.negZ;
        this.posY = this.posZ = d;
        this.posX = this.posZ;
    }

    private static atc getMouseVector(float f) {
        return OpenGLLib.unproject(Mouse.getX(), Mouse.getY(), f);
    }

    private atc calculateXPoint(atc atc2, atc atc3, double d) {
        double d2 = (d - atc2.c) / atc3.c;
        double d3 = atc2.d + atc3.d * d2;
        double d4 = atc2.e + atc3.e * d2;
        if (this.negY <= d3 && d3 <= this.posY && this.negZ <= d4 && d4 <= this.posZ) {
            return atc.a((double)d, (double)d3, (double)d4);
        }
        return null;
    }

    private atc calculateYPoint(atc atc2, atc atc3, double d) {
        double d2 = (d - atc2.d) / atc3.d;
        double d3 = atc2.c + atc3.c * d2;
        double d4 = atc2.e + atc3.e * d2;
        if (this.negX <= d3 && d3 <= this.posX && this.negZ <= d4 && d4 <= this.posZ) {
            return atc.a((double)d3, (double)d, (double)d4);
        }
        return null;
    }

    private atc calculateZPoint(atc atc2, atc atc3, double d) {
        double d2 = (d - atc2.e) / atc3.e;
        double d3 = atc2.c + atc3.c * d2;
        double d4 = atc2.d + atc3.d * d2;
        if (this.negX <= d3 && d3 <= this.posX && this.negY <= d4 && d4 <= this.posY) {
            return atc.a((double)d3, (double)d4, (double)d);
        }
        return null;
    }

    private static void addPoint(Map<ForgeDirection, atc> map, ForgeDirection forgeDirection, atc atc2) {
        if (atc2 != null) {
            map.put(forgeDirection, atc2);
        }
    }

    private Map<ForgeDirection, atc> calculateHitPoints(atc atc2, atc atc3) {
        atc atc4 = atc3.a(atc2);
        EnumMap enumMap = Maps.newEnumMap(ForgeDirection.class);
        DirectionalRayTracer.addPoint(enumMap, ForgeDirection.WEST, this.calculateXPoint(atc2, atc4, this.negX));
        DirectionalRayTracer.addPoint(enumMap, ForgeDirection.EAST, this.calculateXPoint(atc2, atc4, this.posX));
        DirectionalRayTracer.addPoint(enumMap, ForgeDirection.DOWN, this.calculateYPoint(atc2, atc4, this.negY));
        DirectionalRayTracer.addPoint(enumMap, ForgeDirection.UP, this.calculateYPoint(atc2, atc4, this.posY));
        DirectionalRayTracer.addPoint(enumMap, ForgeDirection.NORTH, this.calculateZPoint(atc2, atc4, this.negZ));
        DirectionalRayTracer.addPoint(enumMap, ForgeDirection.SOUTH, this.calculateZPoint(atc2, atc4, this.posZ));
        return enumMap;
    }

    public Map<ForgeDirection, atc> calculateMouseHits() {
        OpenGLLib.updateMatrices();
        atc atc2 = DirectionalRayTracer.getMouseVector(0.0f);
        atc atc3 = DirectionalRayTracer.getMouseVector(1.0f);
        return this.calculateHitPoints(atc2, atc3);
    }

    public HitCoord getNearestHit() {
        OpenGLLib.updateMatrices();
        atc atc2 = DirectionalRayTracer.getMouseVector(0.0f);
        atc atc3 = DirectionalRayTracer.getMouseVector(1.0f);
        Map<ForgeDirection, atc> map = this.calculateHitPoints(atc2, atc3);
        if (map.isEmpty()) {
            return null;
        }
        ForgeDirection forgeDirection = null;
        double d = Double.MAX_VALUE;
        for (Map.Entry<ForgeDirection, atc> entry : map.entrySet()) {
            double d2 = entry.getValue().a(atc2).b();
            if (!(d2 < d)) continue;
            d = d2;
            forgeDirection = entry.getKey();
        }
        if (forgeDirection == null) {
            return null;
        }
        return new HitCoord(forgeDirection, map.get(forgeDirection));
    }

    public static class HitCoord {
        public final ForgeDirection side;
        public final atc coord;

        public HitCoord(ForgeDirection forgeDirection, atc atc2) {
            this.side = forgeDirection;
            this.coord = atc2;
        }
    }
}

