/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import com.google.common.base.Preconditions;
import mrtjp.projectred.core.utils.OpenGLLib;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class ClickRotation {
    private Vector3f dragStart;
    private Matrix4f lastTransform = new Matrix4f();

    private static Vector3f calculateSpherePoint(float f, float f2) {
        Vector3f vector3f = new Vector3f(f, f2, 0.0f);
        float f3 = 1.0f - Vector3f.dot((Vector3f)vector3f, (Vector3f)vector3f);
        if (f3 > 0.0f) {
            vector3f.z = (float)Math.sqrt(f3);
        } else {
            vector3f.normalise();
        }
        return vector3f;
    }

    private Matrix4f getTransform(float f, float f2) {
        Preconditions.checkNotNull((Object)this.dragStart, (Object)"Draging not started");
        Vector3f vector3f = ClickRotation.calculateSpherePoint(f, f2);
        float f3 = Vector3f.dot((Vector3f)this.dragStart, (Vector3f)vector3f);
        if ((double)Math.abs(f3 - 1.0f) < 1.0E-4) {
            return this.lastTransform;
        }
        Vector3f vector3f2 = Vector3f.cross((Vector3f)this.dragStart, (Vector3f)vector3f, null);
        vector3f2.normalise();
        float f4 = 2.0f * (float)Math.acos(f3);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.rotate(f4, vector3f2);
        return Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)this.lastTransform, null);
    }

    public void applyTransform(float f, float f2, boolean bl) {
        OpenGLLib.loadMatrix(bl ? this.getTransform(f, f2) : this.lastTransform);
    }

    public void startDrag(float f, float f2) {
        this.dragStart = ClickRotation.calculateSpherePoint(f, f2);
    }

    public void endDrag(float f, float f2) {
        this.lastTransform = this.getTransform(f, f2);
    }

    public static class ClickRotationHook {
        private final ClickRotation target = new ClickRotation();
        private final float radius;
        private final int mouseButton;
        private boolean isDragging;

        public ClickRotationHook(int n, int n2) {
            this.mouseButton = n;
            this.radius = n2;
        }

        public void update(int n, int n2, boolean bl) {
            float f = (float)n / this.radius;
            float f2 = (float)n2 / this.radius;
            boolean bl2 = Mouse.isButtonDown((int)this.mouseButton);
            if (!this.isDragging && bl2 && bl) {
                this.isDragging = true;
                this.target.startDrag(f, f2);
            } else if (this.isDragging && !bl2) {
                this.isDragging = false;
                this.target.endDrag(f, f2);
            }
            this.target.applyTransform(f, f2, this.isDragging);
        }

        public void setTransform(Matrix4f matrix4f) {
            this.target.lastTransform = matrix4f;
        }
    }
}

