/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import mrtjp.projectred.core.fx.CoreParticle;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.fx.ParticleManagement;

public class ParticleLogicTrail
extends ParticleLogic {
    private int ticksBetweenSpawns = 2;
    private int updateTicks;
    private final String particleName;
    private IParticleBuilder builder;

    public ParticleLogicTrail(String string, IParticleBuilder iParticleBuilder) {
        this.particleName = string;
        this.builder = iParticleBuilder;
        this.updateTicks = 0;
    }

    public ParticleLogicTrail setTicksBetweenSpawns(int n) {
        this.ticksBetweenSpawns = n;
        return this;
    }

    @Override
    public void doUpdate() {
        ++this.updateTicks;
        if (this.updateTicks == this.ticksBetweenSpawns) {
            this.updateTicks = 0;
            CoreParticle coreParticle = ParticleManagement.instance.spawn(this.particle.q, this.particleName, this.particle.u, this.particle.v, this.particle.w);
            if (coreParticle != null) {
                this.builder.build(coreParticle);
            }
        }
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicTrail particleLogicTrail = new ParticleLogicTrail(this.particleName, this.builder).setTicksBetweenSpawns(this.ticksBetweenSpawns);
        return particleLogicTrail;
    }

    public static interface IParticleBuilder {
        public void build(CoreParticle var1);
    }
}

