/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import mrtjp.projectred.core.fx.ParticleLogic;

public final class ParticleLogicColorShift
extends ParticleLogic {
    private float minRed = 0.0f;
    private float maxRed = 1.0f;
    private float minGreen = 0.0f;
    private float maxGreen = 1.0f;
    private float minBlue = 0.0f;
    private float maxBlue = 1.0f;
    private float targetRed;
    private float targetGreen;
    private float targetBlue;
    private boolean endOnReachingColor = false;
    private float shiftSpeed = 0.01f;
    private float redShift;
    private float greenShift;
    private float blueShift;

    public ParticleLogicColorShift() {
        this.generateNextColorTarget();
    }

    public ParticleLogicColorShift setColorTarget(float f, float f2, float f3) {
        this.targetRed = f;
        this.targetGreen = f2;
        this.targetBlue = f3;
        this.redShift = Math.abs(this.particle.getRed() - this.targetRed) * this.shiftSpeed;
        this.greenShift = Math.abs(this.particle.getGreen() - this.targetGreen) * this.shiftSpeed;
        this.blueShift = Math.abs(this.particle.getBlue() - this.targetBlue) * this.shiftSpeed;
        return this;
    }

    public ParticleLogicColorShift setShiftSpeed(float f) {
        this.redShift = this.shiftSpeed = f;
        this.greenShift = this.shiftSpeed;
        this.blueShift = this.shiftSpeed;
        return this;
    }

    public ParticleLogicColorShift setColorRange(float f, float f2, float f3, float f4, float f5, float f6) {
        this.minRed = f;
        this.maxRed = f4;
        this.minGreen = f3;
        this.maxGreen = f5;
        this.minBlue = f2;
        this.maxBlue = f6;
        return this;
    }

    public ParticleLogicColorShift setEndOnReachingTargetColor() {
        this.endOnReachingColor = true;
        return this;
    }

    private void generateNextColorTarget() {
        this.targetRed = this.rand.nextFloat() * (this.maxRed - this.minRed) + this.minRed;
        this.targetGreen = this.rand.nextFloat() * (this.maxGreen - this.minGreen) + this.minGreen;
        this.targetBlue = this.rand.nextFloat() * (this.maxBlue - this.minBlue) + this.minBlue;
    }

    @Override
    public void doUpdate() {
        float f = this.particle.getRed();
        float f2 = this.particle.getGreen();
        float f3 = this.particle.getBlue();
        if (f == this.targetRed && f2 == this.targetGreen && f3 == this.targetBlue) {
            if (this.endOnReachingColor) {
                this.finishLogic();
                return;
            }
            this.generateNextColorTarget();
        }
        this.particle.setRGBColorF(this.shiftValue(f, this.targetRed, this.redShift), this.shiftValue(f2, this.targetGreen, this.greenShift), this.shiftValue(f3, this.targetBlue, this.blueShift));
    }

    private float shiftValue(float f, float f2, float f3) {
        float f4 = Math.abs(f2 - f);
        if (f4 < f3) {
            f3 = f4;
        }
        if (f < f2) {
            f += f3;
        } else if (f > f2) {
            f -= f3;
        }
        return f;
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicColorShift particleLogicColorShift = new ParticleLogicColorShift().setShiftSpeed(this.shiftSpeed).setColorRange(this.minRed, this.minBlue, this.minGreen, this.maxRed, this.maxGreen, this.maxBlue).setColorTarget(this.targetRed, this.targetGreen, this.targetBlue);
        if (this.endOnReachingColor) {
            particleLogicColorShift.setEndOnReachingTargetColor();
        }
        particleLogicColorShift.setFinal(this.finalLogic).setPriority(this.priority);
        return particleLogicColorShift;
    }
}

