/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.Biomes;
import biomesoplenty.configuration.BOPConfigurationIDs;
import biomesoplenty.entities.EntityBird;
import biomesoplenty.entities.EntityGlob;
import biomesoplenty.entities.EntityJungleSpider;
import biomesoplenty.entities.EntityPhantom;
import biomesoplenty.entities.EntityPixie;
import biomesoplenty.entities.EntityRosester;
import biomesoplenty.entities.EntityWasp;
import biomesoplenty.entities.projectiles.EntityDart;
import biomesoplenty.entities.projectiles.EntityMudball;
import biomesoplenty.entities.projectiles.EntityPoisonDart;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public class BOPEntities {
    public static int eggIdCounter = 300;

    public static int getUniqueEntityEggId() {
        while (EntityList.func_75617_a((int)(++eggIdCounter)) != null) {
        }
        return eggIdCounter;
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int primaryColor, int secondaryColor) {
        int id = BOPEntities.getUniqueEntityEggId();
        EntityList.field_75623_d.put(id, entity);
        EntityList.field_75627_a.put(id, new EntityEggInfo(id, primaryColor, secondaryColor));
    }

    public static void init() {
        EntityRegistry.registerModEntity(EntityMudball.class, (String)"MudBall", (int)BOPConfigurationIDs.entityMudballID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityDart.class, (String)"Dart", (int)BOPConfigurationIDs.entityDartID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityPoisonDart.class, (String)"PoisonDart", (int)BOPConfigurationIDs.entityPoisonDartID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        if (BOPConfigurationIDs.jungleSpiderID > 0) {
            EntityRegistry.registerModEntity(EntityJungleSpider.class, (String)"JungleSpider", (int)BOPConfigurationIDs.jungleSpiderID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityJungleSpider.class, 5147192, 11013646);
            if (Biomes.bambooForest.isPresent() && Biomes.jungleNew.isPresent() && Biomes.tropicalRainforest.isPresent() && Biomes.oasis.isPresent() && Biomes.tropics.isPresent()) {
                EntityRegistry.addSpawn(EntityJungleSpider.class, (int)8, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.bambooForest.get(), (BiomeGenBase)Biomes.jungleNew.get(), (BiomeGenBase)Biomes.tropicalRainforest.get(), (BiomeGenBase)Biomes.oasis.get(), (BiomeGenBase)Biomes.tropics.get()});
            }
        }
        if (BOPConfigurationIDs.rosesterID > 0) {
            EntityRegistry.registerModEntity(EntityRosester.class, (String)"Rosester", (int)BOPConfigurationIDs.rosesterID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityRosester.class, 14831439, 16756224);
            if (Biomes.garden.isPresent()) {
                EntityRegistry.addSpawn(EntityRosester.class, (int)10, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.garden.get()});
            }
        }
        if (BOPConfigurationIDs.globID > 0) {
            EntityRegistry.registerModEntity(EntityGlob.class, (String)"Glob", (int)BOPConfigurationIDs.globID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityGlob.class, 6836276, 8414787);
            if (Biomes.bog.isPresent() && Biomes.deadSwamp.isPresent() && Biomes.fen.isPresent() && Biomes.moor.isPresent() && Biomes.quagmire.isPresent() && Biomes.sludgepit.isPresent() && Biomes.swamplandNew.isPresent()) {
                EntityRegistry.addSpawn(EntityGlob.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.bog.get(), (BiomeGenBase)Biomes.deadSwamp.get(), (BiomeGenBase)Biomes.fen.get(), (BiomeGenBase)Biomes.moor.get(), (BiomeGenBase)Biomes.quagmire.get(), (BiomeGenBase)Biomes.sludgepit.get(), (BiomeGenBase)Biomes.swamplandNew.get()});
            }
        }
        if (BOPConfigurationIDs.phantomID > 0) {
            EntityRegistry.registerModEntity(EntityPhantom.class, (String)"Phantom", (int)BOPConfigurationIDs.phantomID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityPhantom.class, 4472140, 2499368);
            if (Biomes.netherBone.isPresent() && Biomes.netherDesert.isPresent()) {
                EntityRegistry.addSpawn(EntityPhantom.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.netherBone.get(), (BiomeGenBase)Biomes.netherDesert.get()});
            }
        }
        if (BOPConfigurationIDs.waspID > 0) {
            EntityRegistry.registerModEntity(EntityWasp.class, (String)"Wasp", (int)BOPConfigurationIDs.waspID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityWasp.class, 16434729, 0x262627);
        }
        if (BOPConfigurationIDs.birdID > 0) {
            EntityRegistry.registerModEntity(EntityBird.class, (String)"Bird", (int)BOPConfigurationIDs.birdID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityBird.class, 5277691, 16772788);
            if (Biomes.promisedLandForest.isPresent() && Biomes.promisedLandSwamp.isPresent() && Biomes.promisedLandPlains.isPresent() && Biomes.promisedLandShrub.isPresent()) {
                EntityRegistry.addSpawn(EntityBird.class, (int)10, (int)3, (int)5, (EnumCreatureType)EnumCreatureType.ambient, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.promisedLandForest.get(), (BiomeGenBase)Biomes.promisedLandSwamp.get(), (BiomeGenBase)Biomes.promisedLandPlains.get(), (BiomeGenBase)Biomes.promisedLandShrub.get()});
            }
        }
        if (BOPConfigurationIDs.pixieID > 0) {
            EntityRegistry.registerModEntity(EntityPixie.class, (String)"Pixie", (int)BOPConfigurationIDs.pixieID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityPixie.class, 0xFF77DD, 16645116);
            if (Biomes.promisedLandForest.isPresent() && Biomes.promisedLandSwamp.isPresent() && Biomes.promisedLandPlains.isPresent() && Biomes.promisedLandShrub.isPresent()) {
                EntityRegistry.addSpawn(EntityPixie.class, (int)4, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.promisedLandForest.get(), (BiomeGenBase)Biomes.promisedLandSwamp.get(), (BiomeGenBase)Biomes.promisedLandPlains.get(), (BiomeGenBase)Biomes.promisedLandShrub.get()});
            }
        }
    }
}

