/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.PRColors;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHalo {
    public static RenderHalo instance = new RenderHalo();
    private static List<LightCache> renderList = new ArrayList<LightCache>();
    private static Vector3 renderEntityPos = new Vector3();
    private static Vector3 vec = new Vector3();

    public static void addLight(int n, int n2, int n3, int n4, Cuboid6 cuboid6) {
        renderList.add(new LightCache(n, n2, n3, n4, cuboid6));
    }

    @ForgeSubscribe
    public void onRenderWorldLast(RenderWorldLastEvent renderWorldLastEvent) {
        bfq bfq2 = bfq.a;
        bdd bdd2 = renderWorldLastEvent.context.k;
        of of2 = renderWorldLastEvent.context.t.i;
        renderEntityPos.set(of2.u, of2.v + (double)of2.f(), of2.w);
        Collections.sort(renderList);
        GL11.glPushMatrix();
        RenderUtils.translateToWorldCoords((nn)renderWorldLastEvent.context.t.i, (float)renderWorldLastEvent.partialTicks);
        RenderHalo.prepareRenderState();
        Iterator<LightCache> iterator = renderList.iterator();
        int n = Configurator.lightHaloMax < 0 ? renderList.size() : Configurator.lightHaloMax;
        for (int i = 0; i < n && iterator.hasNext(); ++i) {
            LightCache lightCache = iterator.next();
            RenderHalo.renderHalo(bfq2, (abw)bdd2, lightCache);
        }
        renderList.clear();
        RenderHalo.restoreRenderState();
        GL11.glPopMatrix();
    }

    public static void prepareRenderState() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        CCRenderState.reset();
        CCRenderState.startDrawing((int)7);
    }

    public static void restoreRenderState() {
        CCRenderState.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    private static void renderHalo(bfq bfq2, abw abw2, LightCache lightCache) {
        CCRenderState.setBrightness((acf)abw2, (int)lightCache.pos.x, (int)lightCache.pos.y, (int)lightCache.pos.z);
        RenderHalo.renderHalo(bfq2, lightCache.cube, lightCache.color, (Transformation)new Translation((double)lightCache.pos.x, (double)lightCache.pos.y, (double)lightCache.pos.z));
    }

    public static void renderHalo(bfq bfq2, Cuboid6 cuboid6, int n, Transformation transformation) {
        bfq2.a(PRColors.VALID_COLORS[n].rgb, 128);
        RenderUtils.renderBlock((Cuboid6)cuboid6, (int)0, (Transformation)transformation, null, null);
    }

    private static class LightCache
    implements Comparable<LightCache> {
        final BlockCoord pos;
        final int color;
        final Cuboid6 cube;

        public LightCache(int n, int n2, int n3, int n4, Cuboid6 cuboid6) {
            this.pos = new BlockCoord(n, n2, n3);
            this.color = n4;
            this.cube = cuboid6;
        }

        private double renderDist() {
            return vec.set((double)this.pos.x, (double)this.pos.y, (double)this.pos.z).sub(renderEntityPos).magSquared();
        }

        @Override
        public int compareTo(LightCache lightCache) {
            double d;
            double d2 = this.renderDist();
            return d2 == (d = lightCache.renderDist()) ? 0 : (d2 < d ? 1 : -1);
        }
    }
}

