/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Map;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.illumination.CageLampPart;
import mrtjp.projectred.illumination.RenderHalo;
import mrtjp.projectred.illumination.RenderLantern;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCageLamp
implements IItemRenderer {
    public static RenderCageLamp instance = new RenderCageLamp();
    private static CCModel[] base;
    public static final Cuboid6[] lightBounds;

    public void renderCageLamp(CageLampPart cageLampPart) {
        ms ms2 = cageLampPart.isOn() ? RenderLantern.onIcons[cageLampPart.type] : RenderLantern.offIcons[cageLampPart.type];
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.setBrightness((acf)cageLampPart.world(), (int)cageLampPart.x(), (int)cageLampPart.y(), (int)cageLampPart.z());
        CCRenderState.useModelColours((boolean)true);
        this.renderPart(ms2, base[cageLampPart.side], cageLampPart.x(), cageLampPart.y(), cageLampPart.z());
    }

    public void renderBreaking(CageLampPart cageLampPart, ms ms2) {
        RenderUtils.renderBlock((Cuboid6)CageLampPart.bounds[cageLampPart.side], (int)0, (Transformation)new Translation((double)cageLampPart.x(), (double)cageLampPart.y(), (double)cageLampPart.z()), (IUVTransformation)new IconTransformation(ms2), null);
    }

    public boolean handleRenderType(ye ye2, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ye ye2, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ye ye2, Object ... objectArray) {
        int n = ye2.k();
        boolean bl = ye2.b() == ProjectRedIllumination.itemPartInvCageLamp();
        switch (itemRenderType) {
            case ENTITY: {
                this.renderInventory(bl, n, -0.25, 0.0, -0.25, 0.75);
                return;
            }
            case EQUIPPED: {
                this.renderInventory(bl, n, -0.15, -0.15, -0.15, 1.5);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderInventory(bl, n, -0.15, -0.15, -0.15, 1.5);
                return;
            }
            case INVENTORY: {
                this.renderInventory(bl, n, 0.0, -0.05, 0.0, 1.0);
                return;
            }
        }
    }

    public void renderInventory(boolean bl, int n, double d, double d2, double d3, double d4) {
        if (n > 15 || n < 0) {
            return;
        }
        ms ms2 = bl ? RenderLantern.onIcons[n] : RenderLantern.offIcons[n];
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)d2, (double)d3);
        GL11.glScaled((double)d4, (double)d4, (double)d4);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.startDrawing((int)7);
        this.renderPart(ms2, base[0], d, d2, d3);
        CCRenderState.draw();
        if (bl) {
            RenderHalo.prepareRenderState();
            RenderHalo.renderHalo(bfq.a, lightBounds[0], n, (Transformation)new Translation(d, d2, d3));
            RenderHalo.restoreRenderState();
        }
        GL11.glPopMatrix();
    }

    public void renderPart(ms ms2, CCModel cCModel, double d, double d2, double d3) {
        cCModel.render(0, cCModel.verts.length, (Transformation)new Translation(d, d2, d3), (IUVTransformation)new IconTransformation(ms2), (IVertexModifier)ColourModifier.instance);
    }

    static {
        lightBounds = new Cuboid6[6];
        Map map = CCModel.parseObjModels((bjo)new bjo("projectred", "textures/obj/lights/cagelamp.obj"), (int)7, (Transformation)new InvertX());
        base = new CCModel[6];
        for (int i = 0; i < 6; ++i) {
            CCModel cCModel = ((CCModel)map.get("base")).copy();
            cCModel.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            cCModel.apply(Rotation.sideOrientation((int)i, (int)0).at(Vector3.center));
            cCModel.computeLighting(LightModel.standardLightModel);
            cCModel.shrinkUVs(5.0E-4);
            RenderCageLamp.base[i] = cCModel.copy();
            Transformation transformation = Rotation.sideRotations[i].at(Vector3.center);
            RenderCageLamp.lightBounds[i] = new Cuboid6(0.25, 0.0, 0.25, 0.75, 0.625, 0.75).apply(transformation).expand(-0.001);
        }
    }
}

