/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.UV;
import codechicken.lib.render.UVScale;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.CuboidCoord;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.HashMultimap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class QBImporter {
    private static final int[][] vertOrder = new int[][]{{3, 0}, {1, 0}, {1, 2}, {3, 2}};
    public static final int TEXTUREPLANES = 1;
    public static final int SQUARETEXTURE = 2;
    public static final int MERGETEXTURES = 4;
    public static final int SCALEMC = 8;
    private static final int CODEFLAG = Integer.reverseBytes(2);
    private static final int NEXTSLICEFLAG = Integer.reverseBytes(6);

    private static String readAsciiString(DataInputStream din) throws IOException {
        byte[] bytes = new byte[din.readByte() & 0xFF];
        din.readFully(bytes);
        return new String(bytes, "US-ASCII");
    }

    private static int readTni(DataInputStream din) throws IOException {
        return Integer.reverseBytes(din.readInt());
    }

    public static QBModel loadQB(InputStream input) throws IOException {
        boolean visEncoded;
        DataInputStream din = new DataInputStream(input);
        QBModel m = new QBModel();
        int version = din.readInt();
        int colorFormat = din.readInt();
        m.rightHanded = din.readInt() != 0;
        boolean compressed = din.readInt() != 0;
        boolean bl = visEncoded = din.readInt() != 0;
        if (visEncoded) {
            throw new IllegalArgumentException("Encoded Visiblity States not supported");
        }
        m.matrices = new QBMatrix[QBImporter.readTni(din)];
        for (int i = 0; i < m.matrices.length; ++i) {
            QBMatrix mat;
            m.matrices[i] = mat = new QBMatrix();
            mat.name = QBImporter.readAsciiString(din);
            mat.size = new BlockCoord(QBImporter.readTni(din), QBImporter.readTni(din), QBImporter.readTni(din));
            mat.pos = new BlockCoord(QBImporter.readTni(din), QBImporter.readTni(din), QBImporter.readTni(din));
            mat.matrix = new int[mat.size.x][mat.size.y][mat.size.z];
            mat.readMatrix(din, compressed);
            if (colorFormat != 1) continue;
            mat.convertBGRAtoRGBA();
        }
        return m;
    }

    public static QBModel loadQB(bjo res) {
        try {
            return QBImporter.loadQB(atv.w().K().a(res).b());
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load model: " + res, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QBModel loadQB(File file) {
        QBModel qBModel;
        FileInputStream fin = new FileInputStream(file);
        try {
            qBModel = QBImporter.loadQB(fin);
        }
        catch (Throwable throwable) {
            try {
                fin.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("failed to load model: " + file.getPath(), e);
            }
        }
        fin.close();
        return qBModel;
    }

    public static class RasterisedModel {
        private Map<String, Holder> map = new HashMap<String, Holder>();
        private List<BufferedImage> images;
        private String[] icons;

        public RasterisedModel(List<BufferedImage> images) {
            this.images = images;
            this.icons = new String[images.size()];
        }

        public void add(String name, CCModel m) {
            this.map.put(name, new Holder(m, Math.min(this.map.size(), this.images.size() - 1)));
        }

        public CCModel getModel(String key) {
            return this.map.get((Object)key).m;
        }

        public ms getIcon(String key, mt r, String iconName) {
            int img = this.map.get((Object)key).img;
            if (this.icons[img] != null && !iconName.equals(this.icons[img])) {
                throw new IllegalArgumentException("Attempted to get a previously registered icon by a different name: " + this.icons[img] + ", " + iconName);
            }
            if (this.icons[img] != null) {
                return r.a(iconName);
            }
            this.icons[img] = iconName;
            return TextureUtils.getTextureSpecial(r, iconName).addTexture(new TextureDataHolder(this.images.get(img)));
        }

        private void exportImg(BufferedImage img, File imgFile) throws IOException {
            if (!imgFile.exists()) {
                imgFile.createNewFile();
            }
            ImageIO.write((RenderedImage)img, "PNG", imgFile);
        }

        public void export(File objFile, File imgDir) {
            try {
                if (!objFile.exists()) {
                    objFile.createNewFile();
                }
                if (!imgDir.exists()) {
                    imgDir.mkdirs();
                }
                HashMap<String, CCModel> modelMap = new HashMap<String, CCModel>();
                for (Map.Entry<String, Holder> e : this.map.entrySet()) {
                    modelMap.put(e.getKey(), e.getValue().m);
                }
                PrintWriter p = new PrintWriter(objFile);
                CCModel.exportObj(modelMap, p);
                p.close();
                if (this.images.size() < this.map.size()) {
                    this.exportImg(this.images.get(0), new File(imgDir, objFile.getName().replaceAll("(.+)\\..+", "$1.png")));
                } else {
                    for (Map.Entry<String, Holder> e : this.map.entrySet()) {
                        this.exportImg(this.images.get(e.getValue().img), new File(imgDir, e.getKey() + ".png"));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private class Holder {
            CCModel m;
            int img;

            public Holder(CCModel m, int img) {
                this.m = m;
                this.img = img;
            }
        }
    }

    public static class QBModel {
        public QBMatrix[] matrices;
        public boolean rightHanded;

        public RasterisedModel toRasterisedModel(int flags) {
            ArrayList<QBImage> qbImages = new ArrayList<QBImage>();
            ArrayList<List<QBQuad>> modelQuads = new ArrayList<List<QBQuad>>();
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            boolean texturePlanes = (flags & 1) != 0;
            boolean squareTextures = (flags & 2) != 0;
            boolean mergeTextures = (flags & 4) != 0;
            boolean scaleMC = (flags & 8) != 0;
            for (QBMatrix mat : this.matrices) {
                List<QBQuad> quads = mat.extractQuads(texturePlanes);
                modelQuads.add(quads);
                QBMatrix.addImages(quads, qbImages);
                if (mergeTextures) continue;
                images.add(ImagePackNode.pack(qbImages, squareTextures).toImage());
                qbImages.clear();
            }
            if (mergeTextures) {
                images.add(ImagePackNode.pack(qbImages, squareTextures).toImage());
            }
            RasterisedModel m = new RasterisedModel(images);
            for (int i = 0; i < this.matrices.length; ++i) {
                QBMatrix mat = this.matrices[i];
                BufferedImage img = (BufferedImage)images.get(mergeTextures ? 0 : i);
                m.add(mat.name, mat.buildModel((List)modelQuads.get(i), img, scaleMC));
            }
            return m;
        }
    }

    public static class QBMatrix {
        public String name;
        public BlockCoord pos;
        public BlockCoord size;
        public int[][][] matrix;

        public void readMatrix(DataInputStream din, boolean compressed) throws IOException {
            if (compressed) {
                for (int z = 0; z < this.size.z; ++z) {
                    int data;
                    int index = 0;
                    while ((data = din.readInt()) != NEXTSLICEFLAG) {
                        if (data == CODEFLAG) {
                            int count = QBImporter.readTni(din);
                            data = din.readInt();
                            int j = 0;
                            while (j < count) {
                                this.matrix[index % this.size.x][index / this.size.x][z] = data;
                                ++j;
                                ++index;
                            }
                            continue;
                        }
                        this.matrix[index % this.size.x][index / this.size.x][z] = data;
                        ++index;
                    }
                }
            } else {
                for (int z = 0; z < this.size.z; ++z) {
                    for (int y = 0; y < this.size.y; ++y) {
                        for (int x = 0; x < this.size.x; ++x) {
                            this.matrix[x][y][z] = din.readInt();
                        }
                    }
                }
            }
        }

        public void convertBGRAtoRGBA() {
            for (int z = 0; z < this.size.z; ++z) {
                for (int y = 0; y < this.size.y; ++y) {
                    for (int x = 0; x < this.size.x; ++x) {
                        int i = this.matrix[x][y][z];
                        this.matrix[x][y][z] = Integer.reverseBytes(i >>> 8) | i & 0xFF;
                    }
                }
            }
        }

        private boolean voxelFull(boolean[][][] solid, CuboidCoord c) {
            for (BlockCoord b : c) {
                if (this.matrix[b.x][b.y][b.z] != 0) continue;
                return false;
            }
            for (BlockCoord b : c) {
                solid[b.x][b.y][b.z] = false;
            }
            return true;
        }

        private QBCuboid expand(boolean[][][] solid, BlockCoord b) {
            CuboidCoord c = new CuboidCoord(b);
            solid[b.x][b.y][b.z] = false;
            for (int s = 0; s < 6; ++s) {
                CuboidCoord slice = c.copy();
                slice.expand(s ^ 1, -(slice.size(s) - 1));
                slice.expand(s, 1);
                while (slice.getSide(s) >= 0 && slice.getSide(s) < this.size.getSide(s) && this.voxelFull(solid, slice)) {
                    slice.expand(s ^ 1, -1);
                    slice.expand(s, 1);
                    c.expand(s, 1);
                }
            }
            return new QBCuboid(this, c);
        }

        public List<QBCuboid> rectangulate() {
            ArrayList<QBCuboid> list = new ArrayList<QBCuboid>();
            boolean[][][] solid = new boolean[this.size.x][this.size.y][this.size.z];
            for (int z = 0; z < this.size.z; ++z) {
                for (int y = 0; y < this.size.y; ++y) {
                    for (int x = 0; x < this.size.x; ++x) {
                        solid[x][y][z] = this.matrix[x][y][z] != 0;
                    }
                }
            }
            for (int x = 0; x < this.size.x; ++x) {
                for (int z = 0; z < this.size.z; ++z) {
                    for (int y = 0; y < this.size.y; ++y) {
                        if (!solid[x][y][z]) continue;
                        list.add(this.expand(solid, new BlockCoord(x, y, z)));
                    }
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                for (int j = i + 1; j < list.size(); ++j) {
                    QBCuboid.clip((QBCuboid)list.get(i), (QBCuboid)list.get(j));
                }
            }
            return list;
        }

        public List<QBQuad> extractQuads(boolean texturePlanes) {
            LinkedList<QBQuad> quads = new LinkedList<QBQuad>();
            for (QBCuboid c : this.rectangulate()) {
                c.extractQuads(quads);
            }
            if (texturePlanes) {
                this.optimisePlanes(quads);
            }
            return quads;
        }

        private void optimisePlanes(List<QBQuad> quads) {
            HashMultimap map = HashMultimap.create();
            for (QBQuad quad : quads) {
                map.put((Object)(quad.side | (int)quad.verts[0].vec.getSide(quad.side) << 3), (Object)quad);
            }
            quads.clear();
            for (Integer key : map.keySet()) {
                Collection plane = map.get((Object)key);
                if (plane.size() == 1) {
                    quads.add((QBQuad)plane.iterator().next());
                    continue;
                }
                int side = key & 7;
                Rectangle4i rect = null;
                for (QBQuad q : plane) {
                    if (rect == null) {
                        rect = q.flatten();
                        continue;
                    }
                    rect.include(q.flatten());
                }
                QBImage img = new QBImage();
                img.data = new int[rect.w][rect.h];
                for (QBQuad q : plane) {
                    QBImage from = q.image;
                    Rectangle4i r = q.flatten();
                    int du = r.x - rect.x;
                    int dv = r.y - rect.y;
                    for (int u = 0; u < from.width(); ++u) {
                        for (int v = 0; v < from.height(); ++v) {
                            img.data[du + u][dv + v] = from.data[u][v];
                        }
                    }
                }
                quads.add(QBQuad.restore(rect, side, key >> 3, img));
            }
        }

        public CCModel buildModel(List<QBQuad> quads, BufferedImage img, boolean scaleMC) {
            CCModel m = CCModel.quadModel(quads.size() * 4);
            int i = 0;
            for (QBQuad quad : quads) {
                quad.applyImageT();
                m.verts[i++] = quad.verts[0];
                m.verts[i++] = quad.verts[1];
                m.verts[i++] = quad.verts[2];
                m.verts[i++] = quad.verts[3];
            }
            m.apply(new UVScale(1.0 / (double)img.getWidth(), 1.0 / (double)img.getHeight()));
            m.apply(new Translation(this.pos.x, this.pos.y, this.pos.z));
            if (scaleMC) {
                m.apply(new Scale(0.0625));
            }
            m.computeNormals();
            return m;
        }

        private static void addImages(List<QBQuad> quads, List<QBImage> images) {
            for (QBQuad q : quads) {
                QBImage img = q.image;
                boolean matched = false;
                for (QBImage img2 : images) {
                    ImageTransform t = img.transformTo(img2);
                    if (t == null) continue;
                    q.t = t;
                    q.image = img2;
                    matched = true;
                    break;
                }
                if (matched) continue;
                images.add(img);
            }
        }
    }

    public static class QBCuboid {
        public QBMatrix mat;
        public CuboidCoord c;
        public int sides;

        public QBCuboid(QBMatrix mat, CuboidCoord c) {
            this.mat = mat;
            this.c = c;
            this.sides = 0;
        }

        public static boolean intersects(QBCuboid a, QBCuboid b) {
            CuboidCoord c = a.c;
            CuboidCoord d = b.c;
            return c.min.x <= d.max.x && d.min.x <= c.max.x && c.min.y <= d.max.y && d.min.y <= c.max.y && c.min.z <= d.max.z && d.min.z <= c.max.z;
        }

        public static void clip(QBCuboid a, QBCuboid b) {
            if (QBCuboid.intersects(a, b)) {
                a.clip(b);
                b.clip(a);
            }
        }

        public void clip(QBCuboid o) {
            CuboidCoord d = o.c;
            for (int a = 0; a < 6; a += 2) {
                int a1 = (a + 2) % 6;
                int a2 = (a + 4) % 6;
                if (this.c.getSide(a1 + 1) > d.getSide(a1 + 1) || this.c.getSide(a1) < d.getSide(a1) || this.c.getSide(a2 + 1) > d.getSide(a2 + 1) || this.c.getSide(a2) < d.getSide(a2)) continue;
                if (this.c.getSide(a) <= d.getSide(a + 1) && this.c.getSide(a) >= d.getSide(a)) {
                    this.c.setSide(a, d.getSide(a + 1) + 1);
                    this.sides |= 1 << a;
                }
                if (this.c.getSide(a + 1) < d.getSide(a) || this.c.getSide(a + 1) > d.getSide(a + 1)) continue;
                this.c.setSide(a + 1, d.getSide(a) - 1);
                this.sides |= 2 << a;
            }
        }

        public void extractQuads(List<QBQuad> quads) {
            Cuboid6 box = this.c.bounds();
            for (int s = 0; s < 6; ++s) {
                if ((this.sides & 1 << s) != 0) continue;
                quads.add(this.extractQuad(s, box));
            }
        }

        private QBQuad extractQuad(int side, Cuboid6 box) {
            double[] da = new double[3];
            da[side >> 1] = box.getSide(side);
            QBQuad quad = new QBQuad(side);
            for (int i = 0; i < 4; ++i) {
                int rU = vertOrder[i][0];
                int rV = vertOrder[i][1];
                int sideU = Rotation.rotateSide(side, rU);
                int sideV = Rotation.rotateSide(side, rV);
                da[sideU >> 1] = box.getSide(sideU);
                da[sideV >> 1] = box.getSide(sideV);
                quad.verts[i] = new Vertex5(Vector3.fromAxes(da), (3 - rU) / 2, rV / 2);
            }
            int sideU = Rotation.rotateSide(side, 1);
            int sideV = Rotation.rotateSide(side, 2);
            quad.image.data = new int[this.c.size(sideU)][this.c.size(sideV)];
            QBImage image = quad.image;
            int[] ia = new int[3];
            ia[side >> 1] = this.c.getSide(side);
            ia[sideU >> 1] = this.c.getSide(sideU ^ 1);
            ia[sideV >> 1] = this.c.getSide(sideV ^ 1);
            BlockCoord b = BlockCoord.fromAxes(ia);
            BlockCoord bU = BlockCoord.sideOffsets[sideU];
            BlockCoord bV = BlockCoord.sideOffsets[sideV];
            for (int u = 0; u < image.width(); ++u) {
                for (int v = 0; v < image.height(); ++v) {
                    image.data[u][v] = this.mat.matrix[b.x + bU.x * u + bV.x * v][b.y + bU.y * u + bV.y * v][b.z + bU.z * u + bV.z * v];
                }
            }
            return quad;
        }
    }

    public static class QBQuad {
        public Vertex5[] verts = new Vertex5[4];
        public QBImage image = new QBImage();
        public ImageTransform t = new ImageTransform();
        public int side;

        public QBQuad(int side) {
            this.side = side;
        }

        public void applyImageT() {
            for (Vertex5 vert : this.verts) {
                this.t.transform(vert.uv);
                this.image.transform(vert.uv);
            }
        }

        public static QBQuad restore(Rectangle4i flat, int side, double d, QBImage img) {
            QBQuad quad = new QBQuad(side);
            quad.image = img;
            TransformationList t = new Scale(-1.0, 1.0, -1.0).with(Rotation.sideOrientation(side, 0)).with(new Translation(new Vector3().setSide(side, d)));
            quad.verts[0] = new Vertex5(flat.x, 0.0, flat.y, 0.0, 0.0);
            quad.verts[1] = new Vertex5(flat.x + flat.w, 0.0, flat.y, 1.0, 0.0);
            quad.verts[2] = new Vertex5(flat.x + flat.w, 0.0, flat.y + flat.h, 1.0, 1.0);
            quad.verts[3] = new Vertex5(flat.x, 0.0, flat.y + flat.h, 0.0, 1.0);
            for (Vertex5 vert : quad.verts) {
                vert.apply(t);
            }
            return quad;
        }

        public Rectangle4i flatten() {
            TransformationList t = Rotation.sideOrientation(this.side, 0).inverse().with(new Scale(-1.0, 0.0, -1.0));
            Vector3 vmin = this.verts[0].vec.copy().apply(t);
            Vector3 vmax = this.verts[2].vec.copy().apply(t);
            return new Rectangle4i((int)vmin.x, (int)vmin.z, (int)(vmax.x - vmin.x), (int)(vmax.z - vmin.z));
        }
    }

    public static class QBImage
    implements Comparable<QBImage> {
        int[][] data;
        ImageTransform packT;
        Rectangle4i packSlot;

        public int width() {
            return this.data.length;
        }

        public int height() {
            return this.data[0].length;
        }

        public int area() {
            return this.width() * this.height();
        }

        @Override
        public int compareTo(QBImage o) {
            int b;
            int a = this.area();
            return a > (b = o.area()) ? -1 : (a == b ? 0 : 1);
        }

        public ImageTransform transformTo(QBImage img) {
            ImageTransform t;
            int i;
            if (this.width() == img.width() && this.height() == img.height()) {
                for (i = 0; i < 4; ++i) {
                    t = new ImageTransform(i);
                    if (!this.equals(img, t)) continue;
                    return t;
                }
            }
            if (this.width() == img.height() && this.height() == img.width()) {
                for (i = 4; i < 8; ++i) {
                    t = new ImageTransform(i);
                    if (!this.equals(img, t)) continue;
                    return t;
                }
            }
            return null;
        }

        public boolean equals(QBImage img, ImageTransform t) {
            for (int u = 0; u < img.width(); ++u) {
                for (int v = 0; v < img.height(); ++v) {
                    if (t.access(this, u, v) == img.data[u][v]) continue;
                    return false;
                }
            }
            return true;
        }

        public void transform(UV uv) {
            this.packT.transform(uv);
            uv.u *= (double)this.packSlot.w;
            uv.v *= (double)this.packSlot.h;
            uv.u += (double)this.packSlot.x;
            uv.v += (double)this.packSlot.y;
        }
    }

    private static class ImageTransform {
        int transform;

        public ImageTransform(int i) {
            this.transform = i;
        }

        public ImageTransform() {
            this(0);
        }

        public boolean transpose() {
            return (this.transform & 4) != 0;
        }

        public boolean flipU() {
            return (this.transform & 1) != 0;
        }

        public boolean flipV() {
            return (this.transform & 2) != 0;
        }

        public int access(QBImage img, int u, int v) {
            if (this.transpose()) {
                int tmp = u;
                u = v;
                v = tmp;
            }
            if (this.flipU()) {
                u = img.width() - 1 - u;
            }
            if (this.flipV()) {
                v = img.height() - 1 - v;
            }
            return img.data[u][v];
        }

        public UV transform(UV uv) {
            if (this.transpose()) {
                double tmp = uv.u;
                uv.u = uv.v;
                uv.v = tmp;
            }
            if (this.flipU()) {
                uv.u = 1.0 - uv.u;
            }
            if (this.flipV()) {
                uv.v = 1.0 - uv.v;
            }
            return uv;
        }
    }

    private static class ImagePackNode {
        Rectangle4i rect;
        ImagePackNode child1;
        ImagePackNode child2;
        QBImage packed;

        public ImagePackNode(int x, int y, int w, int h) {
            this.rect = new Rectangle4i(x, y, w, h);
        }

        public boolean pack(QBImage img) {
            int h;
            if (this.child1 != null) {
                return this.child1.pack(img) || this.child2.pack(img);
            }
            if (this.packed != null) {
                return false;
            }
            int fit = this.getFit(img.width(), img.height());
            if (fit == 0) {
                return false;
            }
            if ((fit & 2) != 0) {
                this.packed = img;
                img.packSlot = this.rect;
                img.packT = new ImageTransform((fit & 1) << 2);
                return true;
            }
            int w = (fit & 1) == 0 ? img.width() : img.height();
            int n = h = (fit & 1) == 0 ? img.height() : img.width();
            if (this.rect.w - w > this.rect.h - h) {
                this.child1 = new ImagePackNode(this.rect.x, this.rect.y, w, this.rect.h);
                this.child2 = new ImagePackNode(this.rect.x + w, this.rect.y, this.rect.w - w, this.rect.h);
            } else {
                this.child1 = new ImagePackNode(this.rect.x, this.rect.y, this.rect.w, h);
                this.child2 = new ImagePackNode(this.rect.x, this.rect.y + h, this.rect.w, this.rect.h - h);
            }
            return this.child1.pack(img);
        }

        private int getFit(int w, int h) {
            if (w == this.rect.w && h == this.rect.h) {
                return 2;
            }
            if (w == this.rect.h && h == this.rect.w) {
                return 3;
            }
            if (this.rect.w >= w && this.rect.h >= h) {
                return 4;
            }
            if (this.rect.w >= h && this.rect.h >= w) {
                return 5;
            }
            return 0;
        }

        private static void nextSize(Rectangle4i rect, boolean square) {
            if (square) {
                rect.w <<= 1;
                rect.h <<= 1;
            } else if (rect.w == rect.h) {
                rect.w *= 2;
            } else {
                rect.h *= 2;
            }
        }

        public static ImagePackNode pack(List<QBImage> images, boolean square) {
            Collections.sort(images);
            int area = 0;
            for (QBImage img : images) {
                area += img.area();
            }
            ImagePackNode node = new ImagePackNode(0, 0, 2, 2);
            while (node.rect.area() < area) {
                ImagePackNode.nextSize(node.rect, square);
            }
            while (true) {
                boolean packed = true;
                for (QBImage img : images) {
                    if (node.pack(img)) continue;
                    packed = false;
                    break;
                }
                if (packed) {
                    return node;
                }
                node.child2 = null;
                node.child1 = null;
                ImagePackNode.nextSize(node.rect, square);
            }
        }

        public BufferedImage toImage() {
            BufferedImage img = new BufferedImage(this.rect.w, this.rect.h, 2);
            this.write(img);
            return img;
        }

        private void write(BufferedImage img) {
            if (this.child1 != null) {
                this.child1.write(img);
                this.child2.write(img);
            } else if (this.packed != null) {
                ImageTransform t = this.packed.packT;
                for (int u = 0; u < this.rect.w; ++u) {
                    for (int v = 0; v < this.rect.h; ++v) {
                        int rgba = t.access(this.packed, u, v);
                        img.setRGB(u + this.rect.x, v + this.rect.y, rgba >>> 8 | rgba << 24);
                    }
                }
            }
        }
    }
}

