/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.preloader.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import tconstruct.preloader.TConstructLoaderContainer;

public class PropertyManager {
    public static final String propFileName = "TConPreloader.cfg";
    public static boolean asmInterfaceRepair_verboseLog = false;

    private PropertyManager() {
    }

    public static boolean getOrCreateProps() throws PropAccessException {
        File fp = new File("config/TConPreloader.cfg");
        Properties props = new Properties();
        if (fp.exists()) {
            try {
                TConstructLoaderContainer.logger.info("Found a properties file. Attempting load...");
                props.load(new FileInputStream(fp));
                asmInterfaceRepair_verboseLog = props.getProperty("asmInterfaceRepair_verboseLog", "false").equalsIgnoreCase("true");
                TConstructLoaderContainer.logger.info("Loaded properties successfully. Using specified settings.");
            }
            catch (IOException ex) {
                throw new PropAccessException();
            }
        }
        try {
            if (!fp.createNewFile()) {
                throw new PropAccessException();
            }
            TConstructLoaderContainer.logger.info("Creating new properties file, as none found...");
            props.setProperty("asmInterfaceRepair_verboseLog", "false");
            props.store(new FileOutputStream(fp), null);
            TConstructLoaderContainer.logger.info("Created properties file; using defaults this run.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new PropAccessException();
        }
        return false;
    }

    public static class PropAccessException
    extends Exception {
    }
}

