/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.EnumArmorPart;
import tconstruct.library.tools.ToolMod;

public abstract class ArmorMod
extends ToolMod {
    protected final EnumSet<EnumArmorPart> armorTypes;

    public ArmorMod(int effect, String dataKey, EnumSet<EnumArmorPart> armorTypes, ItemStack[] items) {
        super(items, effect, dataKey);
        this.armorTypes = armorTypes;
    }

    @Override
    protected boolean canModify(ItemStack armor, ItemStack[] input) {
        ArmorCore item = (ArmorCore)armor.func_77973_b();
        if (this.armorTypes.contains((Object)item.armorPart)) {
            NBTTagCompound tags = armor.func_77978_p().func_74775_l(this.getTagName());
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    @Override
    protected String getTagName() {
        return "TinkerArmor";
    }

    public boolean validArmorType(ArmorCore armor) {
        return true;
    }

    public static NBTTagCompound getAttributeTag(String attributeType, String modifierName, double amount, boolean flat, UUID uuid) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("AttributeName", attributeType);
        tag.func_74778_a("Name", modifierName);
        tag.func_74780_a("Amount", amount);
        tag.func_74768_a("Operation", flat ? 0 : 1);
        tag.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
        return tag;
    }
}

