/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client.gui;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tconstruct.blocks.logic.CraftingStationLogic;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.tools.ToolCore;

public class CraftingStationGui
extends GuiContainer {
    public boolean active;
    public String toolName;
    public GuiTextField text;
    public String title;
    public String body = "";
    CraftingStationLogic logic;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/tinkertable.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    private static final ResourceLocation chest = new ResourceLocation("tinker", "textures/gui/chestside.png");

    public CraftingStationGui(InventoryPlayer inventory, CraftingStationLogic logic, World world, int x, int y, int z) {
        super(logic.getGuiContainer(inventory, world, x, y, z));
        this.logic = logic;
        this.title = "\u00a7n" + StatCollector.func_74838_a((String)"gui.toolforge1");
        this.body = StatCollector.func_74838_a((String)"gui.toolforge2");
        this.toolName = "";
    }

    protected void func_74189_g(int par1, int par2) {
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)(this.logic.tinkerTable ? "crafters.TinkerTable" : this.logic.func_70303_b())), 8, 6, 0x202020);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_74195_c - 96 + 2, 0x202020);
        if (this.logic.chest != null) {
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)((IInventory)this.logic.chest.get()).func_70303_b()), -108, this.field_74195_c - 160, 0x202020);
        }
        if (this.logic.tinkerTable) {
            if (this.logic.isStackInSlot(0)) {
                this.drawToolStats();
            } else {
                this.drawToolInformation();
            }
        }
    }

    void drawToolStats() {
        ItemStack stack = this.logic.func_70301_a(0);
        if (stack.func_77973_b() instanceof ToolCore) {
            ToolCore tool = (ToolCore)stack.func_77973_b();
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
            this.func_73732_a(this.field_73886_k, "\u00a7n" + tool.getToolName(), this.field_74194_b + 63, 8, 0xFFFFFF);
            this.drawModularToolStats(stack, tool, tags);
        } else if (stack.func_77973_b() instanceof ArmorCore) {
            ArmorCore armor = (ArmorCore)stack.func_77973_b();
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("TinkerArmor");
            this.func_73732_a(this.field_73886_k, "\u00a7n" + StatCollector.func_74838_a((String)("armortype." + armor.getArmorName())), this.field_74194_b + 63, 8, 0xFFFFFF);
            this.drawModularArmorStats(stack, armor, tags);
        }
    }

    void drawModularArmorStats(ItemStack stack, ArmorCore tool, NBTTagCompound tags) {
        int modifiers = tags.func_74762_e("Modifiers");
        int base = 24;
        int offset = 0;
        if (modifiers > 0) {
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation18") + tags.func_74762_e("Modifiers"), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                this.field_73886_k.func_78276_b("- " + tipName, this.field_74194_b + 8, base + (offset + tipNum) * 10, 0xFFFFFF);
                continue;
            }
            displayToolTips = false;
        }
    }

    void drawModularToolStats(ItemStack stack, ToolCore tool, NBTTagCompound tags) {
        DecimalFormat df;
        List<String> categories = Arrays.asList(tool.toolCategories());
        int durability = tags.func_74762_e("Damage");
        int maxDur = tags.func_74762_e("TotalDurability");
        int availableDurability = maxDur - durability;
        int base = 24;
        int offset = 0;
        if (maxDur > 0) {
            if (maxDur >= 10000) {
                this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation1"), this.field_74194_b + 8, base + offset * 11, 0xFFFFFF);
                this.field_73886_k.func_78276_b("- " + availableDurability + "/" + maxDur, this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
                ++offset;
            } else {
                this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation2") + availableDurability + "/" + maxDur, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
        }
        float stonebound = tags.func_74760_g("Shoddy");
        if (categories.contains("weapon")) {
            String heart;
            int attack = tags.func_74762_e("Attack") + 1;
            float stoneboundDamage = (float)Math.log((float)durability / 72.0f + 1.0f) * -2.0f * stonebound;
            attack = (int)((float)attack + stoneboundDamage);
            if ((attack = (int)((float)attack * tool.getDamageModifier())) < 1) {
                attack = 1;
            }
            String string = heart = attack == 2 ? StatCollector.func_74838_a((String)"gui.partcrafter8") : StatCollector.func_74838_a((String)"gui.partcrafter9");
            if (attack % 2 == 0) {
                this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation3") + attack / 2 + heart, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            } else {
                this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation3") + (float)attack / 2.0f + heart, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            }
            ++offset;
            if (stoneboundDamage != 0.0f) {
                df = new DecimalFormat("##.##");
                heart = stoneboundDamage == 2.0f ? StatCollector.func_74838_a((String)"gui.partcrafter8") : StatCollector.func_74838_a((String)"gui.partcrafter9");
                String bloss = stoneboundDamage > 0.0f ? StatCollector.func_74838_a((String)"gui.toolstation4") : StatCollector.func_74838_a((String)"gui.toolstation5");
                this.field_73886_k.func_78276_b(bloss + df.format(stoneboundDamage / 2.0f) + heart, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
            ++offset;
        }
        if (categories.contains("bow")) {
            DecimalFormat df2 = new DecimalFormat("##.##");
            df2.setRoundingMode(RoundingMode.DOWN);
            int drawSpeed = tags.func_74762_e("DrawSpeed");
            float flightSpeed = tags.func_74760_g("FlightSpeed");
            float trueDraw = (float)drawSpeed / 20.0f * flightSpeed;
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation6") + df2.format(trueDraw) + "s", this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation7") + df2.format(flightSpeed) + "x", this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        }
        if (categories.contains("ammo")) {
            String heart;
            DecimalFormat df3 = new DecimalFormat("##.##");
            df3.setRoundingMode(RoundingMode.DOWN);
            int attack = tags.func_74762_e("Attack");
            float mass = tags.func_74760_g("Mass");
            float shatter = tags.func_74760_g("BreakChance");
            float accuracy = tags.func_74760_g("Accuracy");
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation10"), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            String string = heart = attack == 2 ? StatCollector.func_74838_a((String)"gui.partcrafter8") : StatCollector.func_74838_a((String)"gui.partcrafter9");
            if (attack % 2 == 0) {
                this.field_73886_k.func_78276_b("- " + attack / 2 + heart, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            } else {
                this.field_73886_k.func_78276_b("- " + (float)attack / 2.0f + heart, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            }
            int minAttack = attack;
            int maxAttack = attack * 2;
            heart = StatCollector.func_74838_a((String)"gui.partcrafter9");
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation11"), this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b(df3.format((float)minAttack / 2.0f) + "-" + df3.format((float)maxAttack / 2.0f) + heart, this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation8") + df3.format(mass), this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation9") + df3.format(accuracy - 4.0f) + "%", this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        }
        if (categories.contains("dualharvest")) {
            float mineSpeed = (float)tags.func_74762_e("MiningSpeed") / 100.0f;
            float mineSpeed2 = (float)tags.func_74762_e("MiningSpeed2") / 100.0f;
            float stoneboundSpeed = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
            df = new DecimalFormat("##.##");
            df.setRoundingMode(RoundingMode.DOWN);
            float trueSpeed = mineSpeed + stoneboundSpeed;
            float trueSpeed2 = mineSpeed2 + stoneboundSpeed;
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation12"), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b("- " + df.format(trueSpeed) + ", " + df.format(trueSpeed2), this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            if (stoneboundSpeed != 0.0f) {
                String bloss = stoneboundSpeed > 0.0f ? StatCollector.func_74838_a((String)"gui.toolstation4") : StatCollector.func_74838_a((String)"gui.toolstation5");
                this.field_73886_k.func_78276_b(bloss + df.format(stoneboundSpeed), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation13"), this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b("- " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel")) + ", " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel2")), this.field_74194_b + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        } else if (categories.contains("harvest")) {
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            int heads = 1;
            if (tags.func_74764_b("MiningSpeed2")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
                ++heads;
            }
            float trueSpeed = mineSpeed / ((float)heads * 100.0f);
            float stoneboundSpeed = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
            DecimalFormat df4 = new DecimalFormat("##.##");
            df4.setRoundingMode(RoundingMode.DOWN);
            trueSpeed += stoneboundSpeed;
            if (trueSpeed < 0.0f) {
                trueSpeed = 0.0f;
            }
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation14") + df4.format(trueSpeed), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            if (stoneboundSpeed != 0.0f) {
                String bloss = stoneboundSpeed > 0.0f ? StatCollector.func_74838_a((String)"gui.toolstation4") : StatCollector.func_74838_a((String)"gui.toolstation5");
                this.field_73886_k.func_78276_b(bloss + df4.format(stoneboundSpeed), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation15") + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel")), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        } else if (categories.contains("utility")) {
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            float trueSpeed = mineSpeed / 100.0f;
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation16") + trueSpeed, this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        }
        int modifiers = tags.func_74762_e("Modifiers");
        if (modifiers > 0) {
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation18") + tags.func_74762_e("Modifiers"), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
        }
        if (tags.func_74764_b("Tooltip1")) {
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"gui.toolstation17"), this.field_74194_b + 8, base + offset * 10, 0xFFFFFF);
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                this.field_73886_k.func_78276_b("- " + tipName, this.field_74194_b + 8, base + (offset + tipNum) * 10, 0xFFFFFF);
                continue;
            }
            displayToolTips = false;
        }
    }

    protected String getHarvestLevelName(int num) {
        switch (num) {
            case 0: {
                return StatCollector.func_74838_a((String)"gui.partcrafter.mining1");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"gui.partcrafter.mining2");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"gui.partcrafter.mining3");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"gui.partcrafter.mining4");
            }
            case 4: {
                return StatCollector.func_74838_a((String)"gui.partcrafter.mining5");
            }
            case 5: {
                return StatCollector.func_74838_a((String)"gui.partcrafter.mining6");
            }
        }
        return String.valueOf(num);
    }

    void drawToolInformation() {
        this.func_73732_a(this.field_73886_k, this.title, this.field_74194_b + 63, 8, 0xFFFFFF);
        this.field_73886_k.func_78279_b(this.body, this.field_74194_b + 8, 24, 115, 0xFFFFFF);
    }

    protected void func_74185_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(background);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.field_74194_b, this.field_74195_c);
        if (this.active) {
            this.func_73729_b(cornerX + 62, cornerY, 0, this.field_74195_c, 112, 22);
        }
        this.field_73882_e.func_110434_K().func_110577_a(icons);
        if (this.logic.tinkerTable && !this.logic.isStackInSlot(5)) {
            this.func_73729_b(cornerX + 47, cornerY + 33, 0, 233, 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(icons);
        if (this.logic.chest != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73882_e.func_110434_K().func_110577_a(chest);
            if (this.logic.doubleChest == null) {
                this.func_73729_b(cornerX - 116, cornerY, 0, 0, 121, this.field_74195_c);
            } else {
                this.func_73729_b(cornerX - 116, cornerY, 125, 0, 122, this.field_74195_c + 21);
            }
        }
        if (this.logic.tinkerTable) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73882_e.func_110434_K().func_110577_a(description);
            cornerX = (this.field_73880_f + this.field_74194_b) / 2;
            cornerY = (this.field_73881_g - this.field_74195_c) / 2;
            this.func_73729_b(cornerX, cornerY, 0, 0, 126, this.field_74195_c + 30);
        }
    }
}

