/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.CastingBasinLogic;
import tconstruct.blocks.logic.CastingTableLogic;
import tconstruct.blocks.logic.FaucetLogic;
import tconstruct.client.block.SearedRender;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventoryBlock;
import tconstruct.library.tools.AbilityHelper;

public class SearedBlock
extends InventoryBlock {
    String texturePrefix = "";

    public SearedBlock(int id) {
        super(id, Material.field_76246_e);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(3.0f);
        this.func_71894_b(20.0f);
        this.func_71884_a(field_71977_i);
    }

    public SearedBlock(int id, String texture) {
        this(id);
        this.texturePrefix = texture;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new CastingTableLogic();
            }
            case 1: {
                return new FaucetLogic();
            }
            case 2: {
                return new CastingBasinLogic();
            }
        }
        return null;
    }

    public int func_71856_s_() {
        return 1;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return null;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        int md = world.func_72805_g(x, y, z);
        if (md == 0) {
            return this.activateCastingTable(world, x, y, z, player);
        }
        if (md == 2) {
            return this.activateCastingBasin(world, x, y, z, player);
        }
        if (md == 1) {
            if (player.func_70093_af()) {
                return false;
            }
            FaucetLogic logic = (FaucetLogic)world.func_72796_p(x, y, z);
            logic.setActive(true);
            return true;
        }
        return super.func_71903_a(world, x, y, z, player, side, clickX, clickY, clickZ);
    }

    boolean activateCastingTable(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack stack;
            CastingTableLogic logic = (CastingTableLogic)world.func_72796_p(x, y, z);
            if (logic.liquid != null) {
                return true;
            }
            if (!logic.isStackInSlot(0) && !logic.isStackInSlot(1)) {
                ItemStack stack2 = player.func_71045_bC();
                stack2 = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                logic.func_70299_a(0, stack2);
            } else if (logic.isStackInSlot(1)) {
                ItemStack stack3 = logic.func_70298_a(1, 1);
                if (stack3 != null) {
                    this.addItemToInventory(player, world, x, y, z, stack3);
                }
            } else if (logic.isStackInSlot(0) && (stack = logic.func_70298_a(0, 1)) != null) {
                this.addItemToInventory(player, world, x, y, z, stack);
            }
            world.func_72845_h(x, y, z);
        }
        return true;
    }

    boolean activateCastingBasin(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack stack;
            CastingBasinLogic logic = (CastingBasinLogic)world.func_72796_p(x, y, z);
            if (logic.liquid != null) {
                return true;
            }
            if (!logic.isStackInSlot(0) && !logic.isStackInSlot(1)) {
                ItemStack stack2 = player.func_71045_bC();
                stack2 = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                logic.func_70299_a(0, stack2);
            } else if (logic.isStackInSlot(1)) {
                ItemStack stack3 = logic.func_70298_a(1, 1);
                if (stack3 != null) {
                    this.addItemToInventory(player, world, x, y, z, stack3);
                }
            } else if (logic.isStackInSlot(0) && (stack = logic.func_70298_a(0, 1)) != null) {
                this.addItemToInventory(player, world, x, y, z, stack);
            }
            world.func_72845_h(x, y, z);
        }
        return true;
    }

    public void addItemToInventory(EntityPlayer player, World world, int x, int y, int z, ItemStack stack) {
        AbilityHelper.spawnItemAtPlayer(player, stack);
    }

    public int func_71857_b() {
        return SearedRender.searedModel;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"castingtable_top", "castingtable_side", "castingtable_bottom", "faucet", "blockcast_top", "blockcast_side", "blockcast_bottom"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 2) {
            return this.icons[this.getTextureIndex(side) + 4];
        }
        return this.icons[3];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71877_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != 1) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            FaucetLogic logic = (FaucetLogic)world.func_72796_p(x, y, z);
            float xMin = 0.25f;
            float xMax = 0.75f;
            float zMin = 0.25f;
            float zMax = 0.75f;
            switch (logic.getRenderDirection()) {
                case 2: {
                    zMin = 0.625f;
                    zMax = 1.0f;
                    break;
                }
                case 3: {
                    zMax = 0.375f;
                    zMin = 0.0f;
                    break;
                }
                case 4: {
                    xMin = 0.625f;
                    xMax = 1.0f;
                    break;
                }
                case 5: {
                    xMax = 0.375f;
                    xMin = 0.0f;
                }
            }
            this.func_71905_a(xMin, 0.25f, zMin, xMax, 0.625f, zMax);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != 1) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        FaucetLogic logic = (FaucetLogic)world.func_72796_p(x, y, z);
        if (logic != null) {
            float xMin = 0.25f;
            float xMax = 0.75f;
            float zMin = 0.25f;
            float zMax = 0.75f;
            switch (logic.getRenderDirection()) {
                case 2: {
                    zMin = 0.625f;
                    zMax = 1.0f;
                    break;
                }
                case 3: {
                    zMax = 0.375f;
                    zMin = 0.0f;
                    break;
                }
                case 4: {
                    xMin = 0.625f;
                    xMax = 1.0f;
                    break;
                }
                case 5: {
                    xMax = 0.375f;
                    xMin = 0.0f;
                }
            }
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + xMin), (double)y + 0.25, (double)((float)z + zMin), (double)((float)x + xMax), (double)y + 0.625, (double)((float)z + zMax));
        }
        return super.func_71872_e(world, x, y, z);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) == 1;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborBlockID) {
        if (world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == 1) {
            FaucetLogic logic = (FaucetLogic)world.func_72796_p(x, y, z);
            logic.setActive(true);
        }
    }
}

