/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.DryingRackLogic;
import tconstruct.client.block.DryingRackRender;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventoryBlock;
import tconstruct.library.tools.AbilityHelper;

public class DryingRack
extends InventoryBlock {
    public DryingRack(int id) {
        super(id, Material.field_76245_d);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71977_i);
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new DryingRackLogic();
    }

    public int func_71856_s_() {
        return 1;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return null;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        if (side > 1) {
            return side;
        }
        return meta;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        int l;
        int direction;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 && (direction = (l = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 2) == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        return this.activateDryingRack(world, x, y, z, player);
    }

    boolean activateDryingRack(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack decrStack;
            DryingRackLogic logic = (DryingRackLogic)world.func_72796_p(x, y, z);
            if (!logic.isStackInSlot(0)) {
                ItemStack stack = player.func_71045_bC();
                if (stack != null) {
                    stack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    logic.func_70299_a(0, stack);
                }
            } else if (logic.isStackInSlot(0) && (decrStack = logic.func_70298_a(0, 1)) != null) {
                this.addItemToInventory(player, world, x, y, z, decrStack);
            }
            world.func_72845_h(x, y, z);
        }
        return true;
    }

    public void addItemToInventory(EntityPlayer player, World world, int x, int y, int z, ItemStack stack) {
        AbilityHelper.spawnItemAtPlayer(player, stack);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        switch (metadata) {
            case 0: {
                zMin = 0.375f;
                yMax = 0.25f;
                zMax = 0.625f;
                break;
            }
            case 1: {
                xMin = 0.375f;
                yMax = 0.25f;
                xMax = 0.625f;
                break;
            }
            case 2: {
                zMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 3: {
                zMax = 0.25f;
                yMin = 0.75f;
                break;
            }
            case 4: {
                xMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 5: {
                xMax = 0.25f;
                yMin = 0.75f;
            }
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + (double)xMin, (double)y + (double)yMin, (double)z + (double)zMin, (double)x + (double)xMax, (double)y + (double)yMax, (double)z + (double)zMax);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        switch (metadata) {
            case 0: {
                zMin = 0.375f;
                yMax = 0.25f;
                zMax = 0.625f;
                break;
            }
            case 1: {
                xMin = 0.375f;
                yMax = 0.25f;
                xMax = 0.625f;
                break;
            }
            case 2: {
                zMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 3: {
                zMax = 0.25f;
                yMin = 0.75f;
                break;
            }
            case 4: {
                xMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 5: {
                xMax = 0.25f;
                yMin = 0.75f;
            }
        }
        this.func_71905_a(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        super.func_71871_a(world, x, y, z, aabb, list, entity);
    }

    public int func_71857_b() {
        return DryingRackRender.model;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"castingtable_top", "castingtable_side", "castingtable_bottom", "faucet", "blockcast_top", "blockcast_side", "blockcast_bottom"};
        return textureNames;
    }

    public Icon func_71858_a(int side, int meta) {
        return Block.field_71988_x.func_71858_a(side, 0);
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }
}

