/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.transmission.ElectricityDisplay;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiDropdown;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiTextBox;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerServer;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.mars.inventory.GCMarsContainerLaunchController;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GCMarsGuiLaunchController
extends GuiContainer
implements GCCoreGuiDropdown.IDropboxCallback,
GCCoreGuiTextBox.ITextBoxCallback,
GCCoreGuiCheckbox.ICheckBoxCallback {
    private static final ResourceLocation launchControllerGui = new ResourceLocation("galacticraftmars", "textures/gui/launchController.png");
    private GCMarsTileEntityLaunchController launchController;
    private GuiButton enableControllerButton;
    private GCCoreGuiCheckbox enablePadRemovalButton;
    private GCCoreGuiCheckbox launchWhenCheckbox;
    private GCCoreGuiDropdown dropdownTest;
    private GCCoreGuiTextBox frequency;
    private GCCoreGuiTextBox destinationFrequency;
    private int cannotEditTimer;

    public GCMarsGuiLaunchController(InventoryPlayer playerInventory, GCMarsTileEntityLaunchController launchController) {
        super((Container)new GCMarsContainerLaunchController(playerInventory, launchController));
        this.field_74195_c = 209;
        this.launchController = launchController;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (this.launchController.disableCooldown > 0) {
            this.enableControllerButton.field_73742_g = false;
            this.enablePadRemovalButton.field_73742_g = false;
        } else {
            this.enableControllerButton.field_73742_g = true;
            this.enablePadRemovalButton.field_73742_g = true;
        }
        this.enableControllerButton.field_73744_e = this.launchController.getDisabled(0) ? "Enable" : "Disable";
        super.func_73863_a(par1, par2, par3);
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.dropdownTest.func_73737_a(this.field_73882_e, par1, par2);
        GL11.glEnable((int)3553);
    }

    protected void func_73869_a(char keyChar, int keyID) {
        if (this.frequency.keyTyped(keyChar, keyID)) {
            return;
        }
        if (this.destinationFrequency.keyTyped(keyChar, keyID)) {
            return;
        }
        super.func_73869_a(keyChar, keyID);
    }

    public boolean isValid(String string) {
        if (string.length() > 0 && ChatAllowedCharacters.field_71568_a.indexOf(string.charAt(string.length() - 1)) >= 0) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.clear();
        int var5 = (this.field_73880_f - this.field_74194_b) / 2;
        int var6 = (this.field_73881_g - this.field_74195_c) / 2;
        this.enableControllerButton = new GuiButton(0, var5 + 70 + 124 - 72, var6 + 16, 48, 20, "Enable");
        this.enablePadRemovalButton = new GCCoreGuiCheckbox(1, (GCCoreGuiCheckbox.ICheckBoxCallback)this, this.field_73880_f / 2 - 78, var6 + 59, "Remove Pad");
        this.launchWhenCheckbox = new GCCoreGuiCheckbox(2, (GCCoreGuiCheckbox.ICheckBoxCallback)this, this.field_73880_f / 2 - 78, var6 + 77, "Launch when: ");
        this.dropdownTest = new GCCoreGuiDropdown(3, (GCCoreGuiDropdown.IDropboxCallback)this, var5 + 95, var6 + 77, new String[]{EntityAutoRocket.EnumAutoLaunch.CARGO_IS_UNLOADED.getTitle(), EntityAutoRocket.EnumAutoLaunch.CARGO_IS_FULL.getTitle(), EntityAutoRocket.EnumAutoLaunch.ROCKET_IS_FUELED.getTitle(), EntityAutoRocket.EnumAutoLaunch.INSTANT.getTitle(), EntityAutoRocket.EnumAutoLaunch.TIME_10_SECONDS.getTitle(), EntityAutoRocket.EnumAutoLaunch.TIME_30_SECONDS.getTitle(), EntityAutoRocket.EnumAutoLaunch.TIME_1_MINUTE.getTitle(), EntityAutoRocket.EnumAutoLaunch.REDSTONE_SIGNAL.getTitle()});
        this.frequency = new GCCoreGuiTextBox(4, (GCCoreGuiTextBox.ITextBoxCallback)this, var5 + 66, var6 + 16, 48, 20, "", true, 6);
        this.destinationFrequency = new GCCoreGuiTextBox(5, (GCCoreGuiTextBox.ITextBoxCallback)this, var5 + 122, var6 + 16 + 22, 48, 20, "", true, 6);
        this.field_73887_h.add(this.enableControllerButton);
        this.field_73887_h.add(this.enablePadRemovalButton);
        this.field_73887_h.add(this.launchWhenCheckbox);
        this.field_73887_h.add(this.dropdownTest);
        this.field_73887_h.add(this.frequency);
        this.field_73887_h.add(this.destinationFrequency);
    }

    protected void func_73864_a(int px, int py, int par3) {
        super.func_73864_a(px, py, par3);
    }

    protected void func_73875_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_73742_g) {
            switch (par1GuiButton.field_73741_f) {
                case 0: {
                    PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftCore", (GCCorePacketHandlerServer.EnumPacketServer)GCCorePacketHandlerServer.EnumPacketServer.UPDATE_DISABLEABLE_BUTTON, (Object[])new Object[]{this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, 0}));
                    break;
                }
                case 1: {
                    PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftCore", (GCCorePacketHandlerServer.EnumPacketServer)GCCorePacketHandlerServer.EnumPacketServer.UPDATE_DISABLEABLE_BUTTON, (Object[])new Object[]{this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, 1}));
                    break;
                }
                default: {
                    PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftCore", (GCCorePacketHandlerServer.EnumPacketServer)GCCorePacketHandlerServer.EnumPacketServer.UPDATE_DISABLEABLE_BUTTON, (Object[])new Object[]{this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, 1}));
                }
            }
        }
    }

    protected void func_74189_g(int par1, int par2) {
        String displayString = this.launchController.getOwnerName() + "'s " + this.launchController.func_70303_b();
        this.field_73886_k.func_78276_b(displayString, this.field_74194_b / 2 - this.field_73886_k.func_78256_a(displayString) / 2, 5, 0x404040);
        if (this.cannotEditTimer > 0) {
            this.field_73886_k.func_78276_b(this.launchController.getOwnerName(), this.field_74194_b / 2 - this.field_73886_k.func_78256_a(displayString) / 2, 5, this.cannotEditTimer % 30 < 15 ? GCCoreUtil.convertTo32BitColor((int)255, (int)255, (int)100, (int)100) : 0x404040);
            --this.cannotEditTimer;
        }
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, 115, 0x404040);
        displayString = this.getStatus();
        this.field_73886_k.func_78279_b(displayString, 60 - this.field_73886_k.func_78256_a(displayString) / 2, 94, 60, 0x404040);
        displayString = ElectricityDisplay.getDisplay((float)(this.launchController.ueWattsPerTick * 20.0f), (ElectricityDisplay.ElectricUnit)ElectricityDisplay.ElectricUnit.WATT);
        this.field_73886_k.func_78276_b(displayString, this.field_74194_b - 26 - this.field_73886_k.func_78256_a(displayString), 94, 0x404040);
        displayString = ElectricityDisplay.getDisplay((float)this.launchController.getVoltage(), (ElectricityDisplay.ElectricUnit)ElectricityDisplay.ElectricUnit.VOLTAGE);
        this.field_73886_k.func_78276_b(displayString, this.field_74194_b - 26 - this.field_73886_k.func_78256_a(displayString), 104, 0x404040);
        this.field_73886_k.func_78276_b("Frequency:", 7, 22, 0x404040);
        this.field_73886_k.func_78276_b("Destination Frequency:", 7, 44, 0x404040);
    }

    private String getStatus() {
        if (!this.launchController.frequencyValid) {
            return EnumColor.RED + "Invalid Frequency";
        }
        if (this.launchController.getEnergyStored() <= 0.0f) {
            return EnumColor.RED + "Not Enough Energy";
        }
        if (this.launchController.getDisabled(0)) {
            return EnumColor.ORANGE + "Disabled";
        }
        return EnumColor.BRIGHT_GREEN + "Active";
    }

    protected void func_74185_a(float par1, int par2, int par3) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(launchControllerGui);
        int var5 = (this.field_73880_f - this.field_74194_b) / 2;
        int var6 = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_74194_b, this.field_74195_c);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.launchController.getEnergyStored() > 0.0f) {
            int scale = this.launchController.getScaledElecticalLevel(54);
            this.func_73729_b(var5 + 99, var6 + 114, 176, 0, Math.min(scale, 54), 7);
        }
        GL11.glPopMatrix();
    }

    public boolean canBeClickedBy(GCCoreGuiDropdown dropdown, EntityPlayer player) {
        if (dropdown.equals(this.dropdownTest)) {
            return player.field_71092_bJ.equals(this.launchController.getOwnerName());
        }
        return false;
    }

    public void onSelectionChanged(GCCoreGuiDropdown dropdown, int selection) {
        if (dropdown.equals(this.dropdownTest)) {
            this.launchController.launchDropdownSelection = selection;
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftMars", (int)5, (Object[])new Object[]{1, this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, this.launchController.launchDropdownSelection}));
        }
    }

    public int getInitialSelection(GCCoreGuiDropdown dropdown) {
        if (dropdown.equals(this.dropdownTest)) {
            return this.launchController.launchDropdownSelection;
        }
        return 0;
    }

    public boolean canPlayerEdit(GCCoreGuiTextBox textBox, EntityPlayer player) {
        return player.field_71092_bJ.equals(this.launchController.getOwnerName());
    }

    public void onTextChanged(GCCoreGuiTextBox textBox, String newText) {
        if (textBox.equals(this.frequency)) {
            this.launchController.frequency = textBox.getIntegerValue();
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftMars", (int)5, (Object[])new Object[]{0, this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, this.launchController.frequency}));
        } else if (textBox.equals(this.destinationFrequency)) {
            this.launchController.destFrequency = textBox.getIntegerValue();
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftMars", (int)5, (Object[])new Object[]{2, this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, this.launchController.destFrequency}));
        }
    }

    public String getInitialText(GCCoreGuiTextBox textBox) {
        if (textBox.equals(this.frequency)) {
            return String.valueOf(this.launchController.frequency);
        }
        if (textBox.equals(this.destinationFrequency)) {
            return String.valueOf(this.launchController.destFrequency);
        }
        return "";
    }

    public int getTextColor(GCCoreGuiTextBox textBox) {
        if (textBox.equals(this.frequency)) {
            return this.launchController.frequencyValid ? GCCoreUtil.convertTo32BitColor((int)255, (int)20, (int)20, (int)255) : GCCoreUtil.convertTo32BitColor((int)255, (int)255, (int)25, (int)25);
        }
        if (textBox.equals(this.destinationFrequency)) {
            return this.launchController.destFrequencyValid ? GCCoreUtil.convertTo32BitColor((int)255, (int)20, (int)20, (int)255) : GCCoreUtil.convertTo32BitColor((int)255, (int)255, (int)25, (int)25);
        }
        return 0;
    }

    public void onSelectionChanged(GCCoreGuiCheckbox checkbox, boolean newSelected) {
        if (checkbox.equals(this.enablePadRemovalButton)) {
            this.launchController.launchPadRemovalDisabled = !newSelected;
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftMars", (int)5, (Object[])new Object[]{3, this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, this.launchController.launchPadRemovalDisabled ? 1 : 0}));
        } else if (checkbox.equals(this.launchWhenCheckbox)) {
            this.launchController.launchSchedulingEnabled = newSelected;
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftMars", (int)5, (Object[])new Object[]{4, this.launchController.field_70329_l, this.launchController.field_70330_m, this.launchController.field_70327_n, this.launchController.launchSchedulingEnabled ? 1 : 0}));
        }
    }

    public boolean canPlayerEdit(GCCoreGuiCheckbox checkbox, EntityPlayer player) {
        return player.field_71092_bJ.equals(this.launchController.getOwnerName());
    }

    public boolean getInitiallySelected(GCCoreGuiCheckbox checkbox) {
        if (checkbox.equals(this.enablePadRemovalButton)) {
            return !this.launchController.launchPadRemovalDisabled;
        }
        if (checkbox.equals(this.launchWhenCheckbox)) {
            return this.launchController.launchSchedulingEnabled;
        }
        return false;
    }

    public void onIntruderInteraction() {
        this.cannotEditTimer = 50;
    }
}

