/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.client.GCCoreCloudRenderer;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderOxygenBubble;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderSpaceship;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererKey;
import micdoodle8.mods.galacticraft.core.client.sounds.GCCoreSoundUpdaterSpaceship;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.mars.CommonProxyMars;
import micdoodle8.mods.galacticraft.mars.GCMarsConfigManager;
import micdoodle8.mods.galacticraft.mars.blocks.GCMarsBlocks;
import micdoodle8.mods.galacticraft.mars.client.GCMarsSkyProvider;
import micdoodle8.mods.galacticraft.mars.client.fx.GCMarsEntityDropParticleFX;
import micdoodle8.mods.galacticraft.mars.client.gui.GCMarsGuiCargoRocket;
import micdoodle8.mods.galacticraft.mars.client.gui.GCMarsGuiLaunchController;
import micdoodle8.mods.galacticraft.mars.client.gui.GCMarsGuiSlimeling;
import micdoodle8.mods.galacticraft.mars.client.gui.GCMarsGuiSlimelingFeed;
import micdoodle8.mods.galacticraft.mars.client.gui.GCMarsGuiSlimelingInventory;
import micdoodle8.mods.galacticraft.mars.client.gui.GCMarsGuiTerraformer;
import micdoodle8.mods.galacticraft.mars.client.model.GCMarsModelSpaceshipTier2;
import micdoodle8.mods.galacticraft.mars.client.render.block.GCMarsBlockRendererMachine;
import micdoodle8.mods.galacticraft.mars.client.render.block.GCMarsBlockRendererRock;
import micdoodle8.mods.galacticraft.mars.client.render.block.GCMarsBlockRendererTintedGlassPane;
import micdoodle8.mods.galacticraft.mars.client.render.block.GCMarsBlockRendererTreasureChest;
import micdoodle8.mods.galacticraft.mars.client.render.block.GCMarsBlockRendererVine;
import micdoodle8.mods.galacticraft.mars.client.render.entity.GCMarsRenderCargoRocket;
import micdoodle8.mods.galacticraft.mars.client.render.entity.GCMarsRenderCreeperBoss;
import micdoodle8.mods.galacticraft.mars.client.render.entity.GCMarsRenderLandingBalloons;
import micdoodle8.mods.galacticraft.mars.client.render.entity.GCMarsRenderProjectileTNT;
import micdoodle8.mods.galacticraft.mars.client.render.entity.GCMarsRenderSlimeling;
import micdoodle8.mods.galacticraft.mars.client.render.entity.GCMarsRenderSludgeling;
import micdoodle8.mods.galacticraft.mars.client.render.item.GCMarsItemRendererMachine;
import micdoodle8.mods.galacticraft.mars.client.render.item.GCMarsItemRendererSpaceshipT2;
import micdoodle8.mods.galacticraft.mars.client.render.tile.GCMarsTileEntityCryogenicChamberRenderer;
import micdoodle8.mods.galacticraft.mars.client.render.tile.GCMarsTileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.mars.dimension.GCMarsWorldProvider;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityCargoRocket;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityCreeperBoss;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityLandingBalloons;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityProjectileTNT;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityRocketT2;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntitySlimeling;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntitySludgeling;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityTerraformBubble;
import micdoodle8.mods.galacticraft.mars.items.GCMarsItems;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityTerraformer;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityTreasureChest;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;

public class ClientProxyMars
extends CommonProxyMars {
    private static int vineRenderID;
    private static int eggRenderID;
    private static int treasureRenderID;
    private static int machineRenderID;
    private static int tintedGlassRenderID;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerClient(), (Side)Side.CLIENT);
        NetworkRegistry.instance().registerChannel((IPacketHandler)new ClientPacketHandler(), "GalacticraftMars", Side.CLIENT);
        vineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCMarsBlockRendererVine(vineRenderID));
        eggRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCMarsBlockRendererRock(eggRenderID));
        treasureRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCMarsBlockRendererTreasureChest(treasureRenderID));
        machineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCMarsBlockRendererMachine(machineRenderID));
        tintedGlassRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCMarsBlockRendererTintedGlassPane(tintedGlassRenderID));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public void registerRenderInformation() {
        IModelCustom chamberModel = AdvancedModelLoader.loadModel((String)"/assets/galacticraftmars/models/chamber.obj");
        IModelCustom cargoRocketModel = AdvancedModelLoader.loadModel((String)"/assets/galacticraftmars/models/cargoRocket.obj");
        ClientRegistry.bindTileEntitySpecialRenderer(GCMarsTileEntityTreasureChest.class, (TileEntitySpecialRenderer)new GCMarsTileEntityTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(GCMarsTileEntityCryogenicChamber.class, (TileEntitySpecialRenderer)new GCMarsTileEntityCryogenicChamberRenderer(chamberModel));
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntitySludgeling.class, (Render)new GCMarsRenderSludgeling());
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntitySlimeling.class, (Render)new GCMarsRenderSlimeling());
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityCreeperBoss.class, (Render)new GCMarsRenderCreeperBoss());
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityRocketT2.class, (Render)new GCCoreRenderSpaceship((ModelBase)new GCMarsModelSpaceshipTier2(), "galacticraftmars", "rocketT2"));
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityTerraformBubble.class, (Render)new GCCoreRenderOxygenBubble(0.25f, 1.0f, 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityProjectileTNT.class, (Render)new GCMarsRenderProjectileTNT());
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityLandingBalloons.class, (Render)new GCMarsRenderLandingBalloons());
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityLandingBalloons.class, (Render)new GCMarsRenderLandingBalloons());
        RenderingRegistry.registerEntityRenderingHandler(GCMarsEntityCargoRocket.class, (Render)new GCMarsRenderCargoRocket(cargoRocketModel));
        RenderingRegistry.addNewArmourRendererPrefix((String)"desh");
        MinecraftForgeClient.registerItemRenderer((int)GCMarsItems.spaceship.field_77779_bT, (IItemRenderer)new GCMarsItemRendererSpaceshipT2(cargoRocketModel));
        MinecraftForgeClient.registerItemRenderer((int)GCMarsItems.key.field_77779_bT, (IItemRenderer)new GCCoreItemRendererKey(new ResourceLocation("galacticraftmars", "textures/model/treasure.png")));
        MinecraftForgeClient.registerItemRenderer((int)GCMarsBlocks.machine.field_71990_ca, (IItemRenderer)new GCMarsItemRendererMachine(chamberModel));
    }

    @Override
    public int getVineRenderID() {
        return vineRenderID;
    }

    @Override
    public int getEggRenderID() {
        return eggRenderID;
    }

    @Override
    public int getTreasureRenderID() {
        return treasureRenderID;
    }

    @Override
    public int getMachineRenderID() {
        return machineRenderID;
    }

    @Override
    public int getTintedGlassPaneRenderID() {
        return tintedGlassRenderID;
    }

    @Override
    public void spawnParticle(String var1, double var2, double var4, double var6) {
        Minecraft var14 = FMLClientHandler.instance().getClient();
        if (var14 != null && var14.field_71451_h != null && var14.field_71452_i != null) {
            double var15 = var14.field_71451_h.field_70165_t - var2;
            double var17 = var14.field_71451_h.field_70163_u - var4;
            double var19 = var14.field_71451_h.field_70161_v - var6;
            GCMarsEntityDropParticleFX var21 = null;
            double var22 = 64.0;
            if (var15 * var15 + var17 * var17 + var19 * var19 < 4096.0 && var1.equals("sludgeDrip")) {
                var21 = new GCMarsEntityDropParticleFX((World)var14.field_71441_e, var2, var4, var6, GCMarsBlocks.bacterialSludge);
            }
            if (var21 != null) {
                ((EntityFX)var21).field_70169_q = ((EntityFX)var21).field_70165_t;
                ((EntityFX)var21).field_70167_r = ((EntityFX)var21).field_70163_u;
                ((EntityFX)var21).field_70166_s = ((EntityFX)var21).field_70161_v;
                var14.field_71452_i.func_78873_a((EntityFX)var21);
            }
        }
    }

    public static boolean handleBacterialMovement(EntityPlayer player) {
        return player.field_70170_p.func_72875_a(player.field_70121_D.func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), GCMarsBlocks.bacterialSludge);
    }

    public static boolean handleLavaMovement(EntityPlayer player) {
        return player.field_70170_p.func_72875_a(player.field_70121_D.func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_76256_h);
    }

    public static boolean handleWaterMovement(EntityPlayer player) {
        return player.field_70170_p.func_72875_a(player.field_70121_D.func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_76244_g);
    }

    public static boolean handleLiquidMovement(EntityPlayer player) {
        return ClientProxyMars.handleBacterialMovement(player) || ClientProxyMars.handleLavaMovement(player) || ClientProxyMars.handleWaterMovement(player);
    }

    @Override
    public void opengSlimelingGui(GCMarsEntitySlimeling slimeling, int gui) {
        switch (gui) {
            case 0: {
                FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCMarsGuiSlimeling(slimeling));
                break;
            }
            case 1: {
                FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCMarsGuiSlimelingFeed(slimeling));
            }
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (ID == GCMarsConfigManager.idGuiMachine) {
            if (tile instanceof GCMarsTileEntityTerraformer) {
                return new GCMarsGuiTerraformer(player.field_71071_by, (GCMarsTileEntityTerraformer)tile);
            }
            if (tile instanceof GCMarsTileEntityLaunchController) {
                return new GCMarsGuiLaunchController(player.field_71071_by, (GCMarsTileEntityLaunchController)tile);
            }
        }
        return null;
    }

    public static class TickHandlerClient
    implements ITickHandler {
        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            Minecraft minecraft = FMLClientHandler.instance().getClient();
            WorldClient world = minecraft.field_71441_e;
            if (type.equals(EnumSet.of(TickType.CLIENT)) && world != null) {
                if (world.field_73011_w instanceof GCMarsWorldProvider) {
                    if (world.field_73011_w.getSkyRenderer() == null) {
                        world.field_73011_w.setSkyRenderer((IRenderHandler)new GCMarsSkyProvider());
                    }
                    if (world.field_73011_w.getCloudRenderer() == null) {
                        world.field_73011_w.setCloudRenderer((IRenderHandler)new GCCoreCloudRenderer());
                    }
                }
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    Object eship;
                    Entity e = (Entity)world.field_72996_f.get(i);
                    if (e == null) continue;
                    if (e instanceof GCMarsEntityRocketT2) {
                        eship = (GCMarsEntityRocketT2)e;
                        if (eship.rocketSoundUpdater != null) continue;
                        eship.rocketSoundUpdater = new GCCoreSoundUpdaterSpaceship(FMLClientHandler.instance().getClient().field_71416_A, (EntitySpaceshipBase)eship, (EntityPlayerSP)FMLClientHandler.instance().getClient().field_71439_g);
                        continue;
                    }
                    if (!(e instanceof GCMarsEntityCargoRocket)) continue;
                    eship = (GCMarsEntityCargoRocket)e;
                    if (((GCMarsEntityCargoRocket)((Object)eship)).rocketSoundUpdater != null) continue;
                    ((GCMarsEntityCargoRocket)((Object)eship)).rocketSoundUpdater = new GCCoreSoundUpdaterSpaceship(FMLClientHandler.instance().getClient().field_71416_A, (EntitySpaceshipBase)eship, (EntityPlayerSP)FMLClientHandler.instance().getClient().field_71439_g);
                }
            }
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        }

        public String getLabel() {
            return "Galacticraft Mars Client";
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.CLIENT);
        }
    }

    public class ClientPacketHandler
    implements IPacketHandler {
        public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player p) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
            int packetType = PacketUtil.readPacketID((DataInputStream)data);
            EntityPlayer player = (EntityPlayer)p;
            if (packetType == 0) {
                Class[] decodeAs = new Class[]{Integer.class, Integer.class, Integer.class};
                Object[] packetReadout = PacketUtil.readPacketData((DataInputStream)data, (Class[])decodeAs);
                int entityID = 0;
                Entity entity = null;
                switch ((Integer)packetReadout[1]) {
                    case 0: {
                        entityID = (Integer)packetReadout[2];
                        entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof GCMarsEntitySlimeling) {
                            FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCMarsGuiSlimelingInventory(player, (GCMarsEntitySlimeling)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)packetReadout[0];
                        break;
                    }
                    case 1: {
                        entityID = (Integer)packetReadout[2];
                        entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof GCMarsEntityCargoRocket) {
                            FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCMarsGuiCargoRocket((IInventory)player.field_71071_by, (GCMarsEntityCargoRocket)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)packetReadout[0];
                    }
                }
            }
        }
    }
}

