/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.inventory;

import cofh.util.inventory.ComparableItemStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStackSafe
extends ComparableItemStack {
    static final String BLOCK = "block";
    static final String ORE = "ore";
    static final String DUST = "dust";
    static final String INGOT = "ingot";
    static final String NUGGET = "nugget";

    public static boolean safeOreType(String oreName) {
        return oreName.startsWith(BLOCK) || oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(INGOT) || oreName.startsWith(NUGGET);
    }

    public static int getOreID(ItemStack stack) {
        int id = OreDictionary.getOreID((ItemStack)stack);
        if (id == -1 || !ComparableItemStackSafe.safeOreType(OreDictionary.getOreName((int)id))) {
            return -1;
        }
        return id;
    }

    public static int getOreID(String oreName) {
        if (!ComparableItemStackSafe.safeOreType(oreName)) {
            return -1;
        }
        return OreDictionary.getOreID((String)oreName);
    }

    public ComparableItemStackSafe(ItemStack stack) {
        super(stack);
        this.oreID = ComparableItemStackSafe.getOreID(stack);
    }

    public ComparableItemStackSafe(int itemID, int damage, int stackSize) {
        super(itemID, damage, stackSize);
        this.oreID = ComparableItemStackSafe.getOreID(this.toItemStack());
    }

    @Override
    public ComparableItemStackSafe set(ItemStack stack) {
        super.set(stack);
        this.oreID = ComparableItemStackSafe.getOreID(stack);
        return this;
    }
}

