/*
 * Decompiled with CFR 0.152.
 */
package cofh.network;

import cofh.CoFHCore;
import cofh.network.PacketHandler;
import cofh.util.FluidHelper;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class Payload {
    private ByteArrayOutputStream arrayout;
    private DataOutputStream dataout;
    public DataInputStream datain;
    private int subID;

    private Payload(int subID) {
        this.subID = subID;
        this.arrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.arrayout);
    }

    public Payload(byte[] data) {
        this.datain = new DataInputStream(new ByteArrayInputStream(data));
    }

    public Packet getPacket() {
        return PacketDispatcher.getTinyPacket((Object)CoFHCore.instance, (short)((short)this.subID), (byte[])this.arrayout.toByteArray());
    }

    public Payload addString(String theString) {
        try {
            this.dataout.writeUTF(theString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addInt(int theInteger) {
        try {
            this.dataout.writeInt(theInteger);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addBool(boolean theBoolean) {
        try {
            this.dataout.writeBoolean(theBoolean);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addByte(byte theByte) {
        try {
            this.dataout.writeByte(theByte);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addByte(int theByte) {
        return this.addByte((byte)theByte);
    }

    public Payload addByteArray(byte[] theByteArray) {
        try {
            this.dataout.write(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addFloat(float theFloat) {
        try {
            this.dataout.writeFloat(theFloat);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addItemStack(ItemStack theStack) {
        try {
            Packet.func_73270_a((ItemStack)theStack, (DataOutput)this.dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addFluidStack(FluidStack theStack) {
        try {
            FluidHelper.writeFluidStackToPacket(theStack, this.dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Payload addCoords(TileEntity theTile) {
        this.addInt(theTile.field_70329_l);
        this.addInt(theTile.field_70330_m);
        return this.addInt(theTile.field_70327_n);
    }

    public Payload addCoords(int x, int y, int z) {
        this.addInt(x);
        this.addInt(y);
        return this.addInt(z);
    }

    public String getString() {
        try {
            return this.datain.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean getBool() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte getByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void getByteArray(byte[] theByteArray) {
        try {
            this.datain.readFully(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public float getFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public ItemStack getItemStack() {
        try {
            return Packet.func_73276_c((DataInput)this.datain);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FluidStack getFluidStack() {
        try {
            return FluidHelper.readFluidStackFromPacket(this.datain);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int[] getCoords() {
        return new int[]{this.getInt(), this.getInt(), this.getInt()};
    }

    public static Packet getPacket(int packetId, ByteArrayOutputStream data) {
        return PacketDispatcher.getTinyPacket((Object)CoFHCore.instance, (short)((short)packetId), (byte[])data.toByteArray());
    }

    public static Payload getDescriptionPayload(TileEntity tile) {
        return new Payload(PacketHandler.PACKET_TILE).addCoords(tile);
    }

    public static Payload getInfoPayload(TileEntity tile) {
        return new Payload(PacketHandler.PACKET_TILE_INFO).addCoords(tile);
    }

    public static Payload getPayload(int packetId) {
        return new Payload(packetId);
    }
}

