/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import cofh.api.tileentity.IRedstoneControl;
import cofh.gui.GuiBase;
import cofh.gui.element.TabBase;
import cofh.util.StringHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class TabRedstone
extends TabBase {
    public static final String[] TOOLTIPS = new String[]{StringHelper.localize("info.cofh.redstoneStateIgnored"), StringHelper.localize("info.cofh.redstoneStateLow"), StringHelper.localize("info.cofh.redstoneStateHigh")};
    IRedstoneControl myTile;
    int headerColor = 14797103;
    int subheaderColor = 11186104;
    int textColor = 0;

    public TabRedstone(GuiBase gui, IRedstoneControl theTile) {
        super(gui);
        this.myTile = theTile;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.backgroundColor = 13640458;
    }

    @Override
    public void draw() {
        this.drawBackground();
        this.drawTabIcon("IconRedstone");
        if (!this.isFullyOpened()) {
            return;
        }
        elementFontRenderer.func_78261_a(StringHelper.localize("info.cofh.redstoneControl"), this.posX + 20, this.posY + 6, this.headerColor);
        elementFontRenderer.func_78261_a(StringHelper.localize("info.cofh.controlStatus") + ":", this.posX + 8, this.posY + 42, this.subheaderColor);
        elementFontRenderer.func_78261_a(StringHelper.localize("info.cofh.signalRequired") + ":", this.posX + 8, this.posY + 66, this.subheaderColor);
        if (this.myTile.getControlDisable()) {
            this.gui.drawButton("IconGunpowder", this.posX + 28, this.posY + 20, 1, 1);
            this.gui.drawButton("IconRSTorchOff", this.posX + 48, this.posY + 20, 1, 0);
            this.gui.drawButton("IconRSTorchOn", this.posX + 68, this.posY + 20, 1, 0);
            elementFontRenderer.func_78276_b(StringHelper.localize("info.cofh.redstoneControlOff"), this.posX + 16, this.posY + 54, this.textColor);
            elementFontRenderer.func_78276_b(TOOLTIPS[0], this.posX + 16, this.posY + 78, this.textColor);
        } else {
            elementFontRenderer.func_78276_b(StringHelper.localize("info.cofh.redstoneControlOn"), this.posX + 16, this.posY + 54, this.textColor);
            if (this.myTile.getControlSetting()) {
                this.gui.drawButton("IconRedstone", this.posX + 28, this.posY + 20, 1, 0);
                this.gui.drawButton("IconRSTorchOff", this.posX + 48, this.posY + 20, 1, 0);
                this.gui.drawButton("IconRSTorchOn", this.posX + 68, this.posY + 20, 1, 1);
                elementFontRenderer.func_78276_b(TOOLTIPS[2], this.posX + 16, this.posY + 78, this.textColor);
            } else {
                this.gui.drawButton("IconRedstone", this.posX + 28, this.posY + 20, 1, 0);
                this.gui.drawButton("IconRSTorchOff", this.posX + 48, this.posY + 20, 1, 1);
                this.gui.drawButton("IconRSTorchOn", this.posX + 68, this.posY + 20, 1, 0);
                elementFontRenderer.func_78276_b(TOOLTIPS[1], this.posX + 16, this.posY + 78, this.textColor);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            if (this.myTile.getControlDisable()) {
                list.add(StringHelper.localize("info.cofh.redstoneControlOff"));
                return;
            }
            if (this.myTile.getControlSetting()) {
                list.add(StringHelper.localize("info.cofh.redstoneControlOn") + ", " + StringHelper.localize("info.cofh.redstoneStateHigh"));
                return;
            }
            list.add(StringHelper.localize("info.cofh.redstoneControlOn") + ", " + StringHelper.localize("info.cofh.redstoneStateLow"));
        }
        int x = this.gui.getMouseX() - this.currentShiftX;
        int y = this.gui.getMouseY() - this.currentShiftY;
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            list.add(TOOLTIPS[0]);
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            list.add(TOOLTIPS[1]);
        } else if (68 <= x && x < 84 && 20 <= y && y < 36) {
            list.add(TOOLTIPS[2]);
        }
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if ((x -= this.currentShiftX) < 24 || x >= 88 || (y -= this.currentShiftY) < 16 || y >= 40) {
            return false;
        }
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            if (!this.myTile.getControlDisable()) {
                this.myTile.setRedstoneConfig(true, false);
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.4f);
            }
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            if (this.myTile.getControlDisable() || this.myTile.getControlSetting()) {
                this.myTile.setRedstoneConfig(false, false);
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.6f);
            }
        } else if (68 <= x && x < 84 && 20 <= y && y < 36 && (this.myTile.getControlDisable() || !this.myTile.getControlSetting())) {
            this.myTile.setRedstoneConfig(false, true);
            elementSoundManager.func_77366_a("random.click", 1.0f, 0.8f);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX + 24, this.posY + 16, 16, 20, 64, 24);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

