/*
 * Decompiled with CFR 0.152.
 */
package cofh.block;

import cofh.api.block.IBlockDebug;
import cofh.api.block.IBlockInfo;
import cofh.api.block.IDismantleable;
import cofh.api.core.IInitializer;
import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ISecureTile;
import cofh.block.ITileDebug;
import cofh.block.ITileInfo;
import cofh.block.TileCoFHBase;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ForgeHooks;

public abstract class BlockCoFHBase
extends BlockContainer
implements IBlockDebug,
IBlockInfo,
IDismantleable,
IInitializer {
    public static int renderPass = 0;
    public static byte secureAccess = 0;
    public static String secureOwner = "[None]";

    public BlockCoFHBase(int id, Material material) {
        super(id, material);
        this.func_71884_a(field_71976_h);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ISecureTile && CoreUtils.isPlayer((EntityPlayer)living)) {
            ((ISecureTile)tile).setOwnerName(((EntityPlayer)living).field_71092_bJ);
        }
        if (tile instanceof IReconfigurableFacing) {
            IReconfigurableFacing reconfig = (IReconfigurableFacing)tile;
            int quadrant = MathHelper.floor((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
            if (reconfig.allowYAxisFacing()) {
                quadrant = living.field_70125_A > 60.0f ? 4 : (living.field_70125_A < -60.0f ? 5 : quadrant);
            }
            switch (quadrant) {
                case 0: {
                    reconfig.setFacing(2);
                    return;
                }
                case 1: {
                    reconfig.setFacing(5);
                    return;
                }
                case 2: {
                    reconfig.setFacing(3);
                    return;
                }
                case 3: {
                    reconfig.setFacing(4);
                    return;
                }
                case 4: {
                    reconfig.setFacing(1);
                    return;
                }
                case 5: {
                    reconfig.setFacing(0);
                    return;
                }
            }
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int bId) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileCoFHBase) {
            ((TileCoFHBase)tile).onNeighborBlockChange();
        }
    }

    public void onNeighborTileChange(World world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileCoFHBase) {
            ((TileCoFHBase)tile).onNeighborTileChange(tileX, tileY, tileZ);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (y <= 0) {
            return 0;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileCoFHBase && tile.field_70331_k != null) {
            return ((TileCoFHBase)tile).getLightValue();
        }
        return 0;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        return tile instanceof IReconfigurableFacing ? ((IReconfigurableFacing)tile).rotateBlock() : false;
    }

    public void func_71852_a(World world, int x, int y, int z, int bId, int bMeta) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ISecureTile) {
            secureOwner = ((ISecureTile)tile).getOwnerName();
            secureAccess = (byte)((ISecureTile)tile).getAccess().ordinal();
        }
        if (tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                CoreUtils.dropItemStackIntoWorldWithVelocity(inv.func_70301_a(i), world, x, y, z);
            }
        }
        if (tile instanceof TileCoFHBase) {
            TileCoFHBase theTile = (TileCoFHBase)tile;
            theTile.blockBroken();
        }
        super.func_71852_a(world, x, y, z, bId, bMeta);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int id = this.func_71922_a(world, x, y, z);
        if (id == 0) {
            return null;
        }
        Item item = Item.field_77698_e[id];
        if (item == null) {
            return null;
        }
        int bMeta = world.func_72805_g(x, y, z);
        ItemStack pickBlock = new ItemStack(this.field_71990_ca, 1, bMeta);
        pickBlock.func_77982_d(this.getItemStackTag(world, x, y, z));
        return pickBlock;
    }

    public float func_71908_a(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ISecureTile && !((ISecureTile)tile).canPlayerAccess(player.field_71092_bJ)) {
            return -1.0f;
        }
        return ForgeHooks.blockStrength((Block)this, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
    }

    public int func_71899_b(int bMeta) {
        return bMeta;
    }

    public int func_94328_b_(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        return tile instanceof TileCoFHBase ? ((TileCoFHBase)tile).getComparatorInput(side) : 0;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_96468_q_() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
    }

    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        return null;
    }

    public abstract ItemStack dismantleBlock(EntityPlayer var1, NBTTagCompound var2, World var3, int var4, int var5, int var6, boolean var7, boolean var8);

    @Override
    public void debugBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side, EntityPlayer player) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ITileDebug) {
            ((ITileDebug)tile).debugTile(side, player);
        }
    }

    @Override
    public void getBlockInfo(IBlockAccess world, int x, int y, int z, ForgeDirection side, EntityPlayer player, List<String> info, boolean debug) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ITileInfo) {
            ((ITileInfo)tile).getTileInfo(info, side, player, debug);
        } else if (tile instanceof IEnergyHandler) {
            IEnergyHandler eHandler = (IEnergyHandler)tile;
            info.add(StringHelper.localize("info.cofh.energy") + ": " + eHandler.getEnergyStored(side) + "/" + eHandler.getMaxEnergyStored(side) + " RF.");
        }
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        return this.dismantleBlock(player, this.getItemStackTag(world, x, y, z), world, x, y, z, returnBlock, false);
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ISecureTile) {
            return ((ISecureTile)tile).canPlayerAccess(player.field_71092_bJ);
        }
        if (tile instanceof TileCoFHBase) {
            return ((TileCoFHBase)tile).canPlayerDismantle(player);
        }
        return true;
    }

    @Override
    public boolean preInit() {
        return true;
    }
}

