/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import java.util.Random;
import mrtjp.projectred.ProjectRedExploration;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IRetroGenerator;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.RetroactiveWorldGenerator;
import mrtjp.projectred.core.world.GeneratorMetamorphicCave;
import mrtjp.projectred.core.world.GeneratorOre;
import mrtjp.projectred.core.world.GeneratorVolcano;
import mrtjp.projectred.exploration.BlockOre;
import mrtjp.projectred.exploration.BlockSpecialStone;
import mrtjp.projectred.exploration.BlockStainedLeaf;
import mrtjp.projectred.exploration.GeneratorColorTree;

public class RetroGenerationManager {
    public static void registerRetroGenerators() {
        if (Configurator.gen_Ruby.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenRuby());
        }
        if (Configurator.gen_Sapphire.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenSapphire());
        }
        if (Configurator.gen_Peridot.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenPeridot());
        }
        if (Configurator.gen_MarbleCave.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenMarbleCave());
        }
        if (Configurator.gen_Volcano.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenVolcano());
        }
        if (Configurator.gen_dyeTrees.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenDyeTrees());
        }
    }

    static class RetrogenDyeTrees
    implements IRetroGenerator {
        RetrogenDyeTrees() {
        }

        public String getSubgenerationID() {
            return "pr_dyetrees";
        }

        public boolean shouldGenerateInLocation(abw abw2, adr adr2) {
            int n = abw2.t.i;
            if (abw2.t.c == acg.c) {
                return false;
            }
            return n == 0;
        }

        public void generate(Random random, abw abw2, int n, int n2) {
            int n3 = random.nextInt(16);
            int n4 = n * 16 + random.nextInt(16);
            int n5 = n2 * 16 + random.nextInt(16);
            int n6 = abw2.f(n4, n5);
            if (random.nextDouble() < (double)(BlockStainedLeaf.EnumDyeTrees.VALID_FOLIAGE[n3].growthChance / 3.0f)) {
                new GeneratorColorTree(ProjectRedExploration.blockStainedLeaf().cF).generateTreeAnyType(abw2, n4, n6, n5, PRColors.get((int)random.nextInt(16)));
            }
        }
    }

    static class RetrogenVolcano
    implements IRetroGenerator {
        RetrogenVolcano() {
        }

        public String getSubgenerationID() {
            return "pr_volcano";
        }

        public boolean shouldGenerateInLocation(abw abw2, adr adr2) {
            if (abw2.t.c == acg.c) {
                return false;
            }
            return abw2.t.i == 0;
        }

        public void generate(Random random, abw abw2, int n, int n2) {
            int n3 = n * 16 + random.nextInt(16);
            int n4 = random.nextInt(64);
            int n5 = n2 * 16 + random.nextInt(16);
            new GeneratorVolcano(ProjectRedExploration.blockStones().cF, BlockSpecialStone.EnumSpecialStone.BASALT.meta, ls.a((Random)random, (int)32000, (int)64000)).a(abw2, random, n3, n4, n5);
        }
    }

    static class RetrogenMarbleCave
    implements IRetroGenerator {
        RetrogenMarbleCave() {
        }

        public String getSubgenerationID() {
            return "pr_marbleCave";
        }

        public boolean shouldGenerateInLocation(abw abw2, adr adr2) {
            return abw2.t.i == 0;
        }

        public void generate(Random random, abw abw2, int n, int n2) {
            int n3 = n * 16 + random.nextInt(16);
            int n4 = 32 + random.nextInt(32);
            int n5 = n2 * 16 + random.nextInt(16);
            new GeneratorMetamorphicCave(ProjectRedExploration.blockStones().cF, BlockSpecialStone.EnumSpecialStone.MARBLE.meta, random.nextInt(4096)).a(abw2, random, n3, n4, n5);
        }
    }

    static class RetrogenPeridot
    implements IRetroGenerator {
        RetrogenPeridot() {
        }

        public String getSubgenerationID() {
            return "pr_peridot";
        }

        public boolean shouldGenerateInLocation(abw abw2, adr adr2) {
            int n = abw2.t.i;
            return n != -1 && n != 1;
        }

        public void generate(Random random, abw abw2, int n, int n2) {
            for (int i = 0; i < 2; ++i) {
                int n3 = n * 16 + random.nextInt(16);
                int n4 = random.nextInt(48);
                int n5 = n2 * 16 + random.nextInt(16);
                new GeneratorOre(ProjectRedExploration.blockOres().cF, BlockOre.EnumOre.OREPERIDOT.meta, 5).a(abw2, random, n3, n4, n5);
            }
        }
    }

    static class RetrogenSapphire
    implements IRetroGenerator {
        RetrogenSapphire() {
        }

        public String getSubgenerationID() {
            return "pr_sapphire";
        }

        public boolean shouldGenerateInLocation(abw abw2, adr adr2) {
            int n = abw2.t.i;
            return n != -1 && n != 1;
        }

        public void generate(Random random, abw abw2, int n, int n2) {
            for (int i = 0; i < 2; ++i) {
                int n3 = n * 16 + random.nextInt(16);
                int n4 = random.nextInt(48);
                int n5 = n2 * 16 + random.nextInt(16);
                new GeneratorOre(ProjectRedExploration.blockOres().cF, BlockOre.EnumOre.ORESAPPHIRE.meta, 5).a(abw2, random, n3, n4, n5);
            }
        }
    }

    static class RetrogenRuby
    implements IRetroGenerator {
        RetrogenRuby() {
        }

        public String getSubgenerationID() {
            return "pr_ruby";
        }

        public boolean shouldGenerateInLocation(abw abw2, adr adr2) {
            int n = abw2.t.i;
            return n != -1 && n != 1;
        }

        public void generate(Random random, abw abw2, int n, int n2) {
            for (int i = 0; i < 2; ++i) {
                int n3 = n * 16 + random.nextInt(16);
                int n4 = random.nextInt(48);
                int n5 = n2 * 16 + random.nextInt(16);
                new GeneratorOre(ProjectRedExploration.blockOres().cF, BlockOre.EnumOre.ORERUBY.meta, 5).a(abw2, random, n3, n4, n5);
            }
        }
    }
}

