/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommand;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.logging.ILogAgent;
import net.minecraft.logging.LogAgent;
import net.minecraft.network.NetworkListenThread;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThreadMain;
import net.minecraft.network.rcon.RConThreadQuery;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.CallableServerType;
import net.minecraft.server.dedicated.CallableType;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerCommandThread;
import net.minecraft.server.dedicated.DedicatedServerListenThread;
import net.minecraft.server.dedicated.DedicatedServerSleepThread;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.CryptManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;

public class DedicatedServer
extends MinecraftServer
implements IServer {
    private final List field_71341_l = Collections.synchronizedList(new ArrayList());
    private final ILogAgent field_98131_l;
    private RConThreadQuery field_71342_m;
    private RConThreadMain field_71339_n;
    private PropertyManager field_71340_o;
    private boolean field_71338_p;
    private EnumGameType field_71337_q;
    private NetworkListenThread field_71336_r;
    private boolean field_71335_s;

    public DedicatedServer(File par1File) {
        super(par1File);
        this.field_98131_l = new LogAgent("Minecraft-Server", (String)null, new File(par1File, "server.log").getAbsolutePath());
        new DedicatedServerSleepThread(this);
    }

    @Override
    protected boolean func_71197_b() throws IOException {
        WorldType worldtype;
        DedicatedServerCommandThread dedicatedservercommandthread = new DedicatedServerCommandThread(this);
        dedicatedservercommandthread.setDaemon(true);
        dedicatedservercommandthread.start();
        this.func_98033_al().func_98233_a("Starting minecraft server version 1.6.2");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            this.func_98033_al().func_98236_b("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        FMLCommonHandler.instance().onServerStart(this);
        this.func_98033_al().func_98233_a("Loading properties");
        this.field_71340_o = new PropertyManager(new File("server.properties"), this.func_98033_al());
        if (this.func_71264_H()) {
            this.func_71189_e("127.0.0.1");
        } else {
            this.func_71229_d(this.field_71340_o.func_73670_a("online-mode", true));
            this.func_71189_e(this.field_71340_o.func_73671_a("server-ip", ""));
        }
        this.func_71251_e(this.field_71340_o.func_73670_a("spawn-animals", true));
        this.func_71257_f(this.field_71340_o.func_73670_a("spawn-npcs", true));
        this.func_71188_g(this.field_71340_o.func_73670_a("pvp", true));
        this.func_71245_h(this.field_71340_o.func_73670_a("allow-flight", false));
        this.func_71269_o(this.field_71340_o.func_73671_a("texture-pack", ""));
        this.func_71205_p(this.field_71340_o.func_73671_a("motd", "A Minecraft Server"));
        this.func_104055_i(this.field_71340_o.func_73670_a("force-gamemode", false));
        if (this.field_71340_o.func_73669_a("difficulty", 1) < 0) {
            this.field_71340_o.func_73667_a("difficulty", (Object)0);
        } else if (this.field_71340_o.func_73669_a("difficulty", 1) > 3) {
            this.field_71340_o.func_73667_a("difficulty", (Object)3);
        }
        this.field_71338_p = this.field_71340_o.func_73670_a("generate-structures", true);
        int i = this.field_71340_o.func_73669_a("gamemode", EnumGameType.SURVIVAL.func_77148_a());
        this.field_71337_q = WorldSettings.func_77161_a((int)i);
        this.func_98033_al().func_98233_a("Default game type: " + this.field_71337_q);
        InetAddress inetaddress = null;
        if (this.func_71211_k().length() > 0) {
            inetaddress = InetAddress.getByName(this.func_71211_k());
        }
        if (this.func_71215_F() < 0) {
            this.func_71208_b(this.field_71340_o.func_73669_a("server-port", 25565));
        }
        this.func_98033_al().func_98233_a("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        this.func_98033_al().func_98233_a("Starting Minecraft server on " + (this.func_71211_k().length() == 0 ? "*" : this.func_71211_k()) + ":" + this.func_71215_F());
        try {
            this.field_71336_r = new DedicatedServerListenThread((MinecraftServer)this, inetaddress, this.func_71215_F());
        }
        catch (IOException ioexception) {
            this.func_98033_al().func_98236_b("**** FAILED TO BIND TO PORT!");
            this.func_98033_al().func_98231_b("The exception was: {0}", new Object[]{ioexception.toString()});
            this.func_98033_al().func_98236_b("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.func_71266_T()) {
            this.func_98033_al().func_98236_b("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            this.func_98033_al().func_98236_b("The server will make no attempt to authenticate usernames. Beware.");
            this.func_98033_al().func_98236_b("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            this.func_98033_al().func_98236_b("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        FMLCommonHandler.instance().onServerStarted();
        this.func_71210_a((ServerConfigurationManager)new DedicatedPlayerList(this));
        long j = System.nanoTime();
        if (this.func_71270_I() == null) {
            this.func_71261_m(this.field_71340_o.func_73671_a("level-name", "world"));
        }
        String s = this.field_71340_o.func_73671_a("level-seed", "");
        String s1 = this.field_71340_o.func_73671_a("level-type", "DEFAULT");
        String s2 = this.field_71340_o.func_73671_a("generator-settings", "");
        long k = new Random().nextLong();
        if (s.length() > 0) {
            try {
                long l = Long.parseLong(s);
                if (l != 0L) {
                    k = l;
                }
            }
            catch (NumberFormatException numberformatexception) {
                k = s.hashCode();
            }
        }
        if ((worldtype = WorldType.func_77130_a((String)s1)) == null) {
            worldtype = WorldType.field_77137_b;
        }
        this.func_71191_d(this.field_71340_o.func_73669_a("max-build-height", 256));
        this.func_71191_d((this.func_71207_Z() + 8) / 16 * 16);
        this.func_71191_d(MathHelper.func_76125_a((int)this.func_71207_Z(), (int)64, (int)256));
        this.field_71340_o.func_73667_a("max-build-height", (Object)this.func_71207_Z());
        if (!FMLCommonHandler.instance().handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        this.func_98033_al().func_98233_a("Preparing level \"" + this.func_71270_I() + "\"");
        this.func_71247_a(this.func_71270_I(), this.func_71270_I(), k, worldtype, s2);
        long i1 = System.nanoTime() - j;
        String s3 = String.format("%.3fs", (double)i1 / 1.0E9);
        this.func_98033_al().func_98233_a("Done (" + s3 + ")! For help, type \"help\" or \"?\"");
        if (this.field_71340_o.func_73670_a("enable-query", false)) {
            this.func_98033_al().func_98233_a("Starting GS4 status listener");
            this.field_71342_m = new RConThreadQuery((IServer)this);
            this.field_71342_m.func_72602_a();
        }
        if (this.field_71340_o.func_73670_a("enable-rcon", false)) {
            this.func_98033_al().func_98233_a("Starting remote control listener");
            this.field_71339_n = new RConThreadMain((IServer)this);
            this.field_71339_n.func_72602_a();
        }
        return FMLCommonHandler.instance().handleServerStarting((MinecraftServer)this);
    }

    @Override
    public boolean func_71225_e() {
        return this.field_71338_p;
    }

    @Override
    public EnumGameType func_71265_f() {
        return this.field_71337_q;
    }

    @Override
    public int func_71232_g() {
        return this.field_71340_o.func_73669_a("difficulty", 1);
    }

    @Override
    public boolean func_71199_h() {
        return this.field_71340_o.func_73670_a("hardcore", false);
    }

    @Override
    protected void func_71228_a(CrashReport par1CrashReport) {
        while (this.func_71278_l()) {
            this.func_71333_ah();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedexception) {
                interruptedexception.printStackTrace();
            }
        }
    }

    @Override
    public CrashReport func_71230_b(CrashReport par1CrashReport) {
        par1CrashReport = super.func_71230_b(par1CrashReport);
        par1CrashReport.func_85056_g().func_71500_a("Is Modded", (Callable)new CallableType(this));
        par1CrashReport.func_85056_g().func_71500_a("Type", (Callable)new CallableServerType(this));
        return par1CrashReport;
    }

    @Override
    protected void func_71240_o() {
        System.exit(0);
    }

    @Override
    public void func_71190_q() {
        super.func_71190_q();
        this.func_71333_ah();
    }

    @Override
    public boolean func_71255_r() {
        return this.field_71340_o.func_73670_a("allow-nether", true);
    }

    @Override
    public boolean func_71193_K() {
        return this.field_71340_o.func_73670_a("spawn-monsters", true);
    }

    @Override
    public void func_70000_a(PlayerUsageSnooper par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.func_76472_a("whitelist_enabled", this.func_71334_ai().func_72383_n());
        par1PlayerUsageSnooper.func_76472_a("whitelist_count", this.func_71334_ai().func_72388_h().size());
        super.func_70000_a(par1PlayerUsageSnooper);
    }

    @Override
    public boolean func_70002_Q() {
        return this.field_71340_o.func_73670_a("snooper-enabled", true);
    }

    public void func_71331_a(String par1Str, ICommandSender par2ICommandSender) {
        this.field_71341_l.add(new ServerCommand(par1Str, par2ICommandSender));
    }

    public void func_71333_ah() {
        while (!this.field_71341_l.isEmpty()) {
            ServerCommand servercommand = (ServerCommand)this.field_71341_l.remove(0);
            this.func_71187_D().func_71556_a(servercommand.field_73701_b, servercommand.field_73702_a);
        }
    }

    @Override
    public boolean func_71262_S() {
        return true;
    }

    public DedicatedPlayerList func_71334_ai() {
        return (DedicatedPlayerList)super.func_71203_ab();
    }

    @Override
    public NetworkListenThread func_71212_ac() {
        return this.field_71336_r;
    }

    public int func_71327_a(String par1Str, int par2) {
        return this.field_71340_o.func_73669_a(par1Str, par2);
    }

    public String func_71330_a(String par1Str, String par2Str) {
        return this.field_71340_o.func_73671_a(par1Str, par2Str);
    }

    public boolean func_71332_a(String par1Str, boolean par2) {
        return this.field_71340_o.func_73670_a(par1Str, par2);
    }

    public void func_71328_a(String par1Str, Object par2Obj) {
        this.field_71340_o.func_73667_a(par1Str, par2Obj);
    }

    public void func_71326_a() {
        this.field_71340_o.func_73668_b();
    }

    public String func_71329_c() {
        File file1 = this.field_71340_o.func_73665_c();
        return file1 != null ? file1.getAbsolutePath() : "No settings file";
    }

    @Override
    public boolean func_71279_ae() {
        return this.field_71335_s;
    }

    @Override
    public String func_71206_a(EnumGameType par1EnumGameType, boolean par2) {
        return "";
    }

    @Override
    public boolean func_82356_Z() {
        return this.field_71340_o.func_73670_a("enable-command-block", false);
    }

    @Override
    public int func_82357_ak() {
        return this.field_71340_o.func_73669_a("spawn-protection", super.func_82357_ak());
    }

    @Override
    public boolean func_96290_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        int i1;
        if (par1World.field_73011_w.field_76574_g != 0) {
            return false;
        }
        if (this.func_71334_ai().func_72376_i().isEmpty()) {
            return false;
        }
        if (this.func_71334_ai().func_72353_e(par5EntityPlayer.func_70005_c_())) {
            return false;
        }
        if (this.func_82357_ak() <= 0) {
            return false;
        }
        ChunkCoordinates chunkcoordinates = par1World.func_72861_E();
        int l = MathHelper.func_76130_a((int)(par2 - chunkcoordinates.field_71574_a));
        int j1 = Math.max(l, i1 = MathHelper.func_76130_a((int)(par4 - chunkcoordinates.field_71573_c)));
        return j1 <= this.func_82357_ak();
    }

    @Override
    public ILogAgent func_98033_al() {
        return this.field_98131_l;
    }

    @Override
    public int func_110455_j() {
        return this.field_71340_o.func_73669_a("op-permission-level", 4);
    }

    @Override
    public ServerConfigurationManager func_71203_ab() {
        return this.func_71334_ai();
    }

    @SideOnly(value=Side.SERVER)
    public void func_120011_ar() {
        MinecraftServerGui.func_120016_a((DedicatedServer)this);
        this.field_71335_s = true;
    }
}

