/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import cpw.mods.fml.common.network.FMLNetworkHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.CallablePacketClass;
import net.minecraft.network.CallablePacketID;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet0KeepAlive;
import net.minecraft.network.packet.Packet101CloseWindow;
import net.minecraft.network.packet.Packet102WindowClick;
import net.minecraft.network.packet.Packet103SetSlot;
import net.minecraft.network.packet.Packet106Transaction;
import net.minecraft.network.packet.Packet107CreativeSetSlot;
import net.minecraft.network.packet.Packet108EnchantItem;
import net.minecraft.network.packet.Packet10Flying;
import net.minecraft.network.packet.Packet130UpdateSign;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.network.packet.Packet13PlayerLookMove;
import net.minecraft.network.packet.Packet14BlockDig;
import net.minecraft.network.packet.Packet15Place;
import net.minecraft.network.packet.Packet16BlockItemSwitch;
import net.minecraft.network.packet.Packet18Animation;
import net.minecraft.network.packet.Packet19EntityAction;
import net.minecraft.network.packet.Packet202PlayerAbilities;
import net.minecraft.network.packet.Packet203AutoComplete;
import net.minecraft.network.packet.Packet204ClientInfo;
import net.minecraft.network.packet.Packet205ClientCommand;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet255KickDisconnect;
import net.minecraft.network.packet.Packet27PlayerInput;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.network.packet.Packet53BlockChange;
import net.minecraft.network.packet.Packet7UseEntity;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.StringUtils;

public class NetServerHandler
extends NetHandler {
    public final INetworkManager field_72575_b;
    private final MinecraftServer field_72573_d;
    public boolean field_72576_c;
    public EntityPlayerMP field_72574_e;
    private int field_72571_f;
    public int field_72572_g;
    private boolean field_72584_h;
    private int field_72585_i;
    private long field_72582_j;
    private static Random field_72583_k = new Random();
    private long field_72580_l;
    private int field_72581_m;
    private int field_72578_n;
    private double field_72579_o;
    private double field_72589_p;
    private double field_72588_q;
    private boolean field_72587_r = true;
    private IntHashMap field_72586_s = new IntHashMap();

    public NetServerHandler(MinecraftServer par1MinecraftServer, INetworkManager par2INetworkManager, EntityPlayerMP par3EntityPlayerMP) {
        this.field_72573_d = par1MinecraftServer;
        this.field_72575_b = par2INetworkManager;
        par2INetworkManager.func_74425_a((NetHandler)this);
        this.field_72574_e = par3EntityPlayerMP;
        par3EntityPlayerMP.field_71135_a = this;
    }

    public void func_72570_d() {
        this.field_72584_h = false;
        ++this.field_72571_f;
        this.field_72573_d.field_71304_b.func_76320_a("packetflow");
        this.field_72575_b.func_74428_b();
        this.field_72573_d.field_71304_b.func_76318_c("keepAlive");
        if ((long)this.field_72571_f - this.field_72580_l > 20L) {
            this.field_72580_l = this.field_72571_f;
            this.field_72582_j = System.nanoTime() / 1000000L;
            this.field_72585_i = field_72583_k.nextInt();
            this.func_72567_b((Packet)new Packet0KeepAlive(this.field_72585_i));
        }
        if (this.field_72581_m > 0) {
            --this.field_72581_m;
        }
        if (this.field_72578_n > 0) {
            --this.field_72578_n;
        }
        this.field_72573_d.field_71304_b.func_76318_c("playerTick");
        this.field_72573_d.field_71304_b.func_76319_b();
    }

    public void func_72565_c(String par1Str) {
        if (!this.field_72576_c) {
            this.field_72574_e.func_71123_m();
            this.func_72567_b((Packet)new Packet255KickDisconnect(par1Str));
            this.field_72575_b.func_74423_d();
            this.field_72573_d.func_71203_ab().func_92062_k(ChatMessageComponent.func_111082_b((String)"multiplayer.player.left", (Object[])new Object[]{this.field_72574_e.func_96090_ax()}).func_111059_a(EnumChatFormatting.YELLOW));
            this.field_72573_d.func_71203_ab().func_72367_e(this.field_72574_e);
            this.field_72576_c = true;
        }
    }

    @Override
    public void func_110774_a(Packet27PlayerInput par1Packet27PlayerInput) {
        this.field_72574_e.func_110430_a(par1Packet27PlayerInput.func_111010_d(), par1Packet27PlayerInput.func_111012_f(), par1Packet27PlayerInput.func_111013_g(), par1Packet27PlayerInput.func_111011_h());
    }

    @Override
    public void func_72498_a(Packet10Flying par1Packet10Flying) {
        WorldServer worldserver = this.field_72573_d.func_71218_a(this.field_72574_e.field_71093_bK);
        this.field_72584_h = true;
        if (!this.field_72574_e.field_71136_j) {
            double d0;
            if (!this.field_72587_r) {
                d0 = par1Packet10Flying.field_73543_b - this.field_72589_p;
                if (par1Packet10Flying.field_73545_a == this.field_72579_o && d0 * d0 < 0.01 && par1Packet10Flying.field_73544_c == this.field_72588_q) {
                    this.field_72587_r = true;
                }
            }
            if (this.field_72587_r) {
                double d9;
                double d8;
                double d4;
                if (this.field_72574_e.field_70154_o != null) {
                    float f = this.field_72574_e.field_70177_z;
                    float f1 = this.field_72574_e.field_70125_A;
                    this.field_72574_e.field_70154_o.func_70043_V();
                    double d1 = this.field_72574_e.field_70165_t;
                    double d2 = this.field_72574_e.field_70163_u;
                    double d3 = this.field_72574_e.field_70161_v;
                    if (par1Packet10Flying.field_73547_i) {
                        f = par1Packet10Flying.field_73542_e;
                        f1 = par1Packet10Flying.field_73539_f;
                    }
                    this.field_72574_e.field_70122_E = par1Packet10Flying.field_73540_g;
                    this.field_72574_e.func_71127_g();
                    this.field_72574_e.field_70139_V = 0.0f;
                    this.field_72574_e.func_70080_a(d1, d2, d3, f, f1);
                    if (this.field_72574_e.field_70154_o != null) {
                        this.field_72574_e.field_70154_o.func_70043_V();
                    }
                    if (!this.field_72587_r) {
                        return;
                    }
                    this.field_72573_d.func_71203_ab().func_72358_d(this.field_72574_e);
                    if (this.field_72587_r) {
                        this.field_72579_o = this.field_72574_e.field_70165_t;
                        this.field_72589_p = this.field_72574_e.field_70163_u;
                        this.field_72588_q = this.field_72574_e.field_70161_v;
                    }
                    worldserver.func_72870_g((Entity)this.field_72574_e);
                    return;
                }
                if (this.field_72574_e.func_70608_bn()) {
                    this.field_72574_e.func_71127_g();
                    this.field_72574_e.func_70080_a(this.field_72579_o, this.field_72589_p, this.field_72588_q, this.field_72574_e.field_70177_z, this.field_72574_e.field_70125_A);
                    worldserver.func_72870_g((Entity)this.field_72574_e);
                    return;
                }
                d0 = this.field_72574_e.field_70163_u;
                this.field_72579_o = this.field_72574_e.field_70165_t;
                this.field_72589_p = this.field_72574_e.field_70163_u;
                this.field_72588_q = this.field_72574_e.field_70161_v;
                double d1 = this.field_72574_e.field_70165_t;
                double d2 = this.field_72574_e.field_70163_u;
                double d3 = this.field_72574_e.field_70161_v;
                float f2 = this.field_72574_e.field_70177_z;
                float f3 = this.field_72574_e.field_70125_A;
                if (par1Packet10Flying.field_73546_h && par1Packet10Flying.field_73543_b == -999.0 && par1Packet10Flying.field_73541_d == -999.0) {
                    par1Packet10Flying.field_73546_h = false;
                }
                if (par1Packet10Flying.field_73546_h) {
                    d1 = par1Packet10Flying.field_73545_a;
                    d2 = par1Packet10Flying.field_73543_b;
                    d3 = par1Packet10Flying.field_73544_c;
                    d4 = par1Packet10Flying.field_73541_d - par1Packet10Flying.field_73543_b;
                    if (!this.field_72574_e.func_70608_bn() && (d4 > 1.65 || d4 < 0.1)) {
                        this.func_72565_c("Illegal stance");
                        this.field_72573_d.func_98033_al().func_98236_b(this.field_72574_e.func_70005_c_() + " had an illegal stance: " + d4);
                        return;
                    }
                    if (Math.abs(par1Packet10Flying.field_73545_a) > 3.2E7 || Math.abs(par1Packet10Flying.field_73544_c) > 3.2E7) {
                        this.func_72565_c("Illegal position");
                        return;
                    }
                }
                if (par1Packet10Flying.field_73547_i) {
                    f2 = par1Packet10Flying.field_73542_e;
                    f3 = par1Packet10Flying.field_73539_f;
                }
                this.field_72574_e.func_71127_g();
                this.field_72574_e.field_70139_V = 0.0f;
                this.field_72574_e.func_70080_a(this.field_72579_o, this.field_72589_p, this.field_72588_q, f2, f3);
                if (!this.field_72587_r) {
                    return;
                }
                d4 = d1 - this.field_72574_e.field_70165_t;
                double d5 = d2 - this.field_72574_e.field_70163_u;
                double d6 = d3 - this.field_72574_e.field_70161_v;
                double d7 = Math.max(Math.abs(d4), Math.abs(this.field_72574_e.field_70159_w));
                double d10 = d7 * d7 + (d8 = Math.max(Math.abs(d5), Math.abs(this.field_72574_e.field_70181_x))) * d8 + (d9 = Math.max(Math.abs(d6), Math.abs(this.field_72574_e.field_70179_y))) * d9;
                if (!(!(d10 > 100.0) || this.field_72573_d.func_71264_H() && this.field_72573_d.func_71214_G().equals(this.field_72574_e.func_70005_c_()))) {
                    this.field_72573_d.func_98033_al().func_98236_b(this.field_72574_e.func_70005_c_() + " moved too quickly! " + d4 + "," + d5 + "," + d6 + " (" + d7 + ", " + d8 + ", " + d9 + ")");
                    this.func_72569_a(this.field_72579_o, this.field_72589_p, this.field_72588_q, this.field_72574_e.field_70177_z, this.field_72574_e.field_70125_A);
                    return;
                }
                float f4 = 0.0625f;
                boolean flag = worldserver.func_72945_a((Entity)this.field_72574_e, this.field_72574_e.field_70121_D.func_72329_c().func_72331_e((double)f4, (double)f4, (double)f4)).isEmpty();
                if (this.field_72574_e.field_70122_E && !par1Packet10Flying.field_73540_g && d5 > 0.0) {
                    this.field_72574_e.func_71020_j(0.2f);
                }
                if (!this.field_72587_r) {
                    return;
                }
                this.field_72574_e.func_70091_d(d4, d5, d6);
                this.field_72574_e.field_70122_E = par1Packet10Flying.field_73540_g;
                this.field_72574_e.func_71000_j(d4, d5, d6);
                double d11 = d5;
                d4 = d1 - this.field_72574_e.field_70165_t;
                d5 = d2 - this.field_72574_e.field_70163_u;
                if (d5 > -0.5 || d5 < 0.5) {
                    d5 = 0.0;
                }
                d6 = d3 - this.field_72574_e.field_70161_v;
                d10 = d4 * d4 + d5 * d5 + d6 * d6;
                boolean flag1 = false;
                if (d10 > 0.0625 && !this.field_72574_e.func_70608_bn() && !this.field_72574_e.field_71134_c.func_73083_d()) {
                    flag1 = true;
                    this.field_72573_d.func_98033_al().func_98236_b(this.field_72574_e.func_70005_c_() + " moved wrongly!");
                }
                if (!this.field_72587_r) {
                    return;
                }
                this.field_72574_e.func_70080_a(d1, d2, d3, f2, f3);
                boolean flag2 = worldserver.func_72945_a((Entity)this.field_72574_e, this.field_72574_e.field_70121_D.func_72329_c().func_72331_e((double)f4, (double)f4, (double)f4)).isEmpty();
                if (!(!flag || !flag1 && flag2 || this.field_72574_e.func_70608_bn() || this.field_72574_e.field_70145_X)) {
                    this.func_72569_a(this.field_72579_o, this.field_72589_p, this.field_72588_q, f2, f3);
                    return;
                }
                AxisAlignedBB axisalignedbb = this.field_72574_e.field_70121_D.func_72329_c().func_72314_b((double)f4, (double)f4, (double)f4).func_72321_a(0.0, -0.55, 0.0);
                if (!(this.field_72573_d.func_71231_X() || this.field_72574_e.field_71134_c.func_73083_d() || worldserver.func_72829_c(axisalignedbb) || this.field_72574_e.field_71075_bZ.field_75101_c)) {
                    if (d11 >= -0.03125) {
                        ++this.field_72572_g;
                        if (this.field_72572_g > 80) {
                            this.field_72573_d.func_98033_al().func_98236_b(this.field_72574_e.func_70005_c_() + " was kicked for floating too long!");
                            this.func_72565_c("Flying is not enabled on this server");
                            return;
                        }
                    }
                } else {
                    this.field_72572_g = 0;
                }
                if (!this.field_72587_r) {
                    return;
                }
                this.field_72574_e.field_70122_E = par1Packet10Flying.field_73540_g;
                this.field_72573_d.func_71203_ab().func_72358_d(this.field_72574_e);
                this.field_72574_e.func_71122_b(this.field_72574_e.field_70163_u - d0, par1Packet10Flying.field_73540_g);
            } else if (this.field_72571_f % 20 == 0) {
                this.func_72569_a(this.field_72579_o, this.field_72589_p, this.field_72588_q, this.field_72574_e.field_70177_z, this.field_72574_e.field_70125_A);
            }
        }
    }

    public void func_72569_a(double par1, double par3, double par5, float par7, float par8) {
        this.field_72587_r = false;
        this.field_72579_o = par1;
        this.field_72589_p = par3;
        this.field_72588_q = par5;
        this.field_72574_e.func_70080_a(par1, par3, par5, par7, par8);
        this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet13PlayerLookMove(par1, par3 + (double)1.62f, par3, par5, par7, par8, false));
    }

    @Override
    public void func_72510_a(Packet14BlockDig par1Packet14BlockDig) {
        WorldServer worldserver = this.field_72573_d.func_71218_a(this.field_72574_e.field_71093_bK);
        if (par1Packet14BlockDig.field_73342_e == 4) {
            this.field_72574_e.func_71040_bB(false);
        } else if (par1Packet14BlockDig.field_73342_e == 3) {
            this.field_72574_e.func_71040_bB(true);
        } else if (par1Packet14BlockDig.field_73342_e == 5) {
            this.field_72574_e.func_71034_by();
        } else {
            boolean flag = false;
            if (par1Packet14BlockDig.field_73342_e == 0) {
                flag = true;
            }
            if (par1Packet14BlockDig.field_73342_e == 1) {
                flag = true;
            }
            if (par1Packet14BlockDig.field_73342_e == 2) {
                flag = true;
            }
            int i = par1Packet14BlockDig.field_73345_a;
            int j = par1Packet14BlockDig.field_73343_b;
            int k = par1Packet14BlockDig.field_73344_c;
            if (flag) {
                double d0 = this.field_72574_e.field_70165_t - ((double)i + 0.5);
                double d1 = this.field_72574_e.field_70163_u - ((double)j + 0.5) + 1.5;
                double d2 = this.field_72574_e.field_70161_v - ((double)k + 0.5);
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                double dist = this.field_72574_e.field_71134_c.getBlockReachDistance() + 1.0;
                if (d3 > (dist *= dist)) {
                    return;
                }
                if (j >= this.field_72573_d.func_71207_Z()) {
                    return;
                }
            }
            if (par1Packet14BlockDig.field_73342_e == 0) {
                if (!this.field_72573_d.func_96290_a((World)worldserver, i, j, k, (EntityPlayer)this.field_72574_e)) {
                    this.field_72574_e.field_71134_c.func_73074_a(i, j, k, par1Packet14BlockDig.field_73341_d);
                } else {
                    this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet53BlockChange(i, j, k, (World)worldserver));
                }
            } else if (par1Packet14BlockDig.field_73342_e == 2) {
                this.field_72574_e.field_71134_c.func_73082_a(i, j, k);
                if (worldserver.func_72798_a(i, j, k) != 0) {
                    this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet53BlockChange(i, j, k, (World)worldserver));
                }
            } else if (par1Packet14BlockDig.field_73342_e == 1) {
                this.field_72574_e.field_71134_c.func_73073_c(i, j, k);
                if (worldserver.func_72798_a(i, j, k) != 0) {
                    this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet53BlockChange(i, j, k, (World)worldserver));
                }
            }
        }
    }

    @Override
    public void func_72472_a(Packet15Place par1Packet15Place) {
        WorldServer worldserver = this.field_72573_d.func_71218_a(this.field_72574_e.field_71093_bK);
        ItemStack itemstack = this.field_72574_e.field_71071_by.func_70448_g();
        boolean flag = false;
        int i = par1Packet15Place.func_73403_d();
        int j = par1Packet15Place.func_73402_f();
        int k = par1Packet15Place.func_73407_g();
        int l = par1Packet15Place.func_73401_h();
        if (par1Packet15Place.func_73401_h() == 255) {
            if (itemstack == null) {
                return;
            }
            PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)this.field_72574_e, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_AIR, (int)0, (int)0, (int)0, (int)-1);
            if (event.useItem != Event.Result.DENY) {
                this.field_72574_e.field_71134_c.func_73085_a((EntityPlayer)this.field_72574_e, (World)worldserver, itemstack);
            }
        } else if (par1Packet15Place.func_73402_f() >= this.field_72573_d.func_71207_Z() - 1 && (par1Packet15Place.func_73401_h() == 1 || par1Packet15Place.func_73402_f() >= this.field_72573_d.func_71207_Z())) {
            this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet3Chat(ChatMessageComponent.func_111082_b((String)"build.tooHigh", (Object[])new Object[]{this.field_72573_d.func_71207_Z()}).func_111059_a(EnumChatFormatting.RED)));
            flag = true;
        } else {
            double dist = this.field_72574_e.field_71134_c.getBlockReachDistance() + 1.0;
            dist *= dist;
            if (this.field_72587_r && this.field_72574_e.func_70092_e((double)i + 0.5, (double)j + 0.5, (double)k + 0.5) < dist && !this.field_72573_d.func_96290_a((World)worldserver, i, j, k, (EntityPlayer)this.field_72574_e)) {
                this.field_72574_e.field_71134_c.func_73078_a((EntityPlayer)this.field_72574_e, (World)worldserver, itemstack, i, j, k, l, par1Packet15Place.func_73406_j(), par1Packet15Place.func_73404_l(), par1Packet15Place.func_73408_m());
            }
            flag = true;
        }
        if (flag) {
            this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet53BlockChange(i, j, k, (World)worldserver));
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
            this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet53BlockChange(i, j, k, (World)worldserver));
        }
        if ((itemstack = this.field_72574_e.field_71071_by.func_70448_g()) != null && itemstack.field_77994_a == 0) {
            this.field_72574_e.field_71071_by.field_70462_a[this.field_72574_e.field_71071_by.field_70461_c] = null;
            itemstack = null;
        }
        if (itemstack == null || itemstack.func_77988_m() == 0) {
            this.field_72574_e.field_71137_h = true;
            this.field_72574_e.field_71071_by.field_70462_a[this.field_72574_e.field_71071_by.field_70461_c] = ItemStack.func_77944_b(this.field_72574_e.field_71071_by.field_70462_a[this.field_72574_e.field_71071_by.field_70461_c]);
            Slot slot = this.field_72574_e.field_71070_bA.func_75147_a((IInventory)this.field_72574_e.field_71071_by, this.field_72574_e.field_71071_by.field_70461_c);
            this.field_72574_e.field_71070_bA.func_75142_b();
            this.field_72574_e.field_71137_h = false;
            if (!ItemStack.func_77989_b(this.field_72574_e.field_71071_by.func_70448_g(), par1Packet15Place.func_73405_i())) {
                this.func_72567_b((Packet)new Packet103SetSlot(this.field_72574_e.field_71070_bA.field_75152_c, slot.field_75222_d, this.field_72574_e.field_71071_by.func_70448_g()));
            }
        }
    }

    @Override
    public void func_72515_a(String par1Str, Object[] par2ArrayOfObj) {
        this.field_72573_d.func_98033_al().func_98233_a(this.field_72574_e.func_70005_c_() + " lost connection: " + par1Str);
        this.field_72573_d.func_71203_ab().func_92062_k(ChatMessageComponent.func_111082_b((String)"multiplayer.player.left", (Object[])new Object[]{this.field_72574_e.func_96090_ax()}).func_111059_a(EnumChatFormatting.YELLOW));
        this.field_72573_d.func_71203_ab().func_72367_e(this.field_72574_e);
        this.field_72576_c = true;
        if (this.field_72573_d.func_71264_H() && this.field_72574_e.func_70005_c_().equals(this.field_72573_d.func_71214_G())) {
            this.field_72573_d.func_98033_al().func_98233_a("Stopping singleplayer server as player logged out");
            this.field_72573_d.func_71263_m();
        }
    }

    @Override
    public void func_72509_a(Packet par1Packet) {
        this.field_72573_d.func_98033_al().func_98236_b(this.getClass() + " wasn't prepared to deal with a " + par1Packet.getClass());
        this.func_72565_c("Protocol error, unexpected packet");
    }

    public void func_72567_b(Packet par1Packet) {
        if (par1Packet instanceof Packet3Chat) {
            Packet3Chat packet3chat = (Packet3Chat)par1Packet;
            int i = this.field_72574_e.func_71126_v();
            if (i == 2) {
                return;
            }
            if (i == 1 && !packet3chat.func_73475_d()) {
                return;
            }
        }
        try {
            this.field_72575_b.func_74429_a(par1Packet);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Packet being sent");
            crashreportcategory.func_71500_a("Packet ID", (Callable)new CallablePacketID(this, par1Packet));
            crashreportcategory.func_71500_a("Packet class", (Callable)new CallablePacketClass(this, par1Packet));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void func_72502_a(Packet16BlockItemSwitch par1Packet16BlockItemSwitch) {
        if (par1Packet16BlockItemSwitch.field_73386_a >= 0 && par1Packet16BlockItemSwitch.field_73386_a < InventoryPlayer.func_70451_h()) {
            this.field_72574_e.field_71071_by.field_70461_c = par1Packet16BlockItemSwitch.field_73386_a;
        } else {
            this.field_72573_d.func_98033_al().func_98236_b(this.field_72574_e.func_70005_c_() + " tried to set an invalid carried item");
        }
    }

    @Override
    public void func_72481_a(Packet3Chat par1Packet3Chat) {
        par1Packet3Chat = FMLNetworkHandler.handleChatMessage((NetHandler)this, (Packet3Chat)par1Packet3Chat);
        if (this.field_72574_e.func_71126_v() == 2) {
            this.func_72567_b((Packet)new Packet3Chat(ChatMessageComponent.func_111077_e((String)"chat.cannotSend").func_111059_a(EnumChatFormatting.RED)));
        } else {
            String s = par1Packet3Chat.field_73476_b;
            if (s.length() > 100) {
                this.func_72565_c("Chat message too long");
            } else {
                s = StringUtils.normalizeSpace((String)s);
                for (int i = 0; i < s.length(); ++i) {
                    if (ChatAllowedCharacters.func_71566_a((char)s.charAt(i))) continue;
                    this.func_72565_c("Illegal characters in chat");
                    return;
                }
                if (s.startsWith("/")) {
                    this.func_72566_d(s);
                } else {
                    if (this.field_72574_e.func_71126_v() == 1) {
                        this.func_72567_b((Packet)new Packet3Chat(ChatMessageComponent.func_111077_e((String)"chat.cannotSend").func_111059_a(EnumChatFormatting.RED)));
                        return;
                    }
                    ChatMessageComponent chatmessagecomponent = ChatMessageComponent.func_111082_b((String)"chat.type.text", (Object[])new Object[]{this.field_72574_e.func_96090_ax(), s});
                    if ((chatmessagecomponent = ForgeHooks.onServerChatEvent((NetServerHandler)this, (String)s, (ChatMessageComponent)chatmessagecomponent)) == null) {
                        return;
                    }
                    this.field_72573_d.func_71203_ab().func_110459_a(chatmessagecomponent, false);
                }
                this.field_72581_m += 20;
                if (this.field_72581_m > 200 && !this.field_72573_d.func_71203_ab().func_72353_e(this.field_72574_e.func_70005_c_())) {
                    this.func_72565_c("disconnect.spam");
                }
            }
        }
    }

    private void func_72566_d(String par1Str) {
        this.field_72573_d.func_71187_D().func_71556_a((ICommandSender)this.field_72574_e, par1Str);
    }

    @Override
    public void func_72524_a(Packet18Animation par1Packet18Animation) {
        if (par1Packet18Animation.field_73469_b == 1) {
            this.field_72574_e.func_71038_i();
        }
    }

    @Override
    public void func_72473_a(Packet19EntityAction par1Packet19EntityAction) {
        if (par1Packet19EntityAction.field_73366_b == 1) {
            this.field_72574_e.func_70095_a(true);
        } else if (par1Packet19EntityAction.field_73366_b == 2) {
            this.field_72574_e.func_70095_a(false);
        } else if (par1Packet19EntityAction.field_73366_b == 4) {
            this.field_72574_e.func_70031_b(true);
        } else if (par1Packet19EntityAction.field_73366_b == 5) {
            this.field_72574_e.func_70031_b(false);
        } else if (par1Packet19EntityAction.field_73366_b == 3) {
            this.field_72574_e.func_70999_a(false, true, true);
            this.field_72587_r = false;
        } else if (par1Packet19EntityAction.field_73366_b == 6) {
            if (this.field_72574_e.field_70154_o != null && this.field_72574_e.field_70154_o instanceof EntityHorse) {
                ((EntityHorse)this.field_72574_e.field_70154_o).func_110206_u(par1Packet19EntityAction.field_111009_c);
            }
        } else if (par1Packet19EntityAction.field_73366_b == 7 && this.field_72574_e.field_70154_o != null && this.field_72574_e.field_70154_o instanceof EntityHorse) {
            ((EntityHorse)this.field_72574_e.field_70154_o).func_110199_f((EntityPlayer)this.field_72574_e);
        }
    }

    @Override
    public void func_72492_a(Packet255KickDisconnect par1Packet255KickDisconnect) {
        this.field_72575_b.func_74424_a("disconnect.quitting", new Object[0]);
    }

    public int func_72568_e() {
        return this.field_72575_b.func_74426_e();
    }

    @Override
    public void func_72507_a(Packet7UseEntity par1Packet7UseEntity) {
        WorldServer worldserver = this.field_72573_d.func_71218_a(this.field_72574_e.field_71093_bK);
        Entity entity = worldserver.func_73045_a(par1Packet7UseEntity.field_73604_b);
        if (entity != null) {
            boolean flag = this.field_72574_e.func_70685_l(entity);
            double d0 = 36.0;
            if (!flag) {
                d0 = 9.0;
            }
            if (this.field_72574_e.func_70068_e(entity) < d0) {
                if (par1Packet7UseEntity.field_73605_c == 0) {
                    this.field_72574_e.func_70998_m(entity);
                } else if (par1Packet7UseEntity.field_73605_c == 1) {
                    if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == this.field_72574_e) {
                        this.func_72565_c("Attempting to attack an invalid entity");
                        this.field_72573_d.func_71236_h("Player " + this.field_72574_e.func_70005_c_() + " tried to attack an invalid entity");
                        return;
                    }
                    this.field_72574_e.func_71059_n(entity);
                }
            }
        }
    }

    @Override
    public void func_72458_a(Packet205ClientCommand par1Packet205ClientCommand) {
        if (par1Packet205ClientCommand.field_73447_a == 1) {
            if (this.field_72574_e.field_71136_j) {
                this.field_72574_e = this.field_72573_d.func_71203_ab().func_72368_a(this.field_72574_e, 0, true);
            } else if (this.field_72574_e.func_71121_q().func_72912_H().func_76093_s()) {
                if (this.field_72573_d.func_71264_H() && this.field_72574_e.func_70005_c_().equals(this.field_72573_d.func_71214_G())) {
                    this.field_72574_e.field_71135_a.func_72565_c("You have died. Game over, man, it's game over!");
                    this.field_72573_d.func_71272_O();
                } else {
                    BanEntry banentry = new BanEntry(this.field_72574_e.func_70005_c_());
                    banentry.func_73689_b("Death in Hardcore");
                    this.field_72573_d.func_71203_ab().func_72390_e().func_73706_a(banentry);
                    this.field_72574_e.field_71135_a.func_72565_c("You have died. Game over, man, it's game over!");
                }
            } else {
                if (this.field_72574_e.func_110143_aJ() > 0.0f) {
                    return;
                }
                this.field_72574_e = this.field_72573_d.func_71203_ab().func_72368_a(this.field_72574_e, this.field_72574_e.field_71093_bK, false);
            }
        }
    }

    @Override
    public boolean func_72469_b() {
        return true;
    }

    @Override
    public void func_72483_a(Packet9Respawn par1Packet9Respawn) {
    }

    @Override
    public void func_72474_a(Packet101CloseWindow par1Packet101CloseWindow) {
        this.field_72574_e.func_71128_l();
    }

    @Override
    public void func_72523_a(Packet102WindowClick par1Packet102WindowClick) {
        if (this.field_72574_e.field_71070_bA.field_75152_c == par1Packet102WindowClick.field_73444_a && this.field_72574_e.field_71070_bA.func_75129_b((EntityPlayer)this.field_72574_e)) {
            ItemStack itemstack = this.field_72574_e.field_71070_bA.func_75144_a(par1Packet102WindowClick.field_73442_b, par1Packet102WindowClick.field_73443_c, par1Packet102WindowClick.field_73439_f, (EntityPlayer)this.field_72574_e);
            if (ItemStack.func_77989_b(par1Packet102WindowClick.field_73441_e, itemstack)) {
                this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet106Transaction(par1Packet102WindowClick.field_73444_a, par1Packet102WindowClick.field_73440_d, true));
                this.field_72574_e.field_71137_h = true;
                this.field_72574_e.field_71070_bA.func_75142_b();
                this.field_72574_e.func_71113_k();
                this.field_72574_e.field_71137_h = false;
            } else {
                this.field_72586_s.func_76038_a(this.field_72574_e.field_71070_bA.field_75152_c, (Object)par1Packet102WindowClick.field_73440_d);
                this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet106Transaction(par1Packet102WindowClick.field_73444_a, par1Packet102WindowClick.field_73440_d, false));
                this.field_72574_e.field_71070_bA.func_75128_a((EntityPlayer)this.field_72574_e, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                for (int i = 0; i < this.field_72574_e.field_71070_bA.field_75151_b.size(); ++i) {
                    arraylist.add(((Slot)this.field_72574_e.field_71070_bA.field_75151_b.get(i)).func_75211_c());
                }
                this.field_72574_e.func_71110_a(this.field_72574_e.field_71070_bA, arraylist);
            }
        }
    }

    @Override
    public void func_72479_a(Packet108EnchantItem par1Packet108EnchantItem) {
        if (this.field_72574_e.field_71070_bA.field_75152_c == par1Packet108EnchantItem.field_73446_a && this.field_72574_e.field_71070_bA.func_75129_b((EntityPlayer)this.field_72574_e)) {
            this.field_72574_e.field_71070_bA.func_75140_a((EntityPlayer)this.field_72574_e, par1Packet108EnchantItem.field_73445_b);
            this.field_72574_e.field_71070_bA.func_75142_b();
        }
    }

    @Override
    public void func_72464_a(Packet107CreativeSetSlot par1Packet107CreativeSetSlot) {
        if (this.field_72574_e.field_71134_c.func_73083_d()) {
            boolean flag3;
            boolean flag = par1Packet107CreativeSetSlot.field_73385_a < 0;
            ItemStack itemstack = par1Packet107CreativeSetSlot.field_73384_b;
            boolean flag1 = par1Packet107CreativeSetSlot.field_73385_a >= 1 && par1Packet107CreativeSetSlot.field_73385_a < 36 + InventoryPlayer.func_70451_h();
            boolean flag2 = itemstack == null || itemstack.field_77993_c < Item.field_77698_e.length && itemstack.field_77993_c >= 0 && Item.field_77698_e[itemstack.field_77993_c] != null;
            boolean bl = flag3 = itemstack == null || itemstack.func_77960_j() >= 0 && itemstack.func_77960_j() >= 0 && itemstack.field_77994_a <= 64 && itemstack.field_77994_a > 0;
            if (flag1 && flag2 && flag3) {
                if (itemstack == null) {
                    this.field_72574_e.field_71069_bz.func_75141_a(par1Packet107CreativeSetSlot.field_73385_a, (ItemStack)null);
                } else {
                    this.field_72574_e.field_71069_bz.func_75141_a(par1Packet107CreativeSetSlot.field_73385_a, itemstack);
                }
                this.field_72574_e.field_71069_bz.func_75128_a((EntityPlayer)this.field_72574_e, true);
            } else if (flag && flag2 && flag3 && this.field_72578_n < 200) {
                this.field_72578_n += 20;
                EntityItem entityitem = this.field_72574_e.func_71021_b(itemstack);
                if (entityitem != null) {
                    entityitem.func_70288_d();
                }
            }
        }
    }

    @Override
    public void func_72476_a(Packet106Transaction par1Packet106Transaction) {
        Short oshort = (Short)this.field_72586_s.func_76041_a(this.field_72574_e.field_71070_bA.field_75152_c);
        if (oshort != null && par1Packet106Transaction.field_73433_b == oshort && this.field_72574_e.field_71070_bA.field_75152_c == par1Packet106Transaction.field_73435_a && !this.field_72574_e.field_71070_bA.func_75129_b((EntityPlayer)this.field_72574_e)) {
            this.field_72574_e.field_71070_bA.func_75128_a((EntityPlayer)this.field_72574_e, true);
        }
    }

    @Override
    public void func_72487_a(Packet130UpdateSign par1Packet130UpdateSign) {
        WorldServer worldserver = this.field_72573_d.func_71218_a(this.field_72574_e.field_71093_bK);
        if (worldserver.func_72899_e(par1Packet130UpdateSign.field_73311_a, par1Packet130UpdateSign.field_73309_b, par1Packet130UpdateSign.field_73310_c)) {
            int j;
            TileEntitySign tileentitysign;
            TileEntity tileentity = worldserver.func_72796_p(par1Packet130UpdateSign.field_73311_a, par1Packet130UpdateSign.field_73309_b, par1Packet130UpdateSign.field_73310_c);
            if (tileentity instanceof TileEntitySign && (!(tileentitysign = (TileEntitySign)tileentity).func_70409_a() || tileentitysign.func_142009_b() != this.field_72574_e)) {
                this.field_72573_d.func_71236_h("Player " + this.field_72574_e.func_70005_c_() + " just tried to change non-editable sign");
                return;
            }
            for (j = 0; j < 4; ++j) {
                boolean flag = true;
                if (par1Packet130UpdateSign.field_73308_d[j].length() > 15) {
                    flag = false;
                } else {
                    for (int i = 0; i < par1Packet130UpdateSign.field_73308_d[j].length(); ++i) {
                        if (ChatAllowedCharacters.field_71568_a.indexOf(par1Packet130UpdateSign.field_73308_d[j].charAt(i)) >= 0) continue;
                        flag = false;
                    }
                }
                if (flag) continue;
                par1Packet130UpdateSign.field_73308_d[j] = "!?";
            }
            if (tileentity instanceof TileEntitySign) {
                j = par1Packet130UpdateSign.field_73311_a;
                int k = par1Packet130UpdateSign.field_73309_b;
                int i = par1Packet130UpdateSign.field_73310_c;
                TileEntitySign tileentitysign1 = (TileEntitySign)tileentity;
                System.arraycopy(par1Packet130UpdateSign.field_73308_d, 0, tileentitysign1.field_70412_a, 0, 4);
                tileentitysign1.func_70296_d();
                worldserver.func_72845_h(j, k, i);
            }
        }
    }

    @Override
    public void func_72477_a(Packet0KeepAlive par1Packet0KeepAlive) {
        if (par1Packet0KeepAlive.field_73592_a == this.field_72585_i) {
            int i = (int)(System.nanoTime() / 1000000L - this.field_72582_j);
            this.field_72574_e.field_71138_i = (this.field_72574_e.field_71138_i * 3 + i) / 4;
        }
    }

    @Override
    public boolean func_72489_a() {
        return true;
    }

    @Override
    public void func_72471_a(Packet202PlayerAbilities par1Packet202PlayerAbilities) {
        this.field_72574_e.field_71075_bZ.field_75100_b = par1Packet202PlayerAbilities.func_73350_f() && this.field_72574_e.field_71075_bZ.field_75101_c;
    }

    @Override
    public void func_72461_a(Packet203AutoComplete par1Packet203AutoComplete) {
        StringBuilder stringbuilder = new StringBuilder();
        for (String s : this.field_72573_d.func_71248_a((ICommandSender)this.field_72574_e, par1Packet203AutoComplete.func_73473_d())) {
            if (stringbuilder.length() > 0) {
                stringbuilder.append("\u0000");
            }
            stringbuilder.append(s);
        }
        this.field_72574_e.field_71135_a.func_72567_b((Packet)new Packet203AutoComplete(stringbuilder.toString()));
    }

    @Override
    public void func_72504_a(Packet204ClientInfo par1Packet204ClientInfo) {
        this.field_72574_e.func_71125_a(par1Packet204ClientInfo);
    }

    @Override
    public void func_72501_a(Packet250CustomPayload par1Packet250CustomPayload) {
        FMLNetworkHandler.handlePacket250Packet((Packet250CustomPayload)par1Packet250CustomPayload, (INetworkManager)this.field_72575_b, (NetHandler)this);
    }

    @Override
    public void handleVanilla250Packet(Packet250CustomPayload par1Packet250CustomPayload) {
        if ("MC|BEdit".equals(par1Packet250CustomPayload.field_73630_a)) {
            try {
                DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet250CustomPayload.field_73629_c));
                ItemStack itemstack = Packet.func_73276_c((DataInput)datainputstream);
                if (!ItemWritableBook.func_77829_a((NBTTagCompound)itemstack.func_77978_p())) {
                    throw new IOException("Invalid book tag!");
                }
                ItemStack itemstack1 = this.field_72574_e.field_71071_by.func_70448_g();
                if (itemstack != null && itemstack.field_77993_c == Item.field_77821_bF.field_77779_bT && itemstack.field_77993_c == itemstack1.field_77993_c) {
                    itemstack1.func_77983_a("pages", (NBTBase)itemstack.func_77978_p().func_74761_m("pages"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("MC|BSign".equals(par1Packet250CustomPayload.field_73630_a)) {
            try {
                DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet250CustomPayload.field_73629_c));
                ItemStack itemstack = Packet.func_73276_c((DataInput)datainputstream);
                if (!ItemEditableBook.func_77828_a((NBTTagCompound)itemstack.func_77978_p())) {
                    throw new IOException("Invalid book tag!");
                }
                ItemStack itemstack1 = this.field_72574_e.field_71071_by.func_70448_g();
                if (itemstack != null && itemstack.field_77993_c == Item.field_77823_bG.field_77779_bT && itemstack1.field_77993_c == Item.field_77821_bF.field_77779_bT) {
                    itemstack1.func_77983_a("author", (NBTBase)new NBTTagString("author", this.field_72574_e.func_70005_c_()));
                    itemstack1.func_77983_a("title", (NBTBase)new NBTTagString("title", itemstack.func_77978_p().func_74779_i("title")));
                    itemstack1.func_77983_a("pages", (NBTBase)itemstack.func_77978_p().func_74761_m("pages"));
                    itemstack1.field_77993_c = Item.field_77823_bG.field_77779_bT;
                }
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        } else if ("MC|TrSel".equals(par1Packet250CustomPayload.field_73630_a)) {
            try {
                DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet250CustomPayload.field_73629_c));
                int i = datainputstream.readInt();
                Container container = this.field_72574_e.field_71070_bA;
                if (container instanceof ContainerMerchant) {
                    ((ContainerMerchant)container).func_75175_c(i);
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        } else if ("MC|AdvCdm".equals(par1Packet250CustomPayload.field_73630_a)) {
            if (!this.field_72573_d.func_82356_Z()) {
                this.field_72574_e.func_70006_a(ChatMessageComponent.func_111077_e((String)"advMode.notEnabled"));
            } else if (this.field_72574_e.func_70003_b(2, "") && this.field_72574_e.field_71075_bZ.field_75098_d) {
                try {
                    DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet250CustomPayload.field_73629_c));
                    int i = datainputstream.readInt();
                    int j = datainputstream.readInt();
                    int k = datainputstream.readInt();
                    String s = Packet.func_73282_a((DataInput)datainputstream, (int)256);
                    TileEntity tileentity = this.field_72574_e.field_70170_p.func_72796_p(i, j, k);
                    if (tileentity != null && tileentity instanceof TileEntityCommandBlock) {
                        ((TileEntityCommandBlock)tileentity).func_82352_b(s);
                        this.field_72574_e.field_70170_p.func_72845_h(i, j, k);
                        this.field_72574_e.func_70006_a(ChatMessageComponent.func_111082_b((String)"advMode.setCommand.success", (Object[])new Object[]{s}));
                    }
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
            } else {
                this.field_72574_e.func_70006_a(ChatMessageComponent.func_111077_e((String)"advMode.notAllowed"));
            }
        } else if ("MC|Beacon".equals(par1Packet250CustomPayload.field_73630_a)) {
            if (this.field_72574_e.field_71070_bA instanceof ContainerBeacon) {
                try {
                    DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet250CustomPayload.field_73629_c));
                    int i = datainputstream.readInt();
                    int j = datainputstream.readInt();
                    ContainerBeacon containerbeacon = (ContainerBeacon)this.field_72574_e.field_71070_bA;
                    Slot slot = containerbeacon.func_75139_a(0);
                    if (slot.func_75216_d()) {
                        slot.func_75209_a(1);
                        TileEntityBeacon tileentitybeacon = containerbeacon.func_82863_d();
                        tileentitybeacon.func_82128_d(i);
                        tileentitybeacon.func_82127_e(j);
                        tileentitybeacon.func_70296_d();
                    }
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        } else if ("MC|ItemName".equals(par1Packet250CustomPayload.field_73630_a) && this.field_72574_e.field_71070_bA instanceof ContainerRepair) {
            ContainerRepair containerrepair = (ContainerRepair)this.field_72574_e.field_71070_bA;
            if (par1Packet250CustomPayload.field_73629_c != null && par1Packet250CustomPayload.field_73629_c.length >= 1) {
                String s1 = ChatAllowedCharacters.func_71565_a((String)new String(par1Packet250CustomPayload.field_73629_c));
                if (s1.length() <= 30) {
                    containerrepair.func_82850_a(s1);
                }
            } else {
                containerrepair.func_82850_a("");
            }
        }
    }

    @Override
    public boolean func_142032_c() {
        return this.field_72576_c;
    }

    @Override
    public void func_72494_a(Packet131MapData par1Packet131MapData) {
        FMLNetworkHandler.handlePacket131Packet((NetHandler)this, (Packet131MapData)par1Packet131MapData);
    }

    public EntityPlayerMP getPlayer() {
        return this.field_72574_e;
    }
}

