/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.logging.ILogAgent;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SharedMonsterAttributes {
    public static final Attribute field_111267_a = new RangedAttribute("generic.maxHealth", 20.0, 0.0, Double.MAX_VALUE).func_111117_a("Max Health").func_111112_a(true);
    public static final Attribute field_111265_b = new RangedAttribute("generic.followRange", 32.0, 0.0, 2048.0).func_111117_a("Follow Range");
    public static final Attribute field_111266_c = new RangedAttribute("generic.knockbackResistance", 0.0, 0.0, 1.0).func_111117_a("Knockback Resistance");
    public static final Attribute field_111263_d = new RangedAttribute("generic.movementSpeed", 0.7f, 0.0, Double.MAX_VALUE).func_111117_a("Movement Speed").func_111112_a(true);
    public static final Attribute field_111264_e = new RangedAttribute("generic.attackDamage", 2.0, 0.0, Double.MAX_VALUE);

    public static NBTTagList func_111257_a(BaseAttributeMap par0BaseAttributeMap) {
        NBTTagList nbttaglist = new NBTTagList();
        for (AttributeInstance attributeinstance : par0BaseAttributeMap.func_111146_a()) {
            nbttaglist.func_74742_a((NBTBase)SharedMonsterAttributes.func_111261_a(attributeinstance));
        }
        return nbttaglist;
    }

    private static NBTTagCompound func_111261_a(AttributeInstance par0AttributeInstance) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        Attribute attribute = par0AttributeInstance.func_111123_a();
        nbttagcompound.func_74778_a("Name", attribute.func_111108_a());
        nbttagcompound.func_74780_a("Base", par0AttributeInstance.func_111125_b());
        Collection collection = par0AttributeInstance.func_111122_c();
        if (collection != null && !collection.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (AttributeModifier attributemodifier : collection) {
                if (!attributemodifier.func_111165_e()) continue;
                nbttaglist.func_74742_a((NBTBase)SharedMonsterAttributes.func_111262_a(attributemodifier));
            }
            nbttagcompound.func_74782_a("Modifiers", (NBTBase)nbttaglist);
        }
        return nbttagcompound;
    }

    private static NBTTagCompound func_111262_a(AttributeModifier par0AttributeModifier) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("Name", par0AttributeModifier.func_111166_b());
        nbttagcompound.func_74780_a("Amount", par0AttributeModifier.func_111164_d());
        nbttagcompound.func_74768_a("Operation", par0AttributeModifier.func_111169_c());
        nbttagcompound.func_74772_a("UUIDMost", par0AttributeModifier.func_111167_a().getMostSignificantBits());
        nbttagcompound.func_74772_a("UUIDLeast", par0AttributeModifier.func_111167_a().getLeastSignificantBits());
        return nbttagcompound;
    }

    public static void func_111260_a(BaseAttributeMap par0BaseAttributeMap, NBTTagList par1NBTTagList, ILogAgent par2ILogAgent) {
        for (int i = 0; i < par1NBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)par1NBTTagList.func_74743_b(i);
            AttributeInstance attributeinstance = par0BaseAttributeMap.func_111152_a(nbttagcompound.func_74779_i("Name"));
            if (attributeinstance != null) {
                SharedMonsterAttributes.func_111258_a(attributeinstance, nbttagcompound);
                continue;
            }
            if (par2ILogAgent == null) continue;
            par2ILogAgent.func_98236_b("Ignoring unknown attribute '" + nbttagcompound.func_74779_i("Name") + "'");
        }
    }

    private static void func_111258_a(AttributeInstance par0AttributeInstance, NBTTagCompound par1NBTTagCompound) {
        par0AttributeInstance.func_111128_a(par1NBTTagCompound.func_74769_h("Base"));
        if (par1NBTTagCompound.func_74764_b("Modifiers")) {
            NBTTagList nbttaglist = par1NBTTagCompound.func_74761_m("Modifiers");
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                AttributeModifier attributemodifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)nbttaglist.func_74743_b(i));
                AttributeModifier attributemodifier1 = par0AttributeInstance.func_111127_a(attributemodifier.func_111167_a());
                if (attributemodifier1 != null) {
                    par0AttributeInstance.func_111124_b(attributemodifier1);
                }
                par0AttributeInstance.func_111121_a(attributemodifier);
            }
        }
    }

    public static AttributeModifier func_111259_a(NBTTagCompound par0NBTTagCompound) {
        UUID uuid = new UUID(par0NBTTagCompound.func_74763_f("UUIDMost"), par0NBTTagCompound.func_74763_f("UUIDLeast"));
        return new AttributeModifier(uuid, par0NBTTagCompound.func_74779_i("Name"), par0NBTTagCompound.func_74769_h("Amount"), par0NBTTagCompound.func_74762_e("Operation"));
    }
}

