/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.crash.CallableBlockDataValue;
import net.minecraft.crash.CallableBlockLocation;
import net.minecraft.crash.CallableBlockType;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategoryEntry;
import net.minecraft.util.MathHelper;

public class CrashReportCategory {
    private final CrashReport field_85078_a;
    private final String field_85076_b;
    private final List field_85077_c = new ArrayList();
    private StackTraceElement[] field_85075_d = new StackTraceElement[0];

    public CrashReportCategory(CrashReport par1CrashReport, String par2Str) {
        this.field_85078_a = par1CrashReport;
        this.field_85076_b = par2Str;
    }

    @SideOnly(value=Side.CLIENT)
    public static String func_85074_a(double par0, double par2, double par4) {
        return String.format("%.2f,%.2f,%.2f - %s", par0, par2, par4, CrashReportCategory.func_85071_a(MathHelper.func_76128_c((double)par0), MathHelper.func_76128_c((double)par2), MathHelper.func_76128_c((double)par4)));
    }

    public static String func_85071_a(int par0, int par1, int par2) {
        int l2;
        int k2;
        int j2;
        int i2;
        int l1;
        int k1;
        int j1;
        int i1;
        StringBuilder stringbuilder = new StringBuilder();
        try {
            stringbuilder.append(String.format("World: (%d,%d,%d)", par0, par1, par2));
        }
        catch (Throwable throwable) {
            stringbuilder.append("(Error finding world loc)");
        }
        stringbuilder.append(", ");
        try {
            int l = par0 >> 4;
            i1 = par2 >> 4;
            j1 = par0 & 0xF;
            k1 = par1 >> 4;
            l1 = par2 & 0xF;
            i2 = l << 4;
            j2 = i1 << 4;
            k2 = (l + 1 << 4) - 1;
            l2 = (i1 + 1 << 4) - 1;
            stringbuilder.append(String.format("Chunk: (at %d,%d,%d in %d,%d; contains blocks %d,0,%d to %d,255,%d)", j1, k1, l1, l, i1, i2, j2, k2, l2));
        }
        catch (Throwable throwable1) {
            stringbuilder.append("(Error finding chunk loc)");
        }
        stringbuilder.append(", ");
        try {
            int l = par0 >> 9;
            i1 = par2 >> 9;
            j1 = l << 5;
            k1 = i1 << 5;
            l1 = (l + 1 << 5) - 1;
            i2 = (i1 + 1 << 5) - 1;
            j2 = l << 9;
            k2 = i1 << 9;
            l2 = (l + 1 << 9) - 1;
            int i3 = (i1 + 1 << 9) - 1;
            stringbuilder.append(String.format("Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,0,%d to %d,255,%d)", l, i1, j1, k1, l1, i2, j2, k2, l2, i3));
        }
        catch (Throwable throwable2) {
            stringbuilder.append("(Error finding world loc)");
        }
        return stringbuilder.toString();
    }

    public void func_71500_a(String par1Str, Callable par2Callable) {
        try {
            this.func_71507_a(par1Str, par2Callable.call());
        }
        catch (Throwable throwable) {
            this.func_71499_a(par1Str, throwable);
        }
    }

    public void func_71507_a(String par1Str, Object par2Obj) {
        this.field_85077_c.add(new CrashReportCategoryEntry(par1Str, par2Obj));
    }

    public void func_71499_a(String par1Str, Throwable par2Throwable) {
        this.func_71507_a(par1Str, par2Throwable);
    }

    public int func_85073_a(int par1) {
        StackTraceElement[] astacktraceelement = Thread.currentThread().getStackTrace();
        int len = astacktraceelement.length - 3 - par1;
        if (len <= 0) {
            len = astacktraceelement.length;
        }
        this.field_85075_d = new StackTraceElement[len];
        System.arraycopy(astacktraceelement, astacktraceelement.length - len, this.field_85075_d, 0, this.field_85075_d.length);
        return this.field_85075_d.length;
    }

    public boolean func_85069_a(StackTraceElement par1StackTraceElement, StackTraceElement par2StackTraceElement) {
        if (this.field_85075_d.length != 0 && par1StackTraceElement != null) {
            StackTraceElement stacktraceelement2 = this.field_85075_d[0];
            if (stacktraceelement2.isNativeMethod() == par1StackTraceElement.isNativeMethod() && stacktraceelement2.getClassName().equals(par1StackTraceElement.getClassName()) && stacktraceelement2.getFileName().equals(par1StackTraceElement.getFileName()) && stacktraceelement2.getMethodName().equals(par1StackTraceElement.getMethodName())) {
                if (par2StackTraceElement != null != this.field_85075_d.length > 1) {
                    return false;
                }
                if (par2StackTraceElement != null && !this.field_85075_d[1].equals(par2StackTraceElement)) {
                    return false;
                }
                this.field_85075_d[0] = par1StackTraceElement;
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_85070_b(int par1) {
        StackTraceElement[] astacktraceelement = new StackTraceElement[this.field_85075_d.length - par1];
        System.arraycopy(this.field_85075_d, 0, astacktraceelement, 0, astacktraceelement.length);
        this.field_85075_d = astacktraceelement;
    }

    public void func_85072_a(StringBuilder par1StringBuilder) {
        par1StringBuilder.append("-- ").append(this.field_85076_b).append(" --\n");
        par1StringBuilder.append("Details:");
        for (CrashReportCategoryEntry crashreportcategoryentry : this.field_85077_c) {
            par1StringBuilder.append("\n\t");
            par1StringBuilder.append(crashreportcategoryentry.func_85089_a());
            par1StringBuilder.append(": ");
            par1StringBuilder.append(crashreportcategoryentry.func_85090_b());
        }
        if (this.field_85075_d != null && this.field_85075_d.length > 0) {
            par1StringBuilder.append("\nStacktrace:");
            for (StackTraceElement stacktraceelement : this.field_85075_d) {
                par1StringBuilder.append("\n\tat ");
                par1StringBuilder.append(stacktraceelement.toString());
            }
        }
    }

    public static void func_85068_a(CrashReportCategory par0CrashReportCategory, int par1, int par2, int par3, int par4, int par5) {
        par0CrashReportCategory.func_71500_a("Block type", (Callable)new CallableBlockType(par4));
        par0CrashReportCategory.func_71500_a("Block data value", (Callable)new CallableBlockDataValue(par5));
        par0CrashReportCategory.func_71500_a("Block location", (Callable)new CallableBlockLocation(par1, par2, par3));
    }
}

