/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.crash.CallableCrashMemoryReport;
import net.minecraft.crash.CallableIntCache;
import net.minecraft.crash.CallableJVMFlags;
import net.minecraft.crash.CallableJavaInfo;
import net.minecraft.crash.CallableJavaInfo2;
import net.minecraft.crash.CallableMemoryInfo;
import net.minecraft.crash.CallableMinecraftVersion;
import net.minecraft.crash.CallableOSInfo;
import net.minecraft.crash.CallableSuspiciousClasses;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.logging.ILogAgent;
import net.minecraft.util.ReportedException;

public class CrashReport {
    private final String field_71513_a;
    private final Throwable field_71511_b;
    private final CrashReportCategory field_85061_c = new CrashReportCategory(this, "System Details");
    private final List field_71512_c = new ArrayList();
    private File field_71510_d;
    private boolean field_85059_f = true;
    private StackTraceElement[] field_85060_g = new StackTraceElement[0];

    public CrashReport(String par1Str, Throwable par2Throwable) {
        this.field_71513_a = par1Str;
        this.field_71511_b = par2Throwable;
        this.func_71504_g();
    }

    private void func_71504_g() {
        this.field_85061_c.func_71500_a("Minecraft Version", (Callable)new CallableMinecraftVersion(this));
        this.field_85061_c.func_71500_a("Operating System", (Callable)new CallableOSInfo(this));
        this.field_85061_c.func_71500_a("Java Version", (Callable)new CallableJavaInfo(this));
        this.field_85061_c.func_71500_a("Java VM Version", (Callable)new CallableJavaInfo2(this));
        this.field_85061_c.func_71500_a("Memory", (Callable)new CallableMemoryInfo(this));
        this.field_85061_c.func_71500_a("JVM Flags", (Callable)new CallableJVMFlags(this));
        this.field_85061_c.func_71500_a("AABB Pool Size", (Callable)new CallableCrashMemoryReport(this));
        this.field_85061_c.func_71500_a("Suspicious classes", (Callable)new CallableSuspiciousClasses(this));
        this.field_85061_c.func_71500_a("IntCache", (Callable)new CallableIntCache(this));
        FMLCommonHandler.instance().enhanceCrashReport(this, this.field_85061_c);
    }

    public String func_71501_a() {
        return this.field_71513_a;
    }

    public Throwable func_71505_b() {
        return this.field_71511_b;
    }

    public void func_71506_a(StringBuilder par1StringBuilder) {
        if (this.field_85060_g != null && this.field_85060_g.length > 0) {
            par1StringBuilder.append("-- Head --\n");
            par1StringBuilder.append("Stacktrace:\n");
            for (StackTraceElement stacktraceelement : this.field_85060_g) {
                par1StringBuilder.append("\t").append("at ").append(stacktraceelement.toString());
                par1StringBuilder.append("\n");
            }
            par1StringBuilder.append("\n");
        }
        for (CrashReportCategory crashreportcategory : this.field_71512_c) {
            crashreportcategory.func_85072_a(par1StringBuilder);
            par1StringBuilder.append("\n\n");
        }
        this.field_85061_c.func_85072_a(par1StringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String func_71498_d() {
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        String s = this.field_71511_b.toString();
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            this.field_71511_b.printStackTrace(printwriter);
            s = stringwriter.toString();
        }
        finally {
            try {
                if (stringwriter != null) {
                    stringwriter.close();
                }
                if (printwriter != null) {
                    printwriter.close();
                }
            }
            catch (IOException ioexception) {}
        }
        return s;
    }

    public String func_71502_e() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Crash Report ----\n");
        stringbuilder.append("// ");
        stringbuilder.append(CrashReport.func_71503_h());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time: ");
        stringbuilder.append(new SimpleDateFormat().format(new Date()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.field_71513_a);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.func_71498_d());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.func_71506_a(stringbuilder);
        return stringbuilder.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public File func_71497_f() {
        return this.field_71510_d;
    }

    public boolean func_71508_a(File par1File, ILogAgent par2ILogAgent) {
        if (this.field_71510_d != null) {
            return false;
        }
        if (par1File.getParentFile() != null) {
            par1File.getParentFile().mkdirs();
        }
        try {
            FileWriter filewriter = new FileWriter(par1File);
            filewriter.write(this.func_71502_e());
            filewriter.close();
            this.field_71510_d = par1File;
            return true;
        }
        catch (Throwable throwable) {
            par2ILogAgent.func_98234_c("Could not save crash report to " + par1File, throwable);
            return false;
        }
    }

    public CrashReportCategory func_85056_g() {
        return this.field_85061_c;
    }

    public CrashReportCategory func_85058_a(String par1Str) {
        return this.func_85057_a(par1Str, 1);
    }

    public CrashReportCategory func_85057_a(String par1Str, int par2) {
        CrashReportCategory crashreportcategory = new CrashReportCategory(this, par1Str);
        if (this.field_85059_f) {
            int j = crashreportcategory.func_85073_a(par2);
            StackTraceElement[] astacktraceelement = this.field_71511_b.getStackTrace();
            StackTraceElement stacktraceelement = null;
            StackTraceElement stacktraceelement1 = null;
            int idx = astacktraceelement.length - j;
            if (astacktraceelement != null && idx < astacktraceelement.length && idx >= 0) {
                stacktraceelement = astacktraceelement[astacktraceelement.length - j];
                if (astacktraceelement.length + 1 - j < astacktraceelement.length) {
                    stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - j];
                }
            }
            this.field_85059_f = crashreportcategory.func_85069_a(stacktraceelement, stacktraceelement1);
            if (j > 0 && !this.field_71512_c.isEmpty()) {
                CrashReportCategory crashreportcategory1 = (CrashReportCategory)this.field_71512_c.get(this.field_71512_c.size() - 1);
                crashreportcategory1.func_85070_b(j);
            } else if (astacktraceelement != null && astacktraceelement.length >= j) {
                this.field_85060_g = new StackTraceElement[astacktraceelement.length - j];
                System.arraycopy(astacktraceelement, 0, this.field_85060_g, 0, this.field_85060_g.length);
            } else {
                this.field_85059_f = false;
            }
        }
        this.field_71512_c.add(crashreportcategory);
        return crashreportcategory;
    }

    private static String func_71503_h() {
        String[] astring = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!"};
        try {
            return astring[(int)(System.nanoTime() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport func_85055_a(Throwable par0Throwable, String par1Str) {
        CrashReport crashreport = par0Throwable instanceof ReportedException ? ((ReportedException)par0Throwable).func_71575_a() : new CrashReport(par1Str, par0Throwable);
        return crashreport;
    }
}

