/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.SecretKey;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenDemo;
import net.minecraft.client.gui.GuiScreenDisconnectedOnline;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityCrit2FX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityPickupFX;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.NpcMerchant;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingSand;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.MemoryConnection;
import net.minecraft.network.TcpConnection;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet0KeepAlive;
import net.minecraft.network.packet.Packet100OpenWindow;
import net.minecraft.network.packet.Packet101CloseWindow;
import net.minecraft.network.packet.Packet103SetSlot;
import net.minecraft.network.packet.Packet104WindowItems;
import net.minecraft.network.packet.Packet105UpdateProgressbar;
import net.minecraft.network.packet.Packet106Transaction;
import net.minecraft.network.packet.Packet10Flying;
import net.minecraft.network.packet.Packet130UpdateSign;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.network.packet.Packet133TileEditorOpen;
import net.minecraft.network.packet.Packet16BlockItemSwitch;
import net.minecraft.network.packet.Packet17Sleep;
import net.minecraft.network.packet.Packet18Animation;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.network.packet.Packet200Statistic;
import net.minecraft.network.packet.Packet201PlayerInfo;
import net.minecraft.network.packet.Packet202PlayerAbilities;
import net.minecraft.network.packet.Packet203AutoComplete;
import net.minecraft.network.packet.Packet205ClientCommand;
import net.minecraft.network.packet.Packet206SetObjective;
import net.minecraft.network.packet.Packet207SetScore;
import net.minecraft.network.packet.Packet208SetDisplayObjective;
import net.minecraft.network.packet.Packet209SetPlayerTeam;
import net.minecraft.network.packet.Packet20NamedEntitySpawn;
import net.minecraft.network.packet.Packet22Collect;
import net.minecraft.network.packet.Packet23VehicleSpawn;
import net.minecraft.network.packet.Packet24MobSpawn;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet252SharedKey;
import net.minecraft.network.packet.Packet253ServerAuthData;
import net.minecraft.network.packet.Packet255KickDisconnect;
import net.minecraft.network.packet.Packet25EntityPainting;
import net.minecraft.network.packet.Packet26EntityExpOrb;
import net.minecraft.network.packet.Packet28EntityVelocity;
import net.minecraft.network.packet.Packet29DestroyEntity;
import net.minecraft.network.packet.Packet30Entity;
import net.minecraft.network.packet.Packet34EntityTeleport;
import net.minecraft.network.packet.Packet35EntityHeadRotation;
import net.minecraft.network.packet.Packet38EntityStatus;
import net.minecraft.network.packet.Packet39AttachEntity;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.network.packet.Packet40EntityMetadata;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet42RemoveEntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet44UpdateAttributes;
import net.minecraft.network.packet.Packet44UpdateAttributesSnapshot;
import net.minecraft.network.packet.Packet4UpdateTime;
import net.minecraft.network.packet.Packet51MapChunk;
import net.minecraft.network.packet.Packet52MultiBlockChange;
import net.minecraft.network.packet.Packet53BlockChange;
import net.minecraft.network.packet.Packet54PlayNoteBlock;
import net.minecraft.network.packet.Packet55BlockDestroy;
import net.minecraft.network.packet.Packet56MapChunks;
import net.minecraft.network.packet.Packet5PlayerInventory;
import net.minecraft.network.packet.Packet60Explosion;
import net.minecraft.network.packet.Packet61DoorChange;
import net.minecraft.network.packet.Packet62LevelSound;
import net.minecraft.network.packet.Packet63WorldParticles;
import net.minecraft.network.packet.Packet6SpawnPosition;
import net.minecraft.network.packet.Packet70GameEvent;
import net.minecraft.network.packet.Packet71Weather;
import net.minecraft.network.packet.Packet8UpdateHealth;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScoreObjectiveCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.CryptManager;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class NetClientHandler
extends NetHandler {
    private boolean field_72554_f;
    private INetworkManager field_72555_g;
    public String field_72560_a;
    private Minecraft field_72563_h;
    private WorldClient field_72564_i;
    private boolean field_72561_j;
    public MapStorage field_72558_b = new MapStorage((ISaveHandler)null);
    private Map field_72562_k = new HashMap();
    public List field_72559_c = new ArrayList();
    public int field_72556_d = 20;
    private GuiScreen field_98183_l;
    Random field_72557_e = new Random();
    private static byte connectionCompatibilityLevel;

    public NetClientHandler(Minecraft par1Minecraft, String par2Str, int par3) throws IOException {
        this.field_72563_h = par1Minecraft;
        Socket socket = new Socket(InetAddress.getByName(par2Str), par3);
        this.field_72555_g = new TcpConnection(par1Minecraft.func_98033_al(), socket, "Client", (NetHandler)this);
        FMLNetworkHandler.onClientConnectionToRemoteServer((NetHandler)this, (String)par2Str, (int)par3, (INetworkManager)this.field_72555_g);
    }

    public NetClientHandler(Minecraft par1Minecraft, String par2Str, int par3, GuiScreen par4GuiScreen) throws IOException {
        this.field_72563_h = par1Minecraft;
        this.field_98183_l = par4GuiScreen;
        Socket socket = new Socket(InetAddress.getByName(par2Str), par3);
        this.field_72555_g = new TcpConnection(par1Minecraft.func_98033_al(), socket, "Client", (NetHandler)this);
        FMLNetworkHandler.onClientConnectionToRemoteServer((NetHandler)this, (String)par2Str, (int)par3, (INetworkManager)this.field_72555_g);
    }

    public NetClientHandler(Minecraft par1Minecraft, IntegratedServer par2IntegratedServer) throws IOException {
        this.field_72563_h = par1Minecraft;
        this.field_72555_g = new MemoryConnection(par1Minecraft.func_98033_al(), (NetHandler)this);
        par2IntegratedServer.func_71343_a().func_71754_a((MemoryConnection)this.field_72555_g, par1Minecraft.func_110432_I().func_111285_a());
        FMLNetworkHandler.onClientConnectionToIntegratedServer((NetHandler)this, (MinecraftServer)par2IntegratedServer, (INetworkManager)this.field_72555_g);
    }

    public void func_72547_c() {
        if (this.field_72555_g != null) {
            this.field_72555_g.func_74427_a();
        }
        this.field_72555_g = null;
        this.field_72564_i = null;
    }

    public void func_72551_d() {
        if (!this.field_72554_f && this.field_72555_g != null) {
            this.field_72555_g.func_74428_b();
        }
        if (this.field_72555_g != null) {
            this.field_72555_g.func_74427_a();
        }
    }

    @Override
    public void func_72470_a(Packet253ServerAuthData par1Packet253ServerAuthData) {
        String s = par1Packet253ServerAuthData.func_73377_d().trim();
        PublicKey publickey = par1Packet253ServerAuthData.func_73376_f();
        SecretKey secretkey = CryptManager.func_75890_a();
        if (!"-".equals(s)) {
            String s1 = new BigInteger(CryptManager.func_75895_a((String)s, (PublicKey)publickey, (SecretKey)secretkey)).toString(16);
            String s2 = this.func_72550_a(this.field_72563_h.func_110432_I().func_111285_a(), this.field_72563_h.func_110432_I().func_111286_b(), s1);
            if (!"ok".equalsIgnoreCase(s2)) {
                this.field_72555_g.func_74424_a("disconnect.loginFailedInfo", new Object[]{s2});
                return;
            }
        }
        this.func_72552_c((Packet)new Packet252SharedKey(secretkey, publickey, par1Packet253ServerAuthData.func_73378_g()));
    }

    private String func_72550_a(String par1Str, String par2Str, String par3Str) {
        try {
            URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + NetClientHandler.func_72549_a(par1Str) + "&sessionId=" + NetClientHandler.func_72549_a(par2Str) + "&serverId=" + NetClientHandler.func_72549_a(par3Str));
            InputStream inputstream = url.openConnection(this.field_72563_h.func_110437_J()).getInputStream();
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream));
            String s3 = bufferedreader.readLine();
            bufferedreader.close();
            return s3;
        }
        catch (IOException ioexception) {
            return ioexception.toString();
        }
    }

    private static String func_72549_a(String par0Str) throws IOException {
        return URLEncoder.encode(par0Str, "UTF-8");
    }

    @Override
    public void func_72513_a(Packet252SharedKey par1Packet252SharedKey) {
        this.func_72552_c((Packet)FMLNetworkHandler.getFMLFakeLoginPacket());
        this.func_72552_c((Packet)new Packet205ClientCommand(0));
    }

    @Override
    public void func_72455_a(Packet1Login par1Packet1Login) {
        this.field_72563_h.field_71442_b = new PlayerControllerMP(this.field_72563_h, this);
        this.field_72563_h.field_71413_E.func_77450_a(StatList.field_75950_i, 1);
        this.field_72564_i = new WorldClient(this, new WorldSettings(0L, par1Packet1Login.field_73557_d, false, par1Packet1Login.field_73560_c, par1Packet1Login.field_73559_b), par1Packet1Login.field_73558_e, par1Packet1Login.field_73555_f, this.field_72563_h.field_71424_I, this.field_72563_h.func_98033_al());
        this.field_72564_i.field_72995_K = true;
        this.field_72563_h.func_71403_a(this.field_72564_i);
        this.field_72563_h.field_71439_g.field_71093_bK = par1Packet1Login.field_73558_e;
        this.field_72563_h.func_71373_a((GuiScreen)new GuiDownloadTerrain(this));
        this.field_72563_h.field_71439_g.field_70157_k = par1Packet1Login.field_73561_a;
        this.field_72556_d = par1Packet1Login.field_73562_h;
        this.field_72563_h.field_71442_b.func_78746_a(par1Packet1Login.field_73557_d);
        FMLNetworkHandler.onConnectionEstablishedToServer((NetHandler)this, (INetworkManager)this.field_72555_g, (Packet1Login)par1Packet1Login);
        this.field_72563_h.field_71474_y.func_82879_c();
        this.field_72555_g.func_74429_a((Packet)new Packet250CustomPayload("MC|Brand", ClientBrandRetriever.getClientModName().getBytes(Charsets.UTF_8)));
    }

    @Override
    public void func_72511_a(Packet23VehicleSpawn par1Packet23VehicleSpawn) {
        double d0 = (double)par1Packet23VehicleSpawn.field_73524_b / 32.0;
        double d1 = (double)par1Packet23VehicleSpawn.field_73525_c / 32.0;
        double d2 = (double)par1Packet23VehicleSpawn.field_73522_d / 32.0;
        Object object = null;
        if (par1Packet23VehicleSpawn.field_73527_h == 10) {
            object = EntityMinecart.func_94090_a((World)this.field_72564_i, (double)d0, (double)d1, (double)d2, (int)par1Packet23VehicleSpawn.field_73528_i);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 90) {
            Entity entity = this.func_72545_a(par1Packet23VehicleSpawn.field_73528_i);
            if (entity instanceof EntityPlayer) {
                object = new EntityFishHook((World)this.field_72564_i, d0, d1, d2, (EntityPlayer)entity);
            }
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 60) {
            object = new EntityArrow((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 61) {
            object = new EntitySnowball((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 71) {
            object = new EntityItemFrame((World)this.field_72564_i, (int)d0, (int)d1, (int)d2, par1Packet23VehicleSpawn.field_73528_i);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 77) {
            object = new EntityLeashKnot((World)this.field_72564_i, (int)d0, (int)d1, (int)d2);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 65) {
            object = new EntityEnderPearl((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 72) {
            object = new EntityEnderEye((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 76) {
            object = new EntityFireworkRocket(this.field_72564_i, d0, d1, d2, null);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 63) {
            object = new EntityLargeFireball((World)this.field_72564_i, d0, d1, d2, (double)par1Packet23VehicleSpawn.field_73523_e / 8000.0, (double)par1Packet23VehicleSpawn.field_73520_f / 8000.0, (double)par1Packet23VehicleSpawn.field_73521_g / 8000.0);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 64) {
            object = new EntitySmallFireball((World)this.field_72564_i, d0, d1, d2, (double)par1Packet23VehicleSpawn.field_73523_e / 8000.0, (double)par1Packet23VehicleSpawn.field_73520_f / 8000.0, (double)par1Packet23VehicleSpawn.field_73521_g / 8000.0);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 66) {
            object = new EntityWitherSkull((World)this.field_72564_i, d0, d1, d2, (double)par1Packet23VehicleSpawn.field_73523_e / 8000.0, (double)par1Packet23VehicleSpawn.field_73520_f / 8000.0, (double)par1Packet23VehicleSpawn.field_73521_g / 8000.0);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 62) {
            object = new EntityEgg((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 73) {
            object = new EntityPotion((World)this.field_72564_i, d0, d1, d2, par1Packet23VehicleSpawn.field_73528_i);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 75) {
            object = new EntityExpBottle((World)this.field_72564_i, d0, d1, d2);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        } else if (par1Packet23VehicleSpawn.field_73527_h == 1) {
            object = new EntityBoat(this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 50) {
            object = new EntityTNTPrimed((World)this.field_72564_i, d0, d1, d2, (EntityLivingBase)null);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 51) {
            object = new EntityEnderCrystal((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 2) {
            object = new EntityItem((World)this.field_72564_i, d0, d1, d2);
        } else if (par1Packet23VehicleSpawn.field_73527_h == 70) {
            object = new EntityFallingSand((World)this.field_72564_i, d0, d1, d2, par1Packet23VehicleSpawn.field_73528_i & 0xFFFF, par1Packet23VehicleSpawn.field_73528_i >> 16);
            par1Packet23VehicleSpawn.field_73528_i = 0;
        }
        if (object != null) {
            ((Entity)object).field_70118_ct = par1Packet23VehicleSpawn.field_73524_b;
            ((Entity)object).field_70117_cu = par1Packet23VehicleSpawn.field_73525_c;
            ((Entity)object).field_70116_cv = par1Packet23VehicleSpawn.field_73522_d;
            ((Entity)object).field_70125_A = (float)(par1Packet23VehicleSpawn.field_92077_h * 360) / 256.0f;
            ((Entity)object).field_70177_z = (float)(par1Packet23VehicleSpawn.field_92078_i * 360) / 256.0f;
            Entity[] aentity = ((Entity)object).func_70021_al();
            if (aentity != null) {
                int i = par1Packet23VehicleSpawn.field_73526_a - ((Entity)object).field_70157_k;
                for (int j = 0; j < aentity.length; ++j) {
                    aentity[j].field_70157_k += i;
                }
            }
            ((Entity)object).field_70157_k = par1Packet23VehicleSpawn.field_73526_a;
            this.field_72564_i.func_73027_a(par1Packet23VehicleSpawn.field_73526_a, (Entity)object);
            if (par1Packet23VehicleSpawn.field_73528_i > 0) {
                Entity entity1;
                if (par1Packet23VehicleSpawn.field_73527_h == 60 && (entity1 = this.func_72545_a(par1Packet23VehicleSpawn.field_73528_i)) instanceof EntityLivingBase) {
                    EntityArrow entityarrow = (EntityArrow)object;
                    entityarrow.field_70250_c = entity1;
                }
                ((Entity)object).func_70016_h((double)par1Packet23VehicleSpawn.field_73523_e / 8000.0, (double)par1Packet23VehicleSpawn.field_73520_f / 8000.0, (double)par1Packet23VehicleSpawn.field_73521_g / 8000.0);
            }
        }
    }

    @Override
    public void func_72514_a(Packet26EntityExpOrb par1Packet26EntityExpOrb) {
        EntityXPOrb entityxporb = new EntityXPOrb((World)this.field_72564_i, (double)par1Packet26EntityExpOrb.field_73531_b, (double)par1Packet26EntityExpOrb.field_73532_c, (double)par1Packet26EntityExpOrb.field_73529_d, par1Packet26EntityExpOrb.field_73530_e);
        entityxporb.field_70118_ct = par1Packet26EntityExpOrb.field_73531_b;
        entityxporb.field_70117_cu = par1Packet26EntityExpOrb.field_73532_c;
        entityxporb.field_70116_cv = par1Packet26EntityExpOrb.field_73529_d;
        entityxporb.field_70177_z = 0.0f;
        entityxporb.field_70125_A = 0.0f;
        entityxporb.field_70157_k = par1Packet26EntityExpOrb.field_73533_a;
        this.field_72564_i.func_73027_a(par1Packet26EntityExpOrb.field_73533_a, (Entity)entityxporb);
    }

    @Override
    public void func_72508_a(Packet71Weather par1Packet71Weather) {
        double d0 = (double)par1Packet71Weather.field_73536_b / 32.0;
        double d1 = (double)par1Packet71Weather.field_73537_c / 32.0;
        double d2 = (double)par1Packet71Weather.field_73534_d / 32.0;
        EntityLightningBolt entitylightningbolt = null;
        if (par1Packet71Weather.field_73535_e == 1) {
            entitylightningbolt = new EntityLightningBolt((World)this.field_72564_i, d0, d1, d2);
        }
        if (entitylightningbolt != null) {
            entitylightningbolt.field_70118_ct = par1Packet71Weather.field_73536_b;
            entitylightningbolt.field_70117_cu = par1Packet71Weather.field_73537_c;
            entitylightningbolt.field_70116_cv = par1Packet71Weather.field_73534_d;
            entitylightningbolt.field_70177_z = 0.0f;
            entitylightningbolt.field_70125_A = 0.0f;
            entitylightningbolt.field_70157_k = par1Packet71Weather.field_73538_a;
            this.field_72564_i.func_72942_c((Entity)entitylightningbolt);
        }
    }

    @Override
    public void func_72495_a(Packet25EntityPainting par1Packet25EntityPainting) {
        EntityPainting entitypainting = new EntityPainting((World)this.field_72564_i, par1Packet25EntityPainting.field_73506_b, par1Packet25EntityPainting.field_73507_c, par1Packet25EntityPainting.field_73504_d, par1Packet25EntityPainting.field_73505_e, par1Packet25EntityPainting.field_73503_f);
        this.field_72564_i.func_73027_a(par1Packet25EntityPainting.field_73508_a, (Entity)entitypainting);
    }

    @Override
    public void func_72520_a(Packet28EntityVelocity par1Packet28EntityVelocity) {
        Entity entity = this.func_72545_a(par1Packet28EntityVelocity.field_73390_a);
        if (entity != null) {
            entity.func_70016_h((double)par1Packet28EntityVelocity.field_73388_b / 8000.0, (double)par1Packet28EntityVelocity.field_73389_c / 8000.0, (double)par1Packet28EntityVelocity.field_73387_d / 8000.0);
        }
    }

    @Override
    public void func_72493_a(Packet40EntityMetadata par1Packet40EntityMetadata) {
        Entity entity = this.func_72545_a(par1Packet40EntityMetadata.field_73393_a);
        if (entity != null && par1Packet40EntityMetadata.func_73391_d() != null) {
            entity.func_70096_w().func_75687_a(par1Packet40EntityMetadata.func_73391_d());
        }
    }

    @Override
    public void func_72518_a(Packet20NamedEntitySpawn par1Packet20NamedEntitySpawn) {
        double d0 = (double)par1Packet20NamedEntitySpawn.field_73515_c / 32.0;
        double d1 = (double)par1Packet20NamedEntitySpawn.field_73512_d / 32.0;
        double d2 = (double)par1Packet20NamedEntitySpawn.field_73513_e / 32.0;
        float f = (float)(par1Packet20NamedEntitySpawn.field_73510_f * 360) / 256.0f;
        float f1 = (float)(par1Packet20NamedEntitySpawn.field_73511_g * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP((World)this.field_72563_h.field_71441_e, par1Packet20NamedEntitySpawn.field_73514_b);
        entityotherplayermp.field_70118_ct = par1Packet20NamedEntitySpawn.field_73515_c;
        entityotherplayermp.field_70169_q = entityotherplayermp.field_70142_S = (double)entityotherplayermp.field_70118_ct;
        entityotherplayermp.field_70117_cu = par1Packet20NamedEntitySpawn.field_73512_d;
        entityotherplayermp.field_70167_r = entityotherplayermp.field_70137_T = (double)entityotherplayermp.field_70117_cu;
        entityotherplayermp.field_70116_cv = par1Packet20NamedEntitySpawn.field_73513_e;
        entityotherplayermp.field_70166_s = entityotherplayermp.field_70136_U = (double)entityotherplayermp.field_70116_cv;
        int i = par1Packet20NamedEntitySpawn.field_73518_h;
        entityotherplayermp.field_71071_by.field_70462_a[entityotherplayermp.field_71071_by.field_70461_c] = i == 0 ? null : new ItemStack(i, 1, 0);
        entityotherplayermp.func_70080_a(d0, d1, d2, f, f1);
        this.field_72564_i.func_73027_a(par1Packet20NamedEntitySpawn.field_73516_a, (Entity)entityotherplayermp);
        List list = par1Packet20NamedEntitySpawn.func_73509_c();
        if (list != null) {
            entityotherplayermp.func_70096_w().func_75687_a(list);
        }
    }

    @Override
    public void func_72512_a(Packet34EntityTeleport par1Packet34EntityTeleport) {
        Entity entity = this.func_72545_a(par1Packet34EntityTeleport.field_73319_a);
        if (entity != null) {
            entity.field_70118_ct = par1Packet34EntityTeleport.field_73317_b;
            entity.field_70117_cu = par1Packet34EntityTeleport.field_73318_c;
            entity.field_70116_cv = par1Packet34EntityTeleport.field_73315_d;
            double d0 = (double)entity.field_70118_ct / 32.0;
            double d1 = (double)entity.field_70117_cu / 32.0 + 0.015625;
            double d2 = (double)entity.field_70116_cv / 32.0;
            float f = (float)(par1Packet34EntityTeleport.field_73316_e * 360) / 256.0f;
            float f1 = (float)(par1Packet34EntityTeleport.field_73314_f * 360) / 256.0f;
            entity.func_70056_a(d0, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void func_72502_a(Packet16BlockItemSwitch par1Packet16BlockItemSwitch) {
        if (par1Packet16BlockItemSwitch.field_73386_a >= 0 && par1Packet16BlockItemSwitch.field_73386_a < InventoryPlayer.func_70451_h()) {
            this.field_72563_h.field_71439_g.field_71071_by.field_70461_c = par1Packet16BlockItemSwitch.field_73386_a;
        }
    }

    @Override
    public void func_72482_a(Packet30Entity par1Packet30Entity) {
        Entity entity = this.func_72545_a(par1Packet30Entity.field_73554_a);
        if (entity != null) {
            entity.field_70118_ct += par1Packet30Entity.field_73552_b;
            entity.field_70117_cu += par1Packet30Entity.field_73553_c;
            entity.field_70116_cv += par1Packet30Entity.field_73550_d;
            double d0 = (double)entity.field_70118_ct / 32.0;
            double d1 = (double)entity.field_70117_cu / 32.0;
            double d2 = (double)entity.field_70116_cv / 32.0;
            float f = par1Packet30Entity.field_73549_g ? (float)(par1Packet30Entity.field_73551_e * 360) / 256.0f : entity.field_70177_z;
            float f1 = par1Packet30Entity.field_73549_g ? (float)(par1Packet30Entity.field_73548_f * 360) / 256.0f : entity.field_70125_A;
            entity.func_70056_a(d0, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void func_72478_a(Packet35EntityHeadRotation par1Packet35EntityHeadRotation) {
        Entity entity = this.func_72545_a(par1Packet35EntityHeadRotation.field_73383_a);
        if (entity != null) {
            float f = (float)(par1Packet35EntityHeadRotation.field_73382_b * 360) / 256.0f;
            entity.func_70034_d(f);
        }
    }

    @Override
    public void func_72491_a(Packet29DestroyEntity par1Packet29DestroyEntity) {
        for (int i = 0; i < par1Packet29DestroyEntity.field_73368_a.length; ++i) {
            this.field_72564_i.func_73028_b(par1Packet29DestroyEntity.field_73368_a[i]);
        }
    }

    @Override
    public void func_72498_a(Packet10Flying par1Packet10Flying) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        double d0 = entityclientplayermp.field_70165_t;
        double d1 = entityclientplayermp.field_70163_u;
        double d2 = entityclientplayermp.field_70161_v;
        float f = entityclientplayermp.field_70177_z;
        float f1 = entityclientplayermp.field_70125_A;
        if (par1Packet10Flying.field_73546_h) {
            d0 = par1Packet10Flying.field_73545_a;
            d1 = par1Packet10Flying.field_73543_b;
            d2 = par1Packet10Flying.field_73544_c;
        }
        if (par1Packet10Flying.field_73547_i) {
            f = par1Packet10Flying.field_73542_e;
            f1 = par1Packet10Flying.field_73539_f;
        }
        entityclientplayermp.field_70139_V = 0.0f;
        entityclientplayermp.field_70179_y = 0.0;
        entityclientplayermp.field_70181_x = 0.0;
        entityclientplayermp.field_70159_w = 0.0;
        entityclientplayermp.func_70080_a(d0, d1, d2, f, f1);
        par1Packet10Flying.field_73545_a = entityclientplayermp.field_70165_t;
        par1Packet10Flying.field_73543_b = entityclientplayermp.field_70121_D.field_72338_b;
        par1Packet10Flying.field_73544_c = entityclientplayermp.field_70161_v;
        par1Packet10Flying.field_73541_d = entityclientplayermp.field_70163_u;
        this.field_72555_g.func_74429_a((Packet)par1Packet10Flying);
        if (!this.field_72561_j) {
            this.field_72563_h.field_71439_g.field_70169_q = this.field_72563_h.field_71439_g.field_70165_t;
            this.field_72563_h.field_71439_g.field_70167_r = this.field_72563_h.field_71439_g.field_70163_u;
            this.field_72563_h.field_71439_g.field_70166_s = this.field_72563_h.field_71439_g.field_70161_v;
            this.field_72561_j = true;
            this.field_72563_h.func_71373_a(null);
        }
    }

    @Override
    public void func_72496_a(Packet52MultiBlockChange par1Packet52MultiBlockChange) {
        int i = par1Packet52MultiBlockChange.field_73452_a * 16;
        int j = par1Packet52MultiBlockChange.field_73450_b * 16;
        if (par1Packet52MultiBlockChange.field_73451_c != null) {
            DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet52MultiBlockChange.field_73451_c));
            try {
                for (int k = 0; k < par1Packet52MultiBlockChange.field_73448_d; ++k) {
                    short short1 = datainputstream.readShort();
                    short short2 = datainputstream.readShort();
                    int l = short2 >> 4 & 0xFFF;
                    int i1 = short2 & 0xF;
                    int j1 = short1 >> 12 & 0xF;
                    int k1 = short1 >> 8 & 0xF;
                    int l1 = short1 & 0xFF;
                    this.field_72564_i.func_73023_g(j1 + i, l1, k1 + j, l, i1);
                }
            }
            catch (IOException ioexception) {
                // empty catch block
            }
        }
    }

    @Override
    public void func_72463_a(Packet51MapChunk par1Packet51MapChunk) {
        if (par1Packet51MapChunk.field_73598_e) {
            if (par1Packet51MapChunk.field_73600_c == 0) {
                this.field_72564_i.func_73025_a(par1Packet51MapChunk.field_73601_a, par1Packet51MapChunk.field_73599_b, false);
                return;
            }
            this.field_72564_i.func_73025_a(par1Packet51MapChunk.field_73601_a, par1Packet51MapChunk.field_73599_b, true);
        }
        this.field_72564_i.func_73031_a(par1Packet51MapChunk.field_73601_a << 4, 0, par1Packet51MapChunk.field_73599_b << 4, (par1Packet51MapChunk.field_73601_a << 4) + 15, 256, (par1Packet51MapChunk.field_73599_b << 4) + 15);
        Chunk chunk = this.field_72564_i.func_72964_e(par1Packet51MapChunk.field_73601_a, par1Packet51MapChunk.field_73599_b);
        if (par1Packet51MapChunk.field_73598_e && chunk == null) {
            this.field_72564_i.func_73025_a(par1Packet51MapChunk.field_73601_a, par1Packet51MapChunk.field_73599_b, true);
            chunk = this.field_72564_i.func_72964_e(par1Packet51MapChunk.field_73601_a, par1Packet51MapChunk.field_73599_b);
        }
        if (chunk != null) {
            chunk.func_76607_a(par1Packet51MapChunk.func_73593_d(), par1Packet51MapChunk.field_73600_c, par1Packet51MapChunk.field_73597_d, par1Packet51MapChunk.field_73598_e);
            this.field_72564_i.func_72909_d(par1Packet51MapChunk.field_73601_a << 4, 0, par1Packet51MapChunk.field_73599_b << 4, (par1Packet51MapChunk.field_73601_a << 4) + 15, 256, (par1Packet51MapChunk.field_73599_b << 4) + 15);
            if (!par1Packet51MapChunk.field_73598_e || !(this.field_72564_i.field_73011_w instanceof WorldProviderSurface)) {
                chunk.func_76613_n();
            }
        }
    }

    @Override
    public void func_72456_a(Packet53BlockChange par1Packet53BlockChange) {
        this.field_72564_i.func_73023_g(par1Packet53BlockChange.field_73425_a, par1Packet53BlockChange.field_73423_b, par1Packet53BlockChange.field_73424_c, par1Packet53BlockChange.field_73421_d, par1Packet53BlockChange.field_73422_e);
    }

    @Override
    public void func_72492_a(Packet255KickDisconnect par1Packet255KickDisconnect) {
        this.field_72555_g.func_74424_a("disconnect.kicked", new Object[]{par1Packet255KickDisconnect.field_73631_a});
        this.field_72554_f = true;
        this.field_72563_h.func_71403_a(null);
        if (this.field_98183_l != null) {
            this.field_72563_h.func_71373_a((GuiScreen)new GuiScreenDisconnectedOnline(this.field_98183_l, "disconnect.disconnected", "disconnect.genericReason", new Object[]{par1Packet255KickDisconnect.field_73631_a}));
        } else {
            this.field_72563_h.func_71373_a((GuiScreen)new GuiDisconnected((GuiScreen)new GuiMultiplayer((GuiScreen)new GuiMainMenu()), "disconnect.disconnected", "disconnect.genericReason", new Object[]{par1Packet255KickDisconnect.field_73631_a}));
        }
    }

    @Override
    public void func_72515_a(String par1Str, Object[] par2ArrayOfObj) {
        if (!this.field_72554_f) {
            this.field_72554_f = true;
            this.field_72563_h.func_71403_a(null);
            if (this.field_98183_l != null) {
                this.field_72563_h.func_71373_a((GuiScreen)new GuiScreenDisconnectedOnline(this.field_98183_l, "disconnect.lost", par1Str, par2ArrayOfObj));
            } else {
                this.field_72563_h.func_71373_a((GuiScreen)new GuiDisconnected((GuiScreen)new GuiMultiplayer((GuiScreen)new GuiMainMenu()), "disconnect.lost", par1Str, par2ArrayOfObj));
            }
        }
    }

    public void func_72546_b(Packet par1Packet) {
        if (!this.field_72554_f) {
            this.field_72555_g.func_74429_a(par1Packet);
            this.field_72555_g.func_74423_d();
            FMLNetworkHandler.onConnectionClosed((INetworkManager)this.field_72555_g, (EntityPlayer)this.getPlayer());
        }
    }

    public void func_72552_c(Packet par1Packet) {
        if (!this.field_72554_f) {
            this.field_72555_g.func_74429_a(par1Packet);
        }
    }

    @Override
    public void func_72475_a(Packet22Collect par1Packet22Collect) {
        Entity entity = this.func_72545_a(par1Packet22Collect.field_73313_a);
        Object object = (EntityLivingBase)this.func_72545_a(par1Packet22Collect.field_73312_b);
        if (object == null) {
            object = this.field_72563_h.field_71439_g;
        }
        if (entity != null) {
            if (entity instanceof EntityXPOrb) {
                this.field_72564_i.func_72956_a(entity, "random.orb", 0.2f, ((this.field_72557_e.nextFloat() - this.field_72557_e.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            } else {
                this.field_72564_i.func_72956_a(entity, "random.pop", 0.2f, ((this.field_72557_e.nextFloat() - this.field_72557_e.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            this.field_72563_h.field_71452_i.func_78873_a((EntityFX)new EntityPickupFX((World)this.field_72563_h.field_71441_e, entity, (Entity)object, -0.5f));
            this.field_72564_i.func_73028_b(par1Packet22Collect.field_73313_a);
        }
    }

    @Override
    public void func_72481_a(Packet3Chat par1Packet3Chat) {
        par1Packet3Chat = FMLNetworkHandler.handleChatMessage((NetHandler)this, (Packet3Chat)par1Packet3Chat);
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(par1Packet3Chat.field_73476_b);
        if (!MinecraftForge.EVENT_BUS.post((Event)event) && event.message != null) {
            this.field_72563_h.field_71456_v.func_73827_b().func_73765_a(ChatMessageComponent.func_111078_c((String)event.message).func_111068_a(true));
        }
    }

    @Override
    public void func_72524_a(Packet18Animation par1Packet18Animation) {
        Entity entity = this.func_72545_a(par1Packet18Animation.field_73470_a);
        if (entity != null) {
            if (par1Packet18Animation.field_73469_b == 1) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                entitylivingbase.func_71038_i();
            } else if (par1Packet18Animation.field_73469_b == 2) {
                entity.func_70057_ab();
            } else if (par1Packet18Animation.field_73469_b == 3) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.func_70999_a(false, false, false);
            } else if (par1Packet18Animation.field_73469_b != 4) {
                if (par1Packet18Animation.field_73469_b == 6) {
                    this.field_72563_h.field_71452_i.func_78873_a((EntityFX)new EntityCrit2FX((World)this.field_72563_h.field_71441_e, entity));
                } else if (par1Packet18Animation.field_73469_b == 7) {
                    EntityCrit2FX entitycrit2fx = new EntityCrit2FX((World)this.field_72563_h.field_71441_e, entity, "magicCrit");
                    this.field_72563_h.field_71452_i.func_78873_a((EntityFX)entitycrit2fx);
                } else if (par1Packet18Animation.field_73469_b != 5 || entity instanceof EntityOtherPlayerMP) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public void func_72460_a(Packet17Sleep par1Packet17Sleep) {
        Entity entity = this.func_72545_a(par1Packet17Sleep.field_73625_a);
        if (entity != null && par1Packet17Sleep.field_73622_e == 0) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.func_71018_a(par1Packet17Sleep.field_73623_b, par1Packet17Sleep.field_73624_c, par1Packet17Sleep.field_73621_d);
        }
    }

    public void func_72553_e() {
        this.field_72554_f = true;
        this.field_72555_g.func_74427_a();
        this.field_72555_g.func_74424_a("disconnect.closed", new Object[0]);
    }

    @Override
    public void func_72519_a(Packet24MobSpawn par1Packet24MobSpawn) {
        double d0 = (double)par1Packet24MobSpawn.field_73495_c / 32.0;
        double d1 = (double)par1Packet24MobSpawn.field_73492_d / 32.0;
        double d2 = (double)par1Packet24MobSpawn.field_73493_e / 32.0;
        float f = (float)(par1Packet24MobSpawn.field_73500_i * 360) / 256.0f;
        float f1 = (float)(par1Packet24MobSpawn.field_73497_j * 360) / 256.0f;
        EntityLivingBase entitylivingbase = (EntityLivingBase)EntityList.func_75616_a((int)par1Packet24MobSpawn.field_73494_b, (World)this.field_72563_h.field_71441_e);
        entitylivingbase.field_70118_ct = par1Packet24MobSpawn.field_73495_c;
        entitylivingbase.field_70117_cu = par1Packet24MobSpawn.field_73492_d;
        entitylivingbase.field_70116_cv = par1Packet24MobSpawn.field_73493_e;
        entitylivingbase.field_70759_as = (float)(par1Packet24MobSpawn.field_73498_k * 360) / 256.0f;
        Entity[] aentity = entitylivingbase.func_70021_al();
        if (aentity != null) {
            int i = par1Packet24MobSpawn.field_73496_a - entitylivingbase.field_70157_k;
            for (int j = 0; j < aentity.length; ++j) {
                aentity[j].field_70157_k += i;
            }
        }
        entitylivingbase.field_70157_k = par1Packet24MobSpawn.field_73496_a;
        entitylivingbase.func_70080_a(d0, d1, d2, f, f1);
        entitylivingbase.field_70159_w = (float)par1Packet24MobSpawn.field_73490_f / 8000.0f;
        entitylivingbase.field_70181_x = (float)par1Packet24MobSpawn.field_73491_g / 8000.0f;
        entitylivingbase.field_70179_y = (float)par1Packet24MobSpawn.field_73499_h / 8000.0f;
        this.field_72564_i.func_73027_a(par1Packet24MobSpawn.field_73496_a, entitylivingbase);
        List list = par1Packet24MobSpawn.func_73489_c();
        if (list != null) {
            entitylivingbase.func_70096_w().func_75687_a(list);
        }
    }

    @Override
    public void func_72497_a(Packet4UpdateTime par1Packet4UpdateTime) {
        this.field_72563_h.field_71441_e.func_82738_a(par1Packet4UpdateTime.field_82562_a);
        this.field_72563_h.field_71441_e.func_72877_b(par1Packet4UpdateTime.field_73301_a);
    }

    @Override
    public void func_72466_a(Packet6SpawnPosition par1Packet6SpawnPosition) {
        this.field_72563_h.field_71439_g.func_71063_a(new ChunkCoordinates(par1Packet6SpawnPosition.field_73300_a, par1Packet6SpawnPosition.field_73298_b, par1Packet6SpawnPosition.field_73299_c), true);
        this.field_72563_h.field_71441_e.func_72912_H().func_76081_a(par1Packet6SpawnPosition.field_73300_a, par1Packet6SpawnPosition.field_73298_b, par1Packet6SpawnPosition.field_73299_c);
    }

    @Override
    public void func_72484_a(Packet39AttachEntity par1Packet39AttachEntity) {
        Object object = this.func_72545_a(par1Packet39AttachEntity.field_111006_b);
        Entity entity = this.func_72545_a(par1Packet39AttachEntity.field_73296_b);
        if (par1Packet39AttachEntity.field_111007_a == 0) {
            boolean flag = false;
            if (par1Packet39AttachEntity.field_111006_b == this.field_72563_h.field_71439_g.field_70157_k) {
                object = this.field_72563_h.field_71439_g;
                if (entity instanceof EntityBoat) {
                    ((EntityBoat)entity).func_70270_d(false);
                }
                flag = object.field_70154_o == null && entity != null;
            } else if (entity instanceof EntityBoat) {
                ((EntityBoat)entity).func_70270_d(true);
            }
            if (object == null) {
                return;
            }
            object.func_70078_a(entity);
            if (flag) {
                GameSettings gamesettings = this.field_72563_h.field_71474_y;
                this.field_72563_h.field_71456_v.func_110326_a(I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{GameSettings.func_74298_c((int)gamesettings.field_74311_E.field_74512_d)}), false);
            }
        } else if (par1Packet39AttachEntity.field_111007_a == 1 && object != null && object instanceof EntityLiving) {
            if (entity != null) {
                ((EntityLiving)((Object)object)).func_110162_b(entity, false);
            } else {
                ((EntityLiving)((Object)object)).func_110160_i(false, false);
            }
        }
    }

    @Override
    public void func_72485_a(Packet38EntityStatus par1Packet38EntityStatus) {
        Entity entity = this.func_72545_a(par1Packet38EntityStatus.field_73627_a);
        if (entity != null) {
            entity.func_70103_a(par1Packet38EntityStatus.field_73626_b);
        }
    }

    private Entity func_72545_a(int par1) {
        return par1 == this.field_72563_h.field_71439_g.field_70157_k ? this.field_72563_h.field_71439_g : this.field_72564_i.func_73045_a(par1);
    }

    @Override
    public void func_72521_a(Packet8UpdateHealth par1Packet8UpdateHealth) {
        this.field_72563_h.field_71439_g.func_71150_b(par1Packet8UpdateHealth.field_73640_a);
        this.field_72563_h.field_71439_g.func_71024_bL().func_75114_a(par1Packet8UpdateHealth.field_73638_b);
        this.field_72563_h.field_71439_g.func_71024_bL().func_75119_b(par1Packet8UpdateHealth.field_73639_c);
    }

    @Override
    public void func_72522_a(Packet43Experience par1Packet43Experience) {
        this.field_72563_h.field_71439_g.func_71152_a(par1Packet43Experience.field_73396_a, par1Packet43Experience.field_73394_b, par1Packet43Experience.field_73395_c);
    }

    @Override
    public void func_72483_a(Packet9Respawn par1Packet9Respawn) {
        if (par1Packet9Respawn.field_73373_a != this.field_72563_h.field_71439_g.field_71093_bK) {
            this.field_72561_j = false;
            Scoreboard scoreboard = this.field_72564_i.func_96441_U();
            this.field_72564_i = new WorldClient(this, new WorldSettings(0L, par1Packet9Respawn.field_73369_d, false, this.field_72563_h.field_71441_e.func_72912_H().func_76093_s(), par1Packet9Respawn.field_73370_e), par1Packet9Respawn.field_73373_a, par1Packet9Respawn.field_73371_b, this.field_72563_h.field_71424_I, this.field_72563_h.func_98033_al());
            this.field_72564_i.func_96443_a(scoreboard);
            this.field_72564_i.field_72995_K = true;
            this.field_72563_h.func_71403_a(this.field_72564_i);
            this.field_72563_h.field_71439_g.field_71093_bK = par1Packet9Respawn.field_73373_a;
            this.field_72563_h.func_71373_a((GuiScreen)new GuiDownloadTerrain(this));
        }
        this.field_72563_h.func_71354_a(par1Packet9Respawn.field_73373_a);
        this.field_72563_h.field_71442_b.func_78746_a(par1Packet9Respawn.field_73369_d);
    }

    @Override
    public void func_72499_a(Packet60Explosion par1Packet60Explosion) {
        Explosion explosion = new Explosion((World)this.field_72563_h.field_71441_e, (Entity)null, par1Packet60Explosion.field_73616_a, par1Packet60Explosion.field_73614_b, par1Packet60Explosion.field_73615_c, par1Packet60Explosion.field_73612_d);
        explosion.field_77281_g = par1Packet60Explosion.field_73613_e;
        explosion.func_77279_a(true);
        this.field_72563_h.field_71439_g.field_70159_w += (double)par1Packet60Explosion.func_73607_d();
        this.field_72563_h.field_71439_g.field_70181_x += (double)par1Packet60Explosion.func_73609_f();
        this.field_72563_h.field_71439_g.field_70179_y += (double)par1Packet60Explosion.func_73608_g();
    }

    @Override
    public void func_72516_a(Packet100OpenWindow par1Packet100OpenWindow) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        switch (par1Packet100OpenWindow.field_73429_b) {
            case 0: {
                entityclientplayermp.func_71007_a((IInventory)new InventoryBasic(par1Packet100OpenWindow.field_73430_c, par1Packet100OpenWindow.field_94500_e, par1Packet100OpenWindow.field_73428_d));
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 1: {
                entityclientplayermp.func_71058_b(MathHelper.func_76128_c((double)entityclientplayermp.field_70165_t), MathHelper.func_76128_c((double)entityclientplayermp.field_70163_u), MathHelper.func_76128_c((double)entityclientplayermp.field_70161_v));
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 2: {
                TileEntityFurnace tileentityfurnace = new TileEntityFurnace();
                if (par1Packet100OpenWindow.field_94500_e) {
                    tileentityfurnace.func_94129_a(par1Packet100OpenWindow.field_73430_c);
                }
                entityclientplayermp.func_71042_a(tileentityfurnace);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 3: {
                TileEntityDispenser tileentitydispenser = new TileEntityDispenser();
                if (par1Packet100OpenWindow.field_94500_e) {
                    tileentitydispenser.func_94049_a(par1Packet100OpenWindow.field_73430_c);
                }
                entityclientplayermp.func_71006_a(tileentitydispenser);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 4: {
                entityclientplayermp.func_71002_c(MathHelper.func_76128_c((double)entityclientplayermp.field_70165_t), MathHelper.func_76128_c((double)entityclientplayermp.field_70163_u), MathHelper.func_76128_c((double)entityclientplayermp.field_70161_v), par1Packet100OpenWindow.field_94500_e ? par1Packet100OpenWindow.field_73430_c : null);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 5: {
                TileEntityBrewingStand tileentitybrewingstand = new TileEntityBrewingStand();
                if (par1Packet100OpenWindow.field_94500_e) {
                    tileentitybrewingstand.func_94131_a(par1Packet100OpenWindow.field_73430_c);
                }
                entityclientplayermp.func_71017_a(tileentitybrewingstand);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 6: {
                entityclientplayermp.func_71030_a((IMerchant)new NpcMerchant((EntityPlayer)((Object)entityclientplayermp)), par1Packet100OpenWindow.field_94500_e ? par1Packet100OpenWindow.field_73430_c : null);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 7: {
                TileEntityBeacon tileentitybeacon = new TileEntityBeacon();
                entityclientplayermp.func_82240_a(tileentitybeacon);
                if (par1Packet100OpenWindow.field_94500_e) {
                    tileentitybeacon.func_94047_a(par1Packet100OpenWindow.field_73430_c);
                }
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 8: {
                entityclientplayermp.func_82244_d(MathHelper.func_76128_c((double)entityclientplayermp.field_70165_t), MathHelper.func_76128_c((double)entityclientplayermp.field_70163_u), MathHelper.func_76128_c((double)entityclientplayermp.field_70161_v));
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 9: {
                TileEntityHopper tileentityhopper = new TileEntityHopper();
                if (par1Packet100OpenWindow.field_94500_e) {
                    tileentityhopper.func_96115_a(par1Packet100OpenWindow.field_73430_c);
                }
                entityclientplayermp.func_94064_a(tileentityhopper);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 10: {
                TileEntityDropper tileentitydropper = new TileEntityDropper();
                if (par1Packet100OpenWindow.field_94500_e) {
                    tileentitydropper.func_94049_a(par1Packet100OpenWindow.field_73430_c);
                }
                entityclientplayermp.func_71006_a((TileEntityDispenser)tileentitydropper);
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
                break;
            }
            case 11: {
                Entity entity = this.func_72545_a(par1Packet100OpenWindow.field_111008_f);
                if (entity == null || !(entity instanceof EntityHorse)) break;
                entityclientplayermp.func_110298_a((EntityHorse)entity, (IInventory)new AnimalChest(par1Packet100OpenWindow.field_73430_c, par1Packet100OpenWindow.field_94500_e, par1Packet100OpenWindow.field_73428_d));
                entityclientplayermp.field_71070_bA.field_75152_c = par1Packet100OpenWindow.field_73431_a;
            }
        }
    }

    @Override
    public void func_72490_a(Packet103SetSlot par1Packet103SetSlot) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        if (par1Packet103SetSlot.field_73637_a == -1) {
            entityclientplayermp.field_71071_by.func_70437_b(par1Packet103SetSlot.field_73636_c);
        } else {
            boolean flag = false;
            if (this.field_72563_h.field_71462_r instanceof GuiContainerCreative) {
                GuiContainerCreative guicontainercreative = (GuiContainerCreative)this.field_72563_h.field_71462_r;
                boolean bl = flag = guicontainercreative.func_74230_h() != CreativeTabs.field_78036_m.func_78021_a();
            }
            if (par1Packet103SetSlot.field_73637_a == 0 && par1Packet103SetSlot.field_73635_b >= 36 && par1Packet103SetSlot.field_73635_b < 45) {
                ItemStack itemstack = entityclientplayermp.field_71069_bz.func_75139_a(par1Packet103SetSlot.field_73635_b).func_75211_c();
                if (par1Packet103SetSlot.field_73636_c != null && (itemstack == null || itemstack.field_77994_a < par1Packet103SetSlot.field_73636_c.field_77994_a)) {
                    par1Packet103SetSlot.field_73636_c.field_77992_b = 5;
                }
                entityclientplayermp.field_71069_bz.func_75141_a(par1Packet103SetSlot.field_73635_b, par1Packet103SetSlot.field_73636_c);
            } else if (!(par1Packet103SetSlot.field_73637_a != entityclientplayermp.field_71070_bA.field_75152_c || par1Packet103SetSlot.field_73637_a == 0 && flag)) {
                entityclientplayermp.field_71070_bA.func_75141_a(par1Packet103SetSlot.field_73635_b, par1Packet103SetSlot.field_73636_c);
            }
        }
    }

    @Override
    public void func_72476_a(Packet106Transaction par1Packet106Transaction) {
        Container container = null;
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        if (par1Packet106Transaction.field_73435_a == 0) {
            container = entityclientplayermp.field_71069_bz;
        } else if (par1Packet106Transaction.field_73435_a == entityclientplayermp.field_71070_bA.field_75152_c) {
            container = entityclientplayermp.field_71070_bA;
        }
        if (container != null && !par1Packet106Transaction.field_73434_c) {
            this.func_72552_c((Packet)new Packet106Transaction(par1Packet106Transaction.field_73435_a, par1Packet106Transaction.field_73433_b, true));
        }
    }

    @Override
    public void func_72486_a(Packet104WindowItems par1Packet104WindowItems) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        if (par1Packet104WindowItems.field_73427_a == 0) {
            entityclientplayermp.field_71069_bz.func_75131_a(par1Packet104WindowItems.field_73426_b);
        } else if (par1Packet104WindowItems.field_73427_a == entityclientplayermp.field_71070_bA.field_75152_c) {
            entityclientplayermp.field_71070_bA.func_75131_a(par1Packet104WindowItems.field_73426_b);
        }
    }

    @Override
    public void func_142031_a(Packet133TileEditorOpen par1Packet133TileEditorOpen) {
        TileEntity tileentity = this.field_72564_i.func_72796_p(par1Packet133TileEditorOpen.field_142035_b, par1Packet133TileEditorOpen.field_142036_c, par1Packet133TileEditorOpen.field_142034_d);
        if (tileentity != null) {
            this.field_72563_h.field_71439_g.func_71014_a(tileentity);
        } else if (par1Packet133TileEditorOpen.field_142037_a == 0) {
            TileEntitySign tileentitysign = new TileEntitySign();
            tileentitysign.func_70308_a((World)this.field_72564_i);
            tileentitysign.field_70329_l = par1Packet133TileEditorOpen.field_142035_b;
            tileentitysign.field_70330_m = par1Packet133TileEditorOpen.field_142036_c;
            tileentitysign.field_70327_n = par1Packet133TileEditorOpen.field_142034_d;
            this.field_72563_h.field_71439_g.func_71014_a((TileEntity)tileentitysign);
        }
    }

    @Override
    public void func_72487_a(Packet130UpdateSign par1Packet130UpdateSign) {
        TileEntity tileentity;
        boolean flag = false;
        if (this.field_72563_h.field_71441_e.func_72899_e(par1Packet130UpdateSign.field_73311_a, par1Packet130UpdateSign.field_73309_b, par1Packet130UpdateSign.field_73310_c) && (tileentity = this.field_72563_h.field_71441_e.func_72796_p(par1Packet130UpdateSign.field_73311_a, par1Packet130UpdateSign.field_73309_b, par1Packet130UpdateSign.field_73310_c)) instanceof TileEntitySign) {
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            if (tileentitysign.func_70409_a()) {
                for (int i = 0; i < 4; ++i) {
                    tileentitysign.field_70412_a[i] = par1Packet130UpdateSign.field_73308_d[i];
                }
                tileentitysign.func_70296_d();
            }
            flag = true;
        }
        if (!flag && this.field_72563_h.field_71439_g != null) {
            this.field_72563_h.field_71439_g.func_70006_a(ChatMessageComponent.func_111066_d((String)("Unable to locate sign at " + par1Packet130UpdateSign.field_73311_a + ", " + par1Packet130UpdateSign.field_73309_b + ", " + par1Packet130UpdateSign.field_73310_c)));
        }
    }

    @Override
    public void func_72468_a(Packet132TileEntityData par1Packet132TileEntityData) {
        TileEntity tileentity;
        if (this.field_72563_h.field_71441_e.func_72899_e(par1Packet132TileEntityData.field_73334_a, par1Packet132TileEntityData.field_73332_b, par1Packet132TileEntityData.field_73333_c) && (tileentity = this.field_72563_h.field_71441_e.func_72796_p(par1Packet132TileEntityData.field_73334_a, par1Packet132TileEntityData.field_73332_b, par1Packet132TileEntityData.field_73333_c)) != null) {
            if (par1Packet132TileEntityData.field_73330_d == 1 && tileentity instanceof TileEntityMobSpawner) {
                tileentity.func_70307_a(par1Packet132TileEntityData.field_73331_e);
            } else if (par1Packet132TileEntityData.field_73330_d == 2 && tileentity instanceof TileEntityCommandBlock) {
                tileentity.func_70307_a(par1Packet132TileEntityData.field_73331_e);
            } else if (par1Packet132TileEntityData.field_73330_d == 3 && tileentity instanceof TileEntityBeacon) {
                tileentity.func_70307_a(par1Packet132TileEntityData.field_73331_e);
            } else if (par1Packet132TileEntityData.field_73330_d == 4 && tileentity instanceof TileEntitySkull) {
                tileentity.func_70307_a(par1Packet132TileEntityData.field_73331_e);
            } else {
                tileentity.onDataPacket(this.field_72555_g, par1Packet132TileEntityData);
            }
        }
    }

    @Override
    public void func_72505_a(Packet105UpdateProgressbar par1Packet105UpdateProgressbar) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        this.func_72509_a((Packet)par1Packet105UpdateProgressbar);
        if (entityclientplayermp.field_71070_bA != null && entityclientplayermp.field_71070_bA.field_75152_c == par1Packet105UpdateProgressbar.field_73634_a) {
            entityclientplayermp.field_71070_bA.func_75137_b(par1Packet105UpdateProgressbar.field_73632_b, par1Packet105UpdateProgressbar.field_73633_c);
        }
    }

    @Override
    public void func_72506_a(Packet5PlayerInventory par1Packet5PlayerInventory) {
        Entity entity = this.func_72545_a(par1Packet5PlayerInventory.field_73400_a);
        if (entity != null) {
            entity.func_70062_b(par1Packet5PlayerInventory.field_73398_b, par1Packet5PlayerInventory.func_73397_d());
        }
    }

    @Override
    public void func_72474_a(Packet101CloseWindow par1Packet101CloseWindow) {
        this.field_72563_h.field_71439_g.func_92015_f();
    }

    @Override
    public void func_72454_a(Packet54PlayNoteBlock par1Packet54PlayNoteBlock) {
        this.field_72563_h.field_71441_e.func_72965_b(par1Packet54PlayNoteBlock.field_73340_a, par1Packet54PlayNoteBlock.field_73338_b, par1Packet54PlayNoteBlock.field_73339_c, par1Packet54PlayNoteBlock.field_73335_f, par1Packet54PlayNoteBlock.field_73336_d, par1Packet54PlayNoteBlock.field_73337_e);
    }

    @Override
    public void func_72465_a(Packet55BlockDestroy par1Packet55BlockDestroy) {
        this.field_72563_h.field_71441_e.func_72888_f(par1Packet55BlockDestroy.func_73322_d(), par1Packet55BlockDestroy.func_73321_f(), par1Packet55BlockDestroy.func_73324_g(), par1Packet55BlockDestroy.func_73320_h(), par1Packet55BlockDestroy.func_73323_i());
    }

    @Override
    public void func_72453_a(Packet56MapChunks par1Packet56MapChunks) {
        for (int i = 0; i < par1Packet56MapChunks.func_73581_d(); ++i) {
            int j = par1Packet56MapChunks.func_73582_a(i);
            int k = par1Packet56MapChunks.func_73580_b(i);
            this.field_72564_i.func_73025_a(j, k, true);
            this.field_72564_i.func_73031_a(j << 4, 0, k << 4, (j << 4) + 15, 256, (k << 4) + 15);
            Chunk chunk = this.field_72564_i.func_72964_e(j, k);
            if (chunk == null) {
                this.field_72564_i.func_73025_a(j, k, true);
                chunk = this.field_72564_i.func_72964_e(j, k);
            }
            if (chunk == null) continue;
            chunk.func_76607_a(par1Packet56MapChunks.func_73583_c(i), par1Packet56MapChunks.field_73590_a[i], par1Packet56MapChunks.field_73588_b[i], true);
            this.field_72564_i.func_72909_d(j << 4, 0, k << 4, (j << 4) + 15, 256, (k << 4) + 15);
            if (this.field_72564_i.field_73011_w instanceof WorldProviderSurface) continue;
            chunk.func_76613_n();
        }
    }

    @Override
    public boolean func_72469_b() {
        return this.field_72563_h != null && this.field_72563_h.field_71441_e != null && this.field_72563_h.field_71439_g != null && this.field_72564_i != null;
    }

    @Override
    public void func_72488_a(Packet70GameEvent par1Packet70GameEvent) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        int i = par1Packet70GameEvent.field_73618_b;
        int j = par1Packet70GameEvent.field_73619_c;
        if (i >= 0 && i < Packet70GameEvent.field_73620_a.length && Packet70GameEvent.field_73620_a[i] != null) {
            entityclientplayermp.func_71035_c(Packet70GameEvent.field_73620_a[i]);
        }
        if (i == 1) {
            this.field_72564_i.func_72912_H().func_76084_b(true);
            this.field_72564_i.func_72894_k(0.0f);
        } else if (i == 2) {
            this.field_72564_i.func_72912_H().func_76084_b(false);
            this.field_72564_i.func_72894_k(1.0f);
        } else if (i == 3) {
            this.field_72563_h.field_71442_b.func_78746_a(EnumGameType.func_77146_a((int)j));
        } else if (i == 4) {
            this.field_72563_h.func_71373_a((GuiScreen)new GuiWinGame());
        } else if (i == 5) {
            GameSettings gamesettings = this.field_72563_h.field_71474_y;
            if (j == 0) {
                this.field_72563_h.func_71373_a((GuiScreen)new GuiScreenDemo());
            } else if (j == 101) {
                this.field_72563_h.field_71456_v.func_73827_b().func_73757_a("demo.help.movement", new Object[]{Keyboard.getKeyName((int)gamesettings.field_74351_w.field_74512_d), Keyboard.getKeyName((int)gamesettings.field_74370_x.field_74512_d), Keyboard.getKeyName((int)gamesettings.field_74368_y.field_74512_d), Keyboard.getKeyName((int)gamesettings.field_74366_z.field_74512_d)});
            } else if (j == 102) {
                this.field_72563_h.field_71456_v.func_73827_b().func_73757_a("demo.help.jump", new Object[]{Keyboard.getKeyName((int)gamesettings.field_74314_A.field_74512_d)});
            } else if (j == 103) {
                this.field_72563_h.field_71456_v.func_73827_b().func_73757_a("demo.help.inventory", new Object[]{Keyboard.getKeyName((int)gamesettings.field_74315_B.field_74512_d)});
            }
        } else if (i == 6) {
            this.field_72564_i.func_72980_b(entityclientplayermp.field_70165_t, entityclientplayermp.field_70163_u + (double)entityclientplayermp.func_70047_e(), entityclientplayermp.field_70161_v, "random.successful_hit", 0.18f, 0.45f, false);
        }
    }

    @Override
    public void func_72494_a(Packet131MapData par1Packet131MapData) {
        FMLNetworkHandler.handlePacket131Packet((NetHandler)this, (Packet131MapData)par1Packet131MapData);
    }

    public void fmlPacket131Callback(Packet131MapData par1Packet131MapData) {
        if (par1Packet131MapData.field_73438_a == Item.field_77744_bd.field_77779_bT) {
            ItemMap.func_77874_a((short)par1Packet131MapData.field_73436_b, (World)this.field_72563_h.field_71441_e).func_76192_a(par1Packet131MapData.field_73437_c);
        } else {
            this.field_72563_h.func_98033_al().func_98236_b("Unknown itemid: " + par1Packet131MapData.field_73436_b);
        }
    }

    @Override
    public void func_72462_a(Packet61DoorChange par1Packet61DoorChange) {
        if (par1Packet61DoorChange.func_82560_d()) {
            this.field_72563_h.field_71441_e.func_82739_e(par1Packet61DoorChange.field_73567_a, par1Packet61DoorChange.field_73566_c, par1Packet61DoorChange.field_73563_d, par1Packet61DoorChange.field_73564_e, par1Packet61DoorChange.field_73565_b);
        } else {
            this.field_72563_h.field_71441_e.func_72926_e(par1Packet61DoorChange.field_73567_a, par1Packet61DoorChange.field_73566_c, par1Packet61DoorChange.field_73563_d, par1Packet61DoorChange.field_73564_e, par1Packet61DoorChange.field_73565_b);
        }
    }

    @Override
    public void func_72517_a(Packet200Statistic par1Packet200Statistic) {
        this.field_72563_h.field_71439_g.func_71167_b(StatList.func_75923_a((int)par1Packet200Statistic.field_73472_a), par1Packet200Statistic.field_73471_b);
    }

    @Override
    public void func_72503_a(Packet41EntityEffect par1Packet41EntityEffect) {
        Entity entity = this.func_72545_a(par1Packet41EntityEffect.field_73420_a);
        if (entity instanceof EntityLivingBase) {
            PotionEffect potioneffect = new PotionEffect((int)par1Packet41EntityEffect.field_73418_b, (int)par1Packet41EntityEffect.field_73417_d, (int)par1Packet41EntityEffect.field_73419_c);
            potioneffect.func_100012_b(par1Packet41EntityEffect.func_100008_d());
            ((EntityLivingBase)entity).func_70690_d(potioneffect);
        }
    }

    @Override
    public void func_72452_a(Packet42RemoveEntityEffect par1Packet42RemoveEntityEffect) {
        Entity entity = this.func_72545_a(par1Packet42RemoveEntityEffect.field_73375_a);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70618_n(par1Packet42RemoveEntityEffect.field_73374_b);
        }
    }

    @Override
    public boolean func_72489_a() {
        return false;
    }

    @Override
    public void func_72480_a(Packet201PlayerInfo par1Packet201PlayerInfo) {
        GuiPlayerInfo guiplayerinfo = (GuiPlayerInfo)this.field_72562_k.get(par1Packet201PlayerInfo.field_73365_a);
        if (guiplayerinfo == null && par1Packet201PlayerInfo.field_73363_b) {
            guiplayerinfo = new GuiPlayerInfo(par1Packet201PlayerInfo.field_73365_a);
            this.field_72562_k.put(par1Packet201PlayerInfo.field_73365_a, guiplayerinfo);
            this.field_72559_c.add(guiplayerinfo);
        }
        if (guiplayerinfo != null && !par1Packet201PlayerInfo.field_73363_b) {
            this.field_72562_k.remove(par1Packet201PlayerInfo.field_73365_a);
            this.field_72559_c.remove(guiplayerinfo);
        }
        if (par1Packet201PlayerInfo.field_73363_b && guiplayerinfo != null) {
            guiplayerinfo.field_78829_b = par1Packet201PlayerInfo.field_73364_c;
        }
    }

    @Override
    public void func_72477_a(Packet0KeepAlive par1Packet0KeepAlive) {
        this.func_72552_c((Packet)new Packet0KeepAlive(par1Packet0KeepAlive.field_73592_a));
    }

    @Override
    public void func_72471_a(Packet202PlayerAbilities par1Packet202PlayerAbilities) {
        EntityClientPlayerMP entityclientplayermp = this.field_72563_h.field_71439_g;
        entityclientplayermp.field_71075_bZ.field_75100_b = par1Packet202PlayerAbilities.func_73350_f();
        entityclientplayermp.field_71075_bZ.field_75098_d = par1Packet202PlayerAbilities.func_73346_h();
        entityclientplayermp.field_71075_bZ.field_75102_a = par1Packet202PlayerAbilities.func_73352_d();
        entityclientplayermp.field_71075_bZ.field_75101_c = par1Packet202PlayerAbilities.func_73348_g();
        entityclientplayermp.field_71075_bZ.func_75092_a(par1Packet202PlayerAbilities.func_73347_i());
        entityclientplayermp.field_71075_bZ.func_82877_b(par1Packet202PlayerAbilities.func_82558_j());
    }

    @Override
    public void func_72461_a(Packet203AutoComplete par1Packet203AutoComplete) {
        String[] astring = par1Packet203AutoComplete.func_73473_d().split("\u0000");
        if (this.field_72563_h.field_71462_r instanceof GuiChat) {
            GuiChat guichat = (GuiChat)this.field_72563_h.field_71462_r;
            guichat.func_73894_a(astring);
        }
    }

    @Override
    public void func_72457_a(Packet62LevelSound par1Packet62LevelSound) {
        this.field_72563_h.field_71441_e.func_72980_b(par1Packet62LevelSound.func_73572_f(), par1Packet62LevelSound.func_73568_g(), par1Packet62LevelSound.func_73569_h(), par1Packet62LevelSound.func_73570_d(), par1Packet62LevelSound.func_73571_i(), par1Packet62LevelSound.func_73573_j(), false);
    }

    @Override
    public void func_72501_a(Packet250CustomPayload par1Packet250CustomPayload) {
        FMLNetworkHandler.handlePacket250Packet((Packet250CustomPayload)par1Packet250CustomPayload, (INetworkManager)this.field_72555_g, (NetHandler)this);
    }

    @Override
    public void handleVanilla250Packet(Packet250CustomPayload par1Packet250CustomPayload) {
        if ("MC|TrList".equals(par1Packet250CustomPayload.field_73630_a)) {
            DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet250CustomPayload.field_73629_c));
            try {
                int i = datainputstream.readInt();
                GuiScreen guiscreen = this.field_72563_h.field_71462_r;
                if (guiscreen != null && guiscreen instanceof GuiMerchant && i == this.field_72563_h.field_71439_g.field_71070_bA.field_75152_c) {
                    IMerchant imerchant = ((GuiMerchant)guiscreen).func_74199_h();
                    MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_77204_a(datainputstream);
                    imerchant.func_70930_a(merchantrecipelist);
                }
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        } else if ("MC|Brand".equals(par1Packet250CustomPayload.field_73630_a)) {
            this.field_72563_h.field_71439_g.func_142020_c(new String(par1Packet250CustomPayload.field_73629_c, Charsets.UTF_8));
        }
    }

    @Override
    public void func_96436_a(Packet206SetObjective par1Packet206SetObjective) {
        Scoreboard scoreboard = this.field_72564_i.func_96441_U();
        if (par1Packet206SetObjective.field_96483_c == 0) {
            ScoreObjective scoreobjective = scoreboard.func_96535_a(par1Packet206SetObjective.field_96484_a, ScoreObjectiveCriteria.field_96641_b);
            scoreobjective.func_96681_a(par1Packet206SetObjective.field_96482_b);
        } else {
            ScoreObjective scoreobjective = scoreboard.func_96518_b(par1Packet206SetObjective.field_96484_a);
            if (par1Packet206SetObjective.field_96483_c == 1) {
                scoreboard.func_96519_k(scoreobjective);
            } else if (par1Packet206SetObjective.field_96483_c == 2) {
                scoreobjective.func_96681_a(par1Packet206SetObjective.field_96482_b);
            }
        }
    }

    @Override
    public void func_96437_a(Packet207SetScore par1Packet207SetScore) {
        Scoreboard scoreboard = this.field_72564_i.func_96441_U();
        ScoreObjective scoreobjective = scoreboard.func_96518_b(par1Packet207SetScore.field_96486_b);
        if (par1Packet207SetScore.field_96485_d == 0) {
            Score score = scoreboard.func_96529_a(par1Packet207SetScore.field_96488_a, scoreobjective);
            score.func_96647_c(par1Packet207SetScore.field_96487_c);
        } else if (par1Packet207SetScore.field_96485_d == 1) {
            scoreboard.func_96515_c(par1Packet207SetScore.field_96488_a);
        }
    }

    @Override
    public void func_96438_a(Packet208SetDisplayObjective par1Packet208SetDisplayObjective) {
        Scoreboard scoreboard = this.field_72564_i.func_96441_U();
        if (par1Packet208SetDisplayObjective.field_96480_b.length() == 0) {
            scoreboard.func_96530_a(par1Packet208SetDisplayObjective.field_96481_a, null);
        } else {
            ScoreObjective scoreobjective = scoreboard.func_96518_b(par1Packet208SetDisplayObjective.field_96480_b);
            scoreboard.func_96530_a(par1Packet208SetDisplayObjective.field_96481_a, scoreobjective);
        }
    }

    @Override
    public void func_96435_a(Packet209SetPlayerTeam par1Packet209SetPlayerTeam) {
        Scoreboard scoreboard = this.field_72564_i.func_96441_U();
        ScorePlayerTeam scoreplayerteam = par1Packet209SetPlayerTeam.field_96489_f == 0 ? scoreboard.func_96527_f(par1Packet209SetPlayerTeam.field_96495_a) : scoreboard.func_96508_e(par1Packet209SetPlayerTeam.field_96495_a);
        if (par1Packet209SetPlayerTeam.field_96489_f == 0 || par1Packet209SetPlayerTeam.field_96489_f == 2) {
            scoreplayerteam.func_96664_a(par1Packet209SetPlayerTeam.field_96493_b);
            scoreplayerteam.func_96666_b(par1Packet209SetPlayerTeam.field_96494_c);
            scoreplayerteam.func_96662_c(par1Packet209SetPlayerTeam.field_96491_d);
            scoreplayerteam.func_98298_a(par1Packet209SetPlayerTeam.field_98212_g);
        }
        if (par1Packet209SetPlayerTeam.field_96489_f == 0 || par1Packet209SetPlayerTeam.field_96489_f == 3) {
            for (String s : par1Packet209SetPlayerTeam.field_96492_e) {
                scoreboard.func_96521_a(s, scoreplayerteam);
            }
        }
        if (par1Packet209SetPlayerTeam.field_96489_f == 4) {
            for (String s : par1Packet209SetPlayerTeam.field_96492_e) {
                scoreboard.func_96512_b(s, scoreplayerteam);
            }
        }
        if (par1Packet209SetPlayerTeam.field_96489_f == 1) {
            scoreboard.func_96511_d(scoreplayerteam);
        }
    }

    @Override
    public void func_98182_a(Packet63WorldParticles par1Packet63WorldParticles) {
        for (int i = 0; i < par1Packet63WorldParticles.func_98202_m(); ++i) {
            double d0 = this.field_72557_e.nextGaussian() * (double)par1Packet63WorldParticles.func_98196_i();
            double d1 = this.field_72557_e.nextGaussian() * (double)par1Packet63WorldParticles.func_98201_j();
            double d2 = this.field_72557_e.nextGaussian() * (double)par1Packet63WorldParticles.func_98199_k();
            double d3 = this.field_72557_e.nextGaussian() * (double)par1Packet63WorldParticles.func_98197_l();
            double d4 = this.field_72557_e.nextGaussian() * (double)par1Packet63WorldParticles.func_98197_l();
            double d5 = this.field_72557_e.nextGaussian() * (double)par1Packet63WorldParticles.func_98197_l();
            this.field_72564_i.func_72869_a(par1Packet63WorldParticles.func_98195_d(), par1Packet63WorldParticles.func_98200_f() + d0, par1Packet63WorldParticles.func_98194_g() + d1, par1Packet63WorldParticles.func_98198_h() + d2, d3, d4, d5);
        }
    }

    @Override
    public void func_110773_a(Packet44UpdateAttributes par1Packet44UpdateAttributes) {
        Entity entity = this.func_72545_a(par1Packet44UpdateAttributes.func_111002_d());
        if (entity != null) {
            if (!(entity instanceof EntityLivingBase)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + entity + ")");
            }
            BaseAttributeMap baseattributemap = ((EntityLivingBase)entity).func_110140_aT();
            for (Packet44UpdateAttributesSnapshot packet44updateattributessnapshot : par1Packet44UpdateAttributes.func_111003_f()) {
                AttributeInstance attributeinstance = baseattributemap.func_111152_a(packet44updateattributessnapshot.func_142040_a());
                if (attributeinstance == null) {
                    attributeinstance = baseattributemap.func_111150_b(new RangedAttribute(packet44updateattributessnapshot.func_142040_a(), 0.0, Double.MIN_NORMAL, Double.MAX_VALUE));
                }
                attributeinstance.func_111128_a(packet44updateattributessnapshot.func_142041_b());
                attributeinstance.func_142049_d();
                for (AttributeModifier attributemodifier : packet44updateattributessnapshot.func_142039_c()) {
                    attributeinstance.func_111121_a(attributemodifier);
                }
            }
        }
    }

    public INetworkManager func_72548_f() {
        return this.field_72555_g;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.field_72563_h.field_71439_g;
    }

    public static void setConnectionCompatibilityLevel(byte connectionCompatibilityLevel) {
        NetClientHandler.connectionCompatibilityLevel = connectionCompatibilityLevel;
    }

    public static byte getConnectionCompatibilityLevel() {
        return connectionCompatibilityLevel;
    }
}

