/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.geometry;

import java.nio.BufferOverflowException;
import java.nio.DoubleBuffer;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.GradientAndArcCalculator;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.numina.render.RenderState;
import net.minecraft.util.Icon;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RadialIndicator {
    protected DoubleBuffer vertices;
    protected DoubleBuffer textures;
    protected DoubleBuffer background;
    protected DoubleBuffer foreground;
    protected Icon icon;
    protected String textureFile;

    public RadialIndicator(double innerRadius, double outerRadius, double startangle, double endangle, Colour backgroundColour, Colour foregroundColour, Icon icon, String texturefile) {
        double offset;
        double i;
        this.icon = icon;
        this.textureFile = texturefile;
        DoubleBuffer arcPoints1 = GradientAndArcCalculator.getArcPoints(startangle, endangle, outerRadius, 0.0, 0.0, 1.0);
        DoubleBuffer arcPoints2 = GradientAndArcCalculator.getArcPoints(startangle, endangle, innerRadius, 0.0, 0.0, 1.0);
        int numpoints = (arcPoints1.limit() + arcPoints2.limit()) / 3;
        this.vertices = BufferUtils.createDoubleBuffer((int)(numpoints * 3));
        while (arcPoints1.hasRemaining() && arcPoints2.hasRemaining()) {
            this.vertices.put(arcPoints1.get());
            this.vertices.put(arcPoints1.get());
            this.vertices.put(arcPoints1.get());
            this.vertices.put(arcPoints2.get());
            this.vertices.put(arcPoints2.get());
            this.vertices.put(arcPoints2.get());
        }
        this.vertices.flip();
        float u1 = icon.func_94209_e();
        float v1 = icon.func_94206_g();
        float u2 = icon.func_94212_f();
        float v2 = icon.func_94210_h();
        this.textures = BufferUtils.createDoubleBuffer((int)(numpoints * 2));
        int numsegments = numpoints / 4;
        for (i = 0.0; i < (double)numsegments; i += 1.0) {
            offset = (double)(v2 - v1) * i / (double)numsegments;
            this.textures.put(u1);
            this.textures.put((double)v1 + offset);
            this.textures.put(u2);
            this.textures.put((double)v1 + offset);
        }
        for (i = 0.0; i < (double)numsegments; i += 1.0) {
            offset = (double)(v2 - v1) * i / (double)numsegments;
            this.textures.put(u1);
            this.textures.put((double)v1 + offset);
            this.textures.put(u2);
            this.textures.put((double)v1 + offset);
        }
        this.textures.flip();
        this.background = BufferUtils.createDoubleBuffer((int)(numpoints * 4));
        try {
            while (true) {
                this.background.put(backgroundColour.asArray());
            }
        }
        catch (BufferOverflowException e) {
            this.background.flip();
            this.foreground = BufferUtils.createDoubleBuffer((int)(numpoints * 4));
            try {
                while (true) {
                    this.foreground.put(foregroundColour.asArray());
                }
            }
            catch (BufferOverflowException e2) {
                this.foreground.flip();
                return;
            }
        }
    }

    public void draw(double x, double y, double percent) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        RenderState.texturelessOff();
        GL11.glDisable((int)3553);
        RenderState.blendingOn();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        RenderState.arraysOff();
        int pointsToDraw = (int)(percent * (double)this.textures.limit() / 2.0);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.vertices);
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.background);
        GL11.glDrawArrays((int)8, (int)0, (int)(this.textures.limit() / 2));
        MuseTextureUtils.pushTexture(this.textureFile);
        GL11.glEnableClientState((int)32888);
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.foreground);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.vertices);
        GL11.glTexCoordPointer((int)2, (int)0, (DoubleBuffer)this.textures);
        GL11.glDrawArrays((int)8, (int)0, (int)pointsToDraw);
        GL11.glDisableClientState((int)32888);
        RenderState.arraysOff();
        MuseTextureUtils.popTexture();
        RenderState.blendingOff();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }
}

