/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.EnergyNet;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemToolMeter
extends ItemIC2 {
    public ItemToolMeter(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.field_77777_bU = 1;
        this.func_77656_e(0);
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = EnergyNet.getForWorld(world).getTileEntity(x, y, z);
        if ((tileEntity instanceof IEnergySource || tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) && IC2.platform.isSimulating()) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            long currentTotalEnergyEmitted = EnergyNet.getForWorld(world).getTotalEnergyEmitted(tileEntity);
            long currentTotalEnergySunken = EnergyNet.getForWorld(world).getTotalEnergySunken(tileEntity);
            long currentMeasureTime = world.func_72820_D();
            if (nbtData.func_74762_e("lastMeasuredTileEntityX") != x || nbtData.func_74762_e("lastMeasuredTileEntityY") != y || nbtData.func_74762_e("lastMeasuredTileEntityZ") != z) {
                nbtData.func_74768_a("lastMeasuredTileEntityX", x);
                nbtData.func_74768_a("lastMeasuredTileEntityY", y);
                nbtData.func_74768_a("lastMeasuredTileEntityZ", z);
                IC2.platform.messagePlayer(entityplayer, "Starting new measurement");
            } else {
                long measurePeriod = currentMeasureTime - nbtData.func_74763_f("lastMeasureTime");
                if (measurePeriod < 1L) {
                    measurePeriod = 1L;
                }
                double deltaEmitted = (double)(currentTotalEnergyEmitted - nbtData.func_74763_f("lastTotalEnergyEmitted")) / (double)measurePeriod;
                double deltaSunken = (double)(currentTotalEnergySunken - nbtData.func_74763_f("lastTotalEnergySunken")) / (double)measurePeriod;
                DecimalFormat powerFormat = new DecimalFormat("0.##");
                IC2.platform.messagePlayer(entityplayer, "Measured power [EU/t]: " + powerFormat.format(deltaSunken) + " in " + powerFormat.format(deltaEmitted) + " out " + powerFormat.format(deltaSunken - deltaEmitted) + " gain" + " (avg. over " + measurePeriod + " ticks)");
            }
            nbtData.func_74772_a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
            nbtData.func_74772_a("lastTotalEnergySunken", currentTotalEnergySunken);
            nbtData.func_74772_a("lastMeasureTime", currentMeasureTime);
            return true;
        }
        return false;
    }
}

