/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.IHitSoundOverride;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.tool.ItemElectricTool;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemElectricToolChainsaw
extends ItemElectricTool
implements IHitSoundOverride {
    public static boolean wasEquipped = false;
    public static AudioSource audioSource;

    public ItemElectricToolChainsaw(Configuration config, InternalName internalName) {
        super(config, internalName, EnumToolMaterial.IRON, 100);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77864_a = 12.0f;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
        this.mineableBlocks.add(Block.field_71988_x);
        this.mineableBlocks.add(Block.field_72093_an);
        this.mineableBlocks.add(Block.field_71951_J);
        this.mineableBlocks.add(Block.field_72077_au);
        this.mineableBlocks.add(Block.field_71952_K);
        this.mineableBlocks.add(Block.field_71955_W);
        this.mineableBlocks.add(Block.field_71973_m[Ic2Items.crop.field_77993_c]);
        if (Ic2Items.rubberLeaves != null) {
            this.mineableBlocks.add(Block.field_71973_m[Ic2Items.rubberLeaves.field_77993_c]);
        }
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLiving entityliving, EntityLiving attacker) {
        if (attacker instanceof EntityPlayer) {
            if (ElectricItem.manager.use(itemstack, this.operationEnergyCost, attacker)) {
                entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 9);
            }
            if (entityliving instanceof EntityCreeper && entityliving.func_70630_aN() <= 0) {
                IC2.achievements.issueAchievement((EntityPlayer)attacker, "killCreeperChainsaw");
            }
        }
        return false;
    }

    @Override
    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp == Material.field_76245_d) {
            return true;
        }
        return super.func_77641_a(block);
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        IShearable target;
        Entity entity = event.target;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack itemstack = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (itemstack != null && itemstack.field_77993_c == this.field_77779_bT && entity instanceof IShearable && ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLiving)player) && (target = (IShearable)entity).isShearable(itemstack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
            ArrayList drops = target.onSheared(itemstack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                EntityItem ent = entity.func_70099_a(stack, 1.0f);
                ent.field_70181_x += (double)(field_77697_d.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int id = player.field_70170_p.func_72798_a(X, Y, Z);
        if (Block.field_71973_m[id] != null && Block.field_71973_m[id] instanceof IShearable && (target = (IShearable)Block.field_71973_m[id]).isShearable(itemstack, player.field_70170_p, X, Y, Z) && ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLiving)player)) {
            ArrayList drops = target.onSheared(itemstack, player.field_70170_p, X, Y, Z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)X + d, (double)Y + d1, (double)Z + d2, stack);
                entityitem.field_70293_c = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a(StatList.field_75934_C[id], 1);
        }
        return false;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        boolean isEquipped;
        boolean bl = isEquipped = flag && entity instanceof EntityLiving;
        if (IC2.platform.isRendering()) {
            if (isEquipped && !wasEquipped) {
                if (audioSource == null) {
                    audioSource = IC2.audioManager.createSource(entity, PositionSpec.Hand, "Tools/Chainsaw/ChainsawIdle.ogg", true, false, IC2.audioManager.defaultVolume);
                }
                if (audioSource != null) {
                    audioSource.play();
                }
            } else if (!isEquipped && audioSource != null) {
                audioSource.stop();
                audioSource.remove();
                audioSource = null;
                if (entity instanceof EntityLiving) {
                    IC2.audioManager.playOnce(entity, PositionSpec.Hand, "Tools/Chainsaw/ChainsawStop.ogg", true, IC2.audioManager.defaultVolume);
                }
            } else if (audioSource != null) {
                audioSource.updatePosition();
            }
            wasEquipped = isEquipped;
        }
    }

    @Override
    public String getHitSoundForBlock(int x, int y, int z) {
        String[] soundEffects = new String[]{"Tools/Chainsaw/ChainsawUseOne.ogg", "Tools/Chainsaw/ChainsawUseTwo.ogg"};
        return soundEffects[field_77697_d.nextInt(soundEffects.length)];
    }
}

