/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityElectricBatBox;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.block.wiring.TileEntityElectricMFE;
import ic2.core.block.wiring.TileEntityElectricMFSU;
import ic2.core.block.wiring.TileEntityTransformerHV;
import ic2.core.block.wiring.TileEntityTransformerLV;
import ic2.core.block.wiring.TileEntityTransformerMV;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemElectricBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;

public class BlockElectric
extends BlockMultiID {
    public BlockElectric(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76243_f, ItemElectricBlock.class);
        this.func_71848_c(1.5f);
        this.func_71884_a(field_71977_i);
        Ic2Items.batBox = new ItemStack((Block)this, 1, 0);
        Ic2Items.mfeUnit = new ItemStack((Block)this, 1, 1);
        Ic2Items.mfsUnit = new ItemStack((Block)this, 1, 2);
        Ic2Items.lvTransformer = new ItemStack((Block)this, 1, 3);
        Ic2Items.mvTransformer = new ItemStack((Block)this, 1, 4);
        Ic2Items.hvTransformer = new ItemStack((Block)this, 1, 5);
    }

    @Override
    public String getTextureFolder() {
        return "wiring";
    }

    public int func_71885_a(int meta, Random random, int j) {
        switch (meta) {
            case 0: {
                return this.field_71990_ca;
            }
            case 3: {
                return this.field_71990_ca;
            }
        }
        return Ic2Items.machine.field_77993_c;
    }

    public int func_71899_b(int meta) {
        switch (meta) {
            case 0: {
                return meta;
            }
            case 3: {
                return meta;
            }
        }
        return Ic2Items.machine.func_77960_j();
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    public int func_71865_a(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_72796_p(x, y, z);
        if (te instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock electricBlock = (TileEntityElectricBlock)te;
            return electricBlock.isEmittingRedstone() ? 15 : 0;
        }
        return 0;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockOpaqueCube(World world, int i, int j, int k) {
        return true;
    }

    public boolean func_71924_d(IBlockAccess world, int i, int j, int k, int l) {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public TileEntityBlock createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityElectricBatBox();
            }
            case 1: {
                return new TileEntityElectricMFE();
            }
            case 2: {
                return new TileEntityElectricMFSU();
            }
            case 3: {
                return new TileEntityTransformerLV();
            }
            case 4: {
                return new TileEntityTransformerMV();
            }
            case 5: {
                return new TileEntityTransformerHV();
            }
        }
        return null;
    }

    @Override
    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack itemStack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntityBlock te = (TileEntityBlock)world.func_72796_p(i, j, k);
        if (entityliving == null) {
            te.setFacing((short)1);
        } else {
            int yaw = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int pitch = Math.round(entityliving.field_70125_A);
            if (pitch >= 65) {
                te.setFacing((short)1);
            } else if (pitch <= -65) {
                te.setFacing((short)0);
            } else {
                switch (yaw) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 2 || stack.func_77960_j() == 5 ? EnumRarity.uncommon : EnumRarity.common;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World par1World, int par2, int par3, int par4, int par5) {
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        if (te instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock teb = (TileEntityElectricBlock)te;
            return (int)Math.floor((float)teb.energy / (float)teb.maxStorage * 15.0f);
        }
        return 0;
    }
}

