/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.crop.IC2Crops;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CropNetherWart
extends CropCard {
    @Override
    public String name() {
        return "Nether Wart";
    }

    @Override
    public String discoveredBy() {
        return "Notch";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Red", "Nether", "Ingredient", "Soulsand"};
    }

    @Override
    public int maxSize() {
        return 3;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 3;
    }

    @Override
    public float dropGainChance() {
        return 2.0f;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Item.field_77727_br, 1);
    }

    @Override
    public void tick(ICropTile crop) {
        TileEntityCrop te = (TileEntityCrop)crop;
        if (te.isBlockBelow(Block.field_72013_bc)) {
            if (this.canGrow(te)) {
                te.growthPoints = (int)((double)te.growthPoints + (double)te.calcGrowthRate() * 0.5);
            }
        } else if (te.isBlockBelow(Block.field_72039_aU) && crop.getWorld().field_73012_v.nextInt(300) == 0) {
            te.id = (short)IC2Crops.cropTerraWart.getId();
        }
    }
}

