/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements ym {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private wm output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirrored = true;

    public ShapedOreRecipe(apa result, Object ... recipe) {
        this(new wm(result), recipe);
    }

    public ShapedOreRecipe(wk result, Object ... recipe) {
        this(new wm(result), recipe);
    }

    public ShapedOreRecipe(wm result, Object ... recipe) {
        this.output = result.m();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof wm) {
                itemMap.put(chr, ((wm)in).m());
            } else if (in instanceof wk) {
                itemMap.put(chr, new wm((wk)in));
            } else if (in instanceof apa) {
                itemMap.put(chr, new wm((apa)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    ShapedOreRecipe(yn recipe, Map<wm, String> replacements) {
        this.output = recipe.b();
        this.width = recipe.b;
        this.height = recipe.c;
        this.input = new Object[recipe.d.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            wm ingred = recipe.d[i];
            if (ingred == null) continue;
            this.input[i] = recipe.d[i];
            for (Map.Entry<wm, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches(replace.getKey(), ingred, true)) continue;
                this.input[i] = OreDictionary.getOres(replace.getValue());
                continue block0;
            }
        }
    }

    public wm a(tr var1) {
        return this.output.m();
    }

    public int a() {
        return this.input.length;
    }

    public wm b() {
        return this.output;
    }

    public boolean a(tr inv, aab world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y2 = 0; y2 <= 3 - this.height; ++y2) {
                if (this.checkMatch(inv, x, y2, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y2, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(tr inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y2 = 0; y2 < 3; ++y2) {
                int subX = x - startX;
                int subY = y2 - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                wm slot = inv.b(x, y2);
                if (target instanceof wm) {
                    if (this.checkItemEquals((wm)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (wm item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(wm target, wm input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.c == input.c && (target.k() == Short.MAX_VALUE || target.k() == input.k());
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }
}

