/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidContainerRegistry {
    public static final int BUCKET_VOLUME = 1000;
    public static final wm EMPTY_BUCKET = new wm(wk.ax);
    private static Map<List, LiquidContainerData> mapFilledItemFromLiquid = new HashMap<List, LiquidContainerData>();
    private static Map<List, LiquidContainerData> mapLiquidFromFilledItem = new HashMap<List, LiquidContainerData>();
    private static Set<List> setContainerValidation = new HashSet<List>();
    private static Set<List> setLiquidValidation = new HashSet<List>();
    private static ArrayList<LiquidContainerData> liquids = new ArrayList();

    public static void registerLiquid(LiquidContainerData data) {
        mapFilledItemFromLiquid.put(Arrays.asList(data.container.c, data.container.k(), data.stillLiquid.itemID, data.stillLiquid.itemMeta), data);
        mapLiquidFromFilledItem.put(Arrays.asList(data.filled.c, data.filled.k()), data);
        setContainerValidation.add(Arrays.asList(data.container.c, data.container.k()));
        setLiquidValidation.add(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta));
        liquids.add(data);
    }

    public static LiquidStack getLiquidForFilledItem(wm filledContainer) {
        if (filledContainer == null) {
            return null;
        }
        LiquidContainerData ret = mapLiquidFromFilledItem.get(Arrays.asList(filledContainer.c, filledContainer.k()));
        return ret == null ? null : ret.stillLiquid.copy();
    }

    public static wm fillLiquidContainer(LiquidStack liquid, wm emptyContainer) {
        if (emptyContainer == null || liquid == null) {
            return null;
        }
        LiquidContainerData ret = mapFilledItemFromLiquid.get(Arrays.asList(emptyContainer.c, emptyContainer.k(), liquid.itemID, liquid.itemMeta));
        if (ret != null && liquid.amount >= ret.stillLiquid.amount) {
            return ret.filled.m();
        }
        return null;
    }

    public static boolean containsLiquid(wm filledContainer, LiquidStack liquid) {
        if (filledContainer == null || liquid == null) {
            return false;
        }
        LiquidContainerData ret = mapLiquidFromFilledItem.get(Arrays.asList(filledContainer.c, filledContainer.k()));
        return ret != null && ret.stillLiquid.isLiquidEqual(liquid);
    }

    public static boolean isBucket(wm container) {
        if (container == null) {
            return false;
        }
        if (container.a(EMPTY_BUCKET)) {
            return true;
        }
        LiquidContainerData ret = mapLiquidFromFilledItem.get(Arrays.asList(container.c, container.k()));
        return ret != null && ret.container.a(EMPTY_BUCKET);
    }

    public static boolean isContainer(wm container) {
        return LiquidContainerRegistry.isEmptyContainer(container) || LiquidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(wm emptyContainer) {
        return emptyContainer != null && setContainerValidation.contains(Arrays.asList(emptyContainer.c, emptyContainer.k()));
    }

    public static boolean isFilledContainer(wm filledContainer) {
        return filledContainer != null && LiquidContainerRegistry.getLiquidForFilledItem(filledContainer) != null;
    }

    public static boolean isLiquid(wm item) {
        return item != null && setLiquidValidation.contains(Arrays.asList(item.c, item.k()));
    }

    public static LiquidContainerData[] getRegisteredLiquidContainerData() {
        return liquids.toArray(new LiquidContainerData[liquids.size()]);
    }

    static {
        LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(apa.F, 1000), new wm(wk.ay), new wm(wk.ax)));
        LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(apa.H, 1000), new wm(wk.az), new wm(wk.ax)));
        LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(apa.F, 1000), new wm((wk)wk.bt), new wm(wk.bu)));
    }
}

