/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IDownloadDisplay;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.ILibrarySet;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class RelaunchLibraryManager {
    private static String[] rootPlugins = new String[]{"cpw.mods.fml.relauncher.FMLCorePlugin", "net.minecraftforge.classloading.FMLForgePlugin"};
    private static List<String> loadedLibraries = new ArrayList<String>();
    private static Map<IFMLLoadingPlugin, File> pluginLocations;
    private static List<IFMLLoadingPlugin> loadPlugins;
    private static List<ILibrarySet> libraries;
    private static boolean deobfuscatedEnvironment;
    private static ByteBuffer downloadBuffer;
    static IDownloadDisplay downloadMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void handleLaunch(File mcDir, RelaunchClassLoader actualClassLoader) {
        block59: {
            File libDir;
            try {
                byte[] bs2 = actualClassLoader.getClassBytes("net.minecraft.world.World");
                if (bs2 != null) {
                    FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                    deobfuscatedEnvironment = true;
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (!deobfuscatedEnvironment) {
                FMLRelaunchLog.fine("Enabling runtime deobfuscation", new Object[0]);
            }
            pluginLocations = new HashMap<IFMLLoadingPlugin, File>();
            loadPlugins = new ArrayList<IFMLLoadingPlugin>();
            libraries = new ArrayList<ILibrarySet>();
            for (String s : rootPlugins) {
                try {
                    IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)Class.forName(s, true, actualClassLoader).newInstance();
                    loadPlugins.add(plugin);
                    for (String libName : plugin.getLibraryRequestClass()) {
                        libraries.add((ILibrarySet)Class.forName(libName, true, actualClassLoader).newInstance());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (loadPlugins.isEmpty()) {
                throw new RuntimeException("A fatal error has occured - no valid fml load plugin was found - this is a completely corrupt FML installation.");
            }
            downloadMonitor.updateProgressString("All core mods are successfully located", new Object[0]);
            String commandLineCoremods = System.getProperty("fml.coreMods.load", "");
            for (String s : commandLineCoremods.split(",")) {
                if (s.isEmpty()) continue;
                FMLRelaunchLog.info("Found a command line coremod : %s", s);
                try {
                    actualClassLoader.addTransformerExclusion(s);
                    Class<?> coreModClass = Class.forName(s, true, actualClassLoader);
                    IFMLLoadingPlugin.TransformerExclusions trExclusions = coreModClass.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class);
                    if (trExclusions != null) {
                        for (String st : trExclusions.value()) {
                            actualClassLoader.addTransformerExclusion(st);
                        }
                    }
                    IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClass.newInstance();
                    loadPlugins.add(plugin);
                    if (plugin.getLibraryRequestClass() == null) continue;
                    for (String libName : plugin.getLibraryRequestClass()) {
                        libraries.add((ILibrarySet)Class.forName(libName, true, actualClassLoader).newInstance());
                    }
                }
                catch (Throwable e) {
                    FMLRelaunchLog.log(Level.SEVERE, e, "Exception occured trying to load coremod %s", s);
                    throw new RuntimeException(e);
                }
            }
            RelaunchLibraryManager.discoverCoreMods(mcDir, actualClassLoader, loadPlugins, libraries);
            ArrayList<Throwable> caughtErrors = new ArrayList<Throwable>();
            try {
                try {
                    libDir = RelaunchLibraryManager.setupLibDir(mcDir);
                }
                catch (Exception e) {
                    caughtErrors.add(e);
                    if (downloadMonitor.shouldStopIt()) {
                        return;
                    }
                    if (caughtErrors.isEmpty()) return;
                    FMLRelaunchLog.severe("There were errors during initial FML setup. Some files failed to download or were otherwise corrupted. You will need to manually obtain the following files from these download links and ensure your lib directory is clean. ", new Object[0]);
                    for (ILibrarySet set : libraries) {
                        for (String file : set.getLibraries()) {
                            FMLRelaunchLog.severe("*** Download " + set.getRootURL(), file);
                        }
                    }
                    FMLRelaunchLog.severe("<===========>", new Object[0]);
                    FMLRelaunchLog.severe("The following is the errors that caused the setup to fail. They may help you diagnose and resolve the issue", new Object[0]);
                    for (Throwable t2 : caughtErrors) {
                        if (t2.getMessage() == null) continue;
                        FMLRelaunchLog.severe(t2.getMessage(), new Object[0]);
                    }
                    FMLRelaunchLog.severe("<<< ==== >>>", new Object[0]);
                    FMLRelaunchLog.severe("The following is diagnostic information for developers to review.", new Object[0]);
                    Iterator<ILibrarySet> i$ = caughtErrors.iterator();
                    while (i$.hasNext()) {
                        Throwable t2;
                        t2 = (Throwable)((Object)i$.next());
                        FMLRelaunchLog.log(Level.SEVERE, t2, "Error details", new Object[0]);
                    }
                    throw new RuntimeException("A fatal error occured and FML cannot continue");
                }
            }
            catch (Throwable throwable) {
                if (downloadMonitor.shouldStopIt()) {
                    return;
                }
                if (caughtErrors.isEmpty()) throw throwable;
                FMLRelaunchLog.severe("There were errors during initial FML setup. Some files failed to download or were otherwise corrupted. You will need to manually obtain the following files from these download links and ensure your lib directory is clean. ", new Object[0]);
                for (ILibrarySet set : libraries) {
                    for (String file : set.getLibraries()) {
                        FMLRelaunchLog.severe("*** Download " + set.getRootURL(), file);
                    }
                }
                FMLRelaunchLog.severe("<===========>", new Object[0]);
                FMLRelaunchLog.severe("The following is the errors that caused the setup to fail. They may help you diagnose and resolve the issue", new Object[0]);
                for (Throwable t3 : caughtErrors) {
                    if (t3.getMessage() == null) continue;
                    FMLRelaunchLog.severe(t3.getMessage(), new Object[0]);
                }
                FMLRelaunchLog.severe("<<< ==== >>>", new Object[0]);
                FMLRelaunchLog.severe("The following is diagnostic information for developers to review.", new Object[0]);
                Iterator<ILibrarySet> i$ = caughtErrors.iterator();
                while (i$.hasNext()) {
                    Throwable t3;
                    t3 = (Throwable)((Object)i$.next());
                    FMLRelaunchLog.log(Level.SEVERE, t3, "Error details", new Object[0]);
                }
                throw new RuntimeException("A fatal error occured and FML cannot continue");
            }
            {
                for (ILibrarySet lib : libraries) {
                    for (int i = 0; i < lib.getLibraries().length; ++i) {
                        File libFile;
                        String libName;
                        boolean download;
                        block58: {
                            download = false;
                            libName = lib.getLibraries()[i];
                            String targFileName = libName.lastIndexOf(47) >= 0 ? libName.substring(libName.lastIndexOf(47)) : libName;
                            String checksum = lib.getHashes()[i];
                            libFile = new File(libDir, targFileName);
                            if (!libFile.exists()) {
                                try {
                                    RelaunchLibraryManager.downloadFile(libFile, lib.getRootURL(), libName, checksum);
                                    download = true;
                                }
                                catch (Throwable e) {
                                    caughtErrors.add(e);
                                    continue;
                                }
                            }
                            if (libFile.exists() && !libFile.isFile()) {
                                caughtErrors.add(new RuntimeException(String.format("Found a file %s that is not a normal file - you should clear this out of the way", libName)));
                                continue;
                            }
                            if (!download) {
                                try {
                                    FileInputStream fis = new FileInputStream(libFile);
                                    FileChannel chan = fis.getChannel();
                                    MappedByteBuffer mappedFile = chan.map(FileChannel.MapMode.READ_ONLY, 0L, libFile.length());
                                    String fileChecksum = RelaunchLibraryManager.generateChecksum(mappedFile);
                                    fis.close();
                                    if (!checksum.equals(fileChecksum)) {
                                        caughtErrors.add(new RuntimeException(String.format("The file %s was found in your lib directory and has an invalid checksum %s (expecting %s) - it is unlikely to be the correct download, please move it out of the way and try again.", libName, fileChecksum, checksum)));
                                        continue;
                                    }
                                    break block58;
                                }
                                catch (Exception e) {
                                    FMLRelaunchLog.log(Level.SEVERE, e, "The library file %s could not be validated", libFile.getName());
                                    caughtErrors.add(new RuntimeException(String.format("The library file %s could not be validated", libFile.getName()), e));
                                }
                                continue;
                            }
                        }
                        if (!download) {
                            downloadMonitor.updateProgressString("Found library file %s present and correct in lib dir", libName);
                        } else {
                            downloadMonitor.updateProgressString("Library file %s was downloaded and verified successfully", libName);
                        }
                        try {
                            actualClassLoader.addURL(libFile.toURI().toURL());
                            loadedLibraries.add(libName);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            caughtErrors.add(new RuntimeException(String.format("Should never happen - %s is broken - probably a somehow corrupted download. Delete it and try again.", libFile.getName()), e));
                        }
                    }
                }
                if (downloadMonitor.shouldStopIt()) {
                    return;
                }
                if (caughtErrors.isEmpty()) break block59;
            }
            FMLRelaunchLog.severe("There were errors during initial FML setup. Some files failed to download or were otherwise corrupted. You will need to manually obtain the following files from these download links and ensure your lib directory is clean. ", new Object[0]);
            for (ILibrarySet set : libraries) {
                for (String file : set.getLibraries()) {
                    FMLRelaunchLog.severe("*** Download " + set.getRootURL(), file);
                }
            }
            FMLRelaunchLog.severe("<===========>", new Object[0]);
            FMLRelaunchLog.severe("The following is the errors that caused the setup to fail. They may help you diagnose and resolve the issue", new Object[0]);
            for (Throwable t4 : caughtErrors) {
                if (t4.getMessage() == null) continue;
                FMLRelaunchLog.severe(t4.getMessage(), new Object[0]);
            }
            FMLRelaunchLog.severe("<<< ==== >>>", new Object[0]);
            FMLRelaunchLog.severe("The following is diagnostic information for developers to review.", new Object[0]);
            Iterator<Object> i$ = caughtErrors.iterator();
            while (i$.hasNext()) {
                Throwable t4;
                t4 = (Throwable)i$.next();
                FMLRelaunchLog.log(Level.SEVERE, t4, "Error details", new Object[0]);
            }
            throw new RuntimeException("A fatal error occured and FML cannot continue");
        }
        for (IFMLLoadingPlugin plug : loadPlugins) {
            if (plug.getASMTransformerClass() == null) continue;
            for (String xformClass : plug.getASMTransformerClass()) {
                actualClassLoader.registerTransformer(xformClass);
            }
        }
        if (!deobfuscatedEnvironment) {
            actualClassLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer");
        }
        downloadMonitor.updateProgressString("Running coremod plugins", new Object[0]);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("mcLocation", mcDir);
        data.put("coremodList", loadPlugins);
        data.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
        for (IFMLLoadingPlugin plugin : loadPlugins) {
            downloadMonitor.updateProgressString("Running coremod plugin %s", plugin.getClass().getSimpleName());
            data.put("coremodLocation", pluginLocations.get(plugin));
            plugin.injectData(data);
            String setupClass = plugin.getSetupClass();
            if (setupClass != null) {
                try {
                    IFMLCallHook call = (IFMLCallHook)Class.forName(setupClass, true, actualClassLoader).newInstance();
                    HashMap<String, Object> callData = new HashMap<String, Object>();
                    callData.put("mcLocation", mcDir);
                    callData.put("classLoader", actualClassLoader);
                    callData.put("coremodLocation", pluginLocations.get(plugin));
                    callData.put("deobfuscationFileName", FMLInjectionData.debfuscationDataName());
                    call.injectData(callData);
                    call.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            downloadMonitor.updateProgressString("Coremod plugin %s run successfully", plugin.getClass().getSimpleName());
            String modContainer = plugin.getModContainerClass();
            if (modContainer == null) continue;
            FMLInjectionData.containers.add(modContainer);
        }
        try {
            downloadMonitor.updateProgressString("Validating minecraft", new Object[0]);
            Class<?> loaderClazz = Class.forName("cpw.mods.fml.common.Loader", true, actualClassLoader);
            Method m2 = loaderClazz.getMethod("injectData", Object[].class);
            m2.invoke(null, new Object[]{FMLInjectionData.data()});
            m2 = loaderClazz.getMethod("instance", new Class[0]);
            m2.invoke(null, new Object[0]);
            downloadMonitor.updateProgressString("Minecraft validated, launching...", new Object[0]);
            downloadBuffer = null;
            return;
        }
        catch (Exception e) {
            System.out.println("A CRITICAL PROBLEM OCCURED INITIALIZING MINECRAFT - LIKELY YOU HAVE AN INCORRECT VERSION FOR THIS FML");
            throw new RuntimeException(e);
        }
    }

    private static void discoverCoreMods(File mcDir, RelaunchClassLoader classLoader, List<IFMLLoadingPlugin> loadPlugins, List<ILibrarySet> libraries) {
        downloadMonitor.updateProgressString("Discovering coremods", new Object[0]);
        File coreMods = RelaunchLibraryManager.setupCoreModDir(mcDir);
        FilenameFilter ff2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        Object[] coreModList = coreMods.listFiles(ff2);
        Arrays.sort(coreModList);
        for (Object coreMod : coreModList) {
            Attributes mfAttributes;
            downloadMonitor.updateProgressString("Found a candidate coremod %s", ((File)coreMod).getName());
            try {
                JarFile jar = new JarFile((File)coreMod);
                if (jar.getManifest() == null) {
                    FMLRelaunchLog.warning("Found an un-manifested jar file in the coremods folder : %s, it will be ignored.", ((File)coreMod).getName());
                    continue;
                }
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log(Level.SEVERE, ioe, "Unable to read the coremod jar file %s - ignoring", ((File)coreMod).getName());
                continue;
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                FMLRelaunchLog.severe("The coremod %s does not contain a valid jar manifest- it will be ignored", ((File)coreMod).getName());
                continue;
            }
            try {
                classLoader.addURL(((File)coreMod).toURI().toURL());
            }
            catch (MalformedURLException e) {
                FMLRelaunchLog.log(Level.SEVERE, e, "Unable to convert file into a URL. weird", new Object[0]);
                continue;
            }
            try {
                IFMLLoadingPlugin.TransformerExclusions trExclusions;
                downloadMonitor.updateProgressString("Loading coremod %s", ((File)coreMod).getName());
                classLoader.addTransformerExclusion(fmlCorePlugin);
                Class<?> coreModClass = Class.forName(fmlCorePlugin, true, classLoader);
                IFMLLoadingPlugin.MCVersion requiredMCVersion = coreModClass.getAnnotation(IFMLLoadingPlugin.MCVersion.class);
                String version = "";
                if (requiredMCVersion == null) {
                    FMLRelaunchLog.log(Level.WARNING, "The coremod %s does not have a MCVersion annotation, it may cause issues with this version of Minecraft", fmlCorePlugin);
                } else {
                    version = requiredMCVersion.value();
                }
                if (!"".equals(version) && !FMLInjectionData.mccversion.equals(version)) {
                    FMLRelaunchLog.log(Level.SEVERE, "The coremod %s is requesting minecraft version %s and minecraft is %s. It will be ignored.", fmlCorePlugin, version, FMLInjectionData.mccversion);
                    continue;
                }
                if (!"".equals(version)) {
                    FMLRelaunchLog.log(Level.FINE, "The coremod %s requested minecraft version %s and minecraft is %s. It will be loaded.", fmlCorePlugin, version, FMLInjectionData.mccversion);
                }
                if ((trExclusions = coreModClass.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class)) != null) {
                    for (String st : trExclusions.value()) {
                        classLoader.addTransformerExclusion(st);
                    }
                }
                IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClass.newInstance();
                loadPlugins.add(plugin);
                pluginLocations.put(plugin, (File)coreMod);
                if (plugin.getLibraryRequestClass() != null) {
                    for (String libName : plugin.getLibraryRequestClass()) {
                        libraries.add((ILibrarySet)Class.forName(libName, true, classLoader).newInstance());
                    }
                }
                downloadMonitor.updateProgressString("Loaded coremod %s", ((File)coreMod).getName());
            }
            catch (ClassNotFoundException cnfe) {
                FMLRelaunchLog.log(Level.SEVERE, cnfe, "Coremod %s: Unable to class load the plugin %s", ((File)coreMod).getName(), fmlCorePlugin);
            }
            catch (ClassCastException cce) {
                FMLRelaunchLog.log(Level.SEVERE, cce, "Coremod %s: The plugin %s is not an implementor of IFMLLoadingPlugin", ((File)coreMod).getName(), fmlCorePlugin);
            }
            catch (InstantiationException ie) {
                FMLRelaunchLog.log(Level.SEVERE, ie, "Coremod %s: The plugin class %s was not instantiable", ((File)coreMod).getName(), fmlCorePlugin);
            }
            catch (IllegalAccessException iae) {
                FMLRelaunchLog.log(Level.SEVERE, iae, "Coremod %s: The plugin class %s was not accessible", ((File)coreMod).getName(), fmlCorePlugin);
            }
        }
    }

    private static File setupLibDir(File mcDir) {
        File libDir = new File(mcDir, "lib");
        try {
            libDir = libDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to canonicalize the lib dir at %s", mcDir.getName()), e);
        }
        if (!libDir.exists()) {
            libDir.mkdir();
        } else if (libDir.exists() && !libDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a lib file in %s that's not a directory", mcDir.getName()));
        }
        return libDir;
    }

    private static File setupCoreModDir(File mcDir) {
        File coreModDir = new File(mcDir, "coremods");
        try {
            coreModDir = coreModDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to canonicalize the coremod dir at %s", mcDir.getName()), e);
        }
        if (!coreModDir.exists()) {
            coreModDir.mkdir();
        } else if (coreModDir.exists() && !coreModDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a coremod file in %s that's not a directory", mcDir.getName()));
        }
        return coreModDir;
    }

    private static void downloadFile(File libFile, String rootUrl, String realFilePath, String hash) {
        try {
            URL libDownload = new URL(String.format(rootUrl, realFilePath));
            downloadMonitor.updateProgressString("Downloading file %s", libDownload.toString());
            FMLRelaunchLog.info("Downloading file %s", libDownload.toString());
            URLConnection connection = libDownload.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "FML Relaunch Downloader");
            int sizeGuess = connection.getContentLength();
            RelaunchLibraryManager.performDownload(connection.getInputStream(), sizeGuess, hash, libFile);
            downloadMonitor.updateProgressString("Download complete", new Object[0]);
            FMLRelaunchLog.info("Download complete", new Object[0]);
        }
        catch (Exception e) {
            if (downloadMonitor.shouldStopIt()) {
                FMLRelaunchLog.warning("You have stopped the downloading operation before it could complete", new Object[0]);
                return;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            FMLRelaunchLog.severe("There was a problem downloading the file %s automatically. Perhaps you have an environment without internet access. You will need to download the file manually or restart and let it try again\n", libFile.getName());
            libFile.delete();
            throw new RuntimeException("A download error occured", e);
        }
    }

    public static List<String> getLibraries() {
        return loadedLibraries;
    }

    private static void performDownload(InputStream is2, int sizeGuess, String validationHash, File target) {
        if (sizeGuess > downloadBuffer.capacity()) {
            throw new RuntimeException(String.format("The file %s is too large to be downloaded by FML - the coremod is invalid", target.getName()));
        }
        downloadBuffer.clear();
        int fullLength = 0;
        downloadMonitor.resetProgress(sizeGuess);
        try {
            int bytesRead;
            downloadMonitor.setPokeThread(Thread.currentThread());
            byte[] smallBuffer = new byte[1024];
            while ((bytesRead = is2.read(smallBuffer)) >= 0) {
                downloadBuffer.put(smallBuffer, 0, bytesRead);
                fullLength += bytesRead;
                if (downloadMonitor.shouldStopIt()) break;
                downloadMonitor.updateProgress(fullLength);
            }
            is2.close();
            downloadMonitor.setPokeThread(null);
            downloadBuffer.limit(fullLength);
            downloadBuffer.position(0);
        }
        catch (InterruptedIOException e) {
            Thread.interrupted();
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            String cksum = RelaunchLibraryManager.generateChecksum(downloadBuffer);
            if (!cksum.equals(validationHash)) {
                throw new RuntimeException(String.format("The downloaded file %s has an invalid checksum %s (expecting %s). The download did not succeed correctly and the file has been deleted. Please try launching again.", target.getName(), cksum, validationHash));
            }
            downloadBuffer.position(0);
            FileOutputStream fos = new FileOutputStream(target);
            fos.getChannel().write(downloadBuffer);
            fos.close();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static String generateChecksum(ByteBuffer buffer) {
        return CertificateHelper.getFingerprint(buffer);
    }

    static {
        downloadBuffer = ByteBuffer.allocateDirect(0x800000);
    }
}

